<?php
// $Id: Apop.php.defaults.Vsite,v 1.3 2001/07/26 04:15:29 pbaltz Exp $
// Copyright 2001 Sun Microsystems, Inc.  All rights reserved.
// Apop.php.defaults.Vsite

if (defined('APOPEXTENSION_DEFAULTS_VSITE'))
{
    return 1;
}
define('APOPEXTENSION_DEFAULTS_VSITE', 1);

include_once('UIExtension.php');

class APOPExtension extends UIExtension
{
    function display(&$helper, &$container, &$prams)
    {
        if (isset($prams['APOP_enabled']))
        {
            $props = array('enabled' => $prams['APOP_enabled']);
        }
        else
        {
            $cce = $helper->getCceClient();
            $props = $cce->get($prams['CCE_SERVICES_OID'], 'APOP');
        }

        $factory = $helper->getHtmlComponentFactory('base-email');
        $page_id = $prams['PAGED_BLOCK_DEFAULT_PAGE'];
        
        $container->addFormField(
                $factory->getBoolean('APOP_enabled', $props['enabled']),
                $factory->getLabel('apopFullText'),
                $page_id
            );
    }

    function handle(&$helper, &$errors, &$prams)
    {
        global $APOP_enabled;

        $cce = $helper->getCceClient();
        
        $cce->set($prams['CCE_SERVICES_OID'], 'APOP', array('enabled' => $APOP_enabled));

        $errors = array_merge($errors, $cce->errors());
    }
}
?>
