<?php
// $Id: Apop.php.create.User,v 1.3 2001/08/11 23:10:02 pbaltz Exp $
// Copyright 2001 Sun Microsystems, Inc.  All rights reserved.
// Apop.php.create.User
//
// Setup authenticated POP on user creation

include_once('UIExtension.php');

class APOPExtension extends UIExtension
{
	function display(&$helper, &$container, &$prams)
	{
		$cce = $helper->getCceClient();

		// don't show if feature not enabled for this vsite
		if ( isset($prams["VSITE_OID"]) ) {
			$feature = $cce->get($prams["VSITE_OID"], "APOP");
			if ( !$feature["enabled"] )
				return;
		}

		$props = $cce->get($prams["CCE_SERVICES_OID"], "APOP");

		$factory = $helper->getHtmlComponentFactory("base-email");
		$pageIds = $container->getPageIds();
		
		$container->addFormField(
				$factory->getBoolean("APOP_enabled", $props["enabled"]),
				$factory->getLabel("enableApop"),
				$pageIds[0]
			);
	}

	function handle(&$helper, &$errors, &$prams)
	{
		global $APOP_enabled;

        if (!isset($APOP_enabled))
            return;

		$cce = $helper->getCceClient();
		
		$cce->set($prams["CCE_OID"], "APOP", array("enabled" => $APOP_enabled));

		$errors = array_merge($errors, $cce->errors());
	}
}
?>
