<?php
// $Id: 10_AnonFtp.php.create.Vsite,v 1.3 2001/10/25 01:24:24 pbaltz Exp $
// Copyright 2001 Sun Microsystems, Inc.  All Rights Reserved.
// AnonFtp.php.create.Vsite

include('UIExtension.php');

class AnonFtpExtension extends UIExtension
{
    function display(&$ServerScriptHelper, &$container, $parameters)
    {
        $factory = $ServerScriptHelper->getHtmlComponentFactory("base-ftp");
        $cce = $ServerScriptHelper->getCceClient();

        $defaults = $cce->get($parameters["CCE_SERVICES_OID"], "AnonFtp");
       
        // construct all the form fields needed, note that only simple
        // form fields are allowd.  no composite form fields
        $ftpQuota =& $factory->getInteger("AnonFtp_quota", $defaults["quota"], 
                                            1);
        $ftpUsers =& $factory->getInteger("AnonFtp_maxConnections", 
                                $defaults["maxConnections"], 1);
    
        // now add the form fields to the block, assume PagedBlock
        if ($parameters['CAN_ADD_PAGE'])
        {
            $pageId = "AnonFtp";
            $container->addPage($pageId, $factory->getLabel("ftpTabName"));
        }
        else
        {
            $pageId = $parameters['PAGED_BLOCK_DEFAULT_PAGE'];
        }
 
        $anonFtp =& $factory->getMultiChoice('AnonFtp_enabled');
        $enable =& $factory->getOption("anonEnable", $defaults["enabled"]);
        $enable->setLabel($factory->getLabel('anonEnable', false));
        
        $enable->addFormField($ftpQuota, $factory->getLabel("ftpQuota"), $pageId);
        $enable->addFormField($ftpUsers, $factory->getLabel("ftpUsers"), $pageId);
        $anonFtp->addOption($enable);
        
        $container->addFormField(
                    $anonFtp,
                    $factory->getLabel('anonFtp'),
                    $pageId);
    }

    function handle(&$ServerScriptHelper, &$errors, $parameters)
    {
        // have to claim all the globals needed or this function won't be able to see them
        global $AnonFtp_enabled, $AnonFtp_quota, $AnonFtp_maxConnections;
        $cce = $ServerScriptHelper->getCceClient();
        
        // simply set the values in CCE
        $cce->set($parameters["CCE_OID"], "AnonFtp",
            array(
                "enabled" => ($AnonFtp_enabled ? 1 : 0), 
                "quota" => $AnonFtp_quota, 
                "maxConnections" => $AnonFtp_maxConnections
            ));
    
        // add any errors that occured so they can get back to the UI
        $errors = array_merge($errors, $cce->errors());
    }
}
?>
