#!/bin/sh

#######################################
# Auther: Hisao SHIBUYA
# $Id:$
#######################################

## Check permission
if [ $UID -ne 0 ]; then
  echo "This installer must be executed by root or with sudo."
  exit 1
fi


## Check installed RPMS
echo
echo "[Phase 1 : checking intalled RPMS...]"
echo

grep "Red Hat Linux release 9" /etc/redhat-release > /dev/null
if [ $? -eq 1 ]; then
  echo "** ERROR **"
  echo "This package supports for Red Hat Linux release 9 only!!"
  exit 1;
fi

requires="httpd bind openssh telnet-server expect perl-DB_File"
for rpm in $requires; do
  rpm -q $rpm > /dev/null
  if [ $? -eq 1 ]; then
    echo
    echo "** ERROR **"
    echo "[$rpm] is not installed. Please install [$rpm] package."
    exit 1
  fi
  echo "[$rpm] is installed."
done

## delete package
removes="vsftp postfix compat-pwdb"
for rpm in $removes; do
  rpm -q $rpm > /dev/null
  if [ $? -eq 0 ]; then
    rpm -e $rpm > /dev/null
    echo
    echo "remove [$rpm] package."
  fi
done


echo

## Check quota
/usr/sbin/repquota /home > /dev/null
if [ $? -eq 1 ]; then
  perl -pi.bak -e 'if (/^LABEL=\/home/) { s/defaults/defaults,usrquota,grpquota/}' /etc/fstab
  /bin/mount -o remount /home
  /sbin/quotacheck -c -u -g -a
  /sbin/quotaon -aug

  /usr/sbin/repquota /home > /dev/null
  if [ $? -eq 1 ]; then
    echo "** ERROR **"
    echo "/home partition does not set quota."
    echo "Please edit /etc/fstab like follows and execute the follows commands."
    echo
    echo "[/etc/fstab]"
    echo "LABEL=/home	/home	ext3	defaults,usrquota,grpquota	1 2"
    echo
    echo "# /bin/mount -o remount /home"
    echo "# /sbin/quotacheck -c -u -g -a"
    echo "# /sbin/quotaon -aug"
    exit 1
  else
    echo "Enable quota on /home partition."
  fi
fi


## change nsswitch.conf
/bin/cp /etc/nsswitch.conf /etc/nsswitch.conf.bqsave
cat /etc/nsswitch.conf | sed 's/^passwd:     files$/passwd:     db files/g' | \
  sed 's/^shadow:     files$/shadow:     db files/g' | \
  sed 's/^group:      files$/group:      db files/g' > /etc/nsswitch.bluequartz \
  && /bin/mv /etc/nsswitch.bluequartz /etc/nsswitch.conf


## Install RPMS
/bin/rm -f /etc/mail/*.db
echo
echo "[Phase 2 : installing RPMS...]"
echo
RPM_PATH=`pwd`/pkgs/RPMS

rpm -Uvh --force \
  $RPM_PATH/glib-1.2.10-11BQ1.i386.rpm \
  $RPM_PATH/glib-devel-1.2.10-11BQ1.i386.rpm \
  $RPM_PATH/imap-2001a-18BQ1.i386.rpm \
  $RPM_PATH/nss_db-2.2-22BQ1.i386.rpm \
  $RPM_PATH/pam-0.75-48BQ1.i386.rpm \
  $RPM_PATH/pam-devel-0.75-48BQ1.i386.rpm \
  $RPM_PATH/perl-Jcode-0.83-3BQ1.i386.rpm \
  $RPM_PATH/perl-Quota-1.4.8-3BQ1.i386.rpm \
  $RPM_PATH/php-4.2.2-17.2BQ1.i386.rpm \
  $RPM_PATH/php-imap-4.2.2-17.2BQ1.i386.rpm \
  $RPM_PATH/php-ldap-4.2.2-17.2BQ1.i386.rpm \
  $RPM_PATH/procmail-3.13.1-2BQ1.i386.rpm \
  $RPM_PATH/proftpd-1.2.9-1.9BQ1.i386.rpm \
  $RPM_PATH/proftpd-inetd-1.2.9-1.9BQ1.i386.rpm \
  $RPM_PATH/pwdb-0.61.1-9BQ3.i386.rpm \
  $RPM_PATH/qpopper-4.0.5-1BQ1.i386.rpm \
  $RPM_PATH/re2c-0.9.1-3BQ1.i386.rpm \
  $RPM_PATH/sendmail-8.12.8-9BQ2.90.i386.rpm \
  $RPM_PATH/poprelayd-2.0-9BQ1.noarch.rpm


## Install base Packages of Blue Quartz
echo
echo "[Phase 3 : installing Blue Quartz base packages...]"
echo
RPM_PATH=`pwd`/RPMS
rpm -ivh --nodeps --force \
  $RPM_PATH/swatch-2.0.49-1.i386.rpm \
  $RPM_PATH/sausalito-* \
  $RPM_PATH/base-* \
  $RPM_PATH/am-bins-* \
  $RPM_PATH/perl-handler-utils-1.3.0-11BQ1.i386.rpm \
  $RPM_PATH/telnet-scripts-1.1.2-6BQ1.i386.rpm


# change LogFormat
perl -pi.bak -e 's/LogFormat "%h %l %u %t \\"%r\\" %>s %b \\"%{Referer}i\\" \\"%{User-Agent}i\\"" combined/LogFormat "%v %h %l %u %t \\"%r\\" %>s %b \\"%{Referer}i\\" \\"%{User-Agent}i\\"" combined/g' /etc/httpd/conf/httpd.conf


## start daemons
echo
echo "[Phase 4 : restart daemons...]"
echo
hostname localhost
services="httpd admserv xinetd sendmail cced.init"
#services="httpd admserv xinetd sendmail"
for service in $services; do
  /sbin/chkconfig $service on
  /sbin/service $service restart
done

## stop daemons
echo
echo "[Phase 5 : stop daemons...]"
echo
services="FreeWnn apmd canna cups pcmcia portmap iptables netfs nfslock xfs"
for service in $services; do
  if [ -x /etc/init.d/$service ]; then
    /sbin/chkconfig $service off
    /sbin/service $service stop
  fi
done


./scripts/enableService.pl
#./scripts/allPerlDebugOn.sh


## finished
echo
echo "Finish installation"
echo
echo "Access http://xxx.xxx.xxx.xxx/login with admin/admin"
echo "** Your root password is same as admin password. **"
echo
