#!/usr/bin/perl -I/usr/sausalito/perl
# $Id: cleanup_aliases.pl,v 1.1.1.1 2004/01/03 06:28:36 shibuya Exp $
# Copyright 2001 Sun Microsystems, Inc.  All rights reserved.
#
# if a real interface has just changed IP addresses to that of an alias
# cleanup the alias

use CCE;

my $cce = new CCE;
$cce->connectfd();

my $network = $cce->event_object();

# if this Network object is not real or not enabled, just succeed
if (!$network->{ipaddr} || !$network->{real} || !$network->{enabled})
{
	$cce->bye('SUCCESS');
	exit(0);
}

# check for aliases
my @aliases = $cce->find('Network',
				{
					'ipaddr' => $network->{ipaddr},
					'real' => 0,
					'enabled' => 1
				});

for (my $i = 0; $i < scalar(@aliases); $i++)
{
	my ($ok) = $cce->set($aliases[$i], '', { 'enabled' => 0 });
	($ok) = $cce->destroy($aliases[$i]);
	if (!$ok)
	{
		$cce->bye('FAIL');
		exit(1);
	}
}

$cce->bye('SUCCESS');
exit(0);
# Copyright (c) 2003 Sun Microsystems, Inc. All  Rights Reserved.
# 
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
# 
# -Redistribution of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
# 
# -Redistribution in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation  
# and/or other materials provided with the distribution.
# 
# Neither the name of Sun Microsystems, Inc. or the names of contributors may 
# be used to endorse or promote products derived from this software without 
# specific prior written permission.
# 
# This software is provided "AS IS," without a warranty of any kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# You acknowledge that  this software is not designed or intended for use in the design, construction, operation or maintenance of any nuclear facility.
