#!/usr/bin/perl
#
#       (c) FRISK Software International
#       author: Svavar Ingi Hermannsson 2002 - 2003
#
#       http://www.f-prot.com/
#
# If you want to run this script in a cronjob, then you
# should put a cron entry into your crontab similar to 
# the following example. Here's an example of a crontab 
# entry which runs check-updates twice a day: 04:27 and
# 16:27.
#       (with this configuration, you will get e-mails whenever
#       virus signature files are updated or when an error occurs)
#
# 27 4,16 * * * /usr/local/f-prot/tools/check-updates.pl -cron
#
#
#       (If you only want to receive an e-mail only when an error
#       occurs, then you want to include the -quiet parameter)
#
# 27 4,16 * * * /usr/local/f-prot/tools/check-updates.pl -cron -quiet
#
# (consult your crontab manual page, this format may differ between
# versions)

## The directory you'll be writing all temporary files to.
my $temporaryDirectory = '/var/tmp/f-prot/';

## Used when creating the directory to hold temporary files.
my $creationMask = 0700; 

## The directory containing the virus signatures (the .DEF files).
my $signatureDirectory = '/usr/local/f-prot/';

## The host which is contacted for information on the latest virus
## signatures.
my $host = 'updates.f-prot.com';

## Argument which is sent to $host to get information on the 
## latest virus signatures.
my $HTTPARG = "/cgi-bin/check-updates?protocol=1&run_as=check_updates";

## This is the variable which will hold the hostname of the download
## server sugested by the updates.f-prot.com server (from above).
my $mainServer;

## If the sugested server for retrieving the latest virus signatures is
## unaccessible, you will try downloading the latest virus signatures from
## this server.
my $fallBackServer = 'http://updates.f-prot.com/files/';

## FTP Username and Password to be used when connecting to the ftp
## servers containing the updated virus-signature files
## (feel free to adjust these values to your host-information).
my $ftpUsername   = 'anonymous';
my $ftpPassword   = 'check-updates@f-prot.com';

## The location of the virus signature files on the supplied server
## (this information is passed to you by from $host (see above)).
my $ftpRemoteDirectory;

## Variables used to indicate weather or not proxying should be used.
my $useProxy;
my $useFtpProxy;

## Variables related to proxying. They are only used if this script
## is passed the proxy arguments (check-updates.pl -help for further
## information).
my $proxyServer;
my $ftpProxyServer;
my $ftpProxyType;
my $proxyUsername;
my $proxyPassword;
my $proxyFtpUsername;
my $proxyFtpPassword;

## A hash table which holds the names of local virus signature files as 
## well as their checksums.
my %localChecksums;

## A hash table which holds the names of remote virus signature files as 
## well as their checksums (if these checksums differ from the local checksums,
## these signatures will be considered to be newer and this script will
## update the local virus signatures).
my %checkSums;

## This variable is used to decide which method is used
## to download the new virus signatuers (this variable
## should not be set manually). The retrival method can
## be either FTP or HTTP.
my $retrivalMethod = 0;

## These variables are used to identify weather or not new
## virus signature files have been successfully downloaded
## or not.
my $downloadSignDEFDone = 0;
my $downloadMacroDEFDone = 0;

## Variables which control which mode this script will be rann in.
## It is not recommended that you manually change these variables
## here in the script itself, you should rather pass the script
## the appropriate arguments (e.g. -cron -quiet).
my $usingCron = 0;
my $quietMode = 0;

## The string which is printed once signatures relating to
## application/script viruses and Trojans are updated.
my $SIGNDEF = "Application/Script viruses and Trojans"; 

## The string which is printed once signatures relating to
## Document/Office/Macro viruses are updated.
my $MACRODEF = "Document/Office/Macro viruses";

## A sub function which includes the warnings module.
sub includeWarnings
{
	eval 'use warnings';
	if (! $@)
	{
		return;
	}
	if ($usingCron != 1 && $quietMode != 1)
	{
		print "Minor error: Unable to 'use warnings'.\n"
			. "This is not a critical problem and this script is able to"
			. " continue running\nwithout it.\n\n";
	}
}

## A sub function which includes the HTTP::Request module.
sub includeHTTPRequest
{
	eval 'use HTTP::Request';
	if (! $@)
	{
		return;
	}
	else
	{
		die("Error: Unable to include perl module: 'HTTP::Request'.\n"
			. "Please install this module and try re-running this script.\n"
			. "(Hint: man CPAN)\n\nFatal error. Exiting...\n");
	}
}

## A sub function which includes the HTTP::Response module.
sub includeHTTPResponse
{
	eval 'use HTTP::Response';
	if (! $@)
	{
		return;
	}
	else
	{
		die("Error: Unable to include perl module: 'HTTP::Response'.\n"
			. "Please install this module and try re-running this script.\n"
			. "(Hint: man CPAN)\n\nFatal error. Exiting...\n");
	}
}

sub includeLWPUserAgent
{
	eval 'use LWP::UserAgent';
	if (! $@)
	{
		return;
	}
	else
	{
		die("Error: Unable to include perl module: 'LWP::UserAgent'.\n"
			. "Please install this module and try re-running this script.\n"
			. "(Hint: man CPAN)\n\nFatal error. Exiting...\n");
	}
}

sub includeIOFile
{
	eval 'use IO::File';
	if (! $@)
	{
		return;
	}
	else
	{
		die("Error: Unable to include perl module: 'IO::File'.\n"
			. "Please install this module and try re-running this script.\n"
			. "(Hint: man CPAN)\n\nFatal error. Exiting...\n");
	}
}

sub includeNetModule
{
	eval 'use Net::FTP';
	if (! $@)
	{
		$retrivalMethod = 1;
		return;
	}
	else
	{
		die "Error: Unable to include perl module: 'Net::FTP'. Please install this module and try re-running\n"
			. "this script.\n(Hint: man CPAN)\n\nFatal error. Exiting...\n";
	}
}

## A sub function which prints out help information. 
## If this function receives an argument it will
## first print the argument before printing the
## help info.
sub printHelp
{
	## Any arguments ?
	unless ($#_  eq -1)
	{
		print "@_\n";
	}

	die("#############################################################\n"
		. "# F-Prot Antivirus Updater (c) Frisk Software International #\n"
		. "#############################################################\n"
		. "\n\n"
		. "check-updates.pl [-cron] [-quiet] [-proxy-server=http://proxy.server:portnumber]\n"
		. "\t[-proxy-username=username] [-proxy-password=password]\n"
		. "\t[-proxy-ftp-server=proxy.server] [-proxy-ftp-username=ftpusername]\n"
		. "\t[-proxy-ftp-password=ftppassword] [-proxy-ftp-type=number]\n\n"
		. "\t-cron  This feature is useful when you're running this script in a\n"
		. "\t\tcron-job. With this configuration, you will get e-mails\n"
		. "\t\twhenever signature files are updated or when an error occurs.\n\n"
		. "\t-quiet  This option will cause check-updates.sh only to report errors.\n"
        	. "\t\tIn other words you will not be notified every time a new\n"
		. "\t\tsignature file has been downloaded and installed.\n\n"
		. "\t-proxy-server=  Here you can tell the F-Prot Antivirus Updater to\n\t\tuse an HTTP proxy.\n\n"
		. "\t-proxy-username=  If your HTTP proxy uses user authentication you\n"
		. "\t\tcan set which username the F-Prot Antivirus Updater should use.\n\n"
		. "\t-proxy-password=  the password to use with the proxy-username for\n\t\tthe proxy authentication.\n\n"
		. "\t-proxy-ftp-server=  Here you can tell the F-Prot Antivirus Updater\n\t\tto use an FTP proxy.\n\n"
		. "\t-proxy-ftp-username=  If your FTP proxy uses user authentication you\n"
		. "\t\tcan set the username to authenticate to the FTP proxy.\n\n"
		. "\t-proxy-ftp-password=  Here you can set the password to use when\n"
		. "\t\tauthenticating with the FTP proxy.\n\n"
		. "\t-proxy-ftp-type=  If you are having problems with the ftp-proxy\n"
		. "\t\tauthentication, you will need to set this value.\n" 
		. "\t\tConsult the perl documentation for Net::Config \n"
		. "\t\t(http://www.perldoc.com/perl5.8.0/lib/Net/Config.html)).\n\n");
}

# A sub function which checks if the temporary directory you are using
# exists, and if it doesn't exist it tries to create it.
sub checkTemporaryDirectory
{
	# If your temporary directory does not exist, you must create it.
	if (! -e $temporaryDirectory)
	{
		mkdir($temporaryDirectory, $creationMask) || 
		die "Error: Unable to create directory: $temporaryDirectory\nError: $!\n\n"
	                . "Exiting...\n";
		return;
	}

	# A file/directory exists, do checks
	# Normally you shouldn't need to check if the $temporaryDirectory is
	# a directory since it's declared by default ending with a slash /.
	# But! In case someone will change this script (namely the 
	# temporaryDirectory variable), it won't hurt having this check.
	if (-f $temporaryDirectory)
	{
		die "$temporaryDirectory is a file, not a directory. You can\n"
			. "either change the location of the \$temporaryDirectory\n"
			. "in the script, or you can remove this file and let this\n"
			. "script create a new directory.\n\n";
	}
	elsif (-l $temporaryDirectory)
	{
		die "Error: There exists a symbolic link with the same name as the\n"
			. "temporary directory you've declared: $temporaryDirectory \n"
			."Please remove this link and re-run the script.\n"
			. "Exiting...\n";
	}
	elsif (! -o $temporaryDirectory)
	{
		die "Error: You are not the owner of the temporary directory\n"
			. "which this script is using: $temporaryDirectory.\n"
			. "Please change the file permissions and try again\n"
			. "Exiting...\n";
	}
}

# A sub function which makes sure only the owner of the script has
# write access to the temporary directory to prevent a race-condition
# in the case of other users.
sub changePermissionsOfTemporaryDirectory
{
	chmod($creationMask, $temporaryDirectory) || die "Unable to change access permissions for:"
		. "$temporaryDirectory.\n\nError: $!\n"
		. "Exiting...\n";

}

## A function which removes all files from the temporary directory.
sub cleanTemporaryDirectory
{
	chdir($temporaryDirectory);

        ## Here you clean everything within the temporary directory.
	## First you get the directory listing.
	my @temporaryDirectoryListing = glob("${temporaryDirectory}*");

	## If the directory is not empty you'll clean it, else there's
	## nothing else to do...
        if ($#temporaryDirectoryListing != -1)
	{
		foreach my $Item (@temporaryDirectoryListing)
		{
			# If it's not a directory, you remove it.
			if (! -d $Item)
			{
				unlink($Item) || die "Unable to clean temporary directory: $temporaryDirectory.\n"
					. "While trying to remove: $Item\n\nError: $!\nExiting...\n";
			}
		}
	}
}

## Here you make sure that the checksums of the newly downloaded virus signature files
## are identical to the checksums posted as beeing the latest version by the updates
## server ($host).
sub doubleCheckUnzippedSignFiles
{
	my $sign1CheckSum = &create_compare_string_for_defs($temporaryDirectory . "SIGN.DEF");
	my $sign2CheckSum = &create_compare_string_for_defs($temporaryDirectory . "SIGN2.DEF");
	if ((! $checkSums{'SIGN.DEF'} eq $sign1CheckSum) || (! $checkSums{'SIGN2.DEF'} eq $sign2CheckSum))
	{
		die "Error: Checksum of decompressed files is incorrect.\n"
			. "Please try updating again, and if the problem persists, you can contact"
			. "support\n\thttp://www.f-prot.com/support/contact_support.html\n"
			. "Fatal error. Exiting...\n";
	}
}

## This sub function does the same as the above. The above sub function double checks SIGN.DEF and
## SIGN2.DEF, while this function focuses on MACRO.DEF.
sub doubleCheckUnzippedMacroFile
{
	my $macroCheckSum = &create_compare_string_for_defs($temporaryDirectory . "MACRO.DEF");
	if (! $checkSums{'MACRO.DEF'} eq $macroCheckSum)
	{
		die "Error: checksum of decompressed file is incorrect.\n"
		. "Please try updating again, and if the problem persists, you can contact"
		. "support\@f-prot.com\nFatal error. Exiting...\n";
	}
}

## This sub function installs the newly downloaded signature files after double checking
## that the checksum of the newly downloaded virus signatures match the checksums
## advertised by the updates server ($host).
sub installDownloadedFiles
{
	if ($downloadSignDEFDone == 1)
	{
		if ($quietMode != 1)
		{
			print "Preparing to install $SIGNDEF signatures.\n";
		}

		if (system("unzip fp-def.zip > /dev/null"))
		{
			die "Error trying to unzip: fp-def.zip.\n"
			. "Make sure unzip is installed and it's location is within your PATH variable\n"
			. "Fatal error.\tExiting...\n";
		}

		## Change access mode of downloaded files (in case umask is incorrectly set up)
		if (system("chmod 0755 SIGN*.DEF > /dev/null"))
		{
			die "Error trying to change file access permissions of signature files.\n"
				. "Fatal error.\tExiting...\n";
		}

		&doubleCheckUnzippedSignFiles;
		if (system("mv -f SIGN*.DEF $signatureDirectory > /dev/null"))
		{
			die "Error while trying to replace old signature files.\n"
				. "Fatal error.\tExiting...";
		}

		if ($quietMode != 1)
		{
			print "$SIGNDEF signatures have successfully been installed.\n\n"
		}
	}
	
	if ($downloadMacroDEFDone == 1)
	{
		if ($quietMode != 1)
		{
			print "Preparing to install $MACRODEF signatures.\n";
		}

		if (system("unzip macrdef2.zip > /dev/null")) 
		{
			die "Error trying to unzip: macrdef2.zip.\n"
				. "Make sure unzip is installed and it's location is within your PATH variable\n"
				. "Fatal error.\tExiting...\n";
		}
		
		## Change access mode of downloaded files (in case umask is incorrectly set up)
		if (system("chmod 0755 MACRO.DEF > /dev/null"))
		{
			die "Error while trying to chang access permissions of macro signature file.\n"
				. "Fatal error.\tExiting...\n";
		}

		&doubleCheckUnzippedMacroFile;
		if (system("mv -f MACRO.DEF $signatureDirectory > /dev/null"))
		{
			die "Error while trying to replace old signature files.\n"
				. "Fatal error:.\tExiting...";
		}
		
		if ($quietMode != 1)
		{
			print "$MACRODEF signatures have successfully been installed.\n\n"
		}
	}

	if ($quietMode != 1)
	{
		if ($downloadSignDEFDone == 1 || $downloadMacroDEFDone == 1)
		{
			&printUpdateCompleted;
		}
		else
		{
			if ($usingCron != 1)
			{
				&printHeader;
				print "Nothing to be done...\n\n";
			}
		}
	}
}

## A subfunction to download files from an HTTP server (which was supplied by
## the updates server).
sub downloadFileHTTP
{
	if ($#_ == -1)
	{
		die "sub function 'downloadFileHTTP' was called without an argument.\nExiting...";
	}
	my $filename	= $_[0];
	my $serverName  = $_[1];
        my $res = new HTTP::Response;
        my $ua = new LWP::UserAgent;
	if ($quietMode != 1)
	{
		print "Starting to download...\n";
	}

        if ($useProxy >= 1 && defined($proxyServer))
        {
                $ua->proxy(['http', 'ftp'] => $proxyServer);
        }
        else
        {
                $ua->env_proxy();
        }

        my $req = new HTTP::Request('GET', $serverName . $filename);
        if ($useProxy >= 1 && defined($proxyUsername) && defined($proxyPassword))
        {
                $req->proxy_authorization_basic($proxyUsername, $proxyPassword);
	}

	## The second argument says where to save the requested file.
        $res = $ua->request($req, $filename);
        if  (! $res->is_success)
        {
		return 1;
	}
	if ($quietMode != 1)
	{
		print "Download completed.\n\n";
	}
	return 0;
}

## This sub function get's the checksum of local virus signatures files and places them
## into the hash table localChecksums.
sub getChecksumOfLocalFiles
{
	$localChecksums{'SIGN.DEF'}  = &create_compare_string_for_defs($signatureDirectory . "SIGN.DEF");
	$localChecksums{'SIGN2.DEF'} = &create_compare_string_for_defs($signatureDirectory . "SIGN2.DEF");
	$localChecksums{'MACRO.DEF'} = &create_compare_string_for_defs($signatureDirectory . "MACRO.DEF");
}

## A subfunction to download files from an HTTP server (which was supplied by
## the updates server).
sub downloadFileThroughFTP
{
	if ($#_ == -1)
	{
		die "sub function 'downloadFileThroughFTP' was called without an argument.\nExiting...";
	}
	
	if ($quietMode != 1)
	{
		print "Starting to download...\n";
	}
	my $hostname   = $mainServer;
	my $filename   = $_[0];
	my $ftp;

	if ($useFtpProxy == 1 && defined($ftpProxyServer))
	{
		if (defined($ftpProxyType))
		{
			eval '$ftp = Net::FTP->new($hostnmae, Passive => 1, Firewall => $ftpProxyServer, FirewallType => $ftpProxyType)';
		}
		else
		{
			eval '$ftp = Net::FTP->new($hostnmae, Passive => 1, Firewall => $ftpProxyServer)';
		}
	}
	else
	{
		eval '$ftp = Net::FTP->new($hostname, Passive=>1)';
	}
	if (defined($ftp))
	{
		## The connection was successful.
		if ($useFtpProxy == 1 && defined($proxyFtpUsername) && defined($proxyFtpPassword))
		{
			ftp->authorize($proxyFtpUsername, $proxyFtpPassword);
		}
		$ftp->login($ftpUsername, $ftpPassword) || die "Could not login.\n";
		$ftp->cwd($ftpRemoteDirectory) || die "Could not cd to $ftpRemoteDirectory.";
		$ftp->pasv() || die "Could not enter into passive mode\n";
		$ftp->binary() || die "Error-FTP: Unable to change to binary mode.\nError: $!. Exiting...\n";
		$ftp->get($filename) || die "Could not get file.";
		$ftp->quit();
	}
	else
	{
		## The connection failed.
		if (&downloadFileHTTP($filename, $fallBackServer) == 1)
		{
                       die("Error while trying to download files through FTP and HTTP. Most likely\n"
                                . "you are experiencing some network problems.\n"
				. "Please check the potential problems section within the f-prot manual.\n"
                                . "If the problem persists, please contact tech support, after making sure your network\n"
				. "connection is working, at http://www.f-prot.com\n");
		}
	}
	if ($quietMode != 1)
	{
		print "Download completed.\n\n";
	}
}

## A sub function which compares the checksums of the downloaded archives 
## containing the new virus signatures to the checksums advertised by the
## updates server.
sub checkChecksumsOnDownloadedFiles
{
	if ($downloadSignDEFDone == 1)
	{
		## Earlier in the script you chdir'ed to the temporary directory.
		my $tempSignCheckSum = &create_compare_string_for_defs($temporaryDirectory . "fp-def.zip");
		if (! $checkSums{'fp-def.zip'} eq $tempSignCheckSum)
		{
			die("The downloaded version of fp-sign.zip has a different checksum than\n"
				. "the one advertised by the update server.\nFatal error. Exiting...\n"); 
		}
	}
	if ($downloadMacroDEFDone == 1)
	{
		my $tempMacroCheckSum = &create_compare_string_for_defs('macrdef2.zip');
		if (! $checkSums{'macrdef2.zip'} eq $tempMacroCheckSum)
		{
			die("The downloaded version of macrdef2.zip has a different checksum than\n"
				. "the one advertised by the update server.\nFatal error. Exiting...\n");
		}
	}
}

## A sub function which starts the download process for new virus signatures.
sub downloadSignatureFiles
{
	my $key;
	my $value;
	my $unchanged;
	my $donePrintingHeader = 0;
	while ( ($key, $value) = each(%localChecksums) )
	{
		$unchanged = 0;
		if ($value eq $checkSums{$key})
		{
			$unchanged = 1;
		}

		if ($key =~ /sign/i && $unchanged != 1)
		{
			if ($downloadSignDEFDone != 1)
			{
				if ($quietMode != 1)
				{
					if ($donePrintingHeader != 1)
					{
						&printHeader;
						$donePrintingHeader = 1;
					}
					print "There's a new version of:\n\"$SIGNDEF\" signatures on the web.\n";
				}
				if ($retrivalMethod == 1)
				{
					&downloadFileThroughFTP("fp-def.zip");
				}
				elsif ($retrivalMethod == 2)
				{
					if (&downloadFileHTTP("fp-def.zip", $mainServer) == 1)
					{
						if (&downloadFileHTTP("fp-def.zip", $fallBackServer) == 1)
						{
							die("Unable to download updated files through HTTP.\n"
								. "Check your Internet connection and try again.\n"
								. "Fatal error. Exiting...\n");
						}
					}
				}
				else
				{
					die("Unknown error\n");
				}

				$downloadSignDEFDone = 1;
			}
		}
		elsif ($key =~ /macr/i && $unchanged != 1)
		{
			## You know there are only three DEF files, two which include SIGN*
			## and then there's only the macro one left.
			if ($quietMode != 1)
			{
				if ($donePrintingHeader != 1)
				{
					&printHeader;
					$donePrintingHeader = 1;
				}
				print "There's a new version of:\n\"$MACRODEF\" signatures on the web.\n";
			}
			if ($retrivalMethod == 1)
			{
				&downloadFileThroughFTP("macrdef2.zip");
			}
			elsif ($retrivalMethod == 2)
			{
				if (&downloadFileHTTP("macrdef2.zip", $mainServer) == 1)
				{
					if (&downloadFileHTTP("macrdef2.zip", $fallBackServer) == 1)
					{
						die("Unable to download updated files through HTTP.\n"
							. "check your Internet connection and try again.\n"
							. "Fatal error. Exiting...\n");
					}
				}
			}
			else
			{
					die("Unknown error\n");
			}

			$downloadMacroDEFDone = 1;
		}
	}

	if ($downloadSignDEFDone == 1 || $downloadMacroDEFDone == 1)
	{
		&checkChecksumsOnDownloadedFiles;
	}
}

## A subfunction which generates the checksum to be used when comparing with
## the checksums advertised by the updates server.
sub create_compare_string_for_defs
{
    my ($filename) = @_;

    if (my $file = new IO::File $filename)
    {
        my $buff = '';
        return undef if ($file->read($buff, 32) != 32);

        # Get file size
        my @fstat = $file->stat();
        my $fsize = $fstat[7];

        $file->close();
        return uc( unpack('H*', $buff) . sprintf("%8.8X", $fsize) );
    }
    return undef;
}

## A sub function used to get the information advertised by the updates server
## (including checksums of new virus signatures).
sub downloadUpdateInfo
{
	my $serverReturnCodeFound = 0;
	my $readBuffer;
	my @response;
	my $res = new HTTP::Response;
	my $ua = new LWP::UserAgent;
	if ($useProxy == 1 && defined($proxyServer))
	{
		$ua->proxy(['http', 'ftp'] => $proxyServer);
	}
	else
	{
		$ua->env_proxy();
	}

	my $req = new HTTP::Request('GET', "http://" . $host . $HTTPARG);
	if ($useProxy == 1 && defined($proxyUsername) && defined($proxyPassword))
	{
		$req->proxy_authorization_basic($proxyUsername, $proxyPassword);
	}
	$res = $ua->request($req);
	if  (! $res->is_success)
	{
		die "Unable to connect retrieve update info from server.\nError: " . $! . "\nExiting...\n";
	}

	@response = split(/\n/, $res->content);

        foreach $readBuffer (@response) 
	{ 
		chomp($readBuffer);
		if ($readBuffer =~ /^\d/)
		{
			&checkHTTPReturnValue($readBuffer);
			$serverReturnCodeFound = 1;
		}
		## If you've received an OK return value from the server
		## you will process the information which follows the 
		## return code, namely the checksums for the signature
		## files, zip files and finally the suggested server to 
		## use for download.
		if ($serverReturnCodeFound == 1)
		{
			if ($readBuffer =~ /^c/i)
			{
				## Here you assume you're following protocol 1 so you know
				## you'll receive a string similar to the following:
				## C:SIGN.DEF=0471AD8C5D... , so you add the file and crc
				## to our associative array %checkSums.
				$readBuffer =~ s/c://i;
				my ($file, $crc) = split(/=/, $readBuffer, 2);
				$checkSums{$file} = $crc;
			}
			elsif ($readBuffer =~ /^s/i)
			{
				$readBuffer =~ s/s://i;
				$mainServer = $readBuffer;
				
				if ($mainServer =~ /^ftp/i)
				{
					$mainServer =~ s/ftp:\/\///i;
					my $index = index($mainServer, "/");
					if ($index == -1)
					{
						die "Error: unable to determine remote directory on server.";
					}
					$ftpRemoteDirectory = substr($mainServer, $index + 1, length($mainServer) -1);
					chop($ftpRemoteDirectory);
					$mainServer = substr($mainServer, 0, $index);
				}
				elsif ($mainServer =~ /^http/i)
				{
					## Do nothing..., You are happy with the $mainserver variable the way
					## it is. It should be something like:
					## http://updates.f-prot.com/files/
					$retrivalMethod = 2;
				}
			}
		}
	}

	if ($serverReturnCodeFound != 1)
	{
		die "Unknown error while processing HTTP Server reply.\nExiting...\n";
	}
}

## A sub function which parses the return value returned by the updates server.
sub checkHTTPReturnValue
{
	## You know you will only call this sub function if you have an integer, and if you know
	## you will always pass this sub function an argument.
	if ($#_  eq -1)
	{
		die "sub function checkHTTPReturnValue was called without an argument\n\n"
			. "Fatal error. Exiting...\n";
	}
	
	## Return code of two means you're ok! Anything else represents an error.
	if ($_[0] == 2)
	{
		return;
	}

	if ($_[0] == 3)
	{
		die "Invalid parameters used in http URL.\nFatal error.Exiting...\n";
	}
	elsif ($_[0] == 4)
	{
		die "Invalid protocol in HTTP URL. Make sure you have protocol=1\n"
			. "in the URL you're sending to the server.\nFatal error. Exiting...\n";
	}
	elsif ($_[0] == 5)
	{
		die "Server error on remote machine.\nFatal error. Exiting...\n";
	}
	else 
	{
		die "Unknown error. Exiting...\n";
	}
}

sub printHeader
{
	print	  "***************************************\n"
		. "* F-Prot Antivirus Updater            *\n"
		. "***************************************\n\n";
}

sub printUpdateCompleted
{
	print 	  "\n**********************************\n"
		. "* Update completed successfully. *\n"
		. "**********************************\n\n";
}

sub checkArguments
{
	if ($useProxy == 0 && $useFtpProxy == 0)
	{
		return;
	}

	if ($useProxy == 1)
	{
		if (! defined($proxyUsername) && defined($proxyPassword))
		{
			&printHelp("Error: No proxy-username defined for proxy-password.\n");
		}
		if (! defined($proxyPassword) && defined($proxyUsername))
		{
			&printHelp("Error: No proxy-password defined for proxy-username: '" . $proxyUsername . "'.\n");
		}
	}
	
	if ($useFtpProxy == 1)
	{
		if (! defined($proxyFtpUsername) && defined($proxyFtpPassword))
		{
			&printHelp("Error: No ftp-proxy-username defined for ftp-proxy-password.\n");
		}
		if (! defined($proxyFtpPassword) && defined($proxyFtpUsername))
		{
			&printHelp("Error: No ftp-proxy-password defined for ftp-proxy-username.\n");
		}
		if (! defined($proxyFtpType) && defined($proxyFtpUsername) && defined($proxyFtpPassword))
		{
			if (! defined($proxyFtpType))
			{
				&printHelp("Error: When using FTP Proxy authentication you need to include\n"
					. "\t-ftp-proxy-type.\n");
			}
		}
	}
}

# Here you begin.

if ($0 =~ /check-updates.sh/i)
{
	print STDERR "The check-updates.sh script has been replaced by a perl script:\n"
		. "\tcheck-updates.pl.\nThe check-updates.sh script has been deprecated\n"
		. "Please make appropriate changes to your crontab entries.\n\n";
}

## Here you check for command line arguments.
foreach my $argument (@ARGV)
{
	my $index = 0;
	if ($argument =~ /cron/i)
	{
		$usingCron = 1;
	}
	elsif ($argument =~ /quiet/i)
	{
		$quietMode = 1;
	}
	elsif ($argument =~ /-proxy-server=/i)
	{	
		$useProxy = 1;
		$index = index($argument, "=");
		if ($index == -1)
		{
			die ("Error while handling argument for Proxy-server\n");
		}
		$proxyServer = substr($argument, $index + 1, length($argument) -1);
	}
	elsif ($argument =~ /-proxy-username=/i)
	{
		$useProxy = 1;
		$index = index($argument, "=");
		if ($index == -1)
		{
			die ("Error while handling argument for proxy username\n");
		}
		$proxyUsername = substr($argument, $index + 1, length($argument) -1);
	}
	elsif ($argument =~ /-proxy-password=/i)
	{
		$useProxy = 1;
		$index = index($argument, "=");
		if ($index == -1)
		{
			die ("Error while handling argument for proxy password\n");
		}
		$proxyPassword = substr($argument, $index + 1, length($argument) - 1);
	}
	elsif ($argument =~ /proxy-ftp-server=/i)
	{
		$useProxy = 2;
		$index = index($argument, "=");
		if ($index == -1)
		{
			die("Error while handling argument for proxy-ftp-server\n");
		}
		$ftpProxyServer = substr($argument, $index + 1, length($argument) - 1);
	}
	elsif ($argument =~ /-proxy-ftp-username=/)
	{	
		$useFtpProxy = 1;
		$index = index($argument, "=");
		if ($index == -1)
		{
			die("Error While handling argument for ftp-username\n");
		}
		$proxyFtpUsername = substr($argument, $index + 1, length($argument) - 1);
	}
	elsif ($argument =~ /-proxy-ftp-password/i)
	{
		$useFtpProxy = 1;
		$index = index($argument, "=");
		if ($index == -1)
		{
			die("Error while handling argument for ftp-password.\n");
		}
		$proxyFtpPassword = substr($argument, $index + 1, length($argument) -1);
	}
	elsif ($argument =~ /-proxy-ftp-type=/i)
	{
		$useFtpProxy = 1;
		$index = index($argument, "=");
		if ($index == -1)
		{
			die("Error while handling argument for ftp-proxy-type.\n");
		}
		$ftpProxyType = $argument;
	}
	else
	{
		&printHelp("Error: Unknown argument. Exiting...\n");
	}
}

&checkArguments;
&includeWarnings;
&includeHTTPRequest;
&includeHTTPResponse;
&includeLWPUserAgent;
&includeIOFile;
&includeNetModule;
&getChecksumOfLocalFiles;
&checkTemporaryDirectory;
&changePermissionsOfTemporaryDirectory;
&cleanTemporaryDirectory;
&downloadUpdateInfo;
&downloadSignatureFiles;
&installDownloadedFiles;

