/*
    goPod 1.1 by JiB, Darth Zgul, g-rem, kang & Alf.
    
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

*/


#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "gfx/mask.xpm"

#define GFX_GO "gfx/go.png"
#define GFX_GO_ "gfx/go_.png"
#define GFX_NOTDETECTED "gfx/notdetected.png"
#define GFX_CAPPED "gfx/capped.png"
#define GFX_UNCAPPED "gfx/uncapped.png"

#if defined(__LINUX__)
#define DEV "/dev/sd%c"
#define START 'a'
#define END 'h'
#elif defined(__FREEBSD__)
#define DEV "/dev/da%i"
#define START 0
#define END 15
#elif defined(__OPENBSD__) || defined(__NETBSD__)
#define DEV "/dev/sd%i"
#define START 0
#define END 15
#endif

#define BLOCK_SIZE 512
#define FIRMWARE_START 32256
#define SQUARE(x) (x)*(x)

int dev = 0;
int block_cap = 950*BLOCK_SIZE;
int byte_cap = 0;
unsigned char buffer[BLOCK_SIZE];

GtkWidget *pWindow;
GtkWidget *pHBox;
GtkWidget *pEventButton;
GtkWidget *pButton;
GdkPixbuf *iButton;
GdkPixbuf *iButtonGo;
GtkWidget *pEventImage;
GtkWidget *pImage;
GdkPixbuf *iImageNotDetected;
GdkPixbuf *iImageCapped;
GdkPixbuf *iImageUncapped;
GError *error;
int is_moving = 0;
int move = 0;
int old_x = 0;
int old_y = 0;
int status = -1;
GdkBitmap *mask;
GtkStyle *style;

int detectIpod(void)
{
    char x;
    
    for (x = START; x <= END; x++)
    {
        char devstring[8];
        sprintf(devstring, DEV, x);
        dev = open(devstring, O_RDWR);
        lseek(dev, FIRMWARE_START, SEEK_CUR); 
        read(dev, buffer, BLOCK_SIZE);
                        
        if (buffer[54]=='S' && buffer[56] == 'T' && buffer[58] == 'O' && buffer [60] == 'P')
        {
            return (1);
        }
        else
        {
            close(dev);
        }
    } 
    return (0);
}

int seekChaine(void) 
{
    int chaine = 0;
    
    lseek(dev, block_cap-FIRMWARE_START, SEEK_CUR); 
    while ((block_cap < 800000) && read(dev, buffer, BLOCK_SIZE) != -1)
    {
        block_cap += BLOCK_SIZE;
        for (byte_cap=0; byte_cap<BLOCK_SIZE; byte_cap++) 
        {
            int found = 0;
            if ((buffer[byte_cap] == 0x8) && (chaine == 0)) 
            {
                chaine++;
                found = 1;
            }
            if ((buffer[byte_cap] == 0x0) && (chaine == 1)) 
            {
                chaine++;
                found = 1;
            }
            if ((buffer[byte_cap] == 0x9F) && (chaine == 2)) 
            {
                chaine++;
                found = 1;
            }
            if ((buffer[byte_cap] == 0xE5) && (chaine == 3)) 
            {
                chaine++;
                found = 1;
            }
            if ((buffer[byte_cap] == 0x38) && (chaine == 4)) 
            {
                chaine++;
                found = 1;
            }
            if ((buffer[byte_cap] == 0x01) && (chaine == 5)) 
            {
                chaine++;
                found = 1;
            }
            if ((buffer[byte_cap] == 0x90) && (chaine == 6)) 
            { 
                chaine++;
                found = 1;
            }
            if ((buffer[byte_cap] == 0xE5) && (chaine == 7)) 
            {
                chaine++;
                return (1);
            }
            if (found == 0 && chaine != 0) 
            {
                chaine = 0;
            }
        }
    } 
    return (0);
}

int isCapped(void) 
{
    if(seekChaine())
    {         
        if(buffer[byte_cap+1] == 0x1 && buffer[byte_cap+2] == 0x0)
        {
            return (1);
        }
        
        if(buffer[byte_cap+1] == 0x0 && buffer[byte_cap+2] == 0x1)
        {
            return (0);
        }
    }
    else
    { 
        return (-1);
    }
}

void unCap(void) 
{
    buffer[byte_cap + 1] = 0x0;
    buffer[byte_cap + 2] = 0x1;
    lseek(dev, -BLOCK_SIZE, SEEK_CUR);
    write(dev, buffer, BLOCK_SIZE);
}


void reCap(void) 
{
    buffer[byte_cap + 1] = 0x1;
    buffer[byte_cap + 2] = 0x0;
    lseek(dev, -BLOCK_SIZE, SEEK_CUR);
    write(dev, buffer, BLOCK_SIZE); 
}

static gboolean is_in_circle(int rayon, int centre_x, int centre_y, int x, int y)
{
    int dist;    
    dist = sqrt(SQUARE(x - centre_x) + SQUARE(y - centre_y));
    if (dist <= rayon)
        return (TRUE);
    return (FALSE);
}

void change_image()
{
    if(status == 1)
        gtk_image_set_from_pixbuf(GTK_IMAGE(pImage), iImageCapped);
    if(status == 0)
     gtk_image_set_from_pixbuf(GTK_IMAGE(pImage), iImageUncapped);
}

static gboolean event_callback(GtkWidget  *event_box, GdkEventButton *event, gpointer data)
{
    int diff_x;
    int diff_y;
    int x;
    int y;
    
    is_moving = 1;
    
    if (!old_x && !old_y)
    {
        old_x = (int)event->x_root;
        old_y = (int)event->y_root;
        return (TRUE);
    }
    
    diff_x = (int)event->x_root - old_x;
    diff_y = (int)event->y_root - old_y;
    gtk_window_get_position(GTK_WINDOW(pWindow), &x, &y);
    gtk_window_move(GTK_WINDOW(pWindow), x + diff_x, y + diff_y);
    old_x = (int)event->x_root;
    old_y = (int)event->y_root;
    return (TRUE);
}

static gboolean button_press_callback(GtkWidget *event_box, GdkEventButton *event, gpointer data)
{
    if (is_in_circle(6, 199, 53, (int)event->x, (int)event->y))
        return (TRUE);
    move = g_signal_connect(G_OBJECT(pWindow), "motion_notify_event", G_CALLBACK(event_callback), pImage);
    return (TRUE);
}

static gboolean button_release_callback(GtkWidget *event_box, GdkEventButton *event, gpointer data)
{
    if (is_in_circle(6, 199, 53, (int)event->x, (int)event->y))
    {
        gtk_main_quit();
        return (TRUE);
    }
    if (is_moving)
    {
        gtk_signal_disconnect(G_OBJECT(pWindow), move);
        old_x = 0;
        old_y = 0;
        is_moving = 0;
        return (TRUE);
    }
}

static gboolean enter_notify_callback(GtkWidget *event_box, GdkEventButton *event, gpointer data)
{
    if (is_in_circle(24, 40, 53, (int)event->x, (int)event->y))
    {
        gtk_image_set_from_pixbuf(GTK_IMAGE(pButton), iButtonGo);
        return (TRUE);
    }
    return (FALSE);
}

static gboolean leave_notify_callback(GtkWidget *event_box, GdkEventButton *event, gpointer data)
{
    if (is_in_circle(24, 40, 53, (int)event->x, (int)event->y))
    {
        if (status == 1)
        {
            unCap();
            status = 0;
        } 
        else if (status == 0)
        {
            reCap();
            status = 1;
        }
        else
        if (detectIpod())
            status = isCapped();
        change_image();
    }
    gtk_image_set_from_pixbuf(GTK_IMAGE(pButton), iButton);
    return (FALSE);
}

int main(int argc,char **argv)
{
    gtk_init(&argc,&argv);
    
    if (detectIpod())
        status = isCapped();
    
    pWindow = gtk_window_new(GTK_WINDOW_POPUP);
    gtk_window_set_position(GTK_WINDOW(pWindow), GTK_WIN_POS_CENTER);
    gtk_window_set_default_size(GTK_WINDOW(pWindow), 281, 103);
    gtk_window_set_title(GTK_WINDOW(pWindow), "goPod");
    gtk_widget_show(pWindow);
    
    style = gtk_widget_get_default_style();
    gdk_pixmap_create_from_xpm_d(pWindow->window, &mask, &style->bg[GTK_STATE_NORMAL], mask_xpm);
    gtk_widget_shape_combine_mask(pWindow, mask, 0, 0);
    
    g_signal_connect(G_OBJECT(pWindow), "destroy", G_CALLBACK(gtk_main_quit), NULL);
    pHBox = gtk_hbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(pWindow), pHBox);
    
    iButton = gdk_pixbuf_new_from_file(GFX_GO, &error);
    iButtonGo = gdk_pixbuf_new_from_file(GFX_GO_, &error);
    pButton = gtk_image_new_from_pixbuf(iButton);
    
    pEventButton = gtk_event_box_new();
    gtk_container_add(GTK_CONTAINER(pEventButton), pButton);
    gtk_box_pack_start(GTK_BOX(pHBox), pEventButton, FALSE, FALSE, 0);
    
    iImageNotDetected = gdk_pixbuf_new_from_file(GFX_NOTDETECTED, &error);
    iImageCapped = gdk_pixbuf_new_from_file(GFX_CAPPED, &error);
    iImageUncapped = gdk_pixbuf_new_from_file(GFX_UNCAPPED, &error);
    pImage = gtk_image_new_from_pixbuf(iImageNotDetected);
    pEventImage = gtk_event_box_new();
    gtk_container_add(GTK_CONTAINER(pEventImage), pImage);
    gtk_box_pack_start(GTK_BOX(pHBox), pEventImage, FALSE, FALSE, 0);
    g_signal_connect(G_OBJECT(pWindow), "button_release_event", G_CALLBACK(button_release_callback), pWindow);    
    g_signal_connect(G_OBJECT(pWindow), "button_press_event", G_CALLBACK(button_press_callback), pWindow);    
    g_signal_connect(G_OBJECT(pEventButton), "button_press_event", G_CALLBACK(enter_notify_callback), pButton);
    g_signal_connect(G_OBJECT(pEventButton), "button_release_event", G_CALLBACK(leave_notify_callback), pButton);
    gtk_widget_show_all(pWindow);
    change_image();
    gtk_main();
    return (EXIT_SUCCESS);
}
