/*
 * Copyright (C) 1998, 1999 Wolfgang Moser
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Commodore CBM 1581 floppy disk copy util for PC's, 1581HLVL.H
 *
 * Redirected contact addresses:
 *   Wolfgang Moser <womo@mindless.com>
 *   Wolfgang Moser <womo@fairlight.to>
 *    http://www.dollar8000.de/womo
 *
 * Current workplace (up to Dezember 1999):
 *   Wolfgang Moser <womo@advm2.gm.fh-koeln.de>
 *    http://advm2.gm.fh-koeln.de/~womo
 *
 *
 * Basic informations from Dan Fandrich <dan@fch.wimsey.bc.ca>.
 *   His readme of the cbmfs-0.3 driver for Linux explained me, what the
 *   difference between a DOS formatted 800 kb disk and a CBM 1581 disk is.
 *   (check: http://vanbc.wimsey.com/~danf/software/)
 *
 *
 * Basic implementations by Ciriaco Garca de Celis <ciri@gui.uva.es>
 *   His util 765Debug, Version 5.0 is great for learning dma based
 *   direct floppy disk controller programming.
 *   (check: ftp://ftp.gui.uva.es/pub/pc/2m/765d50sr.zip)
 *
 * Check out for his floppy disk utils 2M and 2MGUI, the last words
 * in improving floppy disk storage capacity.
 *   http://www.gui.uva.es/2m, ftp://ftp.gui.uva.es/pub/pc/2m
 *
 *
 * For additional informations to FDC programming check:
 *     http://developer.intel.com/design/periphrl/datashts/290468.htm
 *   and get the intel 82078 CHMOS Single-Chip Floppy Disk Controller
 *   PDF document:
 *     http://www.intel.nl/design/periphrl/datashts/29047403.pdf
 *   National Semiconductor has also some pages about their PC
 *   compatible controllers:
 *     http://www.national.com/pf/DP/DP8473.html
 *     http://www.national.com/pf/DP/DP8477B.html
 *
 * Another good source for floppy disk controller programming information
 * are the linux kernal sources, you could have a look into:
 *     http://www.cs.utexas.edu/users/peterson/linux/include/linux/fdreg.h
 *     http://www.cs.utexas.edu/users/peterson/linux/drivers/block/floppy.c
 *
 * Now, that I started talking about Linux: Check out the most massive
 * attack against floppy disks ever made, Alain Knaff's fdutils:
 *     http://fdutils.linux.lu/
 *     http://alain.knaff.linux.lu/
 */


#ifndef __CBM_1581_High_Level__
#define __CBM_1581_High_Level__

#include "fdclowlv.h"
#include "frmheadr.h"
typedef enum{
	Read  = 0x01,
	Write = 0x02,
	Verify= 0x04,	// Verify only is currently not used
	WrVrfy= 0x06,
	Format= 0x08
	}xferM;

// these are name constants for the different array indexes
typedef enum{
	NON_3_5=-2,		// the disk drive is no 3,5" one
	FDUNKNW=-1,		// unknown floppy disk format

	CBM1581= 0,		// CBM1581 compatible floppy disk
   CMDFD2M= 1,		// CMD FD2000 compatible floppy disk

   FDUNDEF= 2		// must be the last entry (undefined)
	}FDprmSet;

/*
	  80,	// Cylinders:   80 cylinders per disk
	   2,	// Heads:        2 sides (tracks) per cylinder
	  10,	// Sectors:     10 sectors per track (side)
	   2,	// BpS:        512 bytes per sector
	   2,	// Rate:       250 kilobit per second
	   1,	// Modulation: MFM
	0xDF,	// SpecifyCMD
	0x0C,	// RWGAP3:      12
	0x23,	// FmtGAP:      35
	0x00	// Pattern:      0
*/
extern const FDCparameterSet FDprmSets[FDUNDEF];

int		waitForDiskChng(uint8 drive, int newDisk);

void		CBMprintStatus	(resultString *resStr, const char *Job);

int		CBMresetDrive	(uint8 drive);
int		CBMrecalibrate	(uint8 drive);
int		CBMseek			(uint8 drive, uint8 cyl);

void		CBMpresetFDprm	(uint8 drive, FDprmSet Set);
FDprmSet	CBMcheckDisk	(uint8 drive, int chkSwap);

int		CBMxferTrackSS	(xferM xfer, uint8 drive, uint8 cyl, uint8 side,
								 uint8 huge *buffer, uint8 ileave, uint retries);
int		CBMxferTrackMS	(xferM xfer, uint8 drive, uint8 cyl, uint8 side,
								 uint8 huge *buffer, uint8 ileave, uint retries);

#ifdef FDCintel82078
int		CBMfwvTrack		(xferM xfer, uint8 drive, uint8 cyl, uint8 side,
						 		 uint8 huge *buffer, uint retries);
#endif

char	  *buildInxName	(char *inStr);
char	  *changeExtension(char *inStr, int force, FDprmSet Set);

#endif
