@echo off
rem *** Rapier Install File for Version v1.1 ***

REM ******************** Validate drive parameters

if %1A == A goto :INS_003a
if %2A == A goto :INS_003b

if %1 == A: goto :INS_002
if %1 == B: goto :INS_002
if %1 == a: goto :INS_002
if %1 == b: goto :INS_002
goto :INS_800

:INS_002
if %2 == C: goto :INS_004
if %2 == D: goto :INS_004
if %2 == E: goto :INS_004
if %2 == F: goto :INS_004
if %2 == G: goto :INS_004
if %2 == H: goto :INS_900
if %2 == I: goto :INS_900
if %2 == J: goto :INS_900
if %2 == K: goto :INS_900
if %2 == L: goto :INS_900
if %2 == M: goto :INS_900
if %2 == N: goto :INS_900
if %2 == O: goto :INS_900
if %2 == P: goto :INS_900
if %2 == Q: goto :INS_900
if %2 == R: goto :INS_900
if %2 == S: goto :INS_900
if %2 == T: goto :INS_900
if %2 == U: goto :INS_900
if %2 == V: goto :INS_900
if %2 == W: goto :INS_900
if %2 == X: goto :INS_900
if %2 == Y: goto :INS_900
if %2 == Z: goto :INS_900

if %2 == c: goto :INS_004
if %2 == d: goto :INS_004
if %2 == e: goto :INS_004
if %2 == f: goto :INS_004
if %2 == g: goto :INS_004
if %2 == h: goto :INS_900
if %2 == i: goto :INS_900
if %2 == j: goto :INS_900
if %2 == k: goto :INS_900
if %2 == l: goto :INS_900
if %2 == m: goto :INS_900
if %2 == n: goto :INS_900
if %2 == o: goto :INS_900
if %2 == p: goto :INS_900
if %2 == q: goto :INS_900
if %2 == r: goto :INS_900
if %2 == s: goto :INS_900
if %2 == t: goto :INS_900
if %2 == u: goto :INS_900
if %2 == v: goto :INS_900
if %2 == w: goto :INS_900
if %2 == x: goto :INS_900
if %2 == y: goto :INS_900
if %2 == z: goto :INS_900

goto :INS_800

:INS_003a
REM ******************** Use Default source and destination drive
A:install A: C:

:INS_003b
REM ******************** Use Default destination drive
%1install %1 C:


:INS_004
REM ******************** Drive parameters appear valid

REM ******************** Check disk space

%1insschk %2 1200000
if ERRORLEVEL 1 goto :INS_850

REM ******************** Disk space okay


REM ******************** Check Processor is up to it (386 / 486)

%1getcpu > NUL
if ERRORLEVEL 4 goto :INS_005
if ERRORLEVEL 3 goto :INS_005
if ERRORLEVEL 2 goto :INS_970
if ERRORLEVEL 1 goto :INS_970

REM ******************** Processor okay

:INS_005

REM ******************** Make sure Rapier Directory exists.

%2
cd \
%1
cd \
%1dirchk %2\RAPIER
if NOT ERRORLEVEL 1 goto :INS_009

md %2\rapier >nul

REM ******************** Check for XMS Driver

:INS_009
%1getxms > NUL
if NOT ERRORLEVEL 1 goto :INS_018

REM ******************** XMS Resident  
REM ********************   
REM ******************** Attempt to edit config.sys to
REM ******************** rem out all XMS managers.
REM ******************** If successful copy config.sys to
REM ******************** rapier directory as .SAV and rename 
REM ******************** config.tmp to config.sys.
REM ******************** If unsuccessful, tell the user to disable it
REM ******************** himself.
REM ******************** 

%1confmod > NUL
if ERRORLEVEL 1 goto :INS_980

if exist c:\config.sys copy c:\config.sys %2\rapier\config.sav > NUL
if exist c:\config.tmp copy c:\config.tmp c:\config.sys > NUL
insmsg /CLEAR CFGEDIT.TXT %1 %2
c:
mode co80
goto :INS_end


:INS_018
REM **************************************************************
REM ********************                      ********************
REM ******************** General introduction ********************
REM ********************                      ********************
REM **************************************************************

insmsg /CLEAR INS001.TXT %1 %2
if ERRORLEVEL 1 goto :INS_999

REM **************************************************************
REM ********************                      ********************
REM ********************     Install s/w      ********************
REM ********************                      ********************
REM **************************************************************

insmsg /NOCLEAR INS002.TXT %1 %2
if ERRORLEVEL 1 goto :INS_999

REM ******************** Check if previous version in \RAPIER

%1dirchk %2\RAPIER
if ERRORLEVEL 1 goto :INS_020

REM ******************** \RAPIER already exists
REM ******************** Remove unwanted files from Rapier
REM ********************    these are diagno.exe
REM ********************          and rapier.cfg
REM ********************	  and tiga.cfg
REM ********************   
REM ********************   Ensure all other files are r/w so that they 
REM ********************   may be overwritten.

if not exist %2\RAPIER\*.* goto :INS_025
%1RW -r %2\RAPIER\ *.* >nul

if exist %2\RAPIER\DIAGNO.EXE del %2\RAPIER\DIAGNO.EXE 
if exist %2\RAPIER\RAPIER.CFG del %2\RAPIER\RAPIER.CFG 
if exist %2\RAPIER\TIGA.CFG del %2\RAPIER\TIGA.CFG 


goto :INS_025

REM ******************** Prepare to make directory and copy files

:INS_020
md %2\rapier >nul

:INS_025
%1
cd \
copy %1rapier.cl %2\rapier >nul
copy %1tigacd.exe %2\rapier >nul
copy %1tigagm.out %2\rapier >nul
copy %1extprims.rlm %2\rapier >nul
copy %1config.exe %2\rapier >nul
copy %1zoom.exe %2\rapier >nul
copy %1zoom.dll %2\rapier >nul
copy %1diags.exe %2\rapier >nul
copy %1diags.rlm %2\rapier >nul
copy %1readme.txt %2\rapier >nul
copy %1rap512.tif %2\rapier >nul

REM ******************** Continue installation
insmsg /NOCLEAR INS003.TXT %1 %2
if ERRORLEVEL 1 goto :INS_999

%2
cd \rapier
%2\rapier\config -m%2\RAPIER 
if ERRORLEVEL 1 goto :INS_999

%1
insmsg /NOCLEAR INS004.TXT %1 %2
if ERRORLEVEL 1 goto :INS_999

REM ***  Run autoexec modifier. ****

automod %2\RAPIER
if ERRORLEVEL 1 goto :INS_950
if not exist c:\autoexec.tmp goto :INS_950

if exist %2\rapier\autoexec.old goto :INS_955
if exist %2\rapier\autoexec.sav ren %2\rapier\autoexec.sav *.old >nul

:INS_955
copy c:\autoexec.bat %2\rapier\*.sav >nul
if not exist %2\rapier\autoexec.sav goto :INS_960

del c:\autoexec.bat >nul
rename c:\autoexec.tmp *.bat >nul

:INS_700
%1
insmsg /NOCLEAR INS005.TXT %1 %2

:INS_710
%2
cd \rapier
mode co80
ECHO **********************************
ECHO *                                *
ECHO * *** Installation Complete ***  *
ECHO *                                *
rem ECHO * Please follow the instructions *
rem ECHO * 3,4,5 and 6 in the 'Installing *
rem ECHO * The Software' section in the   *
rem ECHO * Installation and User Guide    *
rem ECHO *                                *
ECHO **********************************

goto :INS_end

REM ******************** Drive Parameters Incorrect

:INS_800
mode co80
ECHO ******************************************
ECHO *                                        *
ECHO *   *** Drive Parameters Incorrect ***   *
ECHO *                                        *
ECHO * INSTALL must be passed the source and  *
ECHO * destination drives.                    *
ECHO *                                        *
ECHO * Example:                               *
ECHO *                                        *
ECHO *     A:INSTALL A: C:                    *
ECHO *                                        *
ECHO * Where                                  *
ECHO *                                        *
ECHO *     A: - is the source drive           *
ECHO *     C: - is the destination drive      *
ECHO *                                        *
ECHO ******************************************
pause
goto :INS_999

:INS_900
mode co80
ECHO ******************************************
ECHO *                                        *
ECHO *   *** Drive Parameters Incorrect ***   *
ECHO *                                        *
ECHO * INSTALL must have a destination drive  *
ECHO * of C: to G: ONLY.		      *
ECHO *                                        *
ECHO * Example:                               *
ECHO *                                        *
ECHO *     A:INSTALL A: C:                    *
ECHO *                                        *
ECHO * Where                                  *
ECHO *                                        *
ECHO *     A: - is the source drive           *
ECHO *     C: - is the destination drive      *
ECHO *                                        *
ECHO ******************************************
pause
goto :INS_999


REM ****** Autoexec.bat modification error
:INS_950
mode co80
ECHO ******************************************
ECHO *                                        *
ECHO * *** Unable to modify autoexec.bat ***  *
ECHO *                                        *
ECHO ******************************************
pause
goto :INS_999

REM ****** Autoexec.sav error
:INS_960
mode co80
CLS
ECHO ******************************************
ECHO *                                        *
ECHO * *** Error backing up autoexec.bat ***  *
ECHO *                                        *
ECHO ******************************************
pause
goto :INS_999


REM ****** Processor Error
:INS_970
mode co80
CLS
ECHO ******************************************
ECHO *                                        *
ECHO *     *** Wrong Processor Type ***       *
ECHO *                                        *
ECHO * Rapier 24 is compatible with 80386     *
ECHO * and better processors only.            *
ECHO *                                        *
ECHO ******************************************
pause
goto :INS_999




REM ****** XMS Driver Present Error
:INS_980
mode co80
CLS
ECHO ******************************************
ECHO *                                        *
ECHO *       *** XMS Driver Active ***        *
ECHO *                                        *
ECHO * An XMS Driver has been detected.       *
ECHO * Please remove the driver from memory   *
ECHO * (It can be found in your CONFIG.SYS)   *
ECHO * and re-install the Rapier software.    *
ECHO *                                        *
ECHO ******************************************
pause
goto :INS_999




REM ******************** Insufficient disk space

:INS_850
mode co80
ECHO ******************************************
ECHO *                                        *
ECHO *    *** Insufficient Disk Space ***     *
ECHO *                                        *
ECHO * The designated destination drive does  *
ECHO * not have sufficient free space.        *
ECHO *                                        *
ECHO * To successfully install this software  *
ECHO * and have some space for applications   *
ECHO * you need a minimum of 1.2 MB of        *
ECHO * free disk space.                       *
ECHO *                                        *
ECHO ******************************************
pause

REM ******************** Abort installation

:INS_999
mode co80
ECHO ***************************************
ECHO *                                     *
ECHO *    *** Installation aborted ***     *
ECHO *                                     *
ECHO ***************************************
c:
cd \

:INS_end
echo on
