/*****************************************************************************

    Module	    : DVA.C
    Created	    : 20th September 1989
    Author	    : Mike Brassington
	Amended		 : 20th May 1991 (calls to DLL instead of to MIC direct)

    Description	: This contains the Window routines for the Digital
				  Video Adapter control program.

    Copyright 1988,1989 by VideoLogic Limited. All rights reserved.

	No part of this software,either material or conceptual may be
	copied or distributed,transmitted,transcribed,stored in a
	retrieval system or translated into any human or computer language
	in any form by any means,electronic,mechanical,manual or other-
	wise,or disclosed to third parties without the express written
	permission of VideoLogic Limited,Unit 8,Homepark industrial estate,
	Kings Langley,Herts. WD4 8LZ. UK.

	************************************************************************
	*                                                                      *
	*                  FOR DEMONSTRATION PURPOSES ONLY                     *
	*  This source code is supplied as a demonstration of the techniques   *
	*  involved in the writing of Windows applications that intend to      *
	*  make use of the Videologic DVA-4000 Digital Video Adapter.          *
	*  Videologic Ltd. accept no liability for loss of business or damage  *
	*  arising from the use of this software either in whole or in part.   *
	*                                                                      *
	************************************************************************

	MODIFICATIONS:

    FUNCTIONS:
	WinMain() - calls initialization function, processes message loop
	InitDVA() - initializes window data and registers window
	DVAWndProc() - application specific message processor
	DVADlgAboutProc() - processes messages for "ABOUT_BOX" modal dialog box
	DVADlgDFAProc() - processes messages for "DFA_BOX1/2" modeless dialog boxes
	DVADlgPlrProc() - processes messages for "PLR_BOX1/2" modeless dialog boxes

****************************************************************************/

#define LINT_ARGS TRUE				/* enable type checking in libraries */
#include <windows.h>                            /* required for all Windows applications */
#include <dos.h>
#include <stdio.h>
#include <string.h>

#include "micdll.h"
#include "DVA.h"					/* specific to this program */

void DVAtrans ( void );

/* Declare external references */
extern int VertRes,HorzRes;			/* screen resolution variables */
extern DWORD WinColour;				/* window background colour */
extern HBRUSH hWindBrush;			/* brush for window background */
extern int WinWidth,WinHeight;		/* current window width and height */

/* Declare constants */
#define NAMELEN 	10				/* Length of Application and Class name */
#define TITLELEN	30				/* Length of window title */
#define MICBUFLEN	30				/* length of MIC command buildup buffer */
#define GENBUFLEN	80				/* length of general character buffer */
#define TILEDWND	WS_TILEDWINDOW 
#define PALETTESIZE 16

/* declare variables */
HANDLE hInst;						/* current instance */
HANDLE hPrevInst;					/* previous instance */
HANDLE		hPal;	       /* Handle to the application's logical palette */
NPLOGPALETTE	pLogPal;       /* Pointer to program's logical palette        */
HMENU hMenuSave;					/* copy of DVAMenu menu handle */
HMENU hSysMenu;					/* copy of system menu handle */
HWND hWin;							/* window handle of current instance */
char szAppName[NAMELEN];			/* Application name */
char szTitle[TITLELEN];				/* Window Title text */
char GenBuf[GENBUFLEN];				/* General string */
BOOL FreezeActive = FALSE;			/* default to video not frozen */
BOOL SquashActive = TRUE;			/* default to video compressed */
BOOL PropActive = FALSE;			/* default to video compressed to window */
BOOL LockActive = FALSE;			/* default to video not locked to window */
BOOL AudioActive = FALSE;			/* default to no audio from DVA */	
BOOL HideActive = FALSE;			/* default to window not hidden */	
BOOL VideoOn  = TRUE;				/* default to video on */
BOOL AudioOn = FALSE;				/* default to audio from source off */
BOOL IndexOn = FALSE;				/* default to frame number index off */	
BOOL DFABoxOff = TRUE;				/* default activity status for DFA box */
BOOL PLRBoxOff = TRUE;				/* default activity status for PLR box */
BOOL CapBoxOff = TRUE;				/* default activity status for CAP box */
BOOL CapBoxOn = FALSE;				/* default activity status for CAP box */

BOOL DFABoxOn = FALSE;				/* default activity status for DFA box */
BOOL PLRBoxOn = FALSE;				/* default activity status for PLR box */	
BOOL VidSrc   = FALSE;
LONG WinStyle = TILEDWND;			/* default style for DVA window */
FARPROC lpDFAProc;					/* DFA dialogbox far procedure pointer */ 
FARPROC lpPlrProc;					/* Player dialogbox far proc pointer */
FARPROC lpAboutProc;				/* About dialogbox far proc pointer */
HWND hDlgDFA = NULL;				/* DFA dialogbox handle */
HWND hDlgPlr = NULL;				/* Player dialogbox handle */
int UserRequest = IDRETRY;			/* Response from Abort/Retry/Ignore */
int HWInitErr = 3;					/* Player,board,tuner init error status */
int PlayerNum = 1;					/* Player number - default player 1 */
WORD PlrStatus = IDDC_STILL;		/* Default Plr controlbox item */
WORD DFAStatus = IDDC_SQSH;			/* Default DFA controlbox item */


/****************************************************************************

    FUNCTION: WinMain(HANDLE,HANDLE,LPSTR,int)

    PURPOSE: calls initialization function, processes message loop

    COMMENTS:

	This will initialize the window class and set up Normal Framestore
	mode if it is the first time this application is run. If this is the 
	second instance of the program then Parallel mode is set up. In the
	former case Fieldstore references are explicitly to fieldstore 1, in 
	the latter, to fieldstore 2. It then creates the window and processes 
	the message loop until a PostQuitMessage is received.  It exits the
	application by returning the value passed by the PostQuitMessage.

****************************************************************************/

int PASCAL WinMain(hInstance,hPrevInstance,lpCmdLine,nCmdShow)
HANDLE hInstance;					/* current instance */
HANDLE hPrevInstance;				/* previous instance */
LPSTR lpCmdLine;					/* command line */
int nCmdShow;						/* show-window type (open/icon) */
{
	HWND hWnd;						/* window handle */
	MSG  msg;						/* message */

	hInst = hInstance;			/* Save the current instance handle */
	hPrevInst = hPrevInstance;	/* Save previous instance handle */
	

/* Check that this instance of DVA is loadable. If FrameStore mode is Normal 
   then this a loadable instance of the application. If the mode is Dual or
   Parallel then this is the third instance and will be terminated. */ 

	switch (DVAIsLoadable())
		{
		case 0:						/* No error, continue */
            break;

		case 1:						/* MIC-DD not memory resident */		
			LoadString(hInstance,IDS_MICDDLOADERR,GenBuf,40);
			MessageBox(NULL,GenBuf,NULL,						/* display message box and */
		    	 MB_OK | MB_ICONEXCLAMATION | MB_SYSTEMMODAL);	/* halt until user response */
			return(NULL);										/* return and terminate */

		case 2: 					/* MIC-DD open error */ 
			LoadString(hInstance,IDS_MICDDOPENERR,GenBuf,40);
			MessageBox(NULL,GenBuf,NULL,						/* display message box and */
			     MB_OK | MB_ICONEXCLAMATION | MB_SYSTEMMODAL);	/* halt until user response */
			return(NULL);										/* return and terminate */

		case 3:						/* MIC-SERV not memory resident */
			LoadString(hInstance,IDS_MICSVLOADERR,GenBuf,40);
			MessageBox(NULL,GenBuf,NULL,						/* display message box and */
			     MB_OK | MB_ICONEXCLAMATION | MB_SYSTEMMODAL);	/* halt until user response */
			return(NULL);										/* return and terminate */

		case 4:						/* Third instance error */
			LoadString(hInstance,IDS_TOOMANY,GenBuf,40);
			MessageBox(NULL,GenBuf,NULL,						/* display message box and */
			     MB_OK | MB_ICONEXCLAMATION | MB_SYSTEMMODAL);	/* halt until user response */
			return(NULL);										/* return and terminate */
		}
		
		SetScreenAttr(hPrevInst);	/* Set current screen attributes */
									/* (brush and background colour) */
   	
		if (!InitDVA(hInstance,hPrevInst))	/* Try to initialise window data */
		return (NULL);				/* Exit if unable to initialize */


	while (UserRequest == IDRETRY && HWInitErr)
	{
		PlayerNum = (hPrevInst) ? 0 : 1;		/* no player 2 in this ver */
	    HWInitErr = DVAInit(hPrevInst);	/* do hardware initialisation */
		switch (HWInitErr)					/* OK? */
		{								
			case 0:
				break;					/* No probs, continue */	

			case 1:						/* Player 1 absent */			
				LoadString(hInstance,IDS_MICPLR1ERR,GenBuf,40);
				UserRequest = MessageBox(NULL,GenBuf,NULL,
				     MB_ABORTRETRYIGNORE | MB_ICONEXCLAMATION);
				PlayerNum = 0;
				break;

			case 2:						/* Player 2 absent */			
				LoadString(hInstance,IDS_MICPLR2ERR,GenBuf,40);
				UserRequest = MessageBox(NULL,GenBuf,NULL,
				     MB_ABORTRETRYIGNORE | MB_ICONEXCLAMATION);
				PlayerNum = 0;
				break;

			case 3:						/* Tuner absent */			
				LoadString(hInstance,IDS_MICTVT1ERR,GenBuf,40);
				UserRequest = MessageBox(NULL,GenBuf,NULL,
				     MB_ABORTRETRYIGNORE | MB_ICONEXCLAMATION);
				break;
		}
		if (HWInitErr)				
		{
			switch(UserRequest)
			{
				case 0:				/* no memory for message box */
				case IDABORT:		/* user abort request */
					return(NULL);	/* return and terminate */
				
				case IDIGNORE:		/* user ignore request */	
				case IDRETRY:		/* user retry request */
					break;			/* continue */
			}
		}
	}
					

/* Create window and get a handle on it */

    if (!(hWnd = CreateWindow(szAppName,	/* Create window, params are: window class */

		szTitle,						/* window name */

		(DWORD)WinStyle,			/* window style */

										/* x position = ClientX - window frame */
		(HorzRes/4)-GetSystemMetrics(SM_CXFRAME),	

										/* y position = ... */
		(VertRes/4)-GetSystemMetrics(SM_CYCAPTION)+
							GetSystemMetrics(SM_CYFRAME),
										/* ClientY - window caption + frame */									

										/* width of window = ... */
		(HorzRes/2)+GetSystemMetrics(SM_CXFRAME)*2,
										/* width of client area + */
						  				/* width of 2 window frames*/

										/* height of window = ... */
		(VertRes/2)+GetSystemMetrics(SM_CYCAPTION)+
							GetSystemMetrics(SM_CYFRAME)*2,
										/* height of client area + */
										/* height of caption + height of two frames */

		NULL,							/* parent handle */

		NULL,							/* menu or child ID */

		hInstance,					/* instance */

		NULL)))						/* additional info */
			return (NULL);			/* window not created, terminate */
	hWin = hWnd;					/* copy window handle to global storage */
	hMenuSave = GetMenu(hWnd);
   ShowWindow(hWnd,nCmdShow);	/* draw the window on screen*/
   UpdateWindow(hWnd); 			/* and update client area via WM_PAINT */


/* Initialisation complete, board initialised and OK, window drawn and painted.
   We should have video in the window by now. We now enter the message 
   processing main loop, checking for dialog box commands. */

    while (GetMessage(&msg,NULL,NULL,NULL))	
	{
		if (hDlgDFA && IsDialogMessage(hDlgDFA,&msg))
			continue; 
		else 
		{
			if	(hDlgPlr && IsDialogMessage(hDlgPlr,&msg))
				continue;
			else
			{	
				TranslateMessage(&msg);		/* Translates virtual key codes */
				DispatchMessage(&msg);		/* Dispatches message to window */
			}
		}
    }
    return (msg.wParam);		/* Returns the value from PostQuitMessage */
}


/****************************************************************************

    FUNCTION: InitDVA(HANDLE,HANDLE)

    PURPOSE: Initializes window data and registers window class

    COMMENTS:

	Sets up a structure to register the window class.  Structure includes
	such information as what function will process messages, what cursor
	and icon to use, etc.

****************************************************************************/

BOOL InitDVA(hInstance,hPrevInst)
HANDLE hInstance;							/* current instance */
HANDLE hPrevInst;							/* previous instance */
{
    HANDLE hMemory;						/* handle to allocated memory */
    PWNDCLASS pWndClass;				/* structure pointer */
    BOOL bSuccess;						/* RegisterClass() result */

/* Load strings from resource */
    LoadString(hInstance,IDS_NAME,szAppName,NAMELEN);
    LoadString(hInstance,IDS_TITLE,szTitle,TITLELEN);
    
	if (!hPrevInst)
	{
		strcat(szTitle," (1)");
/* Get memory from Windows for window class structure and lock it */
   		hMemory = LocalAlloc(LPTR,sizeof(WNDCLASS));
    	pWndClass = (PWNDCLASS) LocalLock(hMemory);

/* Initialise structure */
	    pWndClass->style = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
	    pWndClass->lpfnWndProc = DVAWndProc;
	    pWndClass->hInstance = hInstance;
	    pWndClass->hIcon = NULL;
    	 pWndClass->hCursor = LoadCursor(NULL,IDC_ARROW);
    	 pWndClass->hbrBackground = NULL;  //hWindBrush;
	    pWndClass->lpszMenuName = "DVAMenu";
	    pWndClass->lpszClassName = szAppName;

/* Register window class */
	    bSuccess = RegisterClass(pWndClass);

/* Unlock the memory and return it to Windows */
    	LocalUnlock(hMemory);			    
    	LocalFree(hMemory); 			    

    	return (bSuccess);				/* Return result of registration */
	}
	else
	{
		strcat(szTitle," (2)");
		return(TRUE);
	}
}
										
/****************************************************************************

    FUNCTION: DVAWndProc(HWND,unsigned,WORD,LONG)

    PURPOSE:  Processes messages

    MESSAGES:

	WM_CREATE     - create window
	WM_SIZE       - redraw window
	WM_MOVE       - redraw window
	WM_PAINT      - redraw window
	WM_SETFOCUS	  - prioritise fieldstore
	WM_DESTROY    - destroy window
	WM_ERASEBGND  - redraw background
	WM_LBUTTONDBLCLK - mouse left button double-clicked
	WM_SYSCOMMAND - used to trap "About DVA" requests

    COMMENTS:	Application specific message handler

****************************************************************************/
										
long FAR PASCAL DVAWndProc(hWnd,message,wParam,lParam)
HWND hWnd;								/* window handle */
unsigned message;						/* type of message */
WORD wParam;							/* additional information */
LONG lParam;							/* additional information */
{
	HDC 			hDC;					/* display context variable */
	PAINTSTRUCT paintstruc;			/* paint structure */
	RECT			rect;
	int			iLoop;

	switch (message)					/* process messages */
	{
	case WM_COMMAND:					/* process command */
		switch (wParam)
		{
		case IDM_DVA:
			if (!DFABoxOn)
			{
				EnableMenuItem(hMenuSave,IDM_DVA,MF_GRAYED);
				ShowWindow(hDlgDFA,SW_SHOW);
				UpdateWindow(hDlgDFA);
			}
			else
			{
				EnableMenuItem(hMenuSave,IDM_DVA,MF_ENABLED);
				ShowWindow(hDlgDFA,SW_HIDE);
				UpdateWindow(hDlgDFA);
			}
			DFABoxOn = !DFABoxOn;
			if ((WinStyle & TILEDWND) == TILEDWND)
				DrawMenuBar(hWnd);
			break;

		case IDM_PLAYER:
			if (!PLRBoxOn)
			{
				EnableMenuItem(hMenuSave,IDM_PLAYER,MF_GRAYED);
				ShowWindow(hDlgPlr,SW_SHOW);
				UpdateWindow(hDlgPlr);
			}
			else
			{
				EnableMenuItem(hMenuSave,IDM_PLAYER,MF_ENABLED);
				ShowWindow(hDlgPlr,SW_HIDE);
				UpdateWindow(hDlgPlr);
			}
			PLRBoxOn = !PLRBoxOn;
			if ((WinStyle & TILEDWND) == TILEDWND)
				DrawMenuBar(hWnd);
			break;
		}
		break;

/* the following two cases deal with the redrawing of the window after a
resize or move operation */

	case WM_ERASEBKGND:					
		GetClientRect(hWnd,&rect);		/* Get client area */
		hDC = GetDC(hWnd);
	   SelectObject(hDC,hWindBrush);	/* Select background brush */
	   FillRect(hDC,&rect,hWindBrush); /* and fill with it */
		ReleaseDC(hWnd,hDC);

		break;


	case WM_PAINT:
		if (!DVAGetFMode() && hPrevInst)	/* if mode Normal and 2nd inst */
		{
			hPrevInst = NULL;
			IndexOn = FALSE;
			AudioOn = FALSE;
			SendMIC("still #1 100;aud off;aud input1;ind #1 off");
			DestroyWindow(hDlgDFA);
			FreeProcInstance(lpDFAProc);
			DestroyWindow(hDlgPlr);
			FreeProcInstance(lpPlrProc);
			lpDFAProc = MakeProcInstance(DVADlgDFAProc,hInst);
			sprintf(GenBuf,"DFA_BOX%c",'1');
			hDlgDFA = CreateDialog(hInst,GenBuf,hWnd,lpDFAProc);
			DFABoxOn = !DFABoxOn;
			DFABoxOff = FALSE;
			lpPlrProc = MakeProcInstance(DVADlgPlrProc,hInst);
			sprintf(GenBuf,"PLR_BOX%c",'1');
			hDlgPlr = CreateDialog(hInst,GenBuf,hWnd,lpPlrProc);
			PLRBoxOn = FALSE;
			PLRBoxOff = FALSE;	
			if (PlayerNum)				/* if there was a player 2 */
				ChangeMenu(GetMenu(hWnd),IDM_PLAYER,"&Player1",IDM_PLAYER,MF_CHANGE);
			else
				ChangeMenu(GetMenu(hWnd),IDM_PLAYER,"&Player1",IDM_PLAYER,MF_APPEND);
			PlayerNum = 1;
			SetWindowText(hWnd,"Digital Video (1)");
			SendMessage(hWnd,WM_COMMAND,IDM_DVA,0L);
			SendMessage(hWnd,WM_COMMAND,IDM_PLAYER,0L);
		}
		hDC = BeginPaint(hWnd,&paintstruc);	/* repaint via our paint struct */	
		EndPaint(hWnd,&paintstruc);
		break;

	case WM_SETFOCUS:
		DVAPrior();
		break;

	case WM_SIZE:							/* Re-size window message handling */
		DVASize(hWnd,wParam,lParam);	/* process new size */
		break;

	case WM_MOVE:							/* Move window message handling */
		DVAMove(hWnd,wParam,lParam);	/* process new position */
		break;

	case WM_RBUTTONDBLCLK:
		VidSrc = !VidSrc;
		DVASource(VidSrc);
		break;

	case WM_LBUTTONDBLCLK:
		if ((WinStyle & TILEDWND) == TILEDWND)
		{
			WinStyle = GetWindowLong(hWnd,GWL_STYLE) & ~TILEDWND;
			SetWindowLong(hWnd,GWL_STYLE,WinStyle);
			SetMenu(hWnd,NULL);
		}
		else
		{
			WinStyle = GetWindowLong(hWnd,GWL_STYLE) | TILEDWND;
			SetWindowLong(hWnd,GWL_STYLE,WinStyle);
			SetMenu(hWnd,hMenuSave);
		}
		InvalidateRect(hWnd,(LPRECT)NULL,TRUE);
		BringWindowToTop(hWnd);
		UpdateWindow(hWnd);
		break;

	case WM_SYSCOMMAND:
		if (wParam == IDM_ABOUT)
		{
			lpAboutProc = MakeProcInstance(DVADlgAboutProc,hInst);
			DialogBox(hInst,"ABOUT_BOX",hWnd,lpAboutProc);
			FreeProcInstance(lpAboutProc);
			return(NULL);
		}
      else
		    return(DefWindowProc(hWnd,message,wParam,lParam));

	case WM_CREATE:						/* Create Window message handling */
	   /* Allocate enough memory for a logical palette with
	    * PALETTESIZE entries and set the size and version fields
	    * of the logical palette structure.
	    */
	   pLogPal = (NPLOGPALETTE) LocalAlloc (LMEM_FIXED,
						(sizeof (LOGPALETTE) +
						(sizeof (PALETTEENTRY) * (PALETTESIZE))));

	   pLogPal->palVersion    = 0x300;
	   pLogPal->palNumEntries = PALETTESIZE;

	   /* fill in intensities for all palette entry colors */
	   for (iLoop = 0; iLoop < PALETTESIZE; iLoop++)
		{
			*((WORD *) (&pLogPal->palPalEntry[iLoop].peRed)) = iLoop;
			pLogPal->palPalEntry[iLoop].peBlue  = 0;
			pLogPal->palPalEntry[iLoop].peFlags = PC_EXPLICIT;
	   }
	   hPal = CreatePalette ((LPLOGPALETTE) pLogPal);

		hDC = GetDC(hWnd);
		SelectPalette(hDC, hPal, 1);
		RealizePalette(hDC);

		hWindBrush = CreateSolidBrush(PALETTEINDEX(13));
		SelectObject (hDC,hWindBrush) ;

		ReleaseDC(hWnd,hDC);

		hSysMenu = GetSystemMenu(hWnd,FALSE);
		ChangeMenu(hSysMenu,NULL,NULL,NULL,MF_APPEND | MF_SEPARATOR);
		ChangeMenu(hSysMenu,NULL,"A&bout DVA...",IDM_ABOUT,MF_APPEND | MF_STRING);
		lpDFAProc = MakeProcInstance(DVADlgDFAProc,hInst);
		sprintf(GenBuf,"DFA_BOX%c",(!hPrevInst) ? '1' : '2');
		hDlgDFA = CreateDialog(hInst,GenBuf,hWnd,lpDFAProc);
		DFABoxOn = FALSE;
		DFABoxOff = FALSE;
		if (!hPrevInst)					/* if this is the first instance... */
			SendMIC("aud off");			/* turn audio off */
		else
			SetWindowText(GetDlgItem(hDlgDFA,IDDC_MUTE),"    ");
		lpPlrProc = MakeProcInstance(DVADlgPlrProc,hInst);
		sprintf(GenBuf,"PLR_BOX%c",(!hPrevInst) ? '1' : '2');
		hDlgPlr = CreateDialog(hInst,GenBuf,hWnd,lpPlrProc);
		PLRBoxOn = FALSE;
		PLRBoxOff = FALSE;
		if (PlayerNum)					/* if there is a player */
		{
			sprintf(GenBuf,"&Player%d",PlayerNum);
			ChangeMenu(GetMenu(hWnd),IDM_PLAYER,GenBuf,IDM_PLAYER,MF_APPEND);
			SendMIC("ind #%d off",PlayerNum);	/* set no index */
		}
	   break;

	case WM_CLOSE:						/* Close Window message handling */
/*		SendMIC("ind #%d off",PlayerNum);
*/	    return(DefWindowProc(hWnd,message,wParam,lParam));

	case WM_DESTROY:		  			/* window being destroyed message */
		DVAClose(hPrevInst);			/* terminate DVA, tidy up h/w state */
		DestroyWindow(hDlgDFA);
		DestroyWindow(hDlgPlr);
		FreeProcInstance(lpDFAProc);
		FreeProcInstance(lpPlrProc);
	   DeleteObject((HANDLE)hWindBrush);
	   if (pLogPal->palNumEntries)
		  DeleteObject (hPal);
	   PostQuitMessage(0);
	   break;

//   case WM_ACTIVATE:
//       if (wParam == 2 ) DVAtrans();
//       break;

	default:							/* Pass message on if unprocessed */
	    return (DefWindowProc(hWnd,message,wParam,lParam));
	}
	return (NULL);
}


/****************************************************************************

    FUNCTION: DVADlgAboutProc(HWND,unsigned,WORD,LONG)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

	WM_INITDIALOG - initialize dialog box
	WM_COMMAND    - Input received

    COMMENTS:

	No initialization is needed for this particular dialog box, but TRUE
	must be returned to Windows.

	Wait for user to click on "Ok" button, then close the dialog box.

****************************************************************************/

BOOL FAR PASCAL DVADlgAboutProc(hDlg,message,wParam,lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
	switch (message) 
	{
	case WM_INITDIALOG:				/* message: initialize dialog box */
	    return (TRUE);

	case WM_COMMAND:					/* message: received a command */
		if (wParam == IDOK)	 	   /* "OK" box selected? */
		{
			EndDialog(hDlg,NULL);	/* Exit the dialog box */
			return (TRUE);
		}
		break;
	}
	return (FALSE);					/* Didn't process a message */
}

BOOL FAR PASCAL DVADlgDFAProc(hDlg,message,wParam,lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
	switch (message) 
	{
	case WM_INITDIALOG:				/* message: initialize dialog box */
		SetFocus(GetDlgItem(hDlg,DFAStatus));	/* focus on last ctrl */		
		return(FALSE);

	case WM_COMMAND:		      		/* message: received a command */
		DFAStatus = wParam;
		switch (wParam)			
		{
			case IDDC_SQSH:
				if (!SquashActive)		/* if have something to do */
				{
					if (LockActive)				/* if locked */
					{
						DVASquash(TRUE);	/* return to squashed state */
						LockActive = FALSE;
					}
					else						/* not locked must be zoomed */
		    			DVAProp(FALSE);	/* return to squashed state */
					PropActive = FALSE;
					SquashActive = TRUE;
				}
				break;

			case IDDC_ZOOM:
				if (LockActive)			/* if locked */
				{
					DVALock(FALSE);		/* unlock and zoom */	
					LockActive = FALSE;
				}
				else 
				{
					if (SquashActive)
					{
						DVAProp(TRUE);		/* then return to zoomed */
						SquashActive = FALSE;
						PropActive = TRUE;
					}
				}
				break;

			case IDDC_LOCK:				/* if about to lock */
				if (!LockActive)			/* if not locked */
				{
					if (!PropActive)		/* if not zoomed */
						DVAProp(TRUE);		/* then zoom */
					DVALock(TRUE);			/* return to locked state */
					SquashActive = FALSE;
					PropActive = TRUE; 
					LockActive = TRUE;
				}
				break;

			case IDDC_FREZ:
				FreezeActive = !FreezeActive;
				DVAFreeze(FreezeActive);
				if (FreezeActive)
					SetWindowText(GetDlgItem(hDlg,wParam),"Thaw");
				else
					SetWindowText(GetDlgItem(hDlg,wParam),"Freeze");
				break;		

			case IDDC_MUTE:				/* Audio channels dialog item handling */
				if (hPrevInst)				/* if it's the second instance */
					break;					/* inhibit changes to this button */
				if (AudioActive)			/* if audio on, mark as not in */
				{
					SendMIC("fade 0,0/a1/a2");
					SetWindowText(GetDlgItem(hDlg,wParam),"Audio");
				}
				else						/* if audio not on, mark as in use */
				{
					SendMIC("fade 255,0/a1/a2");
					SetWindowText(GetDlgItem(hDlg,wParam),"Mute");
				}	
				AudioActive = !AudioActive;			/* set state flag */
			    break;

			case IDDC_HIDE:				/* Hide dialog item handling */
   		 		if (HideActive)		/* if window hidden */
				{
					ShowWindow(hWin,SW_SHOW);
					SetWindowText(GetDlgItem(hDlg,wParam),"Hide");
					SendMIC("FST OUTPUT 0 %d ENABLE",(hPrevInst) ? 2 : 1);
				}
				else
				{
					ShowWindow(hWin,SW_HIDE);
					SetWindowText(GetDlgItem(hDlg,wParam),"Show");
					SendMIC("FST OUTPUT 0 %d DISABLE",(hPrevInst) ? 2 : 1);
				}
				HideActive = !HideActive;			/* set state flag */
		    	break;
		}
		return(TRUE);

	case WM_MOVE:
		return(TRUE);

	case WM_CLOSE:
		if (!HideActive)
			SendMessage(hWin,WM_COMMAND,IDM_DVA,0L);
		return(TRUE);

	case WM_DESTROY:
		DFABoxOff = TRUE;
		return(TRUE);
	}
	return(FALSE);
}

BOOL FAR PASCAL DVADlgPlrProc(hDlg,message,wParam,lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
	switch (message) 
	{
	case WM_INITDIALOG:				/* message: initialize dialog box */
		SetFocus(GetDlgItem(hDlg,PlrStatus));		
	    return (FALSE);				/* focus set to last used button */

	case WM_COMMAND:		      	/* message: received a command */
		PlrStatus = wParam;
		switch (wParam)
		{
		case IDDC_FORWARD:					
			SendMIC("play #%d",PlayerNum);	/* set no index */
		   break;

		case IDDC_BACKWARD:
			SendMIC("play #%d /r",PlayerNum);	
		   break;

		case IDDC_STEPFOR:					
			SendMIC("step #%d",PlayerNum);	
		   break;

		case IDDC_STEPBACK:
			SendMIC("step #%d /r",PlayerNum);	
		   break;

		case IDDC_FASTFOR:
			SendMIC("play #%d /f",PlayerNum);	
		   break;

		case IDDC_FASTBACK:
			SendMIC("play #%d /f/r",PlayerNum);	
		   break;

		case IDDC_SCANFOR:					
			SendMIC("play #%d /sc",PlayerNum);	
		   break;

		case IDDC_SCANBACK:
			SendMIC("play #%d /sc/r",PlayerNum);	
		   break;

		case IDDC_STILL:
			SendMIC("still #%d",PlayerNum);	
		   break;

		case IDDC_INDEX:
		   if (IndexOn)
				SendMIC("index #%d off",PlayerNum);	
		   else
				SendMIC("index #%d on",PlayerNum);	
	  		IndexOn = !IndexOn;
		   break;

		case IDDC_RESET:
			SendMIC("INI #%d",PlayerNum);
			SendMIC("STILL #%d 100",PlayerNum);
			IndexOn = FALSE;
		   break;
		}
		return(TRUE);

	case WM_MOVE:
		return(TRUE);

	case WM_CLOSE:
		SendMessage(hWin,WM_COMMAND,IDM_PLAYER,0L);
		return(TRUE);

	case WM_DESTROY:
		PLRBoxOff = TRUE;
		return(TRUE);
    }
	return(FALSE);
}

WORD SetDlgItem(HWND hDlg, WORD DlgItem, WORD Action)
{
	CheckDlgButton(hDlg,DlgItem,Action);
	return(Action);
}
