/***************************************************************************
;++
Name		:	termreg.h
Title		:	Terminator low-level i/o header file.
Author		:	Nick Jones
Created		:	30/11/92

Copyright 1992 by VideoLogic Limited. All rights reserved.
			No part of this software, either material or conceptual may be
			copied or distributed, transmitted, transcribed, stored in a
			retrieval system or translated into any human or computer language
			in any form by any means, electronic, mechanical, manual or other-
			wise, or disclosed to third parties without the express written
			permission of VideoLogic Limited, Unit 8, Homepark Industrial
			Estate, King's Langley, Hertfordshire, WD4 8LZ, U.K.

Description	:	Module interface header for terminator registers.
;--
****************************************************************************/

#if	!defined _TERMREG_
#define _TERMREG_

#include "masdefs.h"

/* Register Map element structure */
typedef struct
{
	BYTE bStatus;
	BYTE bAddress;
	WORD wData;
} REG_MAP;

/* Status Byte flags in Register Map */
#define STATUS_VALID			0x01
#define ATTRIB_WORD				0x02
#define ATTRIB_BYTE				0x00
#define ATTRIB_READONLY			0x04
#define ATTRIB_WRITEONLY		0x08
#define DEVICE_ARSENAL			0x10
#define DEVICE_M2				0x20
#define DEVICE_VXD				0x30
#define DEVICE_I2C				0x40
#define STATUS_CHANGED			0x80


/* Register Map Logical addresses : Arsenal chip */
#define	MAP_ARSENAL_CAPTURE		1
#define	MAP_ARSENAL_M2WR_ID16	2
#define	MAP_ARSENAL_M2READ      3
#define	MAP_ARSENAL_I2C        	4
#define	MAP_ARSENAL_SETUP       5
#define	MAP_ARSENAL_CONTROL     6
#define	MAP_ARSENAL_ICR         7
#define	MAP_ARSENAL_MEM_BASE    8
#define	MAP_SPARE		    	9

/* Register Map Logical addresses : M2 chip */
#define MAP_IDNUM				10
#define MAP_INTENB				11
#define MAP_INTFLG				12
#define MAP_INTRDY				13
#define MAP_STATUS				14
#define MAP_TSTMODE				15
#define	MAP_VIDSEL              16
#define	MAP_FSDATA              17
#define	MAP_FSRESET             18
#define	MAP_FSMODE              19
#define	MAP_DVPRIO              20
#define	MAP_MCTL                21
#define	MAP_DISPCTL             22
#define	MAP_DPIXNO              23
#define	MAP_BCKGNDY             24
#define	MAP_BCKGNDU             25
#define	MAP_BCKGNDV             26
#define	MAP_XMCTRL              27
#define	MAP_PIXPLINE            28
#define	MAP_PICSTART            29
#define	MAP_PICEND              30
#define	MAP_HSEND               31
#define	MAP_LINPFLD             32
#define	MAP_LINPPIC             33
#define	MAP_VSSTART             34
#define	MAP_VSEND               35
#define	MAP_SPGMODE             36
#define	MAP_RHSTART             37
#define	MAP_RHEND               38
#define	MAP_RVSTART             39
#define	MAP_RVEND               40
#define	MAP_RHFILT              41
#define	MAP_RVFILT              42
#define	MAP_RHSCALE             43
#define	MAP_RVSCALE             44
#define	MAP_FLDSYN              45
#define	MAP_CAPUSE              46
#define	MAP_RVSODD              47
#define	MAP_RVSEVEN             48
#define	MAP_RTLXFS1             49
#define	MAP_RTLYFS1             50
#define	MAP_RBRXFS1             51
#define	MAP_RBRYFS1             52
#define	MAP_FSXFS1              53
#define	MAP_FSYFS1              54
#define	MAP_DVSCFS1             55
#define	MAP_DVCTLFS1            56
#define	MAP_RTLXFS2             57
#define	MAP_RTLYFS2             58
#define	MAP_RBRXFS2             59
#define	MAP_RBRYFS2             60
#define	MAP_FSXFS2              61
#define	MAP_FSYFS2              62
#define	MAP_DVSCFS2             63
#define	MAP_DVCTLFS2            64

/* Register Map Logical addresses : 9051 chip */
#define	MAP_DMSD_STATUS         65
#define	MAP_DMSD_IDEL           66
#define	MAP_DMSD_HSYSTART       67
#define	MAP_DMSD_HSYSTOP        68
#define	MAP_DMSD_HCSTART        69
#define	MAP_DMSD_HCSTOP         70
#define	MAP_DMSD_HSSTART        71
#define	MAP_DMSD_HPEAK          72
#define	MAP_DMSD_HUE            73
#define	MAP_DMSD_CONTROL1       74
#define	MAP_DMSD_CONTROL2       75
#define	MAP_DMSD_CONTROL3       76
#define	MAP_DMSD_SDELAY         77

#define	MAP_END                 78


/* PHYSICAL ADDRESSES */

/* ARSENAL Addresses */
#define ARSENAL_CAPTURE			0x00
#define ARSENAL_M2WR_ID16		0x02
#define ARSENAL_M2READ			0x04
#define ARSENAL_I2C				0x06
#define ARSENAL_SETUP			0x08
#define ARSENAL_CONTROL			0x0A
#define ARSENAL_ICR				0x0C
#define ARSENAL_MEM_BASE		0x0E

/* M2 register addresses */
#define M2_IDNUM			0x00
#define M2_INTENB			0x01
#define M2_INTFLG			0x02
#define M2_INTRDY			0x03
#define M2_STATUS			0x04
#define M2_TSTMODE			0x0F
#define M2_VIDSEL       	0x10	/* Video bus control */
#define M2_FSDATA           0x18
#define M2_FSRESET          0x19
#define M2_FSMODE           0x1A
#define M2_DVPRIO           0x20
#define M2_MCTL				0x21	/* FS selection control */
#define M2_DISPCTL			0x22	/* Output */
#define M2_DPIXNOL			0x24
#define M2_DPIXNOH			0x25
#define M2_BCKGNDY			0x28
#define M2_BCKGNDU			0x29
#define M2_BCKGNDV			0x2A
#define M2_XMCTRL			0x2C
#define M2_PIXPLINEL		0x40
#define M2_PIXPLINEH		0x41
#define M2_PICSTARTL		0x42
#define M2_PICSTARTH		0x43
#define M2_PICENDL			0x44
#define M2_PICENDH			0x45
#define M2_HSEND			0x46
#define M2_LINPFLDL			0x48
#define M2_LINPFLDH			0x49
#define M2_LINPPICL			0x4A
#define M2_LINPPICH			0x4B
#define M2_VSSTARTL			0x4C
#define M2_VSSTARTH			0x4D
#define M2_VSEND			0x4E
#define M2_SPGMODE			0x4F
#define M2_RHSTART			0x50		/* IRegion X1 (Byte) */
#define M2_RHEND			0x51		/* IRegion X2 (Byte) */
#define M2_RVSTARTL			0x52		/* IRegion Y1 (Word) */
#define M2_RVSTARTH			0x53
#define M2_RVENDL			0x54		/* IRegion Y2 (Word) */
#define M2_RVENDH			0x55
#define M2_RHFILT			0x58
#define M2_RVFILT			0x59
#define M2_RHSCALE			0x5A		/* DRegion Ysize (Byte) */
#define M2_RVSCALE			0x5B		/* DRegion Xsize (Byte) */
#define M2_FLDSYN			0x5C
#define M2_CAPUSE			0x5D		/* Input capture mode */
#define M2_RVSODD			0x5E
#define M2_RVSEVEN			0x5F
#define M2_RTLXLFS1			0x60		/* FS1 WRegion X1 (Word) */
#define M2_RTLXHFS1			0x61
#define M2_RTLYLFS1			0x62		/* FS1 WRegion Y1 (Word) */
#define M2_RTLYHFS1			0x63
#define M2_RBRXLFS1			0x64		/* FS1 WRegion X2 (Word) */
#define M2_RBRXHFS1			0x65
#define M2_RBRYLFS1			0x66		/* FS1 WRegion Y2 (Word) */
#define M2_RBRYHFS1			0x67
#define M2_FSXLFS1			0x68		/* FS1 DRegion X1 (Word) */
#define M2_FSXHFS1			0x69
#define M2_FSYLFS1			0x6A		/* FS1 DRegion Y1 (Word) */
#define M2_FSYHFS1			0x6B
#define M2_DVSCFS1			0x6C
#define M2_DVCTLFS1			0x6D
#define M2_RTLXLFS2			0x70		/* FS2 WRegion X1 (Word) */
#define M2_RTLXHFS2			0x71
#define M2_RTLYLFS2			0x72		/* FS2 WRegion Y1 (Word) */
#define M2_RTLYHFS2			0x73
#define M2_RBRXLFS2			0x74		/* FS2 WRegion X2 (Word) */
#define M2_RBRXHFS2			0x75
#define M2_RBRYLFS2			0x76		/* FS2 WRegion Y2 (Word) */
#define M2_RBRYHFS2			0x77
#define M2_FSXLFS2			0x78		/* FS2 DRegion X1 (Word) */
#define M2_FSXHFS2			0x79
#define M2_FSYLFS2			0x7A		/* FS2 DRegion Y1 (Word) */
#define M2_FSYHFS2			0x7B
#define M2_DVSCFS2			0x7C
#define M2_DVCTLFS2			0x7D


/* 9051 DMSD Sub-addresses */
#define SUBADDR_IDEL		0x00
#define SUBADDR_HSYSTART	0x01
#define SUBADDR_HSYSTOP     0x02
#define SUBADDR_HCSTART     0x03
#define SUBADDR_HCSTOP      0x04
#define SUBADDR_HSSTART     0x05
#define SUBADDR_HPEAK       0x06
#define SUBADDR_HUE         0x07
#define SUBADDR_CONTROL1    0x08
#define SUBADDR_CONTROL2    0x09
#define SUBADDR_CONTROL3    0x0A
#define SUBADDR_SDELAY      0x0B
#define SUBADDR_STATUS      0x0C


/* Additional map literals */
#define DEVICE_MAP			0x00
#define DEVICE_MASK			0x70


#define VID_PIXELS_9051		676
#define VID_LINES_9051_PAL	283
#define VID_LINES_9051_NTSC	240
#define ACTIVE_9051_SITES	169

#define FS1					0
#define FS2					1

#define FULL_REGION			10000
#define INTSCALEUP			10000

#define IREGION_SCALE_X		640
#define IREGION_SCALE_Y		480

#define H_ROUNDING_DEFAULT	2
#define V_ROUNDING_DEFAULT	1

/* Status OFF Masks for ANDing */
#define NSTATUS_VALID			(~STATUS_VALID)
#define NSTATUS_CHANGED			(~STATUS_CHANGED)

/* Macro to flag register as changed */
/*#define CHANGE(REG)   RegMap[REG].bStatus &= (BYTE) NSTATUS_CHANGED*/
#define CHANGE(REG)   RegMap[REG].bStatus |= (BYTE) STATUS_CHANGED


/* NORMAL mode register values */
#define NORMAL_FE_VIDSEL		0x88	/* 10111000b */
#define NORMAL_FE_MCTL			0x09	/* 00001001b */
#define NORMAL_FE_FLDSYN		0x05	/* 00000101b */

#define ANALOG_FE_RVSODD		0x2D	/* 00101101b */
#define ANALOG_FE_RVSEVEN		0x11	/* 00010001b */


/* CAPUSE literals */
#define CAPTURE_NONE			0x00
#define CAPTURE_ALL				0x01
#define CAPTURE_EVEN			0x02
#define CAPTURE_ODD				0x03
#define USE_LATEST				0x10

#define CAP_FS1_MASK			0x03
#define CAP_FS1_EVEN			0x02
#define CAP_FS1_ODD				0x03
#define CAP_FS1_ALL				0x01
#define CAP_FS2_MASK			0x0C
#define CAP_FS2_EVEN			0x08
#define CAP_FS2_ODD				0x0C
#define CAP_FS2_ALL				0x04
#define CAP_LATEST				0x10


/* DISPCTL literals */
#define RECT0_ENABLE			0x01
#define RECT0_SOURCE_FS0		0x00
#define RECT0_SOURCE_FS1		0x02
#define RECT0_SOURCE_LATEST		0x04
#define RECT0_SOURCE_ALTERNATE	0x06
#define RECT1_ENABLE			0x08
#define RECT1_SOURCE_FS0		0x00
#define RECT1_SOURCE_FS1		0x10
#define RECT1_SOURCE_LATEST		0x20
#define RECT1_SOURCE_ALTERNATE	0x30
#define PRIORITY_RECT1			0x40
#define PRIORITY_RECT0			0x00

/* Filter literals */
#define SCW_NO_V_INT_OR_FILT	0x04

/* M2 SPG settings */
#define M2_H_BACK_PORCH			8
#define M2_H_SYNC_WIDTH			4
#define M2_H_FRONT_PORCH		0
#define M2_V_TOTAL_BLANK		2
#define	M2_V_PIC_END_BLANK		20
#define M2_V_SYNC_WIDTH			3

/* MIC record mode settings :
#define M2_H_BACK_PORCH			50
#define M2_H_SYNC_WIDTH			12
#define M2_H_FRONT_PORCH		20
#define	M2_H_MIN_TOTAL			256
#define M2_V_TOTAL_BLANK		28
#define	M2_V_PIC_END_BLANK		20
#define M2_V_SYNC_WIDTH			3
*/


#endif      /* _TERMREG_ */

/*****************************************************************************
	End of File.
*****************************************************************************/
