/*****************************************************************************
;++

Name            :   TERMIIC.H
Title           :   Header File for IIC Device Control
C Author        :   John Metcalfe & Marc Stevens
Created         :   16 November 1991

Copyright       :   1991 by VideoLogic Limited. All rights reserved.
                    No part of this software, either material or conceptual
                    may be copied or distributed, transmitted, transcribed,
                    stored in a retrieval system or translated into any
                    human or computer language in any form by any means,
                    electronic, mechanical, manual or other-wise, or
                    disclosed to third parties without the express written
                    permission of VideoLogic Limited, HomePark Estate,
                    King's Langley, Hertfordshire, WD4 8LZ, U.K.

Program Type    :   Generic C Header File

Modifications   :

Notes           :

;--
*****************************************************************************/
#if			!defined ( _TERMIIC_ )
#define     _TERMIIC_


/*****************************************************************************
        defines
*****************************************************************************/

#define 	IIC_CLOCK_BIT		((BYTE)0x1)	   		/* Clock bit */
#define 	IIC_DATA_BIT    	((BYTE)0x2)	   		/* Data bit */
#define 	IIC_CLOCK_POS		((BYTE)0x0)			/* Clock bit position */
#define 	IIC_DATA_POS    	((BYTE)0x1)			/* Data bit position */

#define 	IIC_READ    		((BYTE)0x01)  		/* Read from IIC */
#define 	IIC_MAX_BUFF_SPACE	((WORD)0x40)		/* IIC write buff max */


/*****************************************************************************
        structs
*****************************************************************************/
#define		IIC_WRITE_BUFF_FIELDS\
	LONG   Status;                  /* Status of operation */\
    BYTE   SlaveAddress;            /* Address of Device on IIC bus */\
    BYTE   SubAddress;              /* Sub Address to start writing at */\
    WORD   WBufferLength;    		/* Num bytes to write & bytes written */

/*
    IIC Write structure.
*/
typedef struct
{
	IIC_WRITE_BUFF_FIELDS
	BYTE   WriteSpace[IIC_MAX_BUFF_SPACE];     	/* space for writing */
} IIC_WRITEBUFF, *IIC_WRITEBUFF_PTR;

/*
    IIC Read structure.
*/
typedef struct
{
	LONG   Status;       				/* Status of operation */
	BYTE   SlaveAddress; 				/* Address of Device on IIC bus */
	BYTE   ReturnData;   				/* Data Read from device */
} IIC_READBUFF, *IIC_READBUFF_PTR;

/*****************************************************************************
	function prototypes
*****************************************************************************/
LRESULT WriteIICDevice(IIC_WRITEBUFF_PTR WBPtr);
LRESULT ReadIICDevice(IIC_READBUFF_PTR RBPtr);
void	ClockDelay(int Delay);

#endif /*_TERMIIC_*/

/*****************************************************************************
	End of File.
*****************************************************************************/

