/***************************************************************************
;++

Name			:	MASDEFS.H
Title			:	Useful Data Type Typedefs
Author			:	Marc Stevens
Created			:	31/MAY/93

	Copyright 1992 by VideoLogic Limited. All rights reserved.
	No part of this software, either material or conceptual may be
	copied or distributed, transmitted, transcribed, stored in a
	retrieval system or translated into any human or computer language
	in any form by any means, electronic, mechanical, manual or other-
	wise, or disclosed to third parties without the express written
	permission of VideoLogic Limited, Unit 8, Homepark Industrial
	Estate, King's Langley, Hertfordshire, WD4 8LZ, U.K.

Description		:	Contains useful Typedefs

Program Type    :   C Header File. 

Modifications   :

Notes           :

;--
****************************************************************************/
#if !defined( _MASDEFS_ )
#define _MASDEFS_
/****************************************************************************/
/*  Marc's basic Data type typedefs										    */
/****************************************************************************/
#define NEAR

typedef	void			VOID;			/* Ansi void						*/
typedef	signed char		CHAR;			/* 8 bit signed data				*/
typedef	unsigned char	BYTE;			/* 8 bit unsigned data				*/
typedef	unsigned short	WORD;			/* 16 bit unsigned data				*/ 
typedef	unsigned long	DWORD;			/* 32 bit unsigned data				*/
typedef	short			INT;			/* 16 bit signed integer			*/
typedef	long			LONG;			/* 32 bit signed integer			*/
typedef double			DOUBLE;			/* 32-64 bit IEEE real 				*/

typedef	VOID			*PVOID;			/* ptr to Ansi void					*/
typedef	CHAR 			*PCHAR;			/* ptr to 8 bit signed data	  		*/
typedef	BYTE 			*PBYTE;			/* ptr to 8 bit unsigned data 		*/
typedef	WORD 			*PWORD;			/* ptr to 16 bit unsigned data		*/ 
typedef	DWORD			*PDWORD;		/* ptr to 32 bit unsigned data		*/
typedef	INT 			*PINT;			/* ptr to 16 bit signed integer		*/
typedef	LONG			*PLONG;			/* ptr to 32 bit signed integer		*/
typedef DOUBLE			*PDOUBLE; 		/* ptr to 32-64 bit IEEE real 		*/

typedef	VOID			_far *PFVOID; 	/* far ptr to Ansi void			 	*/
typedef	CHAR 			_far *PFCHAR; 	/* far ptr to 8 bit signed data	 	*/
typedef	BYTE 			_far *PFBYTE; 	/* far ptr to 8 bit unsigned data	*/
typedef	WORD 			_far *PFWORD; 	/* far ptr to 16 bit unsigned data	*/ 
typedef	DWORD			_far *PFDWORD;	/* far ptr to 32 bit unsigned data	*/
typedef	INT 			_far *PFINT;  	/* far ptr to 16 bit signed integer	*/
typedef	LONG			_far *PFLONG; 	/* far ptr to 32 bit signed integer	*/
typedef DOUBLE			_far *PFDOUBLE;	/* far ptr to 32-64 bit IEEE real  	*/

typedef	VOID			_huge *PHVOID; 	/* huge ptr to Ansi void		   	*/
typedef	CHAR 			_huge *PHCHAR; 	/* huge ptr to 8 bit signed data   	*/
typedef	BYTE 			_huge *PHBYTE; 	/* huge ptr to 8 bit unsigned data 	*/
typedef	WORD 			_huge *PHWORD; 	/* huge ptr to 16 bit unsigned data	*/ 
typedef	DWORD			_huge *PHDWORD;	/* huge ptr to 32 bit unsigned data	*/
typedef	INT 			_huge *PHINT;  	/* huge ptr to 16 bit signed integer*/
typedef	LONG			_huge *PHLONG; 	/* huge ptr to 32 bit signed integer*/
typedef DOUBLE			_huge *PHDOUBLE; /* huge ptr to 32-64 bit IEEE real 	*/

typedef BYTE			BOOL;			/* 8-bit boolean 					*/
typedef BOOL			*PBOOL;			/* ptr to 8-bit boolean				*/
typedef BOOL			_far *PFBOOL;	/* far ptr to 8-bit boolean		   	*/
typedef BOOL			_huge *PHBOOL;	/* huge ptr to 8-bit boolean	   	*/
/****************************************************************************/
/*  End of Marc's basic Data type typedefs 								    */
/****************************************************************************/

#define OK		((WORD)0)
#define FALSE	((BOOL)0)
#define TRUE	!FALSE

typedef LONG			LRESULT;
typedef struct tagRECT
{
    int left;
    int top;
    int right;
    int bottom;
} RECT;
typedef RECT*      PRECT;
typedef RECT NEAR* NPRECT;
typedef RECT _far*  LPRECT;

typedef struct tagPOINT
{
    int x;
    int y;
} POINT;
typedef POINT*       PPOINT;
typedef POINT NEAR* NPPOINT;
typedef POINT _far*  LPPOINT;

typedef struct tagSIZE
{
    int cx;
    int cy;
} SIZE;
typedef SIZE*       PSIZE;
typedef SIZE NEAR* NPSIZE;
typedef SIZE _far*  LPSIZE;

/* typedefs to fit in with windows */
typedef	VOID			_far *LPVOID; 	/* far ptr to Ansi void			 	*/
typedef	CHAR 			_far *LPCHAR; 	/* far ptr to 8 bit signed data	 	*/
typedef	BYTE 			_far *LPBYTE; 	/* far ptr to 8 bit unsigned data	*/
typedef	WORD 			_far *LPWORD; 	/* far ptr to 16 bit unsigned data	*/ 
typedef	DWORD			_far *LPDWORD;	/* far ptr to 32 bit unsigned data	*/
typedef	INT 			_far *LPINT;  	/* far ptr to 16 bit signed integer	*/
typedef	LONG			_far *LPLONG; 	/* far ptr to 32 bit signed integer	*/
typedef DOUBLE			_far *LPDOUBLE;	/* far ptr to 32-64 bit IEEE real  	*/


			
#endif	/* _MASDEFS_ */
