/***************************************************************************
;++

Name		:	LRESULT.H
Title		:	Error system for Terminator software
Author		:	Nick Jones
Created		:	21/12/92

	Copyright 1992 by VideoLogic Limited. All rights reserved.
	No part of this software, either material or conceptual may be
	copied or distributed, transmitted, transcribed, stored in a
	retrieval system or translated into any human or computer language
	in any form by any means, electronic, mechanical, manual or other-
	wise, or disclosed to third parties without the express written
	permission of VideoLogic Limited, Unit 8, Homepark Industrial
	Estate, King's Langley, Hertfordshire, WD4 8LZ, U.K.

Description	:

	LRESULT definitions for Terminator software :

	RET_OK	0x00000000 = All OK, nothing to report.

	byte 0	Module specific response numbers

	byte 1	General response Category globally understood.
			(literal prefix CAT_)

	byte 2	The originator's module id.
			(literal prefix MODULE_)

	byte 3	The result type (error, warning, immediate response etc.)
			(literal prefix RET_TYPE)

    eg./
	#define TERMIO_ERR    				(TYPE_ERROR | MODULE_CINTF)
    #define TERMIO_ERR_DRV_NOT_FOUND	(TERMIO_ERR | CAT_MOD_NOTFOUND	| 1)

    Note :	Each module should contain a function to convert it's
    		own errors into meaningful text.

;--
****************************************************************************/


#if !defined _LRESULT_
#define _LRESULT_

#define RET_OK			0L


/* LRESULT field macros */
#define RET_CAT(X)		((LONG)(X)<<8)
#define RET_MOD(X)		((LONG)(X)<<16)
#define RET_TYPE(X)		((LONG)(X)<<24)

#define GET_CAT(X)		(X & 0x0000FF00)
#define GET_MOD(X)		(X & 0x00FF0000)
#define GET_TYPE(X)		(X & 0xFF000000)

/* Types */
#define TYPE_ERROR					RET_TYPE(1)
#define TYPE_WARNING				RET_TYPE(2)
#define TYPE_RESPONSE				RET_TYPE(3)

/* Originators */
#define MODULE_DRVIO				RET_MOD(1)
#define MODULE_CAPDRV				RET_MOD(2)
#define MODULE_ISR					RET_MOD(3)
#define MODULE_CINTF                RET_MOD(4)
#define MODULE_UTILS                RET_MOD(5)
#define MODULE_TBOX					RET_MOD(6)
#define MODULE_TESTER				RET_MOD(7)
#define MODULE_DIGNOSTICS			RET_MOD(8)
#define MODULE_VSNAP				RET_MOD(9)
#define MODULE_TRACE				RET_MOD(10)
#define MODULE_BOARDTEST			RET_MOD(11)
#define MODULE_VXD					RET_MOD(12)
#define MODULE_UNREGISTERED			RET_MOD(255)
#define MODULE_CAP					RET_MOD(13)

/* General Descriptions */
#define CAT_BADCMD					RET_CAT(1)
#define CAT_BADPARAMS				RET_CAT(2)
#define CAT_MEMORY					RET_CAT(3)
#define CAT_FILE					RET_CAT(4)
#define CAT_OSERROR					RET_CAT(5)
#define CAT_TIMEOUT					RET_CAT(6)
#define CAT_NEEDINIT				RET_CAT(7)
#define CAT_DLLMISSING				RET_CAT(8)
#define CAT_HWNOTCAPABLE			RET_CAT(9)
#define CAT_BADRESULT				RET_CAT(10)

#endif /*_LRESULT_*/


