
/* drvio.h */
/* by nick jones */
#if ! defined _DRVIO_
#define _DRVIO_

#include "masdefs.h"
#include "lresult.h"

#define USE_DISPLAY_BUS 1

/* Microsoft C7 re-definitions */
#if defined(_MSC_VER) && (_MSC_VER >= 700)
#define		inp(a)			_inp(a)
#define		inpw(a)			_inpw(a)
#define		outp(a,b)		_outp(a,b)
#define		outpw(a,b)		_outpw(a,b)
#define		eof(a)			_eof(a)
#define		chdir(a)		_chdir(a)
#define		getcwd(a,b)		_getcwd(a,b)
#endif


/* Timing defs */
#define NTSCMICROSECPERTICK      33367L /* = 1/59.94   = 33 mS per Frame */
#define PALMICROSECPERTICK       40000L /* = 1/50.00   = 40 mS per Frame */

#define NTSCFRAMESPERSEC		((LONG)30)
#define PALFRAMESPERSEC			((LONG)25)

/* Low-level driver I/O messages */

#define IOMSG_DRV_VERSION		0x01
#define IOMSG_DRV_HWPRESENCE	0x02
#define IOMSG_DRV_STATUS		0x03
#define IOMSG_DRV_GET_ERR_STR	0x04
#define IOMSG_DRV_RESET			0x05
#define IOMSG_DRV_RESTORE		0x06
#define IOMSG_DRV_TEST			0x07
#define IOMSG_DRV_HOLD			0x08
#define IOMSG_DRV_RELEASE		0x09
#define IOMSG_BOARDREV			0x0A

#define IOMSG_DEFINEBASE		0x10
#define IOMSG_QBASE				0x11
#define IOMSG_PORT_OUT			0x12
#define IOMSG_PORT_IN			0x13
#define IOMSG_M2REG_OUT			0x14
#define IOMSG_M2REG_IN			0x15
#define IOMSG_I2CREG_OUT		0x16
#define IOMSG_I2CREG_IN			0x17
#define IOMSG_MAPREG_OUT		0x18
#define IOMSG_MAPREG_IN			0x19
#define IOMSG_GETMAP			0x1A

#define IOMSG_PRIMECAP			0x20
#define IOMSG_M2OSIZE			0x21
#define IOMSG_M2VSIZE			0x22
#define IOMSG_M2ICLIP			0x23
#define IOMSG_VIDSTANDARD		0x24
#define IOMSG_VIDTYPE			0x25
#define IOMSG_BRIGHTNESS		0x26
#define IOMSG_SATURATION		0x27
#define IOMSG_CONTRAST			0x28
#define IOMSG_GETBRIGHTNESS		0x29
#define IOMSG_GETSATURATION		0x2A
#define IOMSG_GETCONTRAST		0x2B

#define IOMSG_M2RESET			0x30
#define IOMSG_DMSDRESET			0x31
#define IOMSG_ARSENALRESET		0x32
#define IOMSG_DETECTVIDEO		0x33
#define IOMSG_START_AUTO_SENSE	0x34
#define IOMSG_END_AUTO_SENSE	0x35
#define IOMSG_VLCONFIG			0x36
#define IOMSG_SUGGESTSETTINGS	0x37

#define IOMSG_VXD_INIT			0x40
#define IOMSG_VXD_SETUP			0x41
#define IOMSG_VXD_CAPTURE		0x42
#define IOMSG_VXD_GET_VER_STR	0x43
#define IOMSG_VXD_KILL			0x44
#define IOMSG_VXD_SETUP_STREAM	0x45
#define IOMSG_VXD_START_STREAM	0x46
#define IOMSG_VXD_STOP_STREAM	0x47
#define IOMSG_VXD_ADD_BUFFER	0x48
#define IOMSG_VXD_RESET_STREAM	0x49
#define IOMSG_VXD_FINISH_STREAM	0x4A
#define IOMSG_VXD_SETUP_OVERLAY 0x4B
#define IOMSG_VXD_START_OVERLAY 0x4C
#define IOMSG_VXD_STOP_OVERLAY  0x4D


/* Driver I/O return values */
#define DRVIO_ERR    			(TYPE_ERROR | MODULE_DRVIO)
#define IOERR_DRV_UNKNOWN_MSG	(DRVIO_ERR | CAT_BADCMD			| 1)
#define IOERR_DRV_BAD_PARAMS	(DRVIO_ERR | CAT_BADPARAMS		| 2)
#define IOERR_DRV_REG_UNKNOWN	(DRVIO_ERR | CAT_BADPARAMS		| 3)
#define IOERR_DRV_REG_READONLY	(DRVIO_ERR | CAT_HWNOTCAPABLE	| 4)
#define IOERR_DRV_REG_WRITEONLY	(DRVIO_ERR | CAT_HWNOTCAPABLE	| 5)
#define IOERR_DRV_REG_HIBYTE	(DRVIO_ERR | CAT_BADPARAMS		| 6)
#define IOERR_DRV_I2C_NO_ACK	(DRVIO_ERR | CAT_BADPARAMS		| 7)
#define IOERR_DRV_I2C_BUS_ERROR	(DRVIO_ERR | CAT_BADPARAMS		| 8)
#define	IOERR_DRV_VDX_IOERR		(DRVIO_ERR | CAT_OSERROR		| 9)
#define	IOERR_DRV_NO_HARDWARE	(DRVIO_ERR | CAT_HWNOTCAPABLE	| 10)
#define	IOERR_DRV_MEMORY		(DRVIO_ERR | CAT_HWNOTCAPABLE	| 11)
#define	IOERR_DRV_NOVIDEO		(DRVIO_ERR | CAT_BADRESULT		| 12)
#define IOERR_DRV_NO_AVAIL_IO	(DRVIO_ERR | CAT_BADRESULT		| 13)
#define IOERR_DRV_NO_AVAIL_IRQ	(DRVIO_ERR | CAT_BADRESULT		| 14)

#define DRVIO_WARN    			(TYPE_WARNING | MODULE_DRVIO)
#define IOWARN_REG_WRITEONLY	(DRVIO_WARN | CAT_HWNOTCAPABLE	| 1)

/* DrvIO param literals */
#define DRV_STANDARD_NTSC			0x00
#define DRV_STANDARD_PAL			0x01
#define DRV_TYPE_COMPOSITE			0x00
#define DRV_TYPE_SVIDEO				0x01

/* Auto detect status literals */
#define DRV_DETECT_DISABLED			0x00
#define DRV_DETECT_ATTEMPT_1		0x01
#define DRV_DETECT_ATTEMPT_2		0x02
#define DRV_DETECT_ATTEMPT_3		0x03
#define DRV_DETECT_ATTEMPT_4		0x04
#define DRV_DETECT_ATTEMPT_5		0x05
#define DRV_DETECT_NO_VIDEO			0x06
#define DRV_DETECT_NO_TIMER			0x07
#define DRV_DETECT_ERROR			0x08
#define DRV_DETECT_PALCOMP			0x09
#define DRV_DETECT_PALSVID			0x0A
#define DRV_DETECT_NTSCCOMP			0x0B
#define DRV_DETECT_NTSCSVID			0x0C


/*
	Arsenal ICR Register bit defs
*/
#define FS_IRQ_ENB			((WORD)0x0100)
#define RDY_IRQ_ENB			((WORD)0x0200)
#define EOT_IRQ_ENB			((WORD)0x0400)

#define FS_IRQ_SET			((WORD)0x0001)
#define RDY_IRQ_SET			((WORD)0x0002)
#define EOT_IRQ_SET			((WORD)0x0004)

/*
	Arsenal SETUP Register bit defs
*/
#define YUV0				((WORD)0x0000)
#define YUV1				((WORD)0x0001)
#define YUV2				((WORD)0x0002)
#define YUV3				((WORD)0x0003)
#define	MEM					((WORD)0x0004)
#define FEAT				((WORD)0x0008)
#define DMA5				((WORD)0x0010)
#define DMA6				((WORD)0x0020)
#define DMA7				((WORD)0x0030)
#define IRQ15				(((WORD)15 << 6))

/*
	Arsenal CONTROL Register bit defs
*/
#define	RESET				((WORD)0x0000)
#define	RUN					((WORD)0x0001)
#define	GO_CAP				((WORD)0x0002)
#define	FORCE_LOW			((WORD)0x0004)
#define	IRQ_ENB				((WORD)0x0008)
#define	DMA_ENB				((WORD)0x0010)
#define	FRAME				((WORD)0x0020)
#define	TIMER				((WORD)0x0080)

/* wCaptureMode Capture register mode defs */
#define CAPTURE_TYPE_FORMAT1		0x0000
#define CAPTURE_TYPE_FORMAT2		0x0001
#define CAPTURE_TYPE_FORMAT3		0x0002
#define CAPTURE_TYPE_FORMAT4		0x0003

/* wCaptureMode-1 implies arsenal capture mode */
#define ARSENAL_PACKED_YUV			0x0000
#define ARSENAL_UNPACKED_YUV		0x0001
#define ARSENAL_SUPERPACKED_YUV		0x0002
#define ARSENAL_LUMA_ONLY			0x0003


/*****  Functions reachable from within the driver *****/

void InitStatics(void);

/* Main register I/O routines */
LRESULT RegIn(WORD wDevice, WORD wAddress, LPWORD lpwData);
LRESULT RegOut(WORD wDevice, WORD wAddress, WORD wData);

/* Low level I/O routines : */
LRESULT PortWrite (WORD wMapAddress, WORD wData);
LRESULT PortRead (WORD wMapAddress, LPWORD wpDataPtr);
LRESULT M2Write (WORD wMapAddress, WORD wData);
LRESULT M2Read (WORD wMapAddress, LPWORD wpDataPtr);
LRESULT I2CWrite (WORD wMapAddress, WORD wData);
LRESULT I2CRead (WORD wMapAddress, LPWORD wpDataPtr);
LRESULT WriteAllI2CRegs (void);

/* Others */
LRESULT SetReg (WORD RegID, WORD Value);
LRESULT ForceReg (WORD RegID, WORD Value);
LRESULT SendChanges(void);
LRESULT GetRegMap (DWORD dwRegDevice, LPDWORD RegMap);
LRESULT FindReg (WORD wRegAddress, WORD wDevice, LPWORD wpMapAddr);
LRESULT ResetDMSD (void);
LRESULT SetDMSD (WORD wStandardID, WORD wType);
LRESULT ResetArsenal(void);
LRESULT PrimeCapture (void);
LRESULT DelayTime(WORD wMilliSec);
LRESULT StartAutoSense(LPWORD lpwEventID);
LRESULT EndAutoSense(WORD wEventID);

#endif /* _DRVIO_ */

/*drvio.h*/
