        TITLE BUILDLUT.ASM
        page 60,132

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; BUILDLUT.ASM - Create 32k x 1 word 5:5:5 or 5:6:5 RGB LUT designed to be
;		 indexed by a 5:5:5 YUV value
;
; (C) Copyright VideoLogic. 1992-1993.  All rights reserved.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

?PLM=1	    ; PASCAL Calling convention is DEFAULT
?WIN=0      ; Windows calling convention

        .xlist
        include cmacros.inc
        .list
USENEWTAB = 1

SBCDEFS  STRUC
Contrast	dw  ?
ContrastMin	dw  ?
ContrastRange	dw  ?
Brightness	dw  ?
BrightnessMin	dw  ?
BrightnessRange	dw  ?
Saturation	dw  ?
SaturationMin	dw  ?
SaturationRange	dw  ?
SBCDEFS  ENDS

; see vxdif.inc

RGB24TAB   STRUC
Yh		dw  128 dup(?)
Uh		dw  128 dup(?)
UhScaled	dw  128 dup(?)
Vh		dw  128 dup(?)
VhScaled	dw  128 dup(?)
RGB24TAB   ENDS

YUV888TAB  STRUC
R2Yscaled	dw  256 dup(?)
G2Yscaled	dw  256 dup(?)
B2Yscaled	dw  256 dup(?)
Yrevfactor	dw  ?
R2Uscaled	dw  256 dup(?)
G2Uscaled	dw  256 dup(?)
B2Uscaled	dw  256 dup(?)
Urevfactor	dw  ?
R2Vscaled	dw  256 dup(?)
G2Vscaled	dw  256 dup(?)
B2Vscaled	dw  256 dup(?)
Vrevfactor	dw  ?
Yreverse	db  256 dup(?)
UVreverse	db  256 dup(?)
YUV888TAB  ENDS


; -------------------------------------------------------
;               DATA SEGMENT DECLARATIONS
; -------------------------------------------------------

ifndef SEGNAME
    SEGNAME equ <_TEXT>
endif

createSeg %SEGNAME, CodeSeg, word, public, CODE

.386p

sBegin Data

PUBLIC	_CorrectionFor9051
PUBLIC	_UVCorrectionFor9051
PUBLIC	_Y_Reverse_Correction
PUBLIC	_UV_Reverse_Correction

 include new9051.inc

RGB24Lut RGB24TAB  <>

;	GlobalW U_Factor_1, 50
;	GlobalW U_Factor_2, 256
;	GlobalW V_Factor_1, 130
;	GlobalW V_Factor_2, 256

	GlobalW U_Factor_1, 172
	GlobalW U_Factor_2, 500
	GlobalW V_Factor_1, 357
	GlobalW V_Factor_2, 500
	GlobalW V_Factor_3, 701
	GlobalW U_Factor_3, 886

	GlobalW V_Rev_Factor, 246		;         was 436/2
	GlobalW R2V_Factor,   123		; 0.500R  was 306/2
	GlobalW G2V_Factor,   103		; 0.419G  was 256/2
	GlobalW B2V_Factor,    20		; 0.081B  was 50/2

	GlobalW U_Rev_Factor, 254
	GlobalW R2U_Factor,    43		; 0.169R
	GlobalW G2U_Factor,    84		; 0.331G
	GlobalW B2U_Factor,   127		; 0.500B

	GlobalW Y_Rev_Factor, 201
	GlobalW R2Y_Factor,    60		; 0.299R
	GlobalW G2Y_Factor,   118		; 0.587G
	GlobalW B2Y_Factor,    29		; 0.144B

	GlobalW Rcnt,  0
	GlobalW Gcnt,  0
	GlobalW Bcnt,  0
	GlobalD dwRGB, 0

sEnd Data

sBegin	CodeSeg
        assumes cs,CodeSeg
        assumes ds,Data
        assumes es,nothing


;******************************************************************************
;
;   BuildRGB24LUTs
;
;   DESCRIPTION: Builds the constant coefficent tables for a true 7:7:7 YUV
;		 to 24-bit RGB conversion.
;
;   ENTRY:   ax = Bri, bx =  Sat, cx = Cont
;
;   EXIT:
;
;   USES:    all registers
;
;==============================================================================
cProc BuildRGB24LUTs,<NEAR,PASCAL,PUBLIC>

cBegin
	pushad

    	mov ecx,128

B24BT_010:
    	dec ecx

	movzx	ax,byte ptr [ecx]._CorrectionFor9051
    	mov word ptr [RGB24Lut.Yh+ecx*2],ax      ; C0[Y] = Yh

    	cmp ecx,0
    	jnz B24BT_010               ; fill in array
;
;...... Build U table
;
	    mov ecx,128
B24BT_020:
    	dec ecx

	movsx	ax,byte ptr [ecx]._UVCorrectionFor9051

;	mov	ax,cx
;	shl	ax,1
	cbw
	push	ax

	imul    word ptr [U_Factor_3]
	idiv    word ptr [U_Factor_2]
	mov word ptr [RGB24Lut.Uh+ecx*2],ax      ; C1[U] = Uh

	pop	ax
	imul    word ptr [U_Factor_1]
	idiv    word ptr [U_Factor_2]
	mov word ptr [RGB24Lut.UhScaled+ecx*2],ax    ; C3[U] = UhScales

	cmp ecx,0
	jnz B24BT_020
;
;...... Build V Table
;
    	mov ecx,128
B24BT_030:
    	dec ecx

	movsx	ax,byte ptr [ecx]._UVCorrectionFor9051

;	mov	ax,cx
;	shl	ax,1
	cbw
	push	ax

	imul	word ptr [V_Factor_3]
	idiv    word ptr [V_Factor_2]
	mov word ptr [RGB24Lut.Vh+ecx*2],ax      ; C2[V] = Vh

	pop	ax
	imul    word ptr [V_Factor_1]
	idiv    word ptr [V_Factor_2]
	mov word ptr [RGB24Lut.VhScaled+ecx*2],ax    ; C4[U] = UhScaled

	cmp ecx,0
	jnz B24BT_030
	popad
cEnd


;******************************************************************************
;
;   BuildRGB16LUT
;
;   DESCRIPTION:
;
;   ENTRY:	VOID far pointer to 32k x n word buffer to receive LUT
;		BYTE brightness value
;		BYTE Saturation value
;		BYTE Contrast value
;		BYTE Flags = 0 = produce 555 RGB LUT
;			   = 1 = produce 565 RGB LUT
;			   = 2 = produce 888 RGB LUT
;
;
;   EXIT:	none
;
;   USES:	all regs
;
;   DEFINE as VOID NEAR PASCAL BuildRGB16LUT(VOID far *fpwRGBLUT, BYTE Bri,
;					BYTE Sat, BYTE Con, BYTE Flags);
; note
; Build 1.0c1+ has had RGB order reverse inpalette
;
;==============================================================================

cProc BuildRGB16LUT,<NEAR,PASCAL,PUBLIC>
	ParmD fpwRGBLUT
	ParmB bBri
	ParmB bSat
	ParmB bCon
	ParmB bFlags

cBegin
	pushad
;	movsx	ax,bBri
;	movsx	bx,bSat
;	movsx	cx,bCon
	call	BuildRGB24LUTs

	cld
	les	di,fpwRGBLUT
	lea	esi,RGB24Lut

	xor	edx,edx

;
; cl = Y, bl = U, bh = V
;



	xor	cl,cl
BRGB_008:
	xor	bl,bl
BRGB_009:
	xor	bh,bh
BRGB_010:
	xor	eax,eax
	mov	dl,cl
	mov	ax,[esi.Yh + edx*2]
	mov	dl,bh
	add	ax,[esi.Vh + edx*2]

	js	short BRGB_011		; -ve
	cmp	ax,255
	jbe	short BRGB_012		; <=255
	mov	ax,255
	jmp	short BRGB_012

BRGB_011:
	xor	ax,ax

BRGB_012:
	shl	eax,16 			; R = (Y + Vscaled) to eax(Lo)

	mov	dl,cl
	mov	ax,[esi.Yh + edx*2]
	mov	dl,bl
	sub	ax,[esi.UhScaled + edx*2]
	mov	dl,bh
	sub	ax,[esi.VhScaled + edx*2]

	js	short BRGB_013		; -ve
	cmp	ax,255
	jbe	short BRGB_014		; <=255
	mov	ax,255
	jmp	short BRGB_014

BRGB_013:
	xor	ax,ax

BRGB_014:
	xchg	ah,al			; G = Y1 - Vscaled - Uscaled
	shl	eax,8			; eax(H) = R, eax(L] = G

	mov	dl,cl
	mov	ax,[esi.Yh + edx*2]
	mov	dl,bl
	add	ax,[esi.Uh + edx*2]

	js	short BRGB_015		; -ve
	cmp	ax,255
	jbe	short BRGB_016		; <=255
	mov	ax,255
	jmp	short BRGB_016

BRGB_015:
	xor	ax,ax

BRGB_016:
	cmp	bFlags,2		; B in AL = (Y + Uscaled)
	jne	BRGB_019		; go if not RGB 888

	xchg	al,ah
	shr	eax,8			; [x][R][G][B]
	mov	ES:[DI],eax

	add	di,4
	jnc	short BRGB_051

	mov	ax,es			; move into next 64k block
	add	ax,8h           	; bit 0,1 RPL, bit 2 TI, therefore next block is +8

	verr	ax			; is new selector valid
	jnz	BRGB_exit		; go if invalid

	mov	es,ax
	jmp	short BRGB_051

BRGB_019:
	mov	ch,al  			; B = Y1 + V to ch
	shr	eax,16			; R = ah, G = al
;	xchg	ch,ah			; ch = R, al = G, ah = B
	cmp 	bFlags,0		; produce 565 table?
	jne	BR565_020		; yes, go do it
	shr	ah,3			; no, generate 555 table
	and	al,0f8h
	shl	ax,2
	shr	ch,3
	or	al,ch			; ax = RGB 555
	jmp	short BRGB_050

BR565_020:
	shr	ah,3
	and	al,0fch
	shl	ax,3
	shr	ch,3
	or	al,ch			; ax = RGB 565

BRGB_050:
	stosw

BRGB_051:
	add	bh,4
	jns	BRGB_010
	add	bl,4
	jns	BRGB_009
	add	cl,4
	jns	BRGB_008

BRGB_exit:
	popad
cEnd

;******************************************************************************
;
;   ConvertSiteToYUV15Quad
;
;   DESCRIPTION:
;
;   ENTRY:	EDI is ptr to destination data
;
;   EXIT:	none
;
;   USES:
;
;==============================================================================

cProc ConvertSiteToYUV15Quad,<NEAR,PASCAL,PUBLIC>
	ParmW wYUVLo
	ParmW wYUVHi
	ParmD lpwYUVQuad

cBegin
	push	es
	push 	eax
	push	ebx
	push	edx
	push	edi

	cld
;	mov	ax,ss
;	mov	es,ax
	les	di,lpwYUVQuad

	mov	ax,wYUVLo		; Y1,Y2, part U & V
	ror	ax,2
	mov	bx,ax

	mov	ax,wYUVHi
	ror	ax,2			; Y3,Y4, part U & V
	mov	dx,ax
	shl	eax,16
	mov	ax,bx
	and	eax,1F1F1F1Fh		; Y1-4 bits 6 to 2

	shr	bh,3
	shr	bx,3
	and	bx,039Ch

	shr	dh,3
	shr	dx,6
	and	dx,0063h
	add	dx,bx			; dx = 5U + 5V 

	mov	ebx,eax			
	shl	eax,10			; Y1
	and	eax,7C00h
	or	ax,dx
	stosw				; Y1 + U + V

	mov	eax,ebx
	shl	eax,2			; Y2
	and	eax,7C00h
	or	ax,dx
	stosw				; Y2 + U + V

	mov	eax,ebx
	shr	eax,6			; Y3
	and	eax,7C00h
	or	ax,dx
	stosw				; Y3 + U + V

	mov	eax,ebx
	shr	eax,14			; Y4
	and	eax,7C00h
	or	ax,dx
	stosw				; Y4 + U + V
	pop	edi
	pop	edx
	pop	ebx
	pop	eax
	pop	es
cEnd

;******************************************************************************
;
;   ConvertF3SiteToYUV15Quad
;
;   DESCRIPTION:
;
;   ENTRY:	EDI is ptr to destination data
;
;   EXIT:	none
;
;   USES:
;
;==============================================================================
;******************************************************************************
;
;   ConvertF3SiteToYUV15Quad
;
;   DESCRIPTION:
;
;   ENTRY:      EDI is ptr to destination data
;
;   EXIT:       none
;
;   USES:
;
;==============================================================================

cProc ConvertF3SiteToYUV15Quad,<NEAR,PASCAL,PUBLIC>
	ParmW wYUVLo
	ParmW wYUVHi
	ParmD lpwYUVQuad

cBegin
	push    es
	push    eax
	push    ebx
	push    edi

	cld
	les     di,lpwYUVQuad

	mov     ax,wYUVLo               ; Y1 & Y2
	mov     bx,ax                   ; copy eax
	shl     eax,16
	mov     ax,bx
	and     eax,7C007C00h
	stosd

	mov     ax,wYUVHi               ; Y3 & Y4
	mov     bx,ax                   ; copy eax
	shl     eax,16
	mov     ax,bx
	and     eax,7C007C00h
	stosd

	pop     edi
	pop     ebx
	pop     eax
	pop     es
cEnd

;cProc ConvertF3SiteToYUV15Quad,<NEAR,PASCAL,PUBLIC>
;	ParmW wYUVLo
;	ParmW wYUVHi
;	ParmD lpwYUVQuad
;
;cBegin
;	push	es
;	push 	eax
;	push	ebx
;	push	edx
;	push	edi
;
;	cld
;;	mov	ax,ss
;;	mov	es,ax
;	les	di,lpwYUVQuad
;
;	mov	ax,wYUVLo		; Y1,Y2
;	and 	ax,07c7ch
;	mov	bx,ax
;	shl	ax,8
;	stosw
;
;	mov	al,bh
;	shl	ax,8
;	stosw
;
;	mov	ax,wYUVHi		; Y3,Y4
;	mov	bx,ax
;	and 	ax,07c7ch
;	mov	bx,ax
;	shl	ax,8
;	stosw
;
;	mov	al,bh
;	shl	ax,8
;	stosw
;
;	pop	edi
;	pop	edx
;	pop	ebx
;	pop	eax
;	pop	es
;cEnd

;******************************************************************************
;
;   ConvertF0SiteToYUV15Quad
;
;   DESCRIPTION:
;
;   ENTRY:	EDI is ptr to destination data
;
;   EXIT:	none
;
;   USES:
;
;==============================================================================

cProc ConvertF0SiteToYUV15Quad,<NEAR,PASCAL,PUBLIC>
	ParmD dYUVLo
	ParmB bYUVHi
	ParmD lpwYUVQuad

cBegin
	push	es
	push 	eax
	push	ebx
	push	edx
	push	edi

	cld
;	mov	ax,ss
;	mov	es,ax
	les	di,lpwYUVQuad

	mov	eax,dYUVLo
	mov	ebx,eax			; copy eax
	and	eax,0FF00h
	mov	al,bYUVHi				; U4-2 + V6-2 into al
	xchg	eax,edx			; dx = Y2 555
	mov	ax,dx			; ax = Y2 555
	shl	eax,16
	mov	dh,bl			; dx = Y1 5:5:5 video pixel
	mov	ax,dx
	stosd				; write Y1 and Y2
	shr	ebx,16			; Y3 and Y4 to bx
	mov	dh,bl			; ax = Y3 5:5:5 video pixel
	mov	ax,dx
	stosw
	mov	dh,bh			; ax = Y4 5:5:5 video pixel
	mov	ax,dx
	stosw				; salt away Y3 & Y4

	pop	edi
	pop	edx
	pop	ebx
	pop	eax
	pop	es
cEnd

;******************************************************************************
;
;   ConvertF1SiteToYUV15Quad
;
;   DESCRIPTION:
;
;   ENTRY:      EDI is ptr to destination data
;
;   EXIT:       none
;
;   USES:
;
;==============================================================================
cProc ConvertF1SiteToYUV15Quad,<NEAR,PASCAL,PUBLIC>
	ParmD dYUVLo
	ParmW wYUVHi
	ParmD lpwYUVQuad

cBegin
	push    es
	push    eax
	push    ebx
	push    edx
	push    edi
	cld

	les     di,lpwYUVQuad

	mov     eax,dYUVLo
	mov     ebx,eax                 ; copy eax
	mov     ax,wYUVHi               ; U & V
	xchg    al,ah                   ; V now in AL
	shr     eax,2                   ; discard 2 lsbs
	mov     dx,ax
	and     dx,001Fh
	shr     ax,3
	and     ax,03E0h
	or      dx,ax                   ; dx = 5U + 5V 

	mov     ah,bl			; Y1                 
	and     ah,7Ch
	or      ax,dx
	stosw                           ; Y1 + U + V

	mov     ah,bh			; Y2
	and     ah,7Ch
	or      ax,dx
	stosw                           ; Y2 + U + V

	shr	ebx,16
	mov     ah,bl			; Y3
	and     ah,7Ch
	or      ax,dx
	stosw                           ; Y3 + U + V

	mov     ah,bh			; Y4
	and     ah,7Ch
	or      ax,dx
	stosw                           ; Y4 + U + V

	pop     edi
	pop     edx
	pop     ebx
	pop     eax
	pop     es
cEnd


sEnd	CodeSeg

end

