/***************************************************************************
;++

Name			:	CAP.H
Title			:	Capture Library Entry Point Include
Author			:	Marc Stevens
Created			:	31/MAY/93

	Copyright 1992 by VideoLogic Limited. All rights reserved.
	No part of this software, either material or conceptual may be
	copied or distributed, transmitted, transcribed, stored in a
	retrieval system or translated into any human or computer language
	in any form by any means, electronic, mechanical, manual or other-
	wise, or disclosed to third parties without the express written
	permission of VideoLogic Limited, Unit 8, Homepark Industrial
	Estate, King's Langley, Hertfordshire, WD4 8LZ, U.K.

Description		:	Contains the externally callable function definitions
					structs, errors etc for the Capture Library.

Program Type    :   C Header File. 

Modifications   :

Notes           :

;--
****************************************************************************/
#if !defined( _CAP_ )
#define _CAP_


/***************************************************************************/
/* CAP_STATUS Struct													   */
/***************************************************************************/

typedef struct _CAP_STATUS
{
	int IOBase;
	int IRQLevel;
	int InputType;
	int InputStandard;
	int CaptureFormat;
	int DestRectWidth;
	int DestRectHeight;
	int Brightness;
	int Saturation;
	int Contrast;
	int Gamma;
} CAP_STATUS, *PCAP_STATUS;

/***************************************************************************/
/* Stream Statistics Struct			  									   */
/***************************************************************************/

typedef struct _STREAMSTATS
{
	long lError;
	long lFramesSkipped;
   	long lFramesDropped;
	long lFramesCaptured;
	long lFrameCount;
} STREAMSTATS, *PSTREAMSTATS;

/***************************************************************************/
/* Stream Buffer Struct													   */
/***************************************************************************/
typedef struct _STREAMBUF
{
	char InUse;
	char _huge *NPtr;
	char Buf[1];
} STREAMBUF;


/***************************************************************************/
/* Stream Buffer InUse element defines									   */
/***************************************************************************/
#define BUFFER_FILLING	((BYTE)1)
#define BUFFER_FULL		((BYTE)2)

/***************************************************************************/
/* Capture Library Entry point definitions								   */
/***************************************************************************/
long CapReset( void );
long CapGetStatus( CAP_STATUS *CapStatus );
long CapConfigure( int IOBase, int IRQLevel );
long CapSetInput( int InputType, int InputStandard );
long CapSetFormat ( int CaptureFormat );
long CapSetDestRect ( int Width, int Height);
long CapGrabOneFrame ( char _huge *BufferPointer, long MaxBufferSize );
long CapConvertYUVFrameToRGB(char _huge *hpbYUVBuf, char _huge *hpbRGBBuf, 
					int iWidth, int iHeight, int iFormat, long lYUVMax);
long CapSetStreamParams(char _huge *hpbStreamBuf, int iFramesPerSec );
long CapStreamStart( void );
long CapStreamStop( void );
long CapGetStreamStatistics( STREAMSTATS *StreamStatistics );
long CapSetGamma ( int iGamma );
long CapSetContrast ( int iContrast );
long CapSetSaturation ( int iSaturation );
long CapSetBrightness ( int iBrightness );
#endif	/* _CAP_ */
