/* REXX routine to unzip the MVP OS/2 driver and installation files */

Say 'The STB MVP OS/2 Driver Kit Installation Program, Version 1.0'
Say ' '
Say 'This program requires 2.5 MB free space on any disk volume.  It will'
Say 'install an icon on your desktop that may be used to install the MVP'
Say 'OS/2 drivers as well as to configure the drivers and the virtual desktop.'
Say ' '
Say 'Have you already installed the MVP OS/2 Driver Kit before?'
Parse Pull extract
If translate(left(extract, 1)) <> 'N' then do
   Say ' '
   Say 'Select the MVP icon with the right mouse button, and select "Delete"'
   Say 'from the menu that pops up.  This will remove the icon from the desktop.'
   Say 'Next run INSTALL again and, this time, answer "NO" to the question'
   Say '"Have you already installed the MVP OS/2 Driver Kit before?"'
   Say ' '
   Say 'If you are installing the driver kit into a different directory than'
   Say 'you did the first time, you should also delete the files from the old'
   Say 'directory before reinstalling the driver kit in its new location.'
   Say ' '
   Exit 1
End

If rxFuncQuery('SysLoadFuncs') <> 0 then do
   Call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
   Call SysLoadFuncs
End

dira = directory()
target = '--'
Do Forever Until substr(target, 2, 1) = ':'
   Say 'What directory do you want to install the MVP driver/configuration'
   Say 'files into (full path name -- C:\MVP, for example)?'
   Parse Pull target
   target = translate(target)
   If right(target,1) = '\' then target = left(target, length(target) - 1)
End

Call SysMkDir(target)
call directory(target)
Say ' '
Say 'Extracting files from distribution diskette to' target
extract = dira || 'UNZIP ' || dira || 'mvp_os2.zip'
extract
extract = 'COPY ' || dira || 'READ.ME .'
extract

iconset = target || '\STBMVP.ICO'
cmdline = target || '\INSTALL.EXE'
Nogo = SysSetIcon(cmdline, iconset)
If Nogo = 0 then do
   Say 'Unable to set icon'
   call directory(dira)
   exit 1
End

parameters = "EXENAME=" || cmdline || ";STARTUPDIR=" || target || ";PARAMETERS="
spos = lastpos("\", cmdline)
oname = right(cmdline, length(cmdline) - spos)

Nogo = SysDestroyObject('MVP Configure')
Say '<'Nogo'> returned when distroying 'target'\INSTALL.EXE'

Nogo = SysCreateObject("WPProgram", "MVP Configure", "<WP_DESKTOP>", parameters)
If Nogo = 0 then do
   Say 'The Workplace Shell BUILD Object operation failed'
   call directory(dira)
   exit 1
End

Say ' '
Say oname 'created and placed on the desktop'
call directory(dira)
exit 0
