/* This example demostrates How to use the Digitizer Driver - SPGpdrv.com
   Spgpdrv.com Use INT 66h interupt entry.
   it provide 2 functions:

   AH = 2, AL = The SP Commands. ( resolution, tablet origin ... etc. )
      Setup SP.
      eg: AL = 'b' ; Set Tablet to upper left.

   AX = 3;
      Get SP Status.
   Rturn Value:
      BL = Button Status.
      CX = The coordinate of X (Horizential).
      DX = The coordinate of Y (Vertical).
*/

/* The following commands send the DOS command line parameter to SP
   DO NOT : Send the following Command :
            J, K - Set to Mouse Mode.
            D, P - Remote Request.
            E    - Delta Mode.
            k    - Echo.
            A    - Switch Stream.
            
   The Default mode For spgpdrv is:
       Stream, Increment mode. Increment value is '!' (1 point).
       500 lpi is for the Resolution.
       Lower Left - the tablet origin.

  Examples:
      spgpdrv eb         ;Set SP to 200lpi, upperleft
      spgpdrv jI#        ;Set SP to 1000lpi, Increment value # ( 2 point2)

*/

#include <stdio.h>
#include <dos.h>

#define TRUE      1
#define FALSE     0
#define SPGPDRV   32

int checkSPdrv()
{

  int drvID;

  asm {
   push es
   push bx
   xor  ax, ax
   mov  es, ax
   mov  bx, 044 
   mov  ax, es:[bx]
   inc  bx
   inc  bx
   mov  bx, es:[bx]
   mov  es, bx
   mov  bx, ax
   dec  bx
   dec  bx
   mov  ax, es:[bx]
   cmp  ax, 05350h
   JE   getSP

   xor  ax, ax
   mov  es, ax
   mov  bx, 048 
   mov  ax, es:[bx]
   inc  bx
   inc  bx
   mov  bx, es:[bx]
   mov  es, bx
   mov  bx, ax
   dec  bx
   dec  bx
   mov  ax, es:[bx]
   cmp  ax, 05350h
   JE   getSP

   pop  bx
   pop  es
}

  return 0;

getSP:
  asm { 
   dec  bx
   mov  al, es:[bx]
   cbw
   mov  drvID, ax
   pop  bx
   pop  es
}
   drvID = 1 << ( drvID - 1 );

return drvID;
}

main( int argc, char *argv[] )
{
  char  type;
  char  keyecho;
  union REGS regs;
  struct SREGS sregs;
  char *cptr;

  type = checkSPdrv();        /* Check if Driver exist */
  if( type != SPGPDRV ) {   /* if is SPGPDRV Driver */
      puts("Spgpdrv Driver Not Found!\n");        /* Driver not found */
      exit( 1 );
      }

  if( argc == 2 ){          /* if some parameter the setup Tablet */
      cptr = argv[1];
      while( *cptr != NULL ){
        regs.h.ah=2;        /* AX=2 send char to device */
        regs.h.al= *cptr;
        int86(0x66,&regs,&regs); /* send parameter to SP */
        cptr++;
        }
  }

  while ( TRUE ) {          /* loop forever */
    if( kbhit() ) {         /* if keyboard hit then go back to DOS */
        puts("SmartPad Get Point Driver Test OK!");
        exit( 0 );
        }
    regs.x.ax=3;                   /* AX = 3  to get Status */
    int86(0x66,&regs,&regs);       /* test ready key ? */
    if( regs.x.ax != -1 )          /* if AX != -1 then the status changed */
                                   /* show the coordinate */
                                   /* BL = Button Status, CX = X, DX = Y */
      printf("button = %o \tX=%i \tY=%i\n",regs.h.bl&7, regs.x.cx, regs.x.dx );
    }
}

