/******************************************************************************/
/*   Copyright (c) 1993 Advanced Micro devices, Inc.                          */
/*                                                                            */
/*   File:            /etc/conf/pack.d/pnt0/space.c                           */
/*   Version:         1.0                                                     */
/*   Description:     SCO Unix System V/386 Config. file for PCNet family     */
/*   Author:          Leonid Grossman                                         */
/*   Created:         08/20/93                                                */
/******************************************************************************/

#include "config.h"

#if defined(PNT3_UNITS)
#define TOT_UNITS (PNT3_UNITS+PNT2_UNITS+PNT1_UNITS+PNT_UNITS)
#elif defined(PNT2_UNITS)
#define TOT_UNITS (PNT2_UNITS+PNT1_UNITS+PNT_UNITS)
#elif defined(PNT1_UNITS)
#define TOT_UNITS (PNT1_UNITS+PNT_UNITS)
#else
#define TOT_UNITS (PNT_UNITS)
#endif
#define MAX_MINORS 16   /* Please do not modify */
#define TX_BUFFERS_0 16 /* Must be power of 2 (1,2,4,8,...512) */
#define TX_BUFFERS_1 16
#define TX_BUFFERS_2 16
#define TX_BUFFERS_3 16
#define RX_BUFFERS_0 16
#define RX_BUFFERS_1 16
#define RX_BUFFERS_2 16
#define RX_BUFFERS_3 16
#define SCAN_TYPE_0  0  /* 0-all, 1-PCI, 2-PnP, 3-VESA, 4-ISA, 5-PCI1, 6-PCI2 */
#define SCAN_TYPE_1  0
#define SCAN_TYPE_2  0
#define SCAN_TYPE_3  0
#define LED0_0  0xffffffff  /* 0xffffffff - defaults */
#define LED0_1  0xffffffff
#define LED0_2  0xffffffff
#define LED0_3  0xffffffff
#define LED1_0  0xffffffff
#define LED1_1  0xffffffff
#define LED1_2  0xffffffff
#define LED1_3  0xffffffff
#define LED2_0  0xffffffff
#define LED2_1  0xffffffff
#define LED2_2  0xffffffff
#define LED2_3  0xffffffff
#define LED3_0  0xffffffff
#define LED3_1  0xffffffff
#define LED3_2  0xffffffff
#define LED3_3  0xffffffff
#define dmarotate_0  0 /* 0 - normal priority, 1 - rotate priority */
#define dmarotate_1  0
#define dmarotate_2  0
#define dmarotate_3  0
#define tp_0  0        /* 0 - the the autoselect mode, 1 - the UTP mode */
#define tp_1  0
#define tp_2  0
#define tp_3  0
#define fdup_0  0  /* 0 - default, 1 - AUI, 2 - 10BaseT, 3 - OFF */
#define fdup_1  0
#define fdup_2  0
#define fdup_3  0
  /* Please do not modify ACCESS_TYPE and LAST_BUS parameters */
  /* unless you are sure that the values provided by 'netconfig' are wrong */
#define ACCESS_TYPE_0  0 
#define ACCESS_TYPE_1  0
#define ACCESS_TYPE_2  0
#define ACCESS_TYPE_3  0
#define LAST_BUS_0  256
#define LAST_BUS_1  256
#define LAST_BUS_2  256
#define LAST_BUS_3  256

int    pnt_MaxStreams = MAX_MINORS;
int    pnt_TotalDevCount = TOT_UNITS;

/*
 *  Stucture used in space.c to pass configuration to driver. This information
 *  is copied to the pnt_DeviceStruct structure.
 */

struct pnt_ConfigStruct {
   short index;                     /* board index */
   short minors;                    /* minor devices configured */
   short vec;                       /* interrupt vector # */
   short iobase;                    /* boards base memory address */
   short ioend;                     /* Ending base I/O address */
   short dma;                       /* DMA channel used by the board */
   short tx_buffers;                /* Number of Transmit buffers*/
   short rx_buffers;                /* Number of Receive buffers*/
   long bus_scan;                   /* Bus type to search for */
   long  led0;                      /* LED value */
   long  led1;                      /* LED value */
   long  led2;                      /* LED value */
   long  led3;                      /* LED value */
   long  dmarotate;                 
   long  tp;                 
   long  fdup;                 
   long  access_type;                 
   long  last_bus;                 
};

struct pnt_ConfigStruct pnt_ConfigArray[TOT_UNITS] = {
#if defined PNT_UNITS
                {0,
                MAX_MINORS,
                PNT_0_VECT,
                PNT_0_SIOA,
                PNT_0_EIOA,
                PNT_CHAN,
                TX_BUFFERS_0,
                RX_BUFFERS_0,
                SCAN_TYPE_0,
                LED0_0,
                LED1_0,
                LED2_0,
                LED3_0,
                dmarotate_0,
                tp_0,
                fdup_0,
                ACCESS_TYPE_0,
                LAST_BUS_0
                }
#endif
#if defined PNT1_UNITS
                ,{1,
                MAX_MINORS,
                PNT1_0_VECT,
                PNT1_0_SIOA,
                PNT1_0_EIOA,
                PNT1_CHAN,
                TX_BUFFERS_1,
                RX_BUFFERS_1,
                SCAN_TYPE_1,
                LED0_1,
                LED1_1,
                LED2_1,
                LED3_1,
                dmarotate_1,
                tp_1,
                fdup_1,
                ACCESS_TYPE_1,
                LAST_BUS_1
                }
#endif
#if defined PNT2_UNITS
                ,{2,
                MAX_MINORS,
                PNT2_0_VECT,
                PNT2_0_SIOA,
                PNT2_0_EIOA,
                PNT2_CHAN,
                TX_BUFFERS_2,
                RX_BUFFERS_2,
                SCAN_TYPE_2,
                LED0_2,
                LED1_2,
                LED2_2,
                LED3_2,
                dmarotate_2,
                tp_2,
                fdup_2,
                ACCESS_TYPE_2,
                LAST_BUS_2
                }
#endif
#if defined PNT3_UNITS
                ,{3,
                MAX_MINORS,
                PNT3_0_VECT,
                PNT3_0_SIOA,
                PNT3_0_EIOA,
                PNT3_CHAN,
                TX_BUFFERS_3,
                RX_BUFFERS_3,
                SCAN_TYPE_3,
                LED0_3,
                LED1_3,
                LED2_3,
                LED3_3,
                dmarotate_3,
                tp_3,
                fdup_3,
                ACCESS_TYPE_3,
                LAST_BUS_3
                }
#endif
};

