#include "nniosdef.h"  /* defines my types of storage */

/* define NULL if not already defined! */
#ifndef NULL
	#define NULL                (VOID *) 0
#endif

#define PENNY_1024          40
#define PENNY_1280          41
#define PENNY_1024_ROM      42
#define PENNY_1280_ROM      43
#define PENNY_TWIG          44
#define PENNY_1600          45
#define PENNY_TWIG_ROM      46
#define PENNY_1600_ROM      47

#define PENNY_DEAD_SPOT     0x07FFFB10L
#define PENNY_DEAD_ON       0xDEAD
#define PENNY_DEAD_OFF      0x0000

#define PENNY_BASE_IOADDR   0x280
#define PENNY_IO_JMP        0x08
#define PENNY_LAST_IOADDR   0x298

#define PENNY_MAP_ADDR      0x04000000
#define PENNY_MAP_HIRR      0x04000400
#define PENNY_MAP_CFGREGLO  0x04000800
#define PENNY_MAP_CFGREGHI  0x04000810

#define PENNY_MAP_POSREG1   0x04000E00
#define PENNY_MAP_POSREG2   0x04000E10
#define PENNY_MAP_POSREG3   0x04000E20

#define PENNY_ROM_ADDR      0x04400000
#define PENNY_ROM_ID1       0x04400080
#define PENNY_ROM_ID2       0x04400090

#define PENNY_STREAMB_REG0  0x04300000
#define PENNY_STREAMB_REG1  0x04300010
#define PENNY_STREAMB_REG2  0x04300020
#define PENNY_STREAMB_REG3  0x04300030

#define PENNY_VALID_DATA    0x0040
#define PENNY_EMULTYPE      0x0180
#define PENNY_MSV           0x0001
#define PENNY_MSI           0x0002
#define PENNY_MS4           0x0004
#define PENNY_IL4           0x0010
#define PENNY_V2            0x0020
#define PENNY_SOG           0x0800
#define PENNY_ROMBOOT       0x0800
#define PENNY_EXTRAMEM      0x8000
#define PENNY_NO_MEMHI      0x0202

#define PENNY_LEVELMASK     0x7000
#define PENNY_MEM_MASK      0x37
#define PENNY_LEVEL1        0x03
#define PENNY_LEVEL2        0x05
#define PENNY_LEVEL3        0x04
#define PENNY_LEVEL4        0x02
#define PENNY_LEVEL5        0x03

#define PENNY_IRAMMASK      0x0016
#define PENNY_NO_IRAM		0x0002
#define PENNY_1_2MB_IRAM	0x0004
#define PENNY_1MB_IRAM 		0x0014
#define PENNY_2MB_IRAM 		0x0000
#define PENNY_4MB_IRAM		0x0010

#define PENNY_VRAMMASK      0x0021
#define PENNY_1_2MB_VRAM	0x0001
#define PENNY_1MB_VRAM		0x0000
#define PENNY_2MB_VRAM		0x0020

#define MIN_SHADOW_IRAM		128

#define MICROCHANNEL_BIT    0x0001
#define WORDMODE_BITS       0x1400
#define PENNY_MON_MASK      0x000F
#define PENNY_BID_MASK      0x1C00
#define PENNY_MON3_MASK     0x0008

#define PENNY_EMUL_NONE		0x00
#define PENNY_EMUL_MDA		0x01
#define PENNY_EMUL_CGA		0x02
#define PENNY_VGA_LOOP      0x03
#define PENNY_VGA_CABLE     0x10

#define NNIOS_PRESENT_FLAG  0xFFFFFB00
#define NNIOS_NOT_PRESENT   0x0000
#define NNIOS_PRESENT       0x0077

#define PENNY_ID_1          0x9999
#define PENNY_ID_2          0x8080
#define NNIOS_ID            0xEDDF

#define LO_MASK             0x00FF
#define HI_MASK             0xFF00

typedef struct PennyBoardInfo *PENNYPTR;

typedef struct StreamBRegInfo
	{
	unsigned int PennySanityBit : 1;
	unsigned int EmulationType : 4;
	unsigned int MonitorType : 4;
	unsigned int VgaCable : 1;
	unsigned int SogEnable : 1;
	unsigned int MicroChannel : 1;
	unsigned int Interlaced : 1;
	unsigned int RomBoot : 1;
	unsigned int ExtraMemory : 1;
	unsigned int WordMode : 1;
	}STREAMCHIPINFO;

typedef struct MapInfo
		{
		unsigned int MapEnable : 1;
		unsigned int MemHIEnable : 1;
		unsigned int IOHIEnable : 1;
		unsigned int MdaEnable : 1;
		unsigned int BankEnable : 1;
		unsigned int SwapStyle : 3;
		unsigned int VideoSelect : 1;
		unsigned int WriteProtect : 1;
		unsigned int MemHIEnableWord : 1;
		unsigned int BankEnableWord : 1;
		unsigned int IOHIEnableWord : 1;
		unsigned int BurstEnable : 1;
		unsigned int PostedWriteEnable : 1;
		unsigned int ATDmaEnable : 1;
		} MAPCHIPBITS;

typedef union MapChipUnion
	{
	MAPCHIPBITS MapChipBits;
	UWORD MapChipWord;
	}MAPCHIPINFO;

typedef struct StreamBRegZero
	{
	unsigned int Zoom : 2;
	unsigned int Reserved : 1;
	unsigned int Mode0 : 1;
	unsigned int BitsPerPixel : 2;
	unsigned int DacWidth : 1;
	unsigned int SyncOnGreen : 1;
	unsigned int Mode1 : 1;
	unsigned int HorizSync : 1;
	unsigned int VertSync : 1;
	unsigned int CompositSync : 1;
	unsigned int TriTiVclock : 1;
	unsigned int TriVShiftclock: 1;
	unsigned int TriHVSyncs : 1;
	unsigned int TriBlank : 1;
	}STREAMBREGZERO;

typedef union StreamBReg0Union
	{
	STREAMBREGZERO StreamBReg0Bits;
	UWORD StreamBReg0Word;
	}STREAMBREG0INFO;

typedef struct StreamBRegOne
	{
	unsigned int Monitor : 4;
	unsigned int VideoCable : 1;
	unsigned int Blank478Dak : 1;
	unsigned int Blank459Dac : 1;
	unsigned int SoftReset : 1;
	unsigned int TriDacData : 1;
	unsigned int PennySanity : 1;
	unsigned int PennyIdBits : 3;
	unsigned int StreamRev : 2;
	unsigned int Select459Signals : 1;
	}STREAMBREGONE;

typedef union StreamBReg1Union
	{
	STREAMBREGONE StreamBReg1Bits;
	UWORD StreamBReg1Word;
	}STREAMBREG1INFO;

typedef struct StreamBRegTwo
	{
	unsigned int MSV : 1;
	unsigned int MSI : 1;
	unsigned int MS4 : 1;
	unsigned int C : 1;
	unsigned int IL4 : 1;
	unsigned int V2 : 1;
	unsigned int SV : 1;
	unsigned int EmulType : 2;
	unsigned int Reserved : 2;
	unsigned int RomBoot : 1;
	unsigned int Level : 3;
	unsigned int ExtraMemory : 1;
	}STREAMBREGTWO;

typedef union StreamBReg2Union
	{
	STREAMBREGTWO StreamBReg2Bits;
	UWORD StreamBReg2Word;
	}STREAMBREG2INFO;

typedef struct PennyBoardInfo
	{
	PENNYPTR NextPenny;
	PENNYPTR PrevPenny;
	DWORD PennyAddr;
	UWORD HIAddr;
	WORD BoardLevel;
	WORD BoardType;
	UWORD IramSize;
	UWORD VramSize;
	STREAMCHIPINFO StreamChip;
	MAPCHIPINFO MapChip;
	STREAMBREG0INFO StreamBReg0;
	STREAMBREG1INFO StreamBReg1;
	STREAMBREG2INFO StreamBReg2;
	WORD Reserved;
	BYTE BoardName[20];
	}PENNYINFO;




/********************** penny.obj function prototypes **********************/
extern PENNYPTR FindPenny();
extern WORD GetPcbIdent( UWORD );
extern WORD GetPennyLevel( UWORD );
extern WORD ReadPenny( UWORD, DWORD );
extern VOID WritePenny( UWORD, DWORD, UWORD );
extern VOID PennyMemTest( UWORD );
extern VOID InitPennyStruct();
extern VOID SetPennyName();
extern VOID WritePennyLevel( UWORD );

