@ECHO OFF

rem --- MIROINST.CMD (02.11.1995) ---

ECHO.
ECHO **************************************************************
ECHO *  OS/2 Grafik-Treiber Installation fr miro Grafikkarten.   *
ECHO *  OS/2 Display Driver Installation for miro Video Boards.   *
ECHO **************************************************************

rem --- check arguments ---
IF .%1. == .. GOTO USAGE
IF .%2. == .. GOTO USAGE

rem --- check dirs and files ---
IF NOT EXIST %1\BUNDLE         GOTO USAGE
IF NOT EXIST %1\TIMING         GOTO USAGE
IF NOT EXIST %1\S3VIDEO        GOTO USAGE
IF NOT EXIST %1\S3WIN          GOTO USAGE
IF NOT EXIST %1\MIRO.DSC       GOTO USAGE
IF NOT EXIST %1\MIRO.DSP       GOTO USAGE
IF NOT EXIST %2\OS2\INSTALL    GOTO USAGE
IF NOT EXIST %2\OS2\ATTRIB.EXE GOTO USAGE
IF NOT EXIST %2\OS2\UNPACK.EXE GOTO USAGE

ECHO.
ECHO **************************************************************
ECHO *  Bitte lesen Sie zuerst OS2HELPD.INF auf dieser Diskette.  *
ECHO *  Fhren Sie dazu den Befehl "VIEW.EXE OS2HELPD.INF" aus.   *
ECHO *                                                            *
ECHO *  Please read the OS2HELPE.INF file on this diskette first. *
ECHO *  To do so, issue the command "VIEW.EXE OS2HELPE.INF".      *
ECHO **************************************************************
ECHO.
ECHO Weiter mit beliebiger Taste oder Ctrl-C fr Abbruch ...
ECHO Press any key when ready or Ctrl-C to break ...

PAUSE 1>NUL 2>NUL

ECHO.
ECHO **************************************************************
ECHO *  Kopiere Dateien, bitte warten Sie ...                     *
ECHO *  Copying files, please stand by ...                        *
ECHO **************************************************************

rem --- backup original files ---
%2\OS2\ATTRIB -R %2\OS2\*.* /S 1>NUL 2>NUL
IF EXIST %2\OS2\SVGA.SAV GOTO NEXT1
COPY %2\OS2\SVGA.EXE %2\OS2\SVGA.SAV 1>NUL 2>NUL
:NEXT1
IF EXIST %2\OS2\MDOS\VSVGA.SAV GOTO NEXT2
COPY %2\OS2\MDOS\VSVGA.SYS %2\OS2\MDOS\VSVGA.SAV 1>NUL 2>NUL
:NEXT2
IF EXIST %2\OS2\SCREEN0?.SAV GOTO NEXT3
COPY %2\OS2\SCREEN0?.SYS %2\OS2\SCREEN0?.SAV 1>NUL 2>NUL
:NEXT3
IF EXIST %2\OS2\VIDEO.SAV GOTO NEXT4
COPY %2\OS2\VIDEO.CFG %2\OS2\VIDEO.SAV 1>NUL 2>NUL
:NEXT4
DEL  %2\OS2\VIDEO.CFG 1>NUL 2>NUL

rem --- create miro directory ---
MKDIR %2\OS2\MIRO           1>NUL 2>NUL
MKDIR %2\OS2\MIRO\COMMON    1>NUL 2>NUL
MKDIR %2\OS2\MIRO\FONT      1>NUL 2>NUL
MKDIR %2\OS2\MIRO\TIMING    1>NUL 2>NUL

rem --- unpack install files from archives ---
%2\OS2\UNPACK2 %1\BUNDLE %2 1>NUL 2>NUL
%2\OS2\UNPACK2 %1\TIMING %2 1>NUL 2>NUL

rem --- look for custom timing files ---
IF NOT EXIST %1\*.INI GOTO NOINI
COPY %1\*.INI %2\OS2\MIRO\TIMING\*.INI
:NOINI

rem --- copy information files ---
COPY %1\*.INF %2\OS2\MIRO\COMMON 1>NUL 2>NUL

rem --- copy dspinstl control file ---
COPY %1\MIRO.DSC %2\OS2\INSTALL\MIRO.DSC 1>NUL 2>NUL

rem --- copy screen0?.sys to boot directory (OS/2 Warp beta) ---
COPY %2\OS2\SCREEN0?.SYS %2\OS2\BOOT\SCREEN0?.SYS 1>NUL 2>NUL

rem --- select card and monitor, ---
rem --- create svgadata.pmi file ---
SET MIROPATH=%2\OS2\MIRO
%2\OS2\MIRO\COMMON\MIROMAT2.EXE

rem --- run display install programm ---
%2\OS2\INSTALL\DSPINSTL.EXE

rem --- create miro folder and icons ---
%2\OS2\MIRO\COMMON\MIROICON.EXE ICO

rem --- call "system" notebook ---
%2\OS2\MIRO\COMMON\MIROICON.EXE SYS

ECHO.
ECHO **************************************************************
ECHO *  Whlen Sie die gewnschte Auflsung im Fenster "System"   *
ECHO *  und fhren Sie danach einen Systemabschlu durch.         *
ECHO *                                                            *
ECHO *  Select the desired resolution in the "System" notebook    *
ECHO *  and perform a system shut down afterwards.                *
ECHO **************************************************************
ECHO.
GOTO END

:USAGE
ECHO.
ECHO Syntax: MIROINST [INSTALLDRIVE:] [OS2DRIVE:]
ECHO.

:END

