/********************************************************************
*    miroVDI Utility                          Stand 19-05-87        *
*                                                                   *
*    simple test program                                            *
*                                                                   *
*    You have to compile this program in LATTICE C -P Modell        *
*********************************************************************
    History:
---------------------------------------------------------------------
    02-04-87    Definition /Germund
    19-05-87    change in test for miroVDI installed /Germund
********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <mirovdi.h>

static struct INQUIRE inq;
int xmax,ymax,i;

int init_all ()
{
    /* initialization */
 if (init_screen (NULL) != 0) return (0xFFFF);  /* bei fehler, EXIT */
 inq_char (&inq);   /* inquire screen size and store it */
 xmax = inq.xpix;
 ymax = inq.ypix;
 clear_screen (0);  /* clear the video memory */
 clip_area (0,0,xmax-1,ymax-1); /* define clipping area */
 move_abs (0, 0);
 return (0x0000);
}

void prt_string (dir, ptr)
int dir;
char *ptr;
{
 while (*ptr) {
  draw_char (dir, *ptr);
  ptr++;
 }
}

/* ---------------------------------------------------------------------- */

int star[16] =  { 0x1004, 0x0C18, 0x0A28, 0x0948,
                  0x0490, 0x0410, 0x0220, 0x0C18,
                  0x3006, 0x7C1F, 0x0220, 0x0140,
                  0x0140, 0x0080, 0x0080, 0x0080 };

void main (argc, argv)
int argc;
char *argv[];
{
    /* test command line parameters */
    
    if (argc > 2) {
        puts ("\nInvalid number of parameters");
        exit (1);
    }
    if (argc == 2) {
        i = sscanf (argv[1], "%x",&vector);
        if (i != 1) {
            puts ("\nInvalid parameter");
            exit (1);
        }
    } else {
        vector = VECTOR;    /* default interrupt vector */
    }
    printf("\n==========================================================================");
    printf("\n  Test-Program for miroVDI (miroGRAPH 500 / 510 / 530)        Version 1.0b");
    printf("\n==========================================================================");
    /* test, if miroVDI already installed */
    if (testvdi() == 0) {
        printf ("\nmiroVDI not installed");
        exit (1);
    }

    if (init_all () != 0) {
        printf ("\nError during hardware initialization");
        exit (1);
    }

    /* function test */
    
    select_color (1, 1);        /* border around the screen */
    move_abs (0, 0);
    line_abs (xmax-1, 0);
    line_abs (xmax-1, ymax-1);
    line_abs (0, ymax-1);
    line_abs (0, 0);
    move_abs (xmax/2, ymax/2);  /* circle */
    select_color (2, 2);
    circle (xmax/3);
    select_color (3, 3);        /* little square starting at midpoint */
    rct_rel (xmax/3, xmax/3);
    move_abs (xmax/2-xmax/3-1, ymax/2-xmax/3-1);    /* square around */
    select_color (4, 4);                            /* circle */
    rct_abs (xmax/2+xmax/3+1, ymax/2+xmax/3+1);
    move_abs (0, 0);
    write_pram (16, 16, &star[0]);  
    select_color (0, 5);
    pattern (0, 80, 80);        /* first star square with pattern command */
    move_abs (0, 100);
    write_pram (10, 10, &star[0]);  /* define star pattern in 10 x 10 */
    select_color (0, 6);
    frct_rel (80, 80);          /* filled rectangle */
    move_abs (0, 200);
    ptn_zoom (2, 2);            /* switch to pattern zoom factor 2 */
    select_color (0, 7);
    frct_abs (80, 280);         /* filled rectangle with zoomed pattern */
    select_color (0,1);         /* write zoomed text */
    move_abs (xmax/5, ymax-ymax/16);
    prt_string (0, "This is a simple Testprogram\0");
    set_color (0, 0x00707070L); /* set background color to dark gray */
}
