/*----------------------------------------------------------------------------

  WinWTV.c -- Sample Windows 32 Bit Win/TV Program - FOR DEMONSTRATION ONLY

              This application creates a window of live video and 
              allows the user to freeze/unfreeze it The window may
              be re-sized from ICON to FULL_SCREEN.
              Audio may be toggled on and off from the CONTROLS
              pull-down menu. The audio levels are fixed. This 
              application will work under windows NT and windows 95.              

              This program can be used freely to develop your own 
              software application. It is NOT intended to be used
              as an application, and has been intentionally kept
              simple. It should be used as a framework upon which 
              to build your own application using the Win/TV board.

              Please refer to the Windows SDK for information on 
              specific Windows calls.

              Information concerning calls to the PCVID32.DLL are the
			  same as the 16 bit version PCVIDEO.DLL and are documented 
			  in the WIN/TV SOFTWARE DEVELOPMENT GUIDE, part number 464101-01.
              
              WinWTV.c: Revision 1.00 - July 31, 1995

              (c)1995 Hauppauge Computer Works, Inc.

----------------------------------------------------------------------------*/
#include <windows.h>
#include "wintv.h"
#include "WinWTV.h"
#include "wintvacc.h"
#include "stdlib.h"
WORD    wTuneStatus;          /* Flag to see if we tuned a channel properly */
int     iAudioStatus = 1;     /* Mute audio upon initialization of the app  */
BYTE    iSave;                /* Flag to indicate if PCVIDEO.INI should be..
                                 ..updated upon exit                        */
	  

int APIENTRY WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)

        {
          static char szAppName[] = "WinW32TV" ;
          HWND            hwnd ;
          MSG             msg ;
          WNDCLASS        wndclass ;                            
          short           error ;
          BOOL			  bFirstInstance;

		  bFirstInstance = (InterlockedIncrement(&glUsageCount) == 0);
		  if(!bFirstInstance) {
		  	MessageBox(NULL, "Application is already running!", szAppName, MB_OK);
		  	}
		  else { 
	          hInst = hInstance;     //save handle of application instance.
	/* 
	          Initialize the Win/TV board and check for possible errors..
	*/        
	         if ((error = PCV_Initialize() ) == 0)
			 	{
				  LoadString(hInst, WTV_GetErrorCode(), gszBuffer, sizeof(gszBuffer));
				  MessageBox(NULL, gszBuffer, szAppName, MB_OK);
				  return FALSE;
				}
	          if (!hPrevInstance)
	            {
	              wndclass.style          = CS_HREDRAW | CS_VREDRAW ;
	              wndclass.lpfnWndProc    = WndProc ;
	              wndclass.cbClsExtra     = 0 ;
	              wndclass.cbWndExtra     = 0 ;
	              wndclass.hInstance      = hInstance ;
	              wndclass.hIcon          = NULL ;
	              wndclass.hCursor        = LoadCursor (NULL, IDC_ARROW) ;
	              wndclass.lpszMenuName   = "WinWTV" ;
	              wndclass.lpszClassName  = szAppName ;
	              wndclass.hbrBackground  = CreateSolidBrush(WTV_GetKeyColor());
	              RegisterClass (&wndclass) ;
	            }

	/*        We want to set up some parameters before the window is displayed.
	          Specifically, we want the audio to be muted so we wont get 
	          blasted upon the app starting. Normally, these are all set
	          to defaults during PCV_Initialize if this is the first time 
	          the app is run, or to whatever state the last session left. 

	          NOTE: This app will read initial parameters from the same PCVIDEO.INI
	                file that the standard application uses. Access to the INI 
	                file is hard-coded in PCVID32.DLL. Note, however, that we will
	                NOT write back any settings to the INI file when we exit
	                this application (iSave=0)
                
	*/
   	          WTV_SetAudio(MUTE, 1);        /* Mute the audio              */
		  	  WTV_SetSVideo(0);				/* Disable SVideo	       	   */
//	          PCV_SetVideoSource(2);        /* Set video source to TUNER   */
	          WTV_SetAudio(VOLUME, 65);     /* Set volume to 65%           */
//	          WTV_SetAudio(SOURCE, 2);      /* Set Audio source to TUNER   */
	          WTV_SetAudio(BASS, 100);      /* 100% Bass                   */
	          WTV_SetAudio(TREBLE, 80);     /*  80% Treble                 */

	          MessageBox(NULL, "   Win/TV Sample Software -\nFOR DEMONSTRATION ONLY",
	                          szAppName, MB_OK);

	          hwnd = CreateWindow (szAppName, "Win/TV-Windows 32 Bit Sample Program",
	                               WS_OVERLAPPEDWINDOW,
	                               150, 150,                /* Top, left corner */
	                               330, 270,                /* Width, height    */
	                               NULL, NULL, hInstance, NULL);

	/* 
	        wTuneStatus will return a value indicating success. For the purposes
	        of this demo, we will ignore it because we will use the default settings
			in pcvideo.ini to set the tuner channel.
	*/   
	//          wTuneStatus = WTV_SetTunerChannel(CCIR, 3, 0, 0);      /* Channel 3 */

	          ShowWindow (hwnd, nCmdShow) ; /* Make the window visible	     */
	          UpdateWindow (hwnd);          /* Force a WM_PAINT                  */

	          while (GetMessage (&msg, NULL, 0, 0)) /* Get a message from the..
	                                                   ..message queue           */
	            {
	              TranslateMessage (&msg);  /* Convert virtual-key to character..*/
	              DispatchMessage (&msg) ;  /* ..and dispatch it to our window   */
	            }
			  InterlockedDecrement(&glUsageCount);
	          return msg.wParam ;
		  }
		  InterlockedDecrement(&glUsageCount);
		  return(0);
  }

 long APIENTRY WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
        {
          static short cxClient, cyClient, 
                       x1, x2, x3, x4, 
                       y1, y2, y3, y4,
                       nEvent  = IDM_ADJAUD;
          HDC          hdc ;
          HMENU        hMenu ;
          HCURSOR      hCur;                    /* Handle for cursor type    */
          PAINTSTRUCT  ps ;
          POINT        worg;
          POINT        porg;
          static short xWinSize, yWinSize;      /* Windows' client area size */
		  FARPROC	   lpProcAbout;				/* pointer to the About Dialog box function */
          hCur = LoadCursor(NULL, IDC_WAIT);      /* Change the cursor to an ..
                                                   .. hour glass if the ..
                                                   .. operation is going to ..
                                                   .. take a while           */
         
                    
          switch (message)      /* System messages processed here..          */
            {
              case WM_CREATE:   /* Build the window..   */
                porg.x = porg.y = 0;
                PCV_PanWindow((WORD)porg.x, (WORD)porg.y);
                PCV_EnableVideo();
                hMenu = GetMenu(hwnd) ;
                CheckMenuItem (hMenu, IDM_FRZ,    MF_UNCHECKED) ;
                CheckMenuItem (hMenu, IDM_UNFREZ, MF_CHECKED) ;
                CheckMenuItem (hMenu, IDM_ADJAUD, MF_UNCHECKED) ;
                InvalidateRect(hwnd, NULL, FALSE);   /* Send a PAINT message */
                break;
                      
              case WM_SIZE:     /* The window has been re-sized. Scale the..
                                   ..video to fit in this new window.   */
                InvalidateRect(hwnd,NULL,FALSE);
                xWinSize = LOWORD(lParam);
                yWinSize = HIWORD(lParam);
                worg.x = worg.y = 0;
                ClientToScreen(hwnd,&worg);
                PCV_CreateWindow((WORD)worg.x,(WORD)worg.y, xWinSize, yWinSize, 1);
                break;

              case WM_COMMAND:  /* A Pull-down command has occurred     */
                nEvent = wParam;
                switch (LOWORD(wParam))
                  {
                    case IDM_FRZ:       /* Freeze-frame was selected.. */
                      PCV_FreezeVideo();
                      hMenu = GetMenu (hwnd) ;
                      CheckMenuItem (hMenu, IDM_UNFREZ,MF_UNCHECKED);
                      CheckMenuItem (hMenu, IDM_FRZ  , MF_CHECKED) ;
                      break;

                    case IDM_UNFREZ:    /* UnFreeze the video.. */
                      PCV_UnFreezeVideo(); 
                      hMenu = GetMenu (hwnd) ;
                      CheckMenuItem (hMenu, IDM_FRZ,   MF_UNCHECKED);
                      CheckMenuItem (hMenu, IDM_UNFREZ,MF_CHECKED) ;
                      break;

                    case IDM_ADJVID:    /* Call the adjust video subfunction */
                      WTVacc_AlignVideo(hwnd);
                      break;

                    case IDM_ADJCOL:    /* Call the adjust color subfunction */
                      WTVacc_AdjustColors(hwnd);
                      break;

                    case IDM_ADJAUD:    /* Toggle audio mute..  */
                      hMenu = GetMenu (hwnd) ;
                      if (!iAudioStatus) /* Check state of the MUTE function */
                        {
                          WTV_SetAudio(MUTE, 1);
                          CheckMenuItem (hMenu, IDM_ADJAUD, MF_UNCHECKED) ;
                          iAudioStatus = 1;     /* toggle the MUTE bit */
                        }
                      else
                        {
                          CheckMenuItem (hMenu, IDM_ADJAUD, MF_CHECKED) ;
                          WTV_SetAudio(MUTE, 0);
                          iAudioStatus = 0;     /* toggle the MUTE bit */
                        }
                      break;
					case IDM_ABOUT:
						lpProcAbout = MakeProcInstance((FARPROC)AboutDlgProc, hInst);
						DialogBox(hInst,MAKEINTRESOURCE(IDD_ABOUT), hwnd, AboutDlgProc);
						FreeProcInstance(lpProcAbout);
					  break;
                  }
                  break ;

              case WM_PAINT:    /* Re-draw the window parameters. */
                hdc = BeginPaint (hwnd, &ps) ;
                EndPaint (hwnd, &ps) ;
                return 0 ;

              case WM_MOVE:
                worg.x = worg.y = 0;
                ClientToScreen(hwnd,&worg);
                PCV_SetWindowPosition((WORD)worg.x,(WORD)worg.y);
                break;

              case WM_DESTROY:
                iSave = 0;   /* Do NOT Update parameters to PCVIDEO.INI file */
                WTV_Exit(iSave);
                PostQuitMessage(0);
                return 0;
            }

            return DefWindowProc (hwnd, message, wParam, lParam) ;

}

BOOL APIENTRY AboutDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
#define DECIMAL "."

  DWORD		dwVersion[2];                        
  char		infostring[2][64] = {"",""} ,  temp[16];
  WORD		wVersionNumber, wRevisionNumber, wMinorReleaseNumber;
  int 		i;

	switch (message) {
		case WM_INITDIALOG:
			//get version number and breakdown into parts
			dwVersion[0] = WTV_GetVersion();
			dwVersion[1] = WTVacc_GetVersion();
			lstrcat(infostring[0], "PCVID32.DLL Version ");
			lstrcat(infostring[1], "WTVACC32.DLL Version ");

			for (i = 0; i < 2; i++)
			{
			wVersionNumber = LOWORD(dwVersion[i]) / 100;
			wRevisionNumber = LOWORD(dwVersion[i]) % 100;
			wMinorReleaseNumber = (WORD)((dwVersion[i] & 0x0FF0000) >> 16);

			//convert numbers in strings and build string
			_itoa(wVersionNumber, temp, 10);
			lstrcat(infostring[i], temp);
			lstrcat(infostring[i], DECIMAL);
			_itoa(wRevisionNumber, temp, 10);
			lstrcat(infostring[i], temp);
			lstrcat(infostring[i], DECIMAL);
			_itoa(wMinorReleaseNumber, temp, 10);
			lstrcat(infostring[i], temp);
			//check flags
			if (dwVersion[i] & 0x1000000) lstrcat(infostring[i], " Debug");
			if (dwVersion[i] & 0x2000000) lstrcat(infostring[i], " PreRelease");
			}
			SetDlgItemText(hDlg, IDC_STATIC2, infostring[0]);
			SetDlgItemText(hDlg, IDC_STATIC3, infostring[1]);
			return TRUE;
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDOK:
					EndDialog (hDlg, TRUE);
					return TRUE;
			}
			break;
		}
	return FALSE;
}
