Option Explicit

Type Rect_Type
  X1 As Integer
  Y1 As Integer
  X2 As Integer
  Y2 As Integer
End Type

' Return values for WTV_GetBoardType

Global Const BT_WINTV = 1
Global Const BT_WINTVCELEBRITY = 2
Global Const BT_WINTVCINEMA = 3
Global Const BT_WINTVCINEMA202 = 4
Global Const BT_WINTVSOUTHOLD = 5


' Index values for WTV_GetStatus

Global Const GS_VIDEOSIGNAL = 0
Global Const GS_TUNED = 1
Global Const GS_INIT = 2


' Image types for Load & Save Image

Global Const BM_DIB24 = 0       ' Windows DIB 24 bpp true color
Global Const BM_DIB8P = 1       ' Windows DIB 8 bpp palettized
Global Const BM_DIB8G = 2       ' Windows DIB 8 bpp gray-scale
Global Const BM_DIB4D = 3       ' Windows DIB 4 bpp dithered
Global Const BM_TRG32 = 4       ' Targa 32 bpp true color
Global Const BM_TRG24 = 5       ' Targa 24 bpp true color
Global Const BM_TRG16 = 6       ' Targa 16 bpp true color
Global Const BM_YUV411 = 7      ' IBM MMotion format YUV
Global Const BM_TIFF24 = 8      ' TIFF 24 bit true color
Global Const BM_TIFF8P = 9      ' TIFF 8 bit palettized
Global Const BM_TIFF8G = 10     ' TIFF 8 bit gray-scale
Global Const BM_PCX8P = 11      ' PCX 8 bit palettized
Global Const BM_PCX8G = 12      ' PCX 8 bit gray-scale
Global Const BM_PCX4D = 13      ' PCX 4 bit dithered
Global Const BM_GIF8P = 14      ' GIF 8 bit palettized
Global Const BM_GIF8G = 15      ' GIF 8 bit gray-scale
Global Const BM_JPEG = 16       ' JPEG compressed 4:2:2 YUV
Global Const BM_DIB1P = 17      ' BMP monochrome
Global Const BM_DIB4P = 18      ' BMP 16 colors palettized



Global Const CLP_BITMAP = &H1000
Global Const CLP_DIB = &H2000
Global Const CLP_MASK = &HF000


Global Const NO_SKEW_FACTORS = 6    ' 6 on Boards without PLL
Global Const MAX_SKEW_FACTOR = (NO_SKEW_FACTORS - 1)


' Index values for PCV_GetSkewFactor / PCV_SetSkewFactor

Global Const SF_DISPWINSKEWX = 0                ' Display Window X Skew
Global Const SF_DISPWINSKEWY = 1                ' Display Window Y Skew
Global Const SF_DISPADDRSKEWX = 2               ' Display Address X Skew
Global Const SF_DISPADDRSKEWY = 3               ' Display Address Y Skew
Global Const SF_SHIFTCLOCKSTART = 4             ' Shift Clock Start
Global Const SF_PALETTESKEW = 5                 ' Palette Skew
Global Const SF_DISPLAYWIDTH = 6                ' Display Width (Horizontal Total)
Global Const SF_PLLVCOGAIN = 7                  ' PLL VCO Gain
Global Const SF_PLLPHDETGAIN = 8                ' PLL Phase Det Gain


Global Const DISPWINSKEWXRANGE = &H7FF          ' Display Window X Skew Range
Global Const DISPWINSKEWYRANGE = &H7FF          ' Display Window Y Skew Range
Global Const DISPADDRSKEWXRANGE = &H3FF         ' Display Address X Skew Range
Global Const DISPADDRSKEWYRANGE = &H3FF         ' Display Address Y Skew Range
Global Const SHIFTCLOCKSTARTRANGE = &H7F        ' Shift Clock Start Range
Global Const PALETTESKEWRANGE = &H7             ' Palette Skew Range
Global Const DISPWIDTHRANGE = &H7FF             ' Display Width Range
Global Const PLLVCOGAINRANGE = &H3               ' PLL VCO Gain
Global Const PLLPHDETGAINRANGE = &H3            ' PLL Phase Det Gain



Global Const NO_FORMATS = 6
Global Const MAX_FORMAT = (NO_FORMATS - 1)

' Video Formats supported by PCV_GetInputFormat / PCV_SetInputFormat

Global Const PAL_BGHI = 0
Global Const NTSC_M = 1
Global Const SECAM = 2
Global Const PAL_M = 3
Global Const PAL_N = 4
Global Const NTSC_443 = 5
Global Const EXTERNAL_SRC = 6


' Tuner Type codes for WTV_DGetTunerType / WTV_SetTunerType

Global Const M_TUNER = 0
Global Const BG_TUNER = 1
Global Const I_TUNER = 2


Global Const NO_REGIONS = 12
Global Const MAX_REGION = (NO_REGIONS - 1)

' Regions for use with WTV_SetTunerChannel

Global Const USA = 0
Global Const US_CATV = 1
Global Const CCIR = 2           ' Western Europe
Global Const CCIR_CATV = 3      ' Western Europe
Global Const AUSTRALIA = 4      ' Australia
Global Const JAPAN = 5          ' Japan
Global Const JAPAN_CATV = 6
Global Const US_HRC = 7
Global Const UK_CATV = 8
Global Const FRANCE = 9
Global Const FRANCE_CATV = 10
Global Const ALL = 11

' Option bits for WTV_SetTunerChannel

Global Const TUNER_NOMUTE = &H1
Global Const TUNER_NOWAITTUNER = &H2
Global Const TUNER_NOWAITSIGNAL = &H4


' Return values for WTV_SetTunerChannel

Global Const CHANNEL_OK = 0
Global Const CHANNEL_LOW = 1
Global Const CHANNEL_HIGH = 2
Global Const CHANNEL_SKIP = 3



' Bit definitions for bits returned by WTV_HWOptions

Global Const HW_TunerPresent = &H1
Global Const HW_SECAMPresent = &H2
Global Const HW_AudioPresent = &H4
Global Const HW_TeletextPresent = &H8
Global Const HW_SVideoPresent = &H10
Global Const HW_External2 = &H20
Global Const HW_RAMAccess = &H8000


' Index values for WTV_GetModeInfo

Global Const MI_VIDEOMODE = 0
Global Const MI_VGAWIDTH = 1
Global Const MI_VGAHEIGHT = 2
Global Const MI_MODEFLAGS = 3
Global Const MI_HIGHRES = 4
Global Const MI_HIGHRESFLAGS = 5



' Flag bits for use with WTV_SetHighResMode

Global Const HRF_HICOLOR2X = 1
Global Const HRF_LT60HZ = 2
Global Const HRF_INTDIV = 4
Global Const HRF_HW_RESOLUTION = &H2000         ' Use H/W reg resolution in place of driver specified resolution
Global Const HRF_FORCE_INTERLACE = &H4000
Global Const HRF_INTERLACE_ON = &H0
Global Const HRF_INTERLACE_OFF = &H8000



Global Const NO_DAC_Settings = 8
Global Const MAX_DAC_SETTING = (NO_DAC_Settings - 1)

' Index Values for WTV_GetDAC / WTV_SetDAC

Global Const DAC_RED_CUTOFF = 0
Global Const DAC_GREEN_CUTOFF = 1
Global Const DAC_BLUE_CUTOFF = 2
Global Const DAC_SAA9060_CTRL1 = 3
Global Const DAC_SAA9060_CTRL0 = 4
Global Const DAC_IBIAS = 5
Global Const DAC_SEPERATION = 6


' Bit definitions for bits returned by WTV_GetAudio(AUDIO_OPTIONS)

Global Const AUDIO_HAS_VOLUME = &H1
Global Const AUDIO_HAS_BALANCE = &H2
Global Const AUDIO_HAS_BASS = &H4
Global Const AUDIO_HAS_TREBLE = &H8
Global Const AUDIO_HAS_SEPARATION = &H10
Global Const AUDIO_HAS_SOURCE = &H20
Global Const AUDIO_HAS_MUTE = &H40
Global Const AUDIO_HAS_LOUDNESS = &H80
Global Const AUDIO_HAS_STEREO = &H100
Global Const AUDIO_HAS_DUALMONO = &H200
                    

' Index values for WTV_GetAudio / WTV_SetAudio

Global Const VOLUME = 0
Global Const BALANCE = 1
Global Const BASS = 2
Global Const TREBLE = 3
Global Const SEPERATION = 4
Global Const SEPARATION = 4
Global Const SOURCE = 5
Global Const MUTE = 6
Global Const DUALMONO = 7
Global Const LOUDNESS = 8
Global Const AUTOMUTE = 9

Global Const AUDIO_VOLUME = 0
Global Const AUDIO_BALANCE = 1
Global Const AUDIO_BASS = 2
Global Const AUDIO_TREBLE = 3
Global Const AUDIO_SEPARATION = 4
Global Const AUDIO_SOURCE = 5
Global Const AUDIO_MUTE = 6
Global Const AUDIO_DUALMONO = 7
Global Const AUDIO_LOUDNESS = 8
Global Const AUDIO_AUTOMUTE = 9

'       Audio Parameters

Global Const NO_AUDIO_SETTINGS = 10
Global Const MAX_AUDIO_SETTING = (NO_AUDIO_SETTINGS - 1)


Global Const MAX_SOURCE = 3

Global Const SRC_EXT1 = 0
Global Const SRC_EXT2 = 1
Global Const SRC_TUNER = 2


'       Privilege Settings
Global Const PRIV_CHANNEL_ALL = 0     'Normal Setting - Full Privileges
Global Const PRIV_CHANNEL_NoScan = 1  'Scanning disabled
Global Const PRIV_CHANNEL_NONE = 2    'Scanning and all channel editing disabled

' PCV_SetVideoMode selections

Global Const FIT_VIDEO = &H0                    ' Scale video to fit in capture buffer
Global Const CROP_VIDEO = &H1                   ' Crop video


' Index values for PCV_GetColor / PCV_SetColor

Global Const BRIGHTNESS = 0
Global Const SATURATION = 1
Global Const CONTRAST = 2
Global Const HUE = 3
Global Const RED = 4
Global Const GREEN = 5
Global Const BLUE = 6
Global Const BW = 7

' Index values for PCV_GetSystemMetrics

Global Const SM_VIDEOWIDTH = 0
Global Const SM_VIDEOHEIGHT = 1
Global Const SM_XRESOLUTION = 2
Global Const SM_YRESOLUTION = 3
Global Const SM_BOARDTYPE = 4
Global Const SM_VERSION = 5
Global Const SM_INTERLACE = 6
Global Const SM_REPLICATE = 7
Global Const SM_IMAGEWIDTH = 8
Global Const SM_IMAGEHEIGHT = 9
Global Const SM_IMAGETYPE = 10
Global Const SM_BUFFERWIDTH = 11
Global Const SM_BUFFERHEIGHT = 12
Global Const SM_CROPLEFT = 13
Global Const SM_CROPTOP = 14
Global Const SM_SCALERTYPE = 15
Global Const SM_RAMSIZE = 16
Global Const SM_COMPTYPE = 17               'Buffer Compression Type


' Frame buffer formats returned by PCV_GetSystemMetrics( SM_BOARDTYPE )

Global Const BT_YUV411 = 0
Global Const BT_YUV422 = 5



' Current Frame Buffer Compression Type
Global Const BCT_other = 65535
Global Const BCT_none = 0
Global Const BCT_411 = 1
Global Const BCT_422 = 2


' Scaler Types returned by PCV_GetSystemMetrics( SM_SCALERTYPE )

Global Const ST_CT9001 = 1
Global Const ST_VXP500 = 2
Global Const ST_VXP501FAMILY = 3



' Error codes returned by WTV_GetErrorCode

Global Const E_DRIVER = 1
Global Const E_NOTPRESENT = 2
Global Const E_WIDTH = 3
Global Const E_HEIGHT = 4
Global Const E_INIFILE = 5
Global Const E_BOARDTYPE = 6
Global Const E_WINTV = 7


' Flag bits for use with WTV_SetFreezeResolution

Global Const FM_BESTSAVE = &H1
Global Const FM_Q100 = &H2
Global Const FM_NODISABLE = &H4





'       Win/TV Accessory DLL


Type PageSetup
    LeftMargin As Single
    RightMargin As Single
    TopMargin As Single
    BottomMargin As Single
    PrintScale As Integer
    Flags As Integer
End Type


Global Const F_FitToPage = 1
Global Const F_PreserveAspectRatio = 2



'       Video Out
Global Const VO_FILTER = 1
Global Const VO_WIDTH = 2
Global Const VO_FORMAT = 3

