VERSION 4.00
Begin VB.Form WinTV 
   Appearance      =   0  'Flat
   BackColor       =   &H00FF00FF&
   Caption         =   "Simple Visual Basic Win/TV Example"
   ClientHeight    =   3630
   ClientLeft      =   1365
   ClientTop       =   1740
   ClientWidth     =   4830
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   0
      weight          =   700
      size            =   8.25
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   4320
   Icon            =   "WINTV.frx":0000
   Left            =   1305
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   ScaleHeight     =   242
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   322
   Top             =   1110
   Width           =   4950
   Begin VB.Timer Move_Timer 
      Interval        =   100
      Left            =   225
      Top             =   720
   End
   Begin VB.Label L_Channel 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      Caption         =   "255"
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   18
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FF00&
      Height          =   435
      Left            =   210
      TabIndex        =   0
      Top             =   210
      Width           =   645
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuSaveImage 
         Caption         =   "&Save Image"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuOptions 
      Caption         =   "&Options"
      Begin VB.Menu mnuBestSave 
         Caption         =   "&Best Save"
      End
      Begin VB.Menu mnuVertInterp 
         Caption         =   "&Vertical Interpolation"
      End
   End
   Begin VB.Menu mnuTuner 
      Caption         =   "&Tuner"
      Begin VB.Menu mnuCATV 
         Caption         =   "&CATV"
      End
      Begin VB.Menu mnuChannelUp 
         Caption         =   "Channel &Up"
      End
      Begin VB.Menu mnuChannelDown 
         Caption         =   "Channel &Down"
      End
   End
   Begin VB.Menu mnuAlign 
      Caption         =   "&Align"
      Begin VB.Menu mnuAlignColor 
         Caption         =   "&Color..."
      End
      Begin VB.Menu mnuAlignVideo 
         Caption         =   "&Video..."
      End
   End
End
Attribute VB_Name = "WinTV"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Dim HW_Init  As Integer

Dim Save_Top As Long, Save_Left As Long
Dim WinPos As Point_Type

Dim Channel As Integer

Dim Region As Integer

Private Sub Form_Load()
Dim SaveTitle$
    If App.PrevInstance Then
        SaveTitle$ = App.Title
        App.Title = "... duplicate instance."
        WinTV.Caption = "... duplicate instance."
        AppActivate SaveTitle$
        SendKeys "% R", True
        End
     End If
    HW_Init = False
    If PCV_Initialize() <= 0 Then
        MsgBox "WinTV Card Initilization Error" + Chr$(13) + "Error Code = " + Str$(WTV_GetErrorCode()), 16
        Unload WinTV
        Exit Sub
    End If
    
    HW_Init = True

    Call WTV_SetSVideo(0)
    Call PCV_SetVideoSource(2)    ' Set Video Source to Tuner
    Call WTV_SetAudio(SOURCE, 2)  ' Set Audio Source to Tuner

    Channel = WTV_GetTunerChannel()
    Region = (Channel \ 256) And 255
    Channel = Channel And 255
    L_Channel.Caption = Format$(Channel)

End Sub

Private Sub Form_Resize()
    Save_Top = TOP
    Save_Left = Left
    WinPos.x = 0
    WinPos.y = 0
    Call ClientToScreen(hwnd, WinPos)
'   ScaleMode = 3
    Call PCV_CreateWindow(WinPos.x, WinPos.y, ScaleWidth, ScaleHeight, 1)
End Sub

Private Sub Form_Unload(Cancel As Integer)
    If HW_Init Then
        Call WTV_Exit(1)      ' Exit 0 = No Save / 1 = Save
    End If
    End
End Sub

Private Sub mnuAlignColor_Click()
  WTVacc_AdjustColors (hwnd)
End Sub

Private Sub mnuAlignVideo_Click()
  WTVacc_AlignVideo (hwnd)
End Sub

Private Sub mnuBestSave_Click()
    mnuBestSave.Checked = Not mnuBestSave.Checked
End Sub

Private Sub mnuCATV_Click()
  mnuCATV.Checked = Not mnuCATV.Checked
  If mnuCATV.Checked Then
      Region = US_CATV
  Else
      Region = USA
  End If
End Sub

Private Sub mnuChannelDown_Click()
  Dim chnl%, s%

  chnl = Channel
  Do
    chnl = chnl - 1
    s = WTV_SetTunerChannel(Region, chnl, 0, 0)
    Select Case s
      Case CHANNEL_OK
        Channel = chnl
        L_Channel.Caption = Format$(Channel)
        Exit Sub
      Case CHANNEL_LOW
        chnl = 256
    End Select
  Loop
End Sub

Private Sub mnuChannelUp_Click()
  Dim chnl%, s%

  chnl = Channel
  Do
    chnl = chnl + 1
    s = WTV_SetTunerChannel(Region, chnl, 0, 0)
    Select Case s
      Case CHANNEL_OK
        Channel = chnl
        L_Channel.Caption = Format$(Channel)
        Exit Sub
      Case CHANNEL_HIGH
        chnl = -1
    End Select
  Loop
End Sub

Private Sub mnuExit_Click()
  Unload WinTV
End Sub

Private Sub mnusaveimage_Click()
    Dim i As Integer
    Dim msg As String

    Screen.MousePointer = 11
    If mnuBestSave.Checked Then
        WTV_SetFreezeResolution ScaleWidth, ScaleHeight, &H3
    End If
    i = PCV_FreezeVideo()
    
    i = PCV_SaveImageRect("test.bmp", 0, 0, ScaleWidth, ScaleHeight, 1, 0)
    Select Case i
    Case 0: msg = "ERROR 0: Error Reading the Video Buffer."
        MsgBox msg
    Case -1: msg = "ERROR -1: File Creation error."
        MsgBox msg
    Case -2: msg = "ERROR -2: Memory allocation error."
        MsgBox msg
    Case -3: msg = "ERROR -3: File Write error."
        MsgBox msg
    End Select
    
    PCV_UnFreezeVideo
    Screen.MousePointer = 0
End Sub

Private Sub mnuVertInterp_Click()
    mnuVertInterp.Checked = Not mnuVertInterp.Checked
    WTV_SetVerticalInterpolation (mnuVertInterp.Checked)
End Sub

Private Sub Move_Timer_Timer()
  Dim ret&
    If (Save_Top <> TOP) Or (Save_Left <> Left) Then
        WinPos.x = 0
        WinPos.y = 0
        ret = ClientToScreen(hwnd, WinPos)
        Call PCV_SetWindowPosition(WinPos.x, WinPos.y)
    End If
    
    WTV_CheckQFactor

End Sub

