/************************************************************************
* Program:	PCVIDEO.DLL						*
* Module:	WINTV.H							*
* Description:	Externally Callable Win/TV routines and associated	*
*		constants						*
* Version:	3.3							*
*									*
*   History:								*
*		6/08/94  jas  Changes for DOSLIB:			*
*									*
* Copyright (C) Hauppauge Computer Works, Inc. 1991, 1992, 1993, 1994	*
************************************************************************/

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif	/* __cplusplus */

#ifdef DOSLIB

#define FAR		    _far
#define PASCAL		    _pascal

typedef int		    BOOL;

typedef unsigned char	    BYTE;
typedef unsigned int	    WORD;
typedef unsigned long	    DWORD;


typedef char FAR	    *LPSTR;

typedef DWORD		    COLORREF;

typedef BYTE FAR*	    LPBYTE;
typedef WORD FAR*	    LPWORD;

#ifndef RECT

typedef struct tagRECT
  {
    int 	left;
    int 	top;
    int 	right;
    int 	bottom;
  } RECT;

#endif

#endif

#define	EXPORT		FAR

typedef	LPSTR		FPSTR;

typedef int		    BOOL;
typedef unsigned char	    BYTE;

#ifdef JAMESPORT
void EXPORT PASCAL PCV_CreateWindowExt(HWND, WORD, WORD, WORD, WORD, BOOL);
#else
void EXPORT PASCAL PCV_CreateWindow(WORD,WORD,WORD,WORD,BOOL);
#endif
void EXPORT PASCAL PCV_SetWindowPosition(WORD,WORD);
void EXPORT PASCAL PCV_SetWindowSize(WORD,WORD,BOOL);
void EXPORT PASCAL PCV_SetVideoScaling(WORD,WORD,BOOL);
void EXPORT PASCAL PCV_SetCaptureAddress(WORD,WORD);
void EXPORT PASCAL PCV_SetDisplayWindow(WORD,WORD,WORD,WORD);
void EXPORT PASCAL PCV_SetAcquisitionWindow(WORD,WORD,WORD,WORD);
void EXPORT PASCAL PCV_PanWindow(WORD,WORD);
void EXPORT PASCAL PCV_SetColorKey(WORD);
BOOL EXPORT PASCAL PCV_FreezeVideo(void);
void EXPORT PASCAL PCV_UnFreezeVideo(void);
void EXPORT PASCAL PCV_SetWriteProtectMask(DWORD);
void EXPORT PASCAL PCV_EnableVideo(void);
void EXPORT PASCAL PCV_DisableVideo(void);
int  EXPORT PASCAL PCV_SaveImageRect(LPSTR,WORD,WORD,WORD,WORD,WORD,WORD);
int  EXPORT PASCAL PCV_LoadImageRect(LPSTR,WORD,WORD);

int  EXPORT PASCAL PCV_LoadImageInRect(LPSTR,RECT);

#ifndef DOSLIB
int  EXPORT PASCAL PCV_SaveClipboardFormat(HWND,WORD,WORD,WORD,WORD,WORD,WORD);
int  EXPORT PASCAL PCV_LoadClipboardFormat(HWND,WORD,WORD);
#endif

int  EXPORT PASCAL PCV_ReadImageRect(FPSTR,WORD,WORD,WORD,WORD,WORD,char far *);
int  EXPORT PASCAL PCV_WriteImageRect(FPSTR,FPSTR,WORD,WORD,WORD,WORD,WORD);

WORD EXPORT PASCAL PCV_GetInputFormat(void);
void EXPORT PASCAL PCV_SetInputFormat(WORD);
void EXPORT PASCAL PCV_SetColor(WORD,BYTE);
BYTE EXPORT PASCAL PCV_GetColor(WORD);
void EXPORT PASCAL PCV_ResetColors(void);
int  EXPORT PASCAL PCV_ClearVideoRect(WORD,WORD,WORD,WORD);
int  EXPORT PASCAL PCV_LoadConfiguration(void);
int  EXPORT PASCAL PCV_SaveConfiguration(void);
WORD EXPORT PASCAL PCV_GetPortAddress(void);
BOOL EXPORT PASCAL PCV_SetPortAddress(WORD);
WORD EXPORT PASCAL PCV_GetVideoAddress(void);
BOOL EXPORT PASCAL PCV_SetVideoAddress(WORD);
WORD EXPORT PASCAL PCV_GetVideoSource(void);
void EXPORT PASCAL PCV_SetVideoSource(WORD);
WORD EXPORT PASCAL PCV_GetSkewFactor(WORD);
BOOL EXPORT PASCAL PCV_SetSkewFactor(WORD,WORD);
void EXPORT PASCAL PCV_ResetSkewFactors(void);
WORD EXPORT PASCAL PCV_GetSystemMetrics(WORD);
void EXPORT PASCAL PCV_EnableInterlace(void);
void EXPORT PASCAL PCV_DisableInterlace(void);
void EXPORT PASCAL PCV_HorizontalZoom(int);
void EXPORT PASCAL PCV_VerticalZoom(int);
void EXPORT PASCAL PCV_EnableFieldReplication(void);
void EXPORT PASCAL PCV_DisableFieldReplication(void);
BYTE EXPORT PASCAL PCV_SetRegister(WORD,BYTE);
BYTE EXPORT PASCAL PCV_GetRegister(WORD);
int  EXPORT PASCAL PCV_Initialize(void);
void EXPORT PASCAL PCV_Exit(void);
void EXPORT PASCAL PCV_WaitVGARetrace(void);
void EXPORT PASCAL PCV_EnableColorKey(void);
void EXPORT PASCAL PCV_DisableColorKey(void);
#ifdef WIN32
int EXPORT PASCAL PCV_GetProfileInt(LPSTR,LPSTR);
#else
WORD EXPORT PASCAL PCV_GetProfileInt(LPSTR,LPSTR);
#endif
int  EXPORT PASCAL PCV_GetProfileString(LPSTR,LPSTR,LPSTR,int);
void EXPORT PASCAL PCV_SetVideoMode(WORD);
WORD EXPORT PASCAL PCV_GetIRQUsed(WORD);
#if VXP500
void EXPORT PASCAL PCV_DrawWindow(WORD, WORD, WORD, WORD, WORD, WORD, WORD, WORD, WORD );
#else
void EXPORT PASCAL PCV_DrawWindow(WORD, WORD, WORD, WORD, WORD, WORD, WORD, WORD, WORD, WORD, WORD, WORD );
#endif


/* Video Mode Flag spec */
#define	FIT_VIDEO	0x0000		/* Scale video to fit in capture buffer */
#define CROP_VIDEO	0x0001		/* Crop video */

#define CAPTURE_BUFFER_WIDTH    1024    /* Dimensions of the capture */ 
#define CAPTURE_BUFFER_HEIGHT   512     /* buffer in pixels */

/* Color adjustments */
#define BRIGHTNESS	0
#define	SATURATION	1
#define	CONTRAST	2
#define	HUE		3
#define	RED		4
#define	GREEN		5
#define	BLUE		6
#define BW              7


/* System metrics */
#define	SM_VIDEOWIDTH	0
#define	SM_VIDEOHEIGHT	1
#define	SM_XRESOLUTION	2
#define	SM_YRESOLUTION	3
#define	SM_BOARDTYPE	4
#define	SM_VERSION	5
#define	SM_INTERLACE	6
#define	SM_REPLICATE	7
#define	SM_IMAGEWIDTH	8
#define	SM_IMAGEHEIGHT	9
#define	SM_IMAGETYPE	10
#define	SM_BUFFERWIDTH	11		/* HCW JBC 10/19/94 Frame Buffer width	*/
#define	SM_BUFFERHEIGHT	12		/* HCW JBC 10/19/94 Frame Buffer height	*/
#define	SM_CROPLEFT	13
#define	SM_CROPTOP	14
#define SM_SCALERTYPE   15
#define SM_RAMSIZE      16
#define SM_COMPTYPE     17      //Current Frame Buffer Compression Type
#define SM_OS           18      //Operating System ie DOS, NT
#define SM_OSINTERFACE  19      //Operating System Interface ie Win3.1, Win95


/* Video Frame Buffer Compression Types */
#define BCT_other       65535
#define BCT_none        0       //BuffCompression Off
#define BCT_411         1
#define BCT_422         2


/* Video board types */
#define	BT_YUV411	0
#define	BT_YUV422	5


/* Scaler Types returned by PCV_GetSystemMetrics( SM_SCALERTYPE ) */

#define ST_CT9001       1
#define ST_VXP500       2
#define ST_VXP501FAMILY 3


/*
** Operating System Types returned by PCV_GetSystemMetrics( SM_OS )
** Note that these DO NOT indicate a particular Version 
*/
#define OS_OTHER        0
#define OS_DOS          1
#define OS_NT           2
#define OS_OS2          3


/*
** Operating System Types returned by PCV_GetSystemMetrics( SM_OSINTERFACE )
** Note that these may or may not indicate a version as appropriate. 
*/
#define IFACE_OTHER     0
#define IFACE_WIN       1       //Windows (other than detailed below)
#define IFACE_OS2       2       //OS2
#define IFACE_WIN3      3       //Windows 3.x
#define IFACE_WIN95     95      //Windows 95



/* Bitmap types */
#define BM_MASK		0xFF
#define	BM_DIB24	0		/* Windows DIB 24 bit true color */
#define	BM_DIB8P	1		/* Windows DIB 8 bit palettized */
#define	BM_DIB8G	2		/* Windows DIB 8 bit gray-scale */
#define	BM_DIB4D	3		/* Windows DIB 4 bit dithered */
#define	BM_TRG32	4		/* Targa 32 bit true color */
#define	BM_TRG24	5		/* Targa 24 bit true color */
#define	BM_TRG16	6		/* Targa 16 bit true color */
#define	BM_YUV411	7		/* IBM MMotion format 4:1:1 YUV */
#define	BM_TIFF24	8		/* TIFF 24 bit true color */
#define	BM_TIFF8P	9		/* TIFF 8 bit palettized */
#define	BM_TIFF8G	10		/* TIFF 8 bit gray-scale */
#define	BM_PCX8P	11		/* PCX 8 bit palettized */
#define	BM_PCX8G	12		/* PCX 8 bit gray-scale */
#define	BM_PCX4D	13		/* PCX 4 bit dithered */
#define BM_GIF8P        14              // GIF 8 bit palettized
#define BM_GIF8G        15              // GIF 8 bit gray-scale
#define BM_JPEG         16              // JPEG compressed 4:2:2 YUV
#define BM_DIB1P        17              // BMP monochrome
#define BM_DIB4P        18              // BMP 16 colors palettized

/* Clipboard data types */
#define CLP_MASK	0xF000
#define CLP_BITMAP	0x1000
#define CLP_DIB		0x2000

#define NO_COLOR_SETTINGS 8		/* Available color controls */
#define NO_COLOR_CONTROLS 8		/* Actual number of color controls */
#define	NO_CAPTURE_COLOR_CONTROLS 8
#define NO_SKEW_FACTORS	9		/* Number of skew factors */

/* Skew adjustment IDs */
#define	SF_DISPWINSKEWX		0	/* Display Window X Skew */
#define	SF_DISPWINSKEWY		1	/* Display Window Y Skew */
#define	SF_DISPADDRSKEWX	2	/* Display Address X Skew */
#define	SF_DISPADDRSKEWY	3	/* Display Address Y Skew */
#define	SF_SHIFTCLOCKSTART	4	/* Shift Clock Start */
#define	SF_PALETTESKEW		5	/* Palette Skew */
#define	SF_DISPLAYWIDTH		6	/* Display Width (Horizontal Total) */
#define	SF_PLLVCOGAIN		7	/* PLL VCOGain */
#define	SF_PLLPHDETGAIN		8	/* PLL PHDetGain */
#define SF_PLLN1                9       /* PLL N1 */
#define SF_PLLP2               10       /* PLL P2 */

/* Skew adjustment ranges */
#define	DISPWINSKEWXRANGE	0x7FF	/* Display Window X Skew Range */
#define	DISPWINSKEWYRANGE	0x7FF	/* Display Window Y Skew Range */
#define	DISPADDRSKEWXRANGE	0x3FF	/* Display Address X Skew Range */
#define	DISPADDRSKEWYRANGE	0x3FF	/* Display Address Y Skew Range */
#define	SHIFTCLOCKSTARTRANGE	0x7F	/* Shift Clock Start Range */
#define	PALETTESKEWRANGE	0x09	/* Palette Skew Range */
#define	DISPWIDTHRANGE		0x7FF	/* Display Width Range */
#define	PLLVCOGAINRANGE		0x3
#define	PLLPHDETGAINRANGE	0x3

int  EXPORT PASCAL WTV_LoadConfiguration(void);

WORD EXPORT PASCAL WTV_HWOptions(void);

/*	H/W Options		*/

#define	HW_TunerPresent		0x0001
#define	HW_SECAMPresent		0x0002
#define	HW_AudioPresent		0x0004
#define	HW_TeletextPresent	0x0008
#define	HW_SVideoPresent	0x0010
#define HW_External2            0x0020
#define HW_RAMAccess		0x8000


void EXPORT PASCAL WTV_SetDAC(BYTE,BYTE);
WORD EXPORT PASCAL WTV_GetDAC(BYTE);
void EXPORT PASCAL WTV_ResetDAC(void);

/*	DAC Parameters		*/

#define	NO_DAC_SETTINGS		8

#define	DAC_RED_CUTOFF		0
#define	DAC_GREEN_CUTOFF	1
#define	DAC_BLUE_CUTOFF		2
#define	DAC_SAA9060_CTRL1	3
#define	DAC_SAA9060_CTRL0	4
#define	DAC_IBIAS		5
#define	DAC_SEPARATION		6


void EXPORT PASCAL WTV_SetAudio(BYTE,BYTE);
WORD EXPORT PASCAL WTV_GetAudio(BYTE);
WORD EXPORT PASCAL WTV_AudioOptions(void);
void EXPORT PASCAL WTV_ResetAudio(void);


/* Audio Options		*/
#define	AUDIO_HAS_VOLUME		0x0001
#define	AUDIO_HAS_BALANCE		0x0002
#define	AUDIO_HAS_BASS			0x0004
#define	AUDIO_HAS_TREBLE		0x0008
#define	AUDIO_HAS_SEPARATION	        0x0010
#define	AUDIO_HAS_SOURCE		0x0020
#define	AUDIO_HAS_MUTE			0x0040
#define	AUDIO_HAS_LOUDNESS		0x0080
#define	AUDIO_HAS_STEREO		0x0100
#define	AUDIO_HAS_DUALMONO		0x0200


/*	Audio Parameters	*/
#define	VOLUME		0
#define BALANCE		1
#define BASS		2
#define TREBLE		3
#define SEPERATION	4
#define SEPARATION	4
#define SOURCE		5
#define MUTE		6
#define DUALMONO	7
#define LOUDNESS	8
#define	AUDIO_VOLUME		0
#define AUDIO_BALANCE		1
#define AUDIO_BASS		2
#define AUDIO_TREBLE		3
#define AUDIO_SEPARATION	4
#define AUDIO_SOURCE		5
#define AUDIO_MUTE		6
#define AUDIO_DUALMONO	        7
#define AUDIO_LOUDNESS	        8
#define AUDIO_AUTOMUTE          9
#define	NO_AUDIO_SETTINGS	10

/* Audio Paramater Settings */
#define AUDIO_SOURCE_Ext1	0
#define AUDIO_SOURCE_Ext2	1
#define AUDIO_SOURCE_Tuner      2
#define AUDIO_MUTE_OFF		0
#define AUDIO_MUTE_ON		1
#define AUDIO_MUTE_FORCED       2       /* Forced Mute under program control */
#define AUDIO_DUALMONO_OFF	0
#define AUDIO_DUALMONO_ON 	1
#define AUDIO_LOUDNESS_OFF	0
#define AUDIO_LOUDNESS_ON 	1
#define AUDIO_AUTOMUTE_OFF	0
#define AUDIO_AUTOMUTE_ON 	1


void EXPORT PASCAL WTV_Exit(BYTE);
DWORD EXPORT PASCAL WTV_GetVersion(void);
COLORREF EXPORT PASCAL WTV_GetKeyColor(void);
WORD EXPORT PASCAL WTV_GetKeyColorIndex(void);


WORD EXPORT PASCAL WTV_GetTunerType(void);
void EXPORT PASCAL WTV_SetTunerType(BYTE);

/*	Tuner Types	*/
#define TUNER_TYPE_MN           0
#define TUNER_TYPE_BG           1
#define TUNER_TYPE_I            2
#define TUNER_TYPE_BGL          3
#define TUNER_TYPE_DK           4
#define TUNER_TYPE_UNKNOWN      ((BYTE)-1)


WORD EXPORT PASCAL WTV_GetTunerChannel(void);
WORD EXPORT PASCAL WTV_SetTunerChannel(WORD,WORD,int,WORD);


/*	Tuner Frequency Sets for use with WTV_SetTunerChannel	*/

#define	USA		0
#define	US_CATV		1

#define	CCIR		2	/* Western Europe	*/
#define	CCIR_CATV	3	/* Western Europe	*/

#define AUSTRILIA	4	/* Austrilia		*/

#define	JAPAN		5	/* Japan		*/
#define	JAPAN_CATV	6	/* Japan		*/

#define	US_HRC		7	/* US CATV HRC		*/

#define UK_CATV         8       /* UK CATV              */

#define FRANCE          9       /* France               */
#define FRANCE_CATV     10      /* French CATV          */

#define CHINA			11		/* China	*/

#define ALL             12      /* Direct access to freq for Scan All   */



/*	WTV_SetTunerChannel Options Values	*/

#define	TUNER_NOMUTE		0x01
#define	TUNER_NOWAITTUNER	0x02
#define	TUNER_NOWAITSIGNAL	0x04


/*	WTV_SetTuner_Channel return codes	*/
#define NO_TUNER_TYPE           ( (WORD) -1 )
#define	CHANNEL_OK		0
#define	CHANNEL_LOW		1
#define	CHANNEL_HIGH	        2
#define	CHANNEL_SKIP	        3



void EXPORT PASCAL WTV_SetSVideo(BYTE);
WORD EXPORT PASCAL WTV_GetSVideo(void);

WORD EXPORT PASCAL WTV_GetErrorCode(void);


/*	Error Codes	*/

#define	E_DRIVER	1
#define	E_NOTPRESENT	2
#define E_WIDTH		3
#define E_HEIGHT	4
#define E_INIFILE	5
#define E_BOARDTYPE	6
#define	E_WINTV		7
#define	E_NOVGACLK	8
#define	E_NODECCLK	9


/* Input Formats */

#define	PAL_BGHI	0	 //includes DK
#define	NTSC_M		1
#define	SECAM		2
#define	PAL_M		3
#define	PAL_N		4
#define	NTSC_443	5
#define EXTERNAL_SRC	6


#ifndef DOSLIB
WORD EXPORT PASCAL WTV_GetFrameBufferSelector(void);
#endif

int EXPORT PASCAL WTV_GetImageData(LPSTR,WORD,WORD,WORD,WORD);

void EXPORT PASCAL WTV_SetYUVScaleFactor(BYTE,WORD);
WORD EXPORT PASCAL WTV_GetYUVScaleFactor(BYTE);

/*	YUV Scale Factors	*/

#define NO_YUVSCALEFACTORS	6

#define	Y_SCALE_FACTOR	0
#define	U_SCALE_FACTOR	1
#define	V_SCALE_FACTOR	2

BOOL FAR PASCAL WTV_WriteProfileString(LPSTR,LPSTR,LPSTR);
BOOL FAR PASCAL WTV_WriteProfileInt(LPSTR,LPSTR,int);

void EXPORT PASCAL WTV_SetHighResMode(DWORD,int);

/* High Res Mode Flags	*/

#define	HRF_HICOLOR2X	0x0001
#define	HRF_LT60HZ	0x0002
#define HRF_INTDIV	0x0004

#define HRF_HW_RESOLUTION	0x2000	/* Use H/W reg resolution in place
						of driver specified resolution
					 */

#define HRF_FORCE_INTERLACE	0x4000
#define HRF_INTERLACE_ON	0x0000
#define HRF_INTERLACE_OFF	0x8000



DWORD EXPORT PASCAL WTV_GetModeInfo(int);

/*	GetModeInfo	*/

#define	MI_VIDEOMODE	0
#define	MI_VGAWIDTH	1
#define MI_VGAHEIGHT	2
#define	MI_MODEFLAGS	3
#define	MI_HIGHRES	4
#define	MI_HIGHRESFLAGS	5
#define MI_FCSL         6       //Feature Connector or SmartLock ??
        #define MI_FCSL_FC      0       // rc for Feature Connector
        #define MI_FCSL_SL      1       // rc for SmartLock


/*	Attributes	*/

#define		TEXTMODE	0x0000
#define		GRAPHICSMODE	0x0010



/*      VGA Queries     */
#ifdef DOSLIB
        #define VGAINFO_INITED  0
#endif
#define VGAINFO_WIDTH           1
#define VGAINFO_HEIGHT          2
#define VGAINFO_MONCONFIG       3       //single, dual, etc.
#define VGAINFO_ATTRIBUTES      4
#define VGAINFO_BITSPERPIXEL    5
#define VGAINFO_NUMCOLORS       6
#define VGAINFO_VIDEOMODE       7

#define VGAINFO_MON_SINGLE      0x01
#define VGAINFO_MON_DUALWIDE    0x02
#define VGAINFO_MON_THREEWIDE   0x03
#define VGAINFO_MON_FOURWIDE    0x04
#define VGAINFO_MON_ONEHIGH	   0x81	
#define VGAINFO_MON_DUALHIGH    0x82
#define VGAINFO_MON_THREEHIGH   0x83
#define VGAINFO_MON_FOURHIGH	   0x84
#define VGAINFO_MON_USERDEFINED 0xFF


WORD EXPORT PASCAL WTV_GetVGAInfo(WORD);

BYTE EXPORT PASCAL WTV_WriteI2C(BYTE,BYTE,int,BYTE FAR *);
BYTE EXPORT PASCAL WTV_ReadI2C(BYTE,int,BYTE FAR *);

WORD EXPORT PASCAL WTV_GetBoardType(void);

/* Board Types */

#define	BT_WINTV                1
#define	BT_WINTVCELEBRITY	2
#define	BT_WINTVCINEMA		3
#define	BT_WINTVCINEMA202	4
#define BT_WINTVSOUTHOLD        5
#define BT_WINTVGREENPORT	6
#define BT_WINTVJAMESPORT	7
#define BT_WINTVCINEMA501       8

WORD EXPORT PASCAL WTV_GetStatus(WORD);

#define	GS_VIDEOSIGNAL	0	/* Get Video Signal Status TRUE = Valid Video	*/
#define	GS_TUNED	1	/* Get Tuner Status TRUE = Tuner PLL Locked	*/
#define GS_INIT		2	/* Get Initialization Status (True if PCV_Initialize already called	*/

BYTE EXPORT PASCAL WTV_GetCaptureColor(WORD);
void EXPORT PASCAL WTV_SetCaptureColor(WORD,BYTE);
void EXPORT PASCAL WTV_ResetCaptureColors(void);

void EXPORT PASCAL PCV_UpdateVideoWindow(void);

void EXPORT PASCAL	WTV_SetFreezeResolution( WORD, WORD, WORD );


#define	FM_BESTSAVE	0x01
#define	FM_Q100		0x02
#define	FM_NODISABLE	0x04


BOOL EXPORT PASCAL WTV_GetVerticalInterpolation( void );
void EXPORT PASCAL WTV_SetVerticalInterpolation( BOOL );

void EXPORT PASCAL WTV_CheckQFactor( void );

#ifndef	DOSLIB
BOOL FAR PASCAL WTV_PrintImage( HDC, WORD, WORD, WORD, WORD, WORD, WORD, WORD, WORD, WORD);	

/*	WTV_PrintImage Flags bits	*/

#define	PI_FASTPRINT	0x8000


HGLOBAL	FAR PASCAL WTV_CreateDIB( WORD, WORD, WORD, WORD, WORD, WORD );
#endif





/*
** Video Out
*/
#define VO_FILTER       1
#define VO_WIDTH        2
#define VO_FORMAT       3
WORD EXPORT PASCAL WTV_GetVideoOut(WORD);
WORD EXPORT PASCAL WTV_SetVideoOut(WORD, WORD);



/*
** Video Sources
*/
#define VIDEO_SOURCE_Ext1	0
#define VIDEO_SOURCE_Ext2	1
#define VIDEO_SOURCE_Tuner      2


/*
** HAL_GetDisplayViewport[Width][Height] units of measure
*/
#define GDV_RAW         0
#define GDV_PIXELS      1
#define GDV_LINES       2
#define GDV_BYTES       3
//#define GDV_MEMCYCLES   4



/*
** HAL_MeasureFrequency parameter constants.
** NOTE that these values are NOT arbitrary.
** HAL_MeasureFrequency uses these values in logical operations
** and bit shifts.  They must not be changed without reviewing
** the routine's use of them.
*/
#define MF_VOUT        0x00
#define MF_VGA         MF_VOUT
#define MF_VIN         0x01
#define MF_DECODER     MF_VIN



#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif	/* __cplusplus */








