/*
 * vga_line - Draw line from current point to given point
 *
 * 11/18/90 - Copyright (c) 1990, Hauppauge Computer Works
 *
 * Uses Bresanham algorithm
 */

#include "vgadefs.h"

vga_line(x2, y2)
register int x2, y2;
{
	register int x1, y1, x, y, d;
	register int incr1, incr2;
	register int end;
	register color_t *rp;
	register int dx, dy;
	register int slopesgn;
	register color_t cval;
	register int rop;

	x1 = _FB_XPOS;
	y1 = _FB_YPOS;
	_FB_XPOS = x2;
	_FB_YPOS = y2;
	cval = _FB_COLOR;
	rop = _FB_ROP;
#ifdef DEBUG
	fprintf(stderr, "Line from: (%d,%d) -> (%d,%d)  ", x1,y1,x2,y2);
	fprintf(stderr, "Slope=%f\n", (double)(y2-y1)/(double)(x2-x1));
#endif
	slopesgn = 1;
	dx = x2 - x1;
	dy = y2 - y1;
	if(dx < 0){
		dx = -dx;
		if(dy != 0)
			slopesgn = -1;
	}
	if(dy < 0){
		dy = -dy;
		if(dx != 0)
			slopesgn *= -1;
	}
	if(dy > dx){
		/* Slope > 1 */
#ifdef DEBUG
		fprintf(stderr, "Slope is >1\n");
#endif
		incr1 = 2*dx;
		d = 2*dx - dy;
		incr2 = 2*(dx - dy);
		if(y1 > y2){
			x = x2;
			y = y2;
			end = y1;
		} else {
			x = x1;
			y = y1;
			end = y2;
		}
		rp = VRAM + y*HSIZE;
		rp += x;
		switch(rop){
		case ROP_STORE:
			*rp = cval;
			break;
		case ROP_OR:
			*rp |= cval;
			break;
		case ROP_XOR:
			*rp ^= cval;
			break;
		case ROP_CLEAR:
			*rp &= ~cval;
			break;
		}
		if(slopesgn < 0){
#ifdef DEBUG
			fprintf(stderr, "Slope is also negative\n");
#endif
			while(y < end){
				y++;
				rp += HSIZE;
				if(d < 0){
					d += incr1;
				} else {
					x--;
					rp--;
					d += incr2;
				}
				switch(rop){
				case ROP_STORE:
					*rp = cval;
					break;
				case ROP_OR:
					*rp |= cval;
					break;
				case ROP_XOR:
					*rp ^= cval;
					break;
				case ROP_CLEAR:
					*rp &= ~cval;
					break;
				}
			}
		} else {
#ifdef DEBUG
			fprintf(stderr, "Slope is positive\n");
#endif
			while(y < end){
				y++;
				rp += HSIZE;
				if(d < 0){
					d += incr1;
				} else {
					x++;
					rp++;
					d += incr2;
				}
				switch(rop){
				case ROP_STORE:
					*rp = cval;
					break;
				case ROP_OR:
					*rp |= cval;
					break;
				case ROP_XOR:
					*rp ^= cval;
					break;
				case ROP_CLEAR:
					*rp &= ~cval;
					break;
				}
			}
		}
		return;
	}
#ifdef DEBUG
	fprintf(stderr, "Slope <1/2\n");
#endif
	incr1 = 2*dy;
	d = incr1 - dx;
	incr2 = 2*(dy - dx);
	if(x1 > x2){
		x = x2;
		y = y2;
		end = x1;
	} else {
		x = x1;
		y = y1;
		end = x2;
	}
	rp = VRAM + y*HSIZE;
	rp += x;
	switch(rop){
	case ROP_STORE:
		*rp = cval;
		break;
	case ROP_OR:
		*rp |= cval;
		break;
	case ROP_XOR:
		*rp ^= cval;
		break;
	case ROP_CLEAR:
		*rp &= ~cval;
		break;
	}
	if(slopesgn < 0){
#ifdef DEBUG
		fprintf(stderr, "Slope is negative\n");
#endif
		while(x < end){
			x++;
			rp++;
			if (d < 0)
				d += incr1;
			else {
				y--;
				rp -= HSIZE;
				d += incr2;
			}
			switch(rop){
			case ROP_STORE:
				*rp = cval;
				break;
			case ROP_OR:
				*rp |= cval;
				break;
			case ROP_XOR:
				*rp ^= cval;
				break;
			case ROP_CLEAR:
				*rp &= ~cval;
				break;
			}
		}
	} else {
#ifdef DEBUG
		fprintf(stderr, "Slope is positive\n");
#endif
		while(x < end){
			x++;
			rp++;
			if(d < 0)
				d += incr1;
			else {
				y++;
				rp += HSIZE;
				d += incr2;
			}
			switch(rop){
			case ROP_STORE:
				*rp = cval;
				break;
			case ROP_OR:
				*rp |= cval;
				break;
			case ROP_XOR:
				*rp ^= cval;
				break;
			case ROP_CLEAR:
				*rp &= ~cval;
				break;
			}
		}
	}
}
