

/*
 * vga_color - set current color
 *
 * 11/18/90 - Copyright (c) 1990, Hauppauge Computer Works
 *
 */
#include "vgadefs.h"

vga_color(cval)
color_t	cval;
{
	if(cval >= _FB_CMAPSIZE)
		return(-1);
	_FB_COLOR = cval;
	return(0);
}

vga_set_color_map(nval, startval, fcp)
register int nval, startval;
register color_map_t *fcp;
{
	register struct cmap *p1, *p2;
	register int n, i, j, nc, c;
	extern struct cmap cmap[];
	register struct cmap *pp, *cp;

	/*
	 * See how many slots we need
	 */
	n = nval + startval;
	if(n > _FB_CMAPSIZE || _FB_CMAP == _FB_DEF_CMAP){
		/* Allocate new color map, copy old values */
		cp = (struct cmap *)malloc(n * (sizeof (struct cmap)));
		if(cp == (struct cmap *)0)
			return(-1);
		nc = _FB_CMAPSIZE;
		for(p1 = cp, p2 = _FB_CMAP, i = 0; i < nc; i++){
			*p1++ = *p2++;
		}
		for(; i < n; i++, p1++){
			p1->c_red = p1->c_green = p1->c_blue = 0;
		}
		if(_FB_CMAP != _FB_DEF_CMAP){
			free(_FB_CMAP);
		}
		_FB_CMAP = cp;
		_FB_CMAPSIZE = n;
	}
	for(p1 = _FB_CMAP + startval, i = 0; i < nval; i++){
		j = fcp->c_red * 63.0;
		if(j < 0)
			j = 0;
		else if(j > 63)
			j = 63;
		p1->c_red = j;
		j = fcp->c_green * 63.0;
		if(j < 0)
			j = 0;
		else	if(j > 63)
			j = 63;
		p1->c_green = j;
		j = fcp->c_blue * 63.0;
		if(j < 0)
			j = 0;
		else	if(j > 63)
			j = 63;
		p1->c_blue = j;
		p1++;
		fcp++;
	}
	new_colreg(_FB_CMAP, 256);
	return(0);
}
