#include <stdio.h>
#include "..\fblib\fb.h"


main(argc, argv)
char **argv;
{
	register int ns, x, y, c, xl, yl;

	ns = 32;
	while(--argc > 0){
		argv++;
		if(**argv != '-')
			break;
		switch((int)(argv[0][1])){
		case 'n':
			if(argc > 1){
				argv++;
				argc--;
				ns = atoi(*argv);
			}
			break;

		default:
			fprintf(stderr, "Usage: rect [-n nrects]\n");
			exit(1);
		}
	}
	fb_init();
	do_cmap();
	fb_clear_screen();

	while(ns-- > 0){
		x = (rand() % 1000);
		y = (rand() % 800);
		xl = (rand() % (1152-x));
		yl = (rand() % (900-y));
		c = ((rand()>>2)%384) + 2;
		fb_color(c);
		fb_rect(x, y, xl, yl);
	}
	exit(0);
}

color_map_t clist[386];

do_cmap()
{
	long si;
	short n_ent, i, ci, cd;

	/* Make a color wheel
	 * Color index 0 is always black
	 * Color index 1 is always white
	 */

	clist[0].c_red = clist[0].c_green = clist[0].c_blue = 0.0;
	clist[1].c_red = clist[1].c_green = clist[1].c_blue = 1.0;

	/* There are 6 transitions in the color wheel, and 384 colors
	 * to do them in
	 */
	ci = 0;
	cd = 63;
	for(i = 2; i < 64+2; i++, ci++, cd--){
		if(i == 64+2-1){
			ci = 63;
			cd = 0;
		}
		clist[i].c_red = 1.0;
		clist[i].c_green = (float)(ci)/63;
		clist[i].c_blue = 0.0;

		clist[i+64].c_red = (float)(cd)/63.0;
		clist[i+64].c_green = 1.0;
		clist[i+64].c_blue = 0.0;

		clist[i+128].c_red = 0.0;
		clist[i+128].c_green = 1.0;
		clist[i+128].c_blue = (float)(ci)/63.0;

		clist[i+192].c_red = 0.0;
		clist[i+192].c_green = (float)(cd)/63.0;
		clist[i+192].c_blue = 1.0;

		clist[i+256].c_red = (float)(ci)/63.0;
		clist[i+256].c_green = 0.0;
		clist[i+256].c_blue = 1.0;

		clist[i+320].c_red = 1.0;
		clist[i+320].c_green = 0.0;
		clist[i+320].c_blue = (float)(cd)/63.0;
	}
	if(fb_set_color_map(386, 0, clist))
		fprintf(stderr, "error setting map\n");
}


