+----------+
| OVERVIEW |
+----------+

This README describes an OS/2 device driver (GSCDROM.ADD) for the
GoldStar GCD-R420/R400 CD-ROM drive.  The device driver supports
the internal GoldStar GCD-R420/R400 CD-ROM drive.



Supported Features
------------------
The OS/2 GoldStar CD-ROM device driver (GSCDROM.ADD) supports the
following features:

  * Double Speed CD-ROM Drive(R420) / Single Speed CD-ROM Drive(R400)

  * Reads data from CD-ROM discs conforming to the High Sierra/ISO-9660
    file formats.

  * Plays audio from standard audio CDs or mixed mode CD-ROM discs
    containing both data and audio

  * Multisession photo CD

  * Reads data from Mode 2 Form 1 or Mode 2 Form 2 sector formats

  * MMPM/2 Software Motion Video

  * MMPM/2 CD Audio Player

  * Software lock, unlock and eject


THIS CD-ROM DEVICE DRIVER IS DESIGNED TO BE USED WITH THE OS/2 2.1 PRODUCT
AND IS GOVERNED BY THE TERMS AND CONDITIONS OF THE OS/2 PROGRAM LICENSE
AGREEMENT.



GSCDROM.ADD Command Line Options
---------------------------------

   /B:xxx      : base address (Default : 340)
                 (xxx : hexadecimal)
                 (300, 310, 320, ... , 3E0, 3F0)

   /V          : display the identification of drive

   /S:x        : CD-ROM Speed (Only R420)
                 x = 0 : auto mode (Default)
                 x = 1 : single speed

   * example

     BASEDEV=GSCDROM.ADD /B:340 /V /S:1




+--------------+
| INSTALLATION |
+--------------+

The following files are included in the installation diskette:

   GSCDROM.ADD  - OS/2 device driver for GoldStar CD-ROM Drive, GCD-R420/R400
   GSCDROM.DDP  - Installation profile for GCD-R420/R400 adapter
   README.GS    - This README file.




Installation if OS/2 2.1 is already installed on your fixed disk
----------------------------------------------------------------

1. Run the Device Driver installation program

   a. Open the OS/2 System folder on the desktop.
   b. Open the System Setup folder.
   c. Open Device Driver Install.
   d. Insert the "GoldStar CD-ROM Device Driver Diskette"
   e. Change the directory into OS2
   f. Select Install
   g. Select the device driver to install from the list
   h. Select OK.

   (Note: You do not need to reboot OS/2 before starting step 2 below).

2. After the Device Driver Installation is complete, you must run
   Selective Install to install the files for the OS/2 CD-ROM Device
   Manager and OS/2 CD-ROM File System.

   a. Open the OS/2 System folder on the desktop.
   b. Open the System Setup folder.
   c. Open Selective Install
   d. Select the CD-ROM Device Support check box
   e. Select OK
   f. Scroll to the bottom of the CD-ROM device list table and
      select the choice OTHER
   g. Select OK
   h. Select the OK push button to proceed from the System Configuration
      screen to the OS/2 Setup and Installation window
   i. Select Install
   j. When prompted to do so, insert the numbered installation diskettes
      or installation CD-ROM from the OS/2 2.1 product.


3. If you have changed the base I/O port address on your CD-ROM
   host adapter card you must edit your CONFIG.SYS file and add
   modify the /B:nnnn parameter on the BASEDEV=GSCDROM.ADD statement in
   your CONFIG.SYS file.  Refer to the "GoldStar Device Driver Parameters"
   section below.


4. Shut down and restart your system




Installation from the CD-ROM version of OS/2 2.1
------------------------------------------------

1.  Make a copy of the OS/2 2.1 diskette labeled "Diskette 1"

2.  Copy the file GSCDROM.ADD from the "GoldStar CD-ROM Device Driver
    Diskette" to the root directory on the copy of the OS/2 2.1 Diskette 1.

    (Note: If there is not enough room on the copy of OS/2 2.1
     Diskette 1, then delete the file IBM2SCSI.ADD.  If you delete
     IBM2SCSI.ADD, you must also edit the CONFIG.SYS file and delete
     the line BASEDEV=IBM2SCSI.ADD)

3.  Edit the CONFIG.SYS file located on the copy of Diskette 1.
    At the end of the file, add the following statement.

       BASEDEV=GSCDROM.ADD  /B:nnn

          where "/B:nnn" is the base I/O port address selected on the
          CD-ROM host interface card.  The default base I/O port address
          for the GoldStar GCD-R420/R400 interface card is 340h, so the statement
          would appear as follows if the card is set to address 340h:


       BASEDEV=GSCDROM.ADD  /B:340


4.  Begin the installation by inserting the Installation Diskette
    into drive A and restarting the system.  When prompted to insert
    Diskette 1, insert the copy that you modifed.

5.  When the System Configuration screen is displayed during installation,
    the CD-ROM Device Support field will display "None".  Do not modify
    the choice and continue with the installation.

6.  After installation is complete, and you have rebooted your system,
    you will not be able to access your CD-ROM drive.  This is due
    to a defect in the OS/2 2.1 install program.  To access your
    CD-ROM drive, perform the following steps:

    a. Copy the following files from the OS/2 2.1 Diskette 1
       to the drive which OS/2 was installed.
       (Note: the example assume C:, change if different)

       COPY A:OS2CDROM.DMD C:\OS2
       COPY A:CDFS.IFS     C:\OS2

    b. Edit the CONFIG.SYS file on drive which OS/2 was installed
       and add the following statements to the end of the file:
       (Note: the example assume C:, change if different)

       DEVICE=C:\OS2\OS2CDROM.DMD /Q
       IFS=C:\OS2\CDFS.IFS /Q

    c. Shut down and reboot the system


7.  You will need to run Selective Install to copy over some remaining
    system files.

    a. Open the OS/2 System folder on the desktop.
    b. Open the System Setup folder.
    c. Open Selective Install
    d. Select the CD-ROM Device Support check box
    e. Select OK
    f. Scroll to the bottom of the CD-ROM device list table and
       select the choice OTHER
    g. Select OK
    h. Select the OK push button to proceed from the System Configuration
       screen to the OS/2 Setup and Installation window
    i. Select Install
    j. When prompted to do so, insert the installation CD-ROM
       from the OS/2 2.1 product.



Installation from the diskette version of OS/2 2.1
--------------------------------------------------

1. Install the OS/2 2.1 product from the diskettes

2. Go to the section above titled "Installation if OS/2 2.1 is already
   installed on your fixed disk".




+-----------------------------------+
| GoldStar Device Driver Parameters |
+-----------------------------------+

This section lists the parameters which are supported for the
GoldStar CD-ROM device driver.  The parameters can be changed by modifying
the BASEDEV=GSCDROM.ADD line in config.sys.

For the GSCDROM.ADD device driver, the syntax for the line in config.sys
is as follows:

   BASEDEV=GSCDROM.ADD [/B:nnn]

   [/B:nnn]

     Specifies the base I/O port address of the interface card.  The
     port address is specified as a three digit hex value. Leading
     zeros should be NOT specified.  The value must be the same number as
     the port address selected by the jumper on the host interface card.

     If this parameter is not specified, the default port address for the
     host adapter is used.  For the GoldStar GCD-R420/R400 host interface card,
     the default is 340.

     See the section below titled "GoldStar GCD-R420/R400 Host Adapter
     Jumper Settings".


GoldStar GCD-R420/R400 Device Driver Parameter Examples
---------------------------------------------------

1.  GoldStar GCD-R420/R400 CD-ROM drive attached to GoldStar GCD-R420/R400 host adapter:

    The GoldStar GCD-R420/R400 host adapter supports base I/O port addresses of
    320h, 330h, 340h or 360h. If the GCD-R420/R400 host adapter is set to any
    port address other than the default of 340h, the config.sys statement
    needs to be modified. For example, if the GoldStar GCD-R420/R400 host adapter is
    set to a base I/O port address of 360, the line in config.sys should be:

        BASEDEV=GSCDROM.ADD /B:360




GoldStar GCD-R420/R400 Host Adapter Jumper Settings
-----------------------------------------------

The following tables explain the jumper settings for the GCD-R420/R400,

               +---+---+---+---+
        PN801  | o | o | o | o | (default address setting: 340H)
               | o | o | o | o |
               +---+---+---+---+
                 1   2   3   4

                        PN801-1     PN801-2     PN801-3     PN801-4
   ----------------------------------------------------------------
   Base Addr 300H         S           S           S           S
   Base Addr 310H         S           S           S           O
   Base Addr 320H         S           S           O           S
   Base Addr 330H         S           S           O           O
   Base Addr 340H         S           O           S           S
   Base Addr 350H         S           O           S           O
   Base Addr 360H         S           O           O           S
   Base Addr 370H         S           O           O           O
   Base Addr 380H         O           S           S           S
   Base Addr 390H         O           S           S           O
   Base Addr 3A0H         O           S           O           S
   Base Addr 3B0H         O           S           O           O
   Base Addr 3C0H         O           O           S           S
   Base Addr 3D0H         O           O           S           O
   Base Addr 3E0H         O           O           O           S
   Base Addr 3F0H         O           O           O           O
   ----------------------------------------------------------------
   Reference: O = Open, S = Short


+------------------+
| Trouble shooting |
+------------------+

1. If you are not able to access the CD-ROM drive:


   a.  Add the /V parameter switch to the BASEDEV=GSCDROM.ADD statement
       in your CONFIG.SYS file.  For example:

          BASEDEV=GSCDROM.ADD /B:340 /V


       After rebooting, the device driver will display the list of
       drives it has identified.   For example:

         IBM OS/2 GSCDROM.ADD 1.00
         GoldStar CD-ROM GCD-R420 1.00  931001  Port: 340  Units: 0 IRQ: Polled


       If no units were detected, the following message is displayed:

         IBM OS/2 GSCDROM.ADD 1.00
         No units detected.


       If no units were detected, see step 1b below.
       If units were detected, see step 1c below.



   b.  Make sure the Base I/O Port Address specified by the /B parameter
       in the config.sys file matches the Base Port Address selected
       with the DIP switch on the interface card.

       The default Base I/O Port Address for the GoldStar GCD-R420/R400 interface
       card is address 340h.  If you have changed the Base I/O Port Address on
       the card, you must change the /B parameter on the BASEDEV=GSCDROM.ADD
       statement in config.sys.

       For example, if you changed the Base I/O Port Address to 360h, the
       statement in config.sys should be as follows:

           BASEDEV=GSCDROM.ADD /B:360


   c.  Make sure all the required files to operate the CD-ROM drive have
       been installed.  You should have the appropriate BASEDEV=
       statement in CONFIG.SYS for your CD-ROM device driver.  You
       should also have the following statements for the CD-ROM system
       files in your config.sys:


          DEVICE=C:\OS2\OS2CDROM.DMD /Q
          IFS=C:\OS2\CDFS.IFS /Q
          DEVICE=C:\OS2\MDOS\VCDROM.SYS
          BASEDEV=GSCDROM.ADD /B:340


       If you do not have the above statements in your config.sys, you
       must use the OS/2 2.1 Selective Install to install the CD-ROM
       support files.


2.  If the drive letter assigned to the CD-ROM drive under OS/2 is
    different than the drive letter assigned under DOS.

    The CD-ROM drive is assigned the next available drive
    letter after drive letters have been assigned for the
    floppy drives and fixed disk drives.

    The drive letter is also assigned after any installable block
    device drivers which are located in config.sys before the
    DEVICE=C:\OS2\OS2CDROM.DMD statement (i.e. DEVICE=C:\OS2\VDISK.SYS).

    There is currently no mechanism in OS/2 for assigning a specific
    drive letter for the CD-ROM drive.  The drive letter assignment
    under DOS can be controlled by using the /L switch on MSCDEX.EXE
    command line.


+--------------------+
| Reporting Problems |
+--------------------+

Defect reports should include the following information:

  CD-ROM Product ID:
  CD-ROM Firmware Level:
  Device Driver Transfer Mode:
  Host CPU type and speed:      (i.e.  25MZ 486)


The CD-ROM product ID and firmware level can be displayed at
boot time by adding the /V switch to the DEVICE=OS2CDROM.DMD line
in config.sys.  For example, the following line may be displayed at boot
time after the OS/2 logo screen is displayed(case of unit 0):

         IBM OS/2 GSCDROM.ADD 1.00
         0 GOLDSTAR CD-ROM GCD-R420


+-----------------------------+
| TradeMarks and Copyrights   |
+-----------------------------+

IBM(TM) and OS/2(TM) are registered trademarks of International Business
Machines Corporation.

GoldStar(R) is a registered trademarks of GoldStar Corporation.


NOTICE:  The device driver and this file are owned by GoldStar and protected
         by United States copyright laws, international treaty provisions,
         and all other applicable national laws.  You may not reverse
         engineer, decompile, or disassemble the device driver.


GoldStar DISCLAIMS ALL WARRANTIES, WHETHER EXPRESSED
OR IMPLIED, INCLUDING WITHOUT LIMITATION,
WARRANTIES OF FITNESS AND MERCHANTABILITY WITH
RESPECT TO THE INFORMATION IN THIS DOCUMENT.
BY FURNISHING THIS DOCUMENT, GoldStar GRANTS NO
LICENSES TO ANY RELATED PATENTS OR COPYRIGHTS.

Copyright GoldStar Corporation, 1994, all rights reserved.

