/*
 * Copyright (c) 1996 Distributed Processing Technology Corporation
 * All rights reserved.
 *
 * Redistribution and use in source form, with or without modification, are
 * permitted provided that redistributions of source code must retain the
 * above copyright notice, this list of conditions and the following disclaimer.
 *
 * This software is provided `as is' by Distributed Processing Technology and
 * any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose,
 * are disclaimed. In no event shall Distributed Processing Technology be
 * liable for any direct, indirect, incidental, special, exemplary or
 * consequential damages (including, but not limited to, procurement of
 * substitute goods or services; loss of use, data, or profits; or business
 * interruptions) however caused and on any theory of liability, whether in
 * contract, strict liability, or tort (including negligence or otherwise)
 * arising in any way out of the use of this driver software, even if advised
 * of the possibility of such damage.
 *
 * DPT SCSI host adapter pass through handler.
 *
 *      dpt V1.0B 1996/09/01 salyzyn@dpt.com
 *              Fixed the system information code.
 *
 *      bsdi 1996/06/03 pjd@bsdi.com
 *              file name changes only
 *
 *      BSDI  05/31/96  pjd@bsdi.com
 *      changed call parameters to dptioctl() to conform.
 *
 *      dpt V1.00 1996/03/07 salyzyn@dpt.com
 *
 */

/*
 *      Meant to be included at the bottom of eata.c
 */
#undef cp_Req_Len
#undef cp_IAT
#undef cp_Channel
#undef cp_cdb
#undef cp_extent
#undef cp_lun
#undef cp_page
#undef cp_len

#include        <sys/ioctl.h>
#include        <sys/types.h>
#include        <i386/isa/dpt_sys_info.h>
/*
 *      Included here as hard coded. Done because other necessary include
 *      files utilize C++ comment structures which make them a nuisance to
 *      included here just to pick up these three typedefs.
 */
typedef unsigned long   DPT_TAG_T;
typedef unsigned long   DPT_MSG_T;
typedef unsigned long   DPT_RTN_T;

#include        <i386/isa/dpt_osd_unix.h>
#if (!defined(DPT_DEBUG_FLAGS) && !(DPT_DEBUG_FLAGS))
# undef DPT_DEBUG
#endif

#define dptunit(dev)     dv_unit(dev)

STATIC DptHa_t *
dpt_get_sc (dev_t dev)
{       int             unit = dptunit(dev);
        DptHa_t *       sc = dptcd.cd_devs[0];

        if (!sc)
                sc = DptHa;
        for (; (unit > 0) && (sc); --unit)
                sc = sc->ha_next_parent;
        return (sc);
}

STATIC int
dptopen(dev_t dev, int flags, int ifmt, struct proc *p)
{
#       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_CALL))
                printf("dptopen(%x(%x), %x, %x, %x)",
                    dev, dpt_get_sc(dev), flags, ifmt, p);
#       endif

        if (dpt_get_sc (dev)) {
#               if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_CALL))
                        printf (" = 0\n");
#               endif
                return (0);
        }
#       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_CALL))
                printf (" = ENXIO\n");
#       endif
        return (ENXIO);
}

/*----------------------------------------------------------------------*/
/*                          Function dptioctl                           */
/*----------------------------------------------------------------------*/
/* The parameters passed to this function are :                         */
/*     dev  : Device number.                                            */
/*     cmd  : Ioctl Command                                             */
/*     data : User Argument Passed In.                                  */
/*     flag : Mode Parameter                                            */
/*     proc : Process Parameter                                         */
/*                                                                      */
/* This function is the user interface into this adapter driver         */
/*                                                                      */
/* Return : zero if OK, error code if not                               */
/*----------------------------------------------------------------------*/

STATIC int
dptioctl(dev, cmd, data, flag, p)
        dev_t                   dev;
        int                     cmd;
        caddr_t                 data;
        int                     flag;
        struct proc *           p;
{       int                     i, j, error = 0;
        DptHa_t *               sc = dpt_get_sc (dev);
        u_char                  c;
        DptCcb_t *              ccb;

#       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_CALL))
                printf("dptioctl(%x(%x), %x, %x, %x, %x)\n",
                    dev, sc, cmd, data, flag, p);
#       endif

#       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS))
            if (sc)
#       endif
        switch(cmd) {
#ifdef DPT_DEBUG
            case DPT_DEBUG & 0x0000FFFF:
            case DPT_DEBUG:
                sc->ha_debug = (int)data;
                return (0);
#endif
            case DPT_STATINFO:
                printf ("\nI/O Pending :%d\n", sc->ha_Total_IO_Pending);
                return (0);

            case DPT_CLRSTAT:
                return (0);

            case EATAUSRCMD & 0x0000FFFF:
            case EATAUSRCMD: {
                struct buf      bufhdr;
                caddr_t         ccb_hold;
                caddr_t         stat_hold;
                caddr_t         dat_hold;
                caddr_t         sense_hold;
                int             sense_len;
                EataCp_t        hold;

                if (error = suser(p->p_ucred, &p->p_acflag)) {
#                       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS))
                                if (sc->ha_debug)
                                        printf ("EATAUSRCMD !suser\n");
#                       endif
                        return (error);
                }

                /*
                 *      Get a CCB and nail with the incoming data.
                 */
                ccb = dpt_get_ccb (sc, 0, (struct scsi_cdb *)NULL);
                (void)bcopy (&(ccb->EataCp), &hold, sizeof(ccb->EataCp));
                if (cmd & 0xFFFF0000)
                        (void)bcopy (data, &(ccb->EataCp), sizeof(ccb->EataCp));
                else if (error = copyin(data, &(ccb->EataCp),
                    sizeof(ccb->EataCp))) {
                        (void)bcopy(&hold, &(ccb->EataCp), sizeof(ccb->EataCp));
                        dpt_free_ccb (sc, 0, ccb);
#                       if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS))
                                if (sc->ha_debug)
                                        printf ("EATAUSRCMD !copyin EataCP\n");
#                       endif
                        return (error);
                }
                /*
                 *      Check the validity of the incoming CCB?
                 */
#               if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_CHECK))
                        if ((ccb->EataCp.cp_u.y.y_Channel > sc->ha_Config.MaxChannel)
                         || (ccb->EataCp.cp_id > sc->ha_Config.MaxScsiID)) {
                                if (sc->ha_debug)
                                        printf ("EATAUSRCMD invalid ccb (%d,%d,?) > (%d,%d,?)\n",
                                                ccb->EataCp.cp_u.y.y_Channel,
                                                ccb->EataCp.cp_id,
                                                sc->ha_Config.MaxChannel,
                                                sc->ha_Config.MaxScsiID);
                                (void)bcopy(&hold, &(ccb->EataCp),
                                    sizeof(ccb->EataCp));
                                dpt_free_ccb (sc, 0, ccb);
                                return (EINVAL);
                        }
#               endif
                /*
                 *      Save various unswapped user space variables.
                 */
                ccb_hold = ccb->EataCp.cp_vp;
                sense_hold = (caddr_t)(ccb->EataCp.cp_reqDMA);
                dat_hold = (caddr_t)(ccb->EataCp.cp_dataDMA);
                stat_hold = (caddr_t)(ccb->EataCp.cp_statDMA);
                /*
                 *      Initialize the CCB with it's real parameters.
                 */
                ccb->EataCp.cp_vp = (caddr_t)ccb;       /* Overwrite */
                bzero (&bufhdr, sizeof(bufhdr));
                bufhdr.b_iocount = bufhdr.b_bcount = ccb->EataCp.cp_datalen;
                if (ccb->EataCp.cp_DataIn)
                        bufhdr.b_flags = B_READ;
                if (ccb->EataCp.cp_DataIn || ccb->EataCp.cp_DataOut) {
                        if (!(bufhdr.b_un.b_addr = malloc (bufhdr.b_iocount,
                            M_TEMP, M_WAITOK))) {
                                (void)bcopy (&hold, &(ccb->EataCp),
                                    sizeof(ccb->EataCp));
                                dpt_free_ccb (sc, 0, ccb);
#                               if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS))
                                        if (sc->ha_debug)
                                                printf ("EATAUSRCMD !malloc buffer\n");
#                               endif
                                return (ENOMEM);
                        }
                        if (ccb->EataCp.cp_DataOut
                         && (error = copyin (dat_hold, bufhdr.b_un.b_addr,
                            bufhdr.b_iocount))) {
                                free (bufhdr.b_un.b_addr, M_TEMP);
                                (void)bcopy (&hold, &(ccb->EataCp),
                                    sizeof(ccb->EataCp));
                                dpt_free_ccb (sc, 0, ccb);
#                               if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS))
                                        if (sc->ha_debug)
                                                printf ("EATAUSRCMD copyin data\n");
#                               endif
                                return (error);
                        }
                }
                ccb->EataCp.cp_reqDMA = VMTOSWAP (KVTOPHYS (
                    (caddr_t)&(ccb->ccb_sense)));
                dpt_init_sccb (sc, ccb, ccb->EataCp.cp_id - sc->ha_ID,
                    (scintr_fn)NULL, (struct device *)NULL, &bufhdr);
                /*
                 *      What to do with Request Sense? Collect our copy
                 *      into the storage for now.
                 */
                c = ccb->EataCp.cp_Auto_Req_Sen;
                ccb->EataCp.cp_Auto_Req_Sen = 1;
                sense_len = ccb->EataCp.cp_u.y.y_Req_Len;
                ccb->EataCp.cp_u.y.y_Req_Len = sizeof(Scsi_Sense_t);
                /*
                 *      Send the command out
                 */
                j = splbio ();
#               if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_VERBOSE))
                        if (sc->ha_debug & DPT_DEBUG_VERBOSE) {
                                Print_EataCp (ccb);
                                getchar ();
                        }
#               endif
                i = dptccb (sc, ccb, FL_NOMASK|FL_QUIET);
                /*
                 *      Cleanup
                 */
                if (bufhdr.b_un.b_addr) {
                        if (bufhdr.b_flags)
                                error = copyout (bufhdr.b_un.b_addr, dat_hold,
                                    bufhdr.b_iocount);
                        free (bufhdr.b_un.b_addr, M_TEMP);
                        if (error) {
                                (void)bcopy (&hold, &(ccb->EataCp),
                                    sizeof(ccb->EataCp));
                                splx (j);
#                               if (defined(DPT_DEBUG_FLAGS) && (DPT_DEBUG_FLAGS & DPT_DEBUG_VERBOSE))
                                        if (sc->ha_debug)
                                                printf ("EATAUSRCMD copyout\n");
#                               endif
                                return (error);
                        }
                }
                sc->ha_Status_Packet->sp_vp = (DptCcb_t *)ccb_hold;
                /* if (stat_hold)
                        error = copyout (sc->ha_Status_Packet, stat_hold,
                            sizeof(DptStat_t)); */
                if ((sense_hold) && (c))
                        error = copyout (&(ccb->ccb_sense), sense_hold,
                            sense_len);
                /*
                 *      Copy our Status Packet information into the user's
                 *      version.
                 */
                if (cmd & 0xFFFF0000) {
                        ((EATA_CP *)data)->TargetStatus=ccb->ccb_Target_Status;
                        ((EATA_CP *)data)->HostStatus = ccb->ccb_Host_Status;
                } else {error = copyout(&(ccb->ccb_Target_Status),
                            &((EATA_CP *)(*((int **)data)))->TargetStatus,
                            sizeof(char));
                        error = copyout(&(ccb->ccb_Host_Status),
                            &((EATA_CP *)(*((int **)data)))->HostStatus,
                            sizeof(char));
                }
                /*
                 *      Restore Defaults, and release the CCB.
                 */
                (void)bcopy (&hold, &(ccb->EataCp), sizeof(ccb->EataCp));
                splx (j);
                return (error); }

            case DPT_SIGNATURE:
                if (cmd & 0xFFFF0000) {
                        (void)bcopy ((caddr_t)(&dpt_sig), data,
                            sizeof(dpt_sig_S));
                        return (0);
                }
            case DPT_SIGNATURE & 0x0000FFFF:
                return (copyout ((caddr_t)(&dpt_sig), *((int **)data),
                    sizeof(dpt_sig_S)));

            case DPT_NUMCTRLS & 0x0000FFFF:
            case DPT_NUMCTRLS: {
                DptHa_t *       ha_p;

                i = 0;
                ha_p = sc->ha_parent;
                do {
                        ++i;
                } while (ha_p = ha_p->ha_next_parent);
                *((int *)data) = i;
                if ((cmd & 0xFFFF0000) == 0) {
                        error = copyout (&i, *((int **)data), sizeof(int));
                }
                return (error); }

            case DPT_CTRLINFO & 0x0000FFFF:
            case DPT_CTRLINFO: {
                HbaInfo         CtlrInfo;
                DptHa_t *       ha_p = sc->ha_parent;

                bzero (&CtlrInfo, sizeof(CtlrInfo));
                CtlrInfo.id[0] = ha_p->ha_Config.HBA[3];
                CtlrInfo.id[1] = ha_p->ha_Config.HBA[2];
                CtlrInfo.id[2] = ha_p->ha_Config.HBA[1];
                CtlrInfo.id[3] = ha_p->ha_Config.HBA[0];
                CtlrInfo.vect = (ha_p->ha_Config.IRQ_Number)
                        ? ha_p->ha_Config.IRQ_Number
                        : ha_p->ha_Config.IRQ;
                CtlrInfo.base = ha_p->ha_Base;
                CtlrInfo.qdepth = ha_p->ha_Config.QueueSize[1]
                               + (ha_p->ha_Config.QueueSize[0] << 8);
                CtlrInfo.SGsize = ha_p->ha_Config.SG_Size[1]
                               + (ha_p->ha_Config.SG_Size[0] << 8);
                CtlrInfo.eataVersion = ha_p->ha_Config.EATAversion;
                CtlrInfo.cpLength = ha_p->ha_Config.CPlength[3]
                                 + (ha_p->ha_Config.CPlength[2] << 8)
                                 + (ha_p->ha_Config.CPlength[1] << 16)
                                 + (ha_p->ha_Config.CPlength[0] << 24);
                CtlrInfo.spLength = ha_p->ha_Config.SPlength[3]
                                 + (ha_p->ha_Config.SPlength[2] << 8)
                                 + (ha_p->ha_Config.SPlength[1] << 16)
                                 + (ha_p->ha_Config.SPlength[0] << 24);
                CtlrInfo.drqNum = ha_p->ha_Config.DMAChannelValid
                        ? "\0\7\6\5"[ha_p->ha_Config.DMA_Channel]
                        : -1;
                CtlrInfo.eataflag1 = *((u_char *)&(ha_p->ha_Config.flag0));
                CtlrInfo.eataflag2 = ha_p->ha_Config.IRQ_Number
                                  + (ha_p->ha_Config.IRQ_Trigger << 4)
                                  + (ha_p->ha_Config.Secondary << 5)
                                  + (ha_p->ha_Config.DMA_Channel << 6);
                CtlrInfo.maxChannel = ha_p->ha_Config.MaxChannel;
                CtlrInfo.maxID = ha_p->ha_Config.MaxScsiID;
                CtlrInfo.maxLUN = ha_p->ha_Config.MaxLUN;
                CtlrInfo.HbaBusType = is_isa(ha_p)?0:(is_eisa(ha_p)?1:2);
                CtlrInfo.RaidNum = ha_p->ha_Config.RaidNum;
                i = 0;
                do {
                    for (ccb = ha_p->ha_CCB; ccb && ccb->ccb_Device;
                        ccb=ccb->ccb_next)
                            ++i;
                } while (ha_p = ha_p->ha_next);
                CtlrInfo.njobs = i;
                if (cmd & 0xFFFF0000) {
                        bcopy (&CtlrInfo, data, sizeof(CtlrInfo));
                } else {
                        error = copyout (&CtlrInfo, data, sizeof(CtlrInfo));
                }
                return (error); }

            case DPT_SYSINFO & 0x0000FFFF:
            case DPT_SYSINFO: {
                sysInfo_S       Info;
                caddr_t         c_addr;
                /* Kernel Specific ptok `hack' */
                extern int      basemem;
#               define          ptok(a) (((a) >= basemem) \
                                ? ISA_HOLE_VADDR(a) : ((char *)(a) + KERNBASE))

                bzero (&Info, sizeof(Info));

                outb (0x70, 0x12);
                i = inb(0x71);
                j = i >> 4;
                if (i == 0x0f) {
                        outb (0x70, 0x19);
                        j = inb (0x71);
                }
                Info.drive0CMOS = j;

                j = i & 0x0f;
                if (i == 0x0f) {
                        outb (0x70, 0x1a);
                        j = inb (0x71);
                }
                Info.drive1CMOS = j;

                Info.numDrives = *((char *)ptok(0x475));

                Info.processorFamily = dpt_sig.dsProcessorFamily;
                switch (cpu) {
                case CPU_386SX: case CPU_386:
                        Info.processorType = PROC_386; break;
                case CPU_486SX: case CPU_486:
                        Info.processorType = PROC_486; break;
                case CPU_586:
                        Info.processorType = PROC_PENTIUM; break;
                case CPU_686:
                        Info.processorType = PROC_SEXIUM; break;
                }
                Info.osType = OS_BSDI_UNIX;
                Info.osMajorVersion = osrelease[0] - '0';
                Info.osMinorVersion = osrelease[2] - '0';
                /* Info.osRevision = 0; */
                /* Info.osSubRevision = 0; */
                Info.busType = is_isa(sc) ? SI_ISA_BUS
                           : (is_eisa(sc) ? SI_EISA_BUS : SI_PCI_BUS);
                Info.flags = SI_CMOS_Valid | SI_NumDrivesValid
                        | SI_OSversionValid |SI_BusTypeValid;

                /* Go Out And Look For SmartROM */
                for(i = 0; i < 3; ++i) {
                        int     k;

                        if (i == 0) {
                                j = 0xC8000;
                        } else if (i == 1) {
                                j = 0xD8000;
                        } else {
                                j = 0xDC000;
                        }
                        c_addr = ptok(j);
                        if (*((unsigned short *)c_addr) != 0xAA55) {
                                continue;
                        }
                        if (*((unsigned long *)(c_addr + 6)) != 0x202053) {
                                continue;
                        }
                        if (*((unsigned long *)(c_addr + 10)) != 0x545044) {
                                continue;
                        }
                        c_addr += 0x24;
                        for (k = 0; k < 64; ++k) {
                                if ((*((unsigned char *)(c_addr++)) == ' ')
                                 && (*((unsigned char *)(c_addr)) == 'v')) {
                                                break;
                                }
                        }
                        if (k < 64) {
                                Info.smartROMMajorVersion
                                    = *((unsigned char *)(c_addr += 3)) - '0';
                                Info.smartROMMinorVersion
                                    = *((unsigned char *)(c_addr += 2));
                                Info.smartROMRevision
                                    = *((unsigned char *)(++c_addr));
                                Info.flags |= SI_SmartROMverValid;
                                break;
                        }
                }
                if (i >= 3) {
                        Info.flags |= SI_NO_SmartROM;
                }
                /* Get The Conventional Memory Size From CMOS */
                outb (0x70, 0x16);
                j = inb (0x71);
                j <<= 8;
                outb (0x70, 0x15);
                j |= inb(0x71);
                Info.conventionalMemSize = j;

                /* Get The Extended Memory Found At Power On From CMOS */
                outb (0x70, 0x31);
                j = inb (0x71);
                j <<= 8;
                outb (0x70, 0x30);
                j |= inb(0x71);
                Info.extendedMemSize = j;
                Info.flags |= SI_MemorySizeValid;

#               if (defined(THIS_IS_BROKEN))
                /* If There Is 1 or 2 Drives Found, Set Up Drive Parameters */
                if (Info.numDrives > 0) {
                        /*
                         *      Get The Pointer From Int 41 For The First
                         *      Drive Parameters
                         */
                        j = (*((unsigned short *)ptok(0x104+2)) << 4)
                           + *((unsigned short *)ptok(0x104+0));
                        /*
                         * It appears that SmartROM's Int41/Int46 pointers
                         * use memory that gets stepped on by the kernel
                         * loading. We no longer have access to this
                         * geometry information (!?)
                         */
                        Info.drives[0].cylinders = *((unsigned char *)ptok(j));
                        ++j;
                        Info.drives[0].cylinders += ((int)*((unsigned char *)
                            ptok(j))) << 8;
                        ++j;
                        Info.drives[0].heads = *((unsigned char *)ptok(j));
                        j += 12;
                        Info.drives[0].sectors = *((unsigned char *)ptok(j));
                        if (Info.numDrives > 1) {
                                /*
                                 *      Get The Pointer From Int 46 For The
                                 *      Second Drive Parameters
                                 */
                                j = (*((unsigned short *)ptok(0x118+2)) << 4)
                                   + *((unsigned short *)ptok(0x118+0));
                                Info.drives[1].cylinders = *((unsigned char *)
                                    ptok(j));
                                ++j;
                                Info.drives[1].cylinders += ((int)
                                    *((unsigned char *)ptok(j))) << 8;
                                ++j;
                                Info.drives[1].heads = *((unsigned char *)
                                    ptok(j));
                                j += 12;
                                Info.drives[1].sectors = *((unsigned char *)
                                    ptok(j));
                        }
                        Info.flags |= SI_DriveParamsValid;
                }
#               endif
                /* Copy Out The Info Structure To The User */
                if (cmd & 0xFFFF0000) {
                        bcopy (&Info, data, sizeof(Info));
                } else {
                        error = copyout (&Info, data, sizeof(Info));
                }
                return (error); }

                /* Set The Timeout Flag */
            case DPT_TIMEOUT:
                return (0);

                /* Get The BlinkLED State */
            case DPT_BLINKLED:
                j = splbio();
                /*
                 * This Function Checks For The BLINK LED State For An Adapter
                 * Found At the port
                 * Return : Blink State If In Blink LED State, 0 Otherwise
                 */
                {       int     Attempts = 10;
                        long    BlinkIndicator = 0x42445054, State = 0x12345678;
                        long    OldState = 0;

                        i = 0;
                        while ((Attempts--) && (State != OldState)) {
                                OldState = State;
                                State = inl (sc->ha_Base + HA_ERROR);
                        }

                        if ((State == OldState) && (State == BlinkIndicator)) {
                                i = inb (sc->ha_Base + HA_DMA_BASE + 3);
                }
                }
                splx(j);
                if (cmd & 0xFFFF0000) {
                        bcopy ((caddr_t)(&i), data, sizeof(i));
                } else {
                        error = copyout (&i, data, sizeof(i));
                }
                break;
        }
        return (EINVAL);
#undef sc
}
