page		60,132
title		Cirrus Logic VGA Hot Key Option Selector Program
;-----------------------------------------------------------------------
;
;	TITLE:
;
;	   Switcher
;
;	FUNCTION:
;
;	   This program is a terminate and stay resident program to
;	select the available options provided by the Cirrus Logic
;	VGA bios to support flat panels and display switch.
;
;	LICENSE:
;
;	   This program supports a standard IBM PC 83 key keyboard
;	and its associated keyboard controller.  Only Original
;	customers of Cirrus Logic, Inc. are granted the right to
;	modify this source code for their their particular
;	application.
;
;	   This program is a copyrighted work of Cirrus Logic, Inc.
;	and rights are granted to distibute this program either
;	modified or unmodified, in executable format only.
;	Specific permission must be granted by Cirrus Logic, Inc.
;	to distibute the source code of this program to any third
;	party.
;
;	   Furthermore, Cirrus Logic, Inc. grants license to use
;	this program with Cirrus Logic graphics hardware only, and
;	specifically does not grant license to use this program
;	with any non Cirrus Logic graphics application.
;
;	WARRANTY:
;
;	   With respect to the physical diskette and physical
;	documentation enclosed herein, Cirrus Logic, Inc. warrants
;	the same to be free of defects in materials and workmanship.
;	The remedy for breach of this warranty shall be limited to
;	replacement and shall not encompass any other damages,
;	including, but not limited to loss of profit, and special,
;	incidental, consequential, or other similar claims.
;
;	   Cirrus Logic, Inc. specifically disclaims all other
;	warranties, expressed or implied, including but not limited
;	to implied warranties of merchantiblity and fitness for a
;	particular purpose with respect to any particular
;	application, use or purpose.  In no event shall Cirrus Logic,
;	Inc. be liable for any loss of profit or any other commercial
;	damage, including but not limited to special, incidental,
;	consequential or other damages.
;
;	VERSION:
;
;	   1.00, by Paul W. T. Heller, Cirrus Logic, Inc.
;
;	Rev 1:
;
;	   Modified the operation of power save enable/disable.  The
;	keystroke sequence only turns it off, and never on.  The
;	panel is turned on when the next keyboard "make" code is
;	received.  (I tried doing it on the next keyboard activity,
;	but the break codes from letting go of ctrl-shift-s caused
;	it to go back on.)
;
;	   The remaining "hole" in this logic is that if the very
;	next make code is a valid panel hot key sequence (i.e., the
;	user never let go of ctrl and shift and hit another valid
;	key) then that function is acted upon while the panel is
;	still powered down.
;
;	Rev 2: October 29, 1989
;
;	   Modified to switch to internal stack when it decides to
;	act on key strokes.  The internal stack begins at the end
;	of the original PSP (which has long since finished serving
;	its purpose) and extends back.  I looked at the PSP after
;	some vigorous exercising of the functions, and it appears as
;	if stack use is in the neighborhood of about 60h bytes.  Note
;	that the stack switch occurs after setting the re-entrancy lock.
;
;	Rev 3: November 6, 1989
;
;	    Modified to not load resident on non-panel systems.
;
;	Rev 4: November 23, 1989
;
;	    Modified to support display switch between motherboard
;	vga and adapter vga.  Note that either of these VGA's may
;	then have their panel options switched.
;
;	Rev 5: December 13, 1989
;
;	    Modified to perform a psuedo set mode when performing
;	font load functions.  Mostly in support of DOS code page.
;
;	Rev 6: January 21, 1990
;
;	    Preserved al across DOS prt string call in prt_keys.
;	Also updated copyright notice to 1990.
;
;	Rev 7: February 2, 1990
;
;	   Set and reset bit 7 of the PPI control port at 0x61h to
;	keep PC and XT keyboards from hanging.  Also save and restore
;	keyboard buffer head and tail pointers when testing for a
;	resident copy to keep spurious keys from getting into the
;	keyboard buffer.
;
;	Rev 8: June 26, 1990, Keith H. Uhlin
;	   Used INT 15, AH=4F, AL=make or break code to support trap on 
;	keystrokes for us.  Removed all direct programming of keyboard 
;	controller.  
;	   This method is supported by IBM AT BIOS dated after 1/10/84 and
;	IBM compatible planar bioses.
;	   Included support for extensions being locked.
;	   
;	2.01: March 4,1991 Chi-Jen Huang
;	   supported RevC functions - hardware text expand and suspend mode
;	   fix Rev 8 cntl-shift-B bug
;
;	2.02: March 16,1991
;	   disable revc-only hot key in revb
;
;	2.03: March 22,1991
;	   support Raven
;
;	2.04: April 15,1991
;	   A1:support Peacock for Stingray RevC
;	   A2:fix Raven lcd/crt switch
;	   A3:add Raven new functions
;	      new Raven inquire user option 
;	   B1:to QA, support new GD6410 user option function
;	   B2:fix simulscan bug in GD6340
;	   B3:fix reverse graph/text
;	   B4:fix display switch function
;	   B5:fix display switch error message
;	   B6:take out CNTL_SHIFT_M
;	   B7:fix fs4 bug - preserve graphics index
;	     :fix standby hot key bug
;
;	2.05: 12-31-1991 
;	   B1:fix panel/CRT/SimulSCAN message
;	      skip inquiry function in _crt_lcd_simul if pray
;	   B2:support GD6420 as Gd6410
;	      update copyright notice to 1992
;	   Release:Remove width fixup from pray
;         Turbo Assembler 3.0
;         changed "Version" equate to "VersionNum" for Turbo
;         changed "@@:" label in power() to "@f:" to match jumps.
;
;	2.06: 02-17-92
;	   B1:took out standby/suspend option from help message
;	2.07: 03-25-92
;	   A1:support 6412- don't check chip type, but check capability
;	   B1:same as A1 
;	2.08: 04-08-93 Developed from 2.06 source. (Now check chip types)
;	   B1:Added 62XX support, changed to 6340 capabilities mask
;		  Now capabilities are determined at run time (but defined
;		  by OEM in function _init_chip() ).  Only currently
;		  supported options will be displayed.
;		  added support for GD62x5
;	      update copyright notice to 1993
;       2.09: 06-28-93
;          B1:Added 6440 Macaw support.       
;          B2:Removed standby/suspend usage for 6440. (Line#: 444 & 1140)
;          B4:Added 6235 Orion support (line# 2145). Derived from B2 source.
;-----------------------------------------------------------------------
ID_WORD		equ	'SW'
VersionNum	equ	'2.09'	; switcher version number

vectors		segment	at 00h

		org	4*15h
gen_serv_vect 	label	dword		; keyboard isr
gen_serv_off  	dw	?		;    offset
gen_serv_seg  	dw	?		;    segment

		org	4*10h
vd_vect		label	dword		; video bios isr
vd_off		dw	?		;    offset
vd_seg		dw	?		;    segment

vectors		ends

bios_data	segment	at 40h

		org	17h
kb_flag		db	?		; keyboard flags
		org	1ah
kb_head		dw	?		; kb head pointer
kb_tail		dw	?		; kb tail pointer

		org	89h
vga_info	db	?		; vga configuration byte

bios_data	ends

_text		segment	byte public 'code'
		assume	cs:_text,ds:_text

		org	100h		; where .com's start

_start		proc	near
		public	_start

		jmp	_init		; go run init code

_start		endp

isr15		label	dword
		isr15_off	dw	?
		isr15_seg	dw	?

isr10		label	dword
		isr10_off	dw	?
		isr10_seg	dw	?

running		db	1		; reentrancy lock
env_flags	db	0		; environment flags
					; bit 0 - C000 vga supports panels
					; bit 1 - E000 vga supports panels
					; bit 7 - display switch supproted
;
;-----------------------------------------------------------------------
; chip-related data structure
;-----------------------------------------------------------------------
;
; capability mask
SIMUSC_SUPP	equ	01h
VERT_ALIGN_SUPP equ 02h
EXPAND_SUPP	equ 04h
BOLD_SUPP	equ	08h
REV_SUPP	equ	10h
ATTR_EMUL_SUPP	equ 20h
RGB_SUPP	equ	40h
SLEEP_SUPP	equ 80h

; config capability mask
PANEL_FREQ 	equ 01h
MEM_PERFORM	equ	02h


; chip type mask
REVB610620	equ 01h
REVC610620	equ 02h
GD64XX		equ	04h
GD62XX		equ	08h
GD6440          equ     10h    
;next            equ     20h
;next            equ     40h
;next            equ     80h

cap_stat	db	00h	; capability status
config_cap	db	00h	; config capability
chip_type	db	00h	; chip type
chip_fc		db	00h	; function count
chip_funcptr	dw	?	; offset of function structure
chip_msg	dw	?	; offset of sign-on message

REV_C		equ	01h
st_rev		db	00h	; gd610/620 revision

;--------------------------------
;funcstruc struc
;  	hotk	db	0	; scan code of hot key
;	handler	dw	?	; corresponding routine
;funcstruc ends
;--------------------------------
; display-switch only function
;
only_dsk	db	2fh		; scan code for v/V
		dw	_dswitch	; display switch
only_count	= ($ - only_dsk) / 3

; GD610/620 RevB function table
;
revb_funcptr	label	word

		db	20h		; scan code for d/D
		dw	_crt_lcd	; crt/lcd switch
REVB_EXP		db	12h		; scan code for e/E
		dw	_expand		; expand mode
REVB_BOLD		db	30h		; scan code for b/B
		dw	_bold		; bold font
REVB_ATTR		db	1eh		; scan code for a/A
		dw	_automap	; automap/attr emulation
REVB_REV		db	13h		; scan code for r/R
		dw	_reverse	; reverse video
REVB_CENT		db	2eh		; scan code for c/C
		dw	_center		; centering
		db	1fh		; scan code for s/S
		dw	_power		; power save
		db	11h		; scan code for w/W
		dw	_fix720		; 720 dot fix up
		db	21h		; scan code for f/F
		dw	_frame		; frame color
revb_dsk	db	2fh		; scan code for v/V
		dw	_dswitch	; display switch
revb_count	= ($ - revb_funcptr) / 3

;
; GD610/620 RevC function table
;
revc_funcptr	label	word

		db	20h		; scan code for d/D
		dw	_crt_lcd	; crt/lcd switch
REVC_EXP		db	12h		; scan code for e/E
		dw	_expand		; expand mode
REVC_BOLD		db	30h		; scan code for b/B
		dw	_bold		; bold font
REVC_ATTR		db	1eh		; scan code for a/A
		dw	_automap	; automap/attr emulation
REVC_REV		db	13h		; scan code for r/R
		dw	_reverse	; reverse video
REVC_CENT		db	2eh		; scan code for c/C
		dw	_center		; centering
		db	1fh		; scan code for s/S
		dw	_power		; power save
		db	11h		; scan code for w/W
		dw	_fix720		; 720 dot fix up
		db	21h		; scan code for f/F
		dw	_frame		; frame color
revc_dsk	db	2fh		; scan code for v/V
		dw	_dswitch	; display switch
		db	23h		; scan code for h/H
		dw	_hwexp		; hardware text expand
		db	16h		; scan code for u/U
		dw	_suspend	; suspend mode
revc_count	= ($ - revc_funcptr) / 3

;
; GD610/620 RevC and GD6340 function table
;
revcp_funcptr	label	word

REVCP_SIMUL		db	20h		; scan code for d/D
		dw	_crt_lcd_simul	; crt/lcd switch
REVCP_EXP		db	12h		; scan code for e/E
		dw	_expand		; expand mode
REVCP_BOLD		db	30h		; scan code for b/B
		dw	_bold		; bold font
REVCP_ATTR		db	1eh		; scan code for a/A
		dw	_automap	; automap/attr emulation
REVCP_REV		db	13h		; scan code for r/R
		dw	_reverse	; reverse video
REVCP_CENT		db	2eh		; scan code for c/C
		dw	_center		; centering
		db	1fh		; scan code for s/S
		dw	_power		; power save
;***		db	11h		; scan code for w/W
;***		dw	_fix720		; 720 dot fix up
revcp_dsk	db	2fh		; scan code for v/V
		dw	_dswitch	; display switch
		db	23h		; scan code for h/H
		dw	_hwexp		; hardware text expand
		db	16h		; scan code for u/U
		dw	_suspend	; suspend mode
revcp_count	= ($ - revcp_funcptr) / 3

;
; GD6410 & 6420 function table
;
raven_funcptr	label	word

RAV_SIMUL		db	20h		; scan code for d/D
		dw	_crt_lcd_simul	; crt/lcd switch
RAV_EXP			db	12h		; scan code for e/E
		dw	_expand		; expand mode
RAV_BOLD		db	30h		; scan code for b/B
		dw	_bold		; bold font
RAV_ATTR		db	1eh		; scan code for a/A
		dw	_con_enhance	; contrast enhancement
RAV_REV		db	13h		; scan code for r/R
		dw	_greverse	; reverse video - graphics/text
RAV_CENT		db	2eh		; scan code for c/C
		dw	_center		; centering
		db	1fh		; scan code for s/S
		dw	_power		; power save
raven_dsk	db	2fh		; scan code for v/V
		dw	_dswitch	; display switch
		db	16h		; scan code for u/U
		dw	_suspend	; suspend mode
RAV_RGB		db	22h		; scan code for g/G
		dw	_rgb_wt		; rgb weighting
		db	18h		; scan code for o/O
		dw	_fcursor	; full height cursor
		db	26h		; scan code for l/L
		dw	_fontload	; inhibit font load
raven_count	= ($ - raven_funcptr) / 3
;
; GD62XX function table
;
term_funcptr	label	word

TERM_SIMUL		db	20h		; scan code for d/D
		dw	_crt_lcd_simul	; crt/lcd switch
TERM_EXP		db	12h		; scan code for e/E
		dw	_expand		; expand mode
TERM_BOLD		db	30h		; scan code for b/B
		dw	_bold		; bold font
TERM_ATTR		db	1eh		; scan code for a/A
		dw	_automap	; Black and white enhancement
TERM_REV		db	13h		; scan code for r/R
		dw	_greverse	; reverse video - graphics/text
		db	2eh		; scan code for c/C
		dw	_center		; centering
		db	1fh		; scan code for s/S
		dw	_power		; power save

term_dsk	db	2fh		; scan code for v/V
		dw	_dswitch	; display switch
		db	16h		; scan code for u/U
		dw	_suspend	; suspend mode
TERM_GRA	db	22h		; scan code for g/G
		dw	_graphics_wt		; Graphics grey shading
TERM_TXT	db	14h		; scan code for t/T
		dw	_text_wt		; text grey shading
		db	19h		; scan code for p/P
		dw	_p_power; Panel Power Usage
		db	26h		; scan code for l/L
		dw	_fontload	; inhibit font load
term_count	= ($ - term_funcptr) / 3

;
; GD6440 function table
;
macaw_funcptr	label	word

MACAW_SIMUL	db	20h		; scan code for d/D
		dw	_crt_lcd_simul	; crt/lcd switch
MACAW_EXP	db	12h		; scan code for e/E
		dw	_expand		; expand mode
MACAW_BOLD	db	30h		; scan code for b/B
		dw	_bold		; bold font
MACAW_ATTR	db	1eh		; scan code for a/A
		dw	_con_enhance    ; contrast enhancement
MACAW_REV       db	13h		; scan code for r/R
		dw	_greverse	; reverse video - graphics/text
		db	2eh		; scan code for c/C
		dw	_center		; centering
;		db	1fh		; scan code for s/S
;		dw	_power		; power save
macaw_dsk	db	2fh		; scan code for v/V
		dw	_dswitch	; display switch
;		db	16h		; scan code for u/U
;		dw	_suspend	; suspend mode
		db	19h		; scan code for p/P
		dw	_p_power        ; Panel Power Usage
		db	18h		; scan code for o/O
		dw	_fcursor	; full height cursor
		db	26h		; scan code for l/L
		dw	_fontload	; inhibit font load
macaw_count	= ($ - macaw_funcptr) / 3


;-----------------------------------------------------------------------
;
;	expand()
;
;	Function:
;	   Turn expand mode on/off
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
exp_frame	struc
	exp_typ	dw	?		; cursor type
	exp_bp	dw	?		; caller's bp
	exp_ip	dw	?		; caller's ip
exp_frame	ends

_expand		proc	near
		public	_expand

		push	bp		; save caller's bp
		sub	sp,exp_bp	; make space for automatic
		mov	bp,sp		; base of stack frame

		mov	ah,03h		; get cursor information
		int	10h		; BIOS call
		mov	exp_typ[bp],cx	; save cursor type

		call	_status		; get current status
		test	ah,02h		; expand mode disabled ?
		mov	ax,1200h	; enable expand mode
		jnz	set_expand	; yes
		inc	ax		; disable expand mode

set_expand:	mov	bl,8fh		; set expand mode
		int	10h		; video bios call
;
; restore the cursor information
;
		mov	ah,01h		; set cursor type
		mov	cx,exp_typ[bp]	; old type
		int	10h		; BIOS call

		call	psuedo_set	; psuedo setmode

		add	sp,exp_bp	; discard automatic
		pop	bp		; restore bp
		ret			; and return
_expand		endp
;-----------------------------------------------------------------------
;
;	hwexp()
;
;	Function:
;	   Turn hardware text expand on/off
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_hwexp		proc	near
		public	_hwexp

		call	_extstat	; get current status
		test	al,01h		; hwexp mode disabled ?
		mov	ax,1200h	; enable hwexp mode
		jnz	set_hwexp	; yes
		inc	ax		; disable hwexp mode

set_hwexp:	mov	bl,99h		; set hwexp mode
		int	10h		; video bios call

		ret			; and return
_hwexp		endp
;-----------------------------------------------------------------------
;
;	bold()
;
;	Function:
;	   Turn bold font on/off
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_bold		proc	near
		public	_bold

		call	_status		; get current status
		test	ah,20h		; bold mode disabled ?
		mov	ax,1200h	; enable bold mode
		jnz	set_bold	; yes
		inc	ax		; disable bold mode

set_bold:	mov	bl,8bh		; set bold mode
		int	10h		; video bios call

		call	psuedo_set	; psuedo setmode
		ret			; and return
_bold		endp
;-----------------------------------------------------------------------
;
;	automap()
;
;	Function:
;	   Turn automap on/off
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_automap	proc	near
		public	_automap

		call	_status		; get current status
		test	ah,10h		; automap mode disabled ?
		mov	ax,1200h	; enable automap mode
		jnz	set_automap	; yes
		inc	ax		; disable automap mode

set_automap:	mov	bl,8ch		; set automap mode
		int	10h		; video bios call

		ret			; and return
_automap	endp
;-----------------------------------------------------------------------
;
;	_con_enhance()
;
;	Function:
;	   Cycle through contract enhancement (attribute emulation)
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
con_code	db	00h		; assume enable attribute emu

_con_enhance   	proc	near
		public	_con_enhance

		mov	al,cs:con_code	; get current code
		inc	al		; next color
		cmp	al,04h		; > 5
		jbe	_ce_set		; nope
		sub	al,al

_ce_set:	mov	cs:con_code,al	; save new code
		mov	ah,12h		; extended alternate select
		mov	bl,8ch		; set contrast enhancement code
		int	10h		; video bios call

		ret			; and return
_con_enhance   	endp
;-----------------------------------------------------------------------
;
;	reverse()
;
;	Function:
;	   Turn reverse on/off
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_reverse	proc	near
		public	_reverse

		call	_status		; get current status
		test	ah,08h		; reverse mode disabled ?
		mov	ax,1200h	; enable reverse mode
		jnz	set_reverse	; yes
		inc	ax		; disable reverse mode

set_reverse:	mov	bl,89h		; set reverse mode
		int	10h		; video bios call

		ret			; and return
_reverse	endp
;-----------------------------------------------------------------------
;
;	greverse()
;
;	Function:
;	   Turn reverse graphics on/off
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_greverse	proc	near
		public	_greverse

		call	_user_status	; get current status
					; in ax, bx and cx (don't corrupt)
		call	_is_graphics	; graphics mode?
		jz	_tm		; nope

		; we are in graphics mode
;----------------------------------------
		test	ah,08h		; reverse text?
		jz	_gm_rt		; yes

		; in graphics mode, but reverse text disabled
		test	bl,80h		; reverse graphics?
		jz	_gm_rt_d	; yes
		mov	dx,1203h	; disable text, enable graphics
		jmp	short set_rev_x

_gm_rt_d:	; in graph mode, currently, reverse text is disabled and
		; reverse graphics is enabled 
		mov	dx,1201h	; disable text, disable graphics
		jmp	short set_rev_x

		

_gm_rt:		; in graphics mode, but reverse text enabled
		test	bl,80h		; reverse graphics?
		jz	_gm_rt_e	; yes
		mov	dx,1202h	; enable text, enable graphics
		jmp	short set_rev_x

_gm_rt_e:	; in graph mode, currently, reverse text is enabled and
		; reverse graphics is enabled too
		mov	dx,1200h	; enable text, disable graphics
		jmp	short set_rev_x


_tm:		; we are in text mode
;----------------------------------------
		test	bl,80h		; reverse graphics?
		jz	_tm_rg		; yes

		; in text mode, but reverse graphics is disabled
		test	ah,08h		; reverse text?
		jz	_tm_rg_d	; yes
		mov	dx,1200h	; enable text, disable graphics
		jmp	short set_rev_x

_tm_rg_d:	; in text mode, currently, reverse graphics is disabled
		; and reverse text is enabled too
		mov	dx,1201h	; disable text, disable graphics
		jmp	short set_rev_x

_tm_rg:		; in text mode, but reverse graphics is enabled
		test	ah,08h		; reverse text?
		jz	_tm_rg_e	; yes
		mov	dx,1202h	; enable text, enable graphics
		jmp	short set_rev_x

_tm_rg_e:	; in text mode, currently, reverse graphics is enabled
		; and reverse text is enabled too
		mov	dx,1203h	; disable text, enable graphics
		jmp	short set_rev_x
;----------------------------------------
		
set_rev_x:	mov	ax,dx		; get function call in ax
		mov	bl,89h		; set reverse graphics mode
		int	10h		; video bios call

		ret			; and return
_greverse	endp
;-----------------------------------------------------------------------
;
;	is_graphics()
;
;	Function:
;	   
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_is_graphics	proc	near
		public	_is_graphics

		push	dx
		push	ax		; save ax and dx
		mov	dx,3ceh		; graphics controller

;** FS4.0 bug 11-05-91
;***		save graphics index

		in	al,dx		; get index
		push	ax		; save it

		mov	al,6		; miscellaneous
		out	dx,al
		inc	dx	
		in	al,dx
		test	al,01h		; enable graphics mode?

;***		restore graphics index
		mov	dx,3ceh
		pop	ax
		out	dx,al		; done

		pop	ax
		pop	dx		; restore dx and ax

		ret			; and return
_is_graphics	endp
;-----------------------------------------------------------------------
;
;	fcursor()
;
;	Function:
;	   Turn full cursor on/off
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_fcursor	proc	near
		public	_fcursor

		call	_user_status	; get current status
		test	bh,04h		; full cursor mode disabled ?
		mov	ax,1200h	; enable full cursor mode
		jnz	set_fcursor	; yes
		inc	ax		; disable full cursor mode

set_fcursor:	mov	bl,97h		; set full cursor mode
		int	10h		; video bios call

		ret			; and return
_fcursor	endp
;-----------------------------------------------------------------------
;
;	fontload()
;
;	Function:
;	   Inhibit font load
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_fontload	proc	near
		public	_fontload

		call	_user_status	; get current status
		test	bh,08h		; inhibit font load disabled ?
		mov	ax,1200h	; enable inhibit font load
		jnz	set_fontload	; yes
		inc	ax		; disable inhibit font load

set_fontload:	mov	bl,96h		; inhibit font load
		int	10h		; video bios call

		ret			; and return
_fontload	endp
;-----------------------------------------------------------------------
;
;	center()
;
;	Function:
;	   Cycle through centering options.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_center		proc	near
		public	_center

		test	chip_type,GD62XX ; is GD62x5?
		jz	tbs			; nope, top, bottom and center supported
		call	_status		; get current status
		and	al,01h		; just centering bit
		xor	al, 01h		; flip the option
		jmp short set_center

tbs:	call	_status		; get current status
		and	al,03h		; just centering bits
		sub	al,1		; previous centering option
		jns	set_center	; not past auto center
		mov	al,2		; last one
		
set_center:	mov	ah,12h		; extended alternate select
		mov	bl,90h		; set centering mode
		int	10h		; video bios call

		ret			; and return
_center		endp
;-----------------------------------------------------------------------
;
;	fix720()
;
;	Function:
;	   Cycle through 720 dot fix up options.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_fix720		proc	near
		public	_fix720

		call	_status		; get current status
		shr	ax,1		; move fix 720
		shr	ax,1		;    bits to bits 0 and 1
		inc	ax		; next 720 fix up option
		and	al,03h		; just 720 fix up bits, mod 4

set_720:	mov	ah,12h		; extended alternate select
		mov	bl,91h		; set 720 dot fix up mode
		int	10h		; video bios call

		ret			; and return
_fix720		endp
;-----------------------------------------------------------------------
;
;	frame()
;
;	Function:
;	   Cycle through frame color options.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
fr_color	db	0fh		; assume white

_frame		proc	near
		public	_frame

		mov	al,cs:fr_color	; get current color
		inc	al		; next color
		and	al,0fh		; 0 -> 15
		mov	cs:fr_color,al	; save frame color

		mov	ah,12h		; extended alternate select
		mov	bl,8ah		; set frame color
		int	10h		; video bios call

		ret			; and return
_frame		endp
;-----------------------------------------------------------------------
;
;	rgb_wt()
;
;	Function:
;	   Cycle through RGB weighting options.
;
;		al: weighting code (total options = 3! = 6)
;		    code	R G B
;		    ----	- - -
;		       0	2 5 9
;		       1	5 2 9
;		       2	2 9 5
;		       3	5 9 2 
;		       4	9 2 5
;		       5	9 5 2 -> starting weight (default)
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
rgb_code	db	05h		; assume normal weight

_rgb_wt		proc	near
		public	_rgb_wt

		mov	al,cs:rgb_code	; get current code
		inc	al		; next color
		cmp	al,05h		; > 5
		jbe	_rw_set		; nope
		sub	al,al

_rw_set:	mov	cs:rgb_code,al	; save new code
		mov	ah,12h		; extended alternate select
		mov	bl,95h		; set rgb weighting code
		int	10h		; video bios call

		ret			; and return
_rgb_wt		endp
;-----------------------------------------------------------------------
;
;	graphics_wt()
;
;	Function:
;	   Cycle through graphics grey shading options.
;
;		al: 0 = NTSC shading
;			1 = Green output only
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
gra_code	db	00h		; assume NTSC shading

_graphics_wt		proc	near
		public	_graphics_wt

		mov	al,cs:gra_code	; get current code
		inc	al		; next color
		cmp	al,01h		; > 1
		jbe	_gra_rw_set		; nope
		xor	al,al

_gra_rw_set:	mov	cs:gra_code,al	; save new code
		mov	ah,12h		; extended alternate select
		mov	bl,95h		; set rgb weighting code
		int	10h		; video bios call

		ret			; and return
_graphics_wt		endp
;-----------------------------------------------------------------------
;
;	text_wt()
;
;	Function:
;	   Cycle through text grey shading options.
;
;		al: 0 = NTSC shading
;			1 = Green output only
;			2 = Direct mapping
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
txt_code	db	00h		; assume NTSC

_text_wt		proc	near
		public	_text_wt

		mov	al,cs:txt_code	; get current code
		inc	al		; next color
		cmp	al,02h		; > 2
		jbe	_txt_rw_set		; nope
		xor	al,al

_txt_rw_set:	mov	cs:txt_code,al	; save new code
		mov	ah,12h		; extended alternate select
		mov	bl,98h		; set text grey shading
		int	10h		; video bios call

		ret			; and return
_text_wt		endp
;-----------------------------------------------------------------------
;
;	p_power()
;
;	Function:
;	   Enable/Disable low panel power usage
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_p_power		proc	near
		public	_p_power

		call	_status		; get current status
		test	al,80h		; panel power usage at normal?
		mov	ax,1200h	; extended function call
		jnz	low_freq	; yes
		inc	ax		; use normal frequency

low_freq:	mov	bl,9dh		; set panel frequency
		int	10h		; video bios call

		ret			; and return
_p_power	endp
;-----------------------------------------------------------------------
;
;	power()
;
;	Function:
;	   Put the system into/out of power save mode.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;	   We maintain the current status locally, but this function
;	is special in that it only shuts down the system.  The wake
;	call comes from ANY keyboard activity.
;
;-----------------------------------------------------------------------
awake		db	0		; assume awake

_power		proc	near
		public	_power

		mov	al,1		; shut down - standby mode
_power_set:	
public _power_set
		test	chip_type,GD64XX ; is GD6410 compat?
		jz	@f		; nope
		test	chip_type,GD62XX ; is GD62x5 compat?
		jz	@f		; nope

;		test	chip_type,GD6440 ; is GD6440 compat?
;		jz	@f		; nope
		test    chip_type,GD6440 ; GD6440?
		jnz     _p_nop          ; skip standby/suspend for GD6440

		push	ax		; save ax
		call	_status
		test	ah,01h		; panel mode?
		pop	ax
		jz	@f		; yes, go ahead
		call	_beep
;		jmp	short _p_nop	; NOP here
_power_on:
public _power_on
@f:
		mov	cs:awake,al	;  Save current power status
						;	0 = Awake
						;	1 = stand by
						;	2 = suspend
		mov	bx,94h		; set power save (bh=0, Clear time interval)
		mov	ah,12h		; extended alternate select
		int	10h		; video BIOS call

_p_nop:		ret			; and return
_power		endp

;-----------------------------------------------------------------------
;
;	suspend()
;
;	Function:
;	   Put the system into/out of suspend mode.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;	   We maintain the current status locally, but this function
;	is special in that it only shuts down the system.  The wake
;	call comes from ANY keyboard activity.
;
;-----------------------------------------------------------------------
_suspend	proc	near
		public	_suspend

		mov	al,2		; suspend mode
		jmp	short _power_set

_suspend	endp
;-----------------------------------------------------------------------
;
;	_beep()
;
;	Function:
;	   Sound the speaker.
;
;	Input:
;
;	Returns:
;
;-----------------------------------------------------------------------
_beep		proc	near
		public	_beep

		push	ax		; save ax
		push	cx		; cx

		mov	al,0b6h		; timer 2, lsb 1st, mode 3
		out	43h,al		; square wave generator

		mov	ax,533h		; count -> 894 Hz
		jmp	$ + 2
		out	42h,al		; lo byte of count
		mov	al,ah
		jmp	$ + 2
		out	42h,al		; hi byte of count

		in	al,61h		; 8255 control port
		mov	ah,al		; save it ah
		or	al,3		; speaker gated by timer
		jmp	$ + 2
		out	61h,al		; turn on the speaker

		xor	cx,cx
b_wait:		loop	b_wait

		mov	al,ah
		out	61h,al		; restore control port

		pop	cx
		pop	ax		; restore
		ret

_beep		endp
;-----------------------------------------------------------------------
;
;	psscan()
;
;	Function:	   toggle on/off simulscan for GD610/620 + GD6340
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_psscan		proc	near
		public	_psscan

		push	dx		; save dx
		call	_status		; get the current status
		mov	dx,ax		; save status in dx
		test	bh,40h		; simulscan on?
		mov	ax,1202h	; enable it
		jz	pss_00		; yes

		mov	ax,1201h	; assume from crt mode
		test	dh,01h		; crt mode?
		jnz	pss_00		; yes
		dec	al		; from panel mode

pss_00:		pop	dx		; restore dx
		mov	bl,92h		; set display type
		int	10h		; done

		ret
_psscan		endp
;-----------------------------------------------------------------------
;
;	crt_lcd()
;
;	Function:
;	   Switch to the other display.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
crt_frame	struc
	opts_hi	db	?		; hi byte of user options
	opts_lo	db	?		; lo byte of user options
	vga_inf	db	?		; saved 40:89 value
	gr5	db	?		; graphics controller mode register
	cur_pos	dw	?		; cursor position
	cur_typ	dw	?		; cursor type
	crt_bp	dw	?		; caller's bp
	crt_ds	dw	?		; caller's ds
	crt_ip	dw	?		; caller's ip
crt_frame	ends

_crt_lcd	proc	near
		public	_crt_lcd

		push	ds		; save caller's ds
		push	bp		; save caller's bp
		sub	sp,crt_bp	; make space for automatics
		mov	bp,sp		; base of stack frame

;
; preserve graphics controller index
; - fix lcd/crt switch while running MS flight simulator 4.0 :10/30/91
;
		mov	dx,3ceh		; gr index
		in	al,dx
		push	ax
		push	dx

		call	_status		; get the current status
		mov	opts_hi[bp],ah	; save hi byte
		mov	opts_lo[bp],al	; save lo byte
;
; save BIOS lo ram configuration
;
		mov	ax,40h		; bios data segment
		mov	ds,ax		; into ds
		assume	ds:bios_data	; and tell the assembler

		mov	al,vga_info	; get lo ram value
		mov	vga_inf[bp],al	; save it locally
;
; save the cursor type and position
;
		mov	ah,0fh		; get current display page
		int	10h		; BIOS call
		mov	ah,03h		; get cursor information
		int	10h		; BIOS call
		mov	cur_typ[bp],cx	; save cursor type
		mov	cur_pos[bp],dx	; save cursor position

		mov	ah,12h		; alternate select
		mov	al,opts_hi[bp]	; get the hi byte of options
		and	al,01h		; just the display bit
		xor	al,01h		; toggle the display
		mov	bl,92h		; switch the display
		int	10h		; BIOS call
		
;
; restore the cursor information
;
		mov	ah,02h		; set cursor position
		mov	dx,cur_pos[bp]	; old position
		int	10h		; BIOS call (bh has active page)
		mov	ah,01h		; set cursor type
		mov	cx,cur_typ[bp]	; old type
		int	10h		; BIOS call (bh has active page)
;
; restore BIOS data
;
		mov	al,vga_inf[bp]	; get old vga config
		mov	vga_info,al	; restore it

		call	psuedo_set	; psuedo setmode
;
; restore graphics controller index
;
		pop	dx
		pop	ax
		out	dx,al

cl_exit:	add	sp,crt_bp	; discard automatics
		pop	bp		; restore caller's bp
		pop	ds		; restore caller's ds
		ret			; and return
_crt_lcd	endp
page
;-----------------------------------------------------------------------
;
;	crt_lcd_simul()
;
;	Function:
;	   Switch to the other display.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
stxx	db	00h

crt2_frame	struc
	vga_inf2 db	?		; saved 40:89 value
	gr52	 db	?		; graphics controller mode register
	cur_pos2 dw	?		; cursor position
	cur_typ2 dw	?		; cursor type
	crt_bp2  dw	?		; caller's bp
	crt_ds2	 dw	?		; caller's ds
	crt_ip2	 dw	?		; caller's ip
crt2_frame	ends

_crt_lcd_simul	proc	near
		public	_crt_lcd_simul

		push	ds		; save caller's ds
		push	bp		; save caller's bp
		sub	sp,crt_bp	; make space for automatics
		mov	bp,sp		; base of stack frame

;
; preserve graphics controller index
; - fix lcd/crt switch while running MS flight simulator 4.0 :10/30/91
;
		mov	dx,3ceh		; gr index
		in	al,dx
		push	ax
		push	dx

; save BIOS lo ram configuration
;
		mov	ax,40h		; bios data segment
		mov	ds,ax		; into ds
		assume	ds:bios_data	; and tell the assembler

		mov	al,vga_info	; get lo ram value
		mov	vga_inf2[bp],al	; save it locally
;
; save the cursor type and position
;
		mov	ah,0fh		; get current display page
		int	10h		; BIOS call
		mov	ah,03h		; get cursor information
	     	int	10h		; BIOS call
		mov	cur_typ2[bp],cx	; save cursor type
		mov	cur_pos2[bp],dx	; save cursor position
;
; query video mode availability
;
		mov	ax,1203h	; pick video mode 3
		mov	bl,0a0h		; query video mode
		int	10h	

		mov	cs:stxx,ah

		shr	ah,1		; CRT/PANEL bits
		and	ah,03h		; only bits 0-1
		xor	ah,03h		; LCD -> CRT -> SimulSCAN -> LCD..
					;  10 ->  01 -> 11 (bit pattern)
					;       xor 03h
					;  1  ->   2 ->  0 (display mode parm)

		mov	al,12h		; alternate select
		xchg	ah,al		; swap

		; no inquiry function implemented in pray
		test	chip_type,GD6440 ; is GD6440
		jz	cls_doit	; nope, skip the checking
		test	chip_type,GD64XX ; is GD64xx?
		jz	cls_doit	; nope, try 62XX
		test	chip_type,GD62XX ; is GD62x5?
		jz	cls_doit	; nope, skip the checking

		push	ax		; save it
		mov	bl,92h		; switch the display
		or	al,80h		; inquiry first
		int	10h		; BIOS call

;****		or	al,al		; supported?
		cmp	al,0ffh
		pop	ax		; get argument back
		jnz	not_suppp	; nope
;*** uncomment this line if BIOS support inquiry mechanism
;***
cls_doit:
		mov	bl,92h		; switch display
		int	10h		; real operation
		jmp	short ok_cls
not_suppp:
		mov	al,cs:stxx
		shr	al,1
		and	al,03h
		shr	al,1
		mov	bl,92h
		int	10h

ok_cls:
;****		mov	al,05h		; mode register
;****		mov	ah,gr52[bp]	; saved value
;****		out	dx,ax		; restore original value
;
; restore the cursor information
;
		mov	ah,02h		; set cursor position
		mov	dx,cur_pos2[bp]	; old position
		int	10h		; BIOS call (bh has active page)
		mov	ah,01h		; set cursor type
		mov	cx,cur_typ2[bp]	; old type
		int	10h		; BIOS call (bh has active page)
;
; restore BIOS data
;
		mov	al,vga_inf2[bp]	; get old vga config
		mov	vga_info,al	; restore it

;*		call	psuedo_set	; psuedo setmode

;
; restore graphics controller index
;
		pop	dx
		pop	ax
		out	dx,al

cls_exit:	add	sp,crt_bp	; discard automatics
		pop	bp		; restore caller's bp
		pop	ds		; restore caller's ds
		ret			; and return
_crt_lcd_simul	endp
page
;-----------------------------------------------------------------------
;
;	status()
;
;	Function:
;	   Return the current options status.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   ax = the user options word
;
;-----------------------------------------------------------------------
_status		proc	near
		public	_status

		test	chip_type,GD64XX ; is GD64XX?
		jnz	user_stat	; yes
		test	chip_type,GD62XX ; is GD62X5?
		jnz	user_stat	; yes
                                        ; GD6440 supports inquire 84

		mov	ah,12h		; alternate select
		mov al,0h
		mov	bl,84h		; inquire options
		int	10h		; BIOS call

		ret			; and return
_status		endp
page
;-----------------------------------------------------------------------
;
;	user_status()
;
;	Function:
;	   Return the current user options status.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   ax = the user options word
;
;-----------------------------------------------------------------------
_user_status  	proc	near
		public	_user_status
user_stat:
		mov	ah,12h		; alternate select
		mov al, 0h
		mov	bl,9ah		; inquire user options
		int	10h		; BIOS call

		ret			; and return
_user_status  	endp
page
;-----------------------------------------------------------------------
;
;	extstat()
;
;	Function:
;	   Return the current extend option .
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   ax = the extend user options word
;
;-----------------------------------------------------------------------
_extstat     	proc	near
		public	_extstat

		mov	ah,12h		; alternate select
		mov	bl,98h		; inquire options
		int	10h		; BIOS call

		ret			; and return
_extstat      	endp
page
;-----------------------------------------------------------------------
;
;	is_simul()
;
;	Function:
;	   Check if simulscan on or not
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   zero flag clear: simulscan on
;	   zero flag set  : simulscan off
;
;-----------------------------------------------------------------------
_is_simul    	proc	near
		public	_is_simul

		call	_status		; get current status
		test	chip_type,GD6440 ; is GD6440?
		jnz	_is_user_stat	; yes
		test	chip_type,GD64XX ; is GD64XX?
		jnz	_is_user_stat	; yes
		test	chip_type,GD62XX ; is GD62XX?
		jnz	_is_user_stat	; yes

		xor	bh,40h		; toggle it
		test	bh,40h		; is simulSCAN on?
		jmp	short _is_exit

_is_user_stat:	test	bh,02h		; is simulSCAN on?
_is_exit:
		ret			; and return
_is_simul      	endp
page
;-----------------------------------------------------------------------
;
;	psuedo_set()
;
;	Function:
;	   Perform a psuedo set mode so that other TSR's sitting
;	on the int 10h chain have a chance to perform their
;	functions.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;-----------------------------------------------------------------------
psuedo_set	proc	near
		public	psuedo_set

		test	chip_type,GD6440 ; is GD6440?
		jnz	ps_exit		; yes
		test	chip_type,GD64XX ; is GD64XX?
		jnz	ps_exit		; yes
		test	chip_type,GD62XX ; is GD62X5?
		jnz	ps_exit		; yes
		test	cs:st_rev,REV_C	; is GD610/620 RevC
		jnz	ps_exit		; yes

		mov	dx,3c4h		; extensions
		mov	al,0bfh		; scratch pad
		out	dx,al		; set index
		inc	dx		; point to data
		in	al,dx		; read data
		push	ax		; save the data
		or	al,80h		; ignore set modes
		out	dx,al		; and back out

		mov	ah,0fh		; get mode
		int	10h		; bios call
		xor	ah,ah		; set mode
		int	10h		; bios call

		mov	dx,3c4h		; extensions
		mov	al,0bfh		; scratch pad
		out	dx,al		; set index
		inc	dx		; point to data
		pop	ax		; old data
		and	al,7fh		; clear bit 7
		out	dx,al		; and back out
ps_exit:
		ret			; and return
psuedo_set	endp
page
;---------------------------------------------------------------------
;
;	newisr_15()
;
;	Function:
;	   Perform int 15 service
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing
;
;	Remarks:
;	   The BIOS data area is used to track the shift key status.
;	Keyboard interrupts that do not belong to us are passed through
;	to the next keyboard handler, and those that do belong to us
;	are not passed through.  Break codes are also passed through
;	to the next keyboard handler.
;
;---------------------------------------------------------------------

save_ss		dw	?		; interrupted ss
save_sp		dw	?		; interrupted sp

		db	'Copyright Cirrus Logic Inc, 1989-1993.  All rights reserved.'
		dw	ID_WORD		; id word
_newisr_15 	proc	far
		public	_newisr_15

		push	ax		; save interrupted ax
		push	ds		; save interrupted ds

		cmp	ah,4fh		; from isr 09? Keyboard Interupt handler?
		jne	pass_thru	; nope

		push	bx
		mov	bx,40h		; BIOS data segment
		mov	ds,bx		; into ds
		pop	bx

		assume	ds:bios_data	; and tell the assembler
		mov	ah,kb_flag	; get shift status 40:17

		cmp	byte ptr cs:awake,0	; are we shut down? standby or suspend?
		je	chk_kbstat 	; nope

		test	ah,04h	 	; ctrl state?
		jnz	pass_thru	; yup
		test	ah,03h		; shift state?
		jnz 	pass_thru	; yup

		mov	al,0		; clear AL.  Disable power save modes
		push	bx
		sti
		call	_power_on	; and wake up
		cli
		pop	bx
		jmp	short pass_thru

chk_kbstat:	test	ah,04h		; ctrl state ?
		jz	pass_thru	; nope
		test	ah,03h		; shift state ?
		jnz	chk_func	; yes

pass_thru:	pop	ds		; restore ds
		pop	ax		; restore ax
		jmp	cs:isr15	; and give up the cpu

chk_func:	sti			; enable interrupts
		xchg	al,ah		; save al in ah
		push	si		; save si
		mov	si,cs		; our code segment
		mov	ds,si		; and data segment
		assume	ds:_text	; and tell the assembler
		mov	si,chip_funcptr ; ds:si point to function table

		push	cx		; save cx
		mov	cl,chip_fc	; set up count
		sub	ch,ch
i15_loop:	lodsb
		cmp	al,ah		; right scan code?
		jz	assigned
		inc	si
		inc	si		; skip a word
		loop	i15_loop

		pop	cx		; restore cx
		pop	si		; restore bx
		pop	ds		; restore ds
		pop	ax		; restore ax
		jmp	cs:isr15	; and give up the cpu

assigned:	
public assigned
;
; here because one of our keys has been pressed
;


		dec	running		; set and test reentrancy lock
		jnz	isr_15_done	; already running

		push	es		; save interrupted es
		mov	save_ss,ss	; save interrupted ss
		mov	save_sp,sp	; save interrupted sp
		mov	ax,cs		; our code segment
		mov	es,ax		;    is the extra segment
		mov	ss,ax		;    and the stack segment
		mov	sp,offset _start; re-use the psp

		push	dx
		push	di
		call	[si] 		; call the function
		pop	di
		pop	dx

		mov	ss,save_ss	; restore interrupted ss
		mov	sp,save_sp	; restore interrupted sp
		pop	es		; restore interrupted es

isr_15_done:	inc	running		; reset reentrancy lock
		pop	cx		; restore bx
		pop	si		; and si
		pop	ds		; restore ds
		pop	ax		; restore ax
isr_15_exit:	clc			; clear carry flag
					;  indicates we "swallowed the key"
		retf	2		; return to caller
_newisr_15  	endp
page
;-----------------------------------------------------------------------
;
;	dswitch()
;
;	Function:
;	   Toggle active/inactive VGAs.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;	   This function toggles the active and inactive VGA (mother
;	board and adapter VGA) using the BIOS alternate select, display
;	switch functions.
;
;-----------------------------------------------------------------------
_dswitch	proc	near
		public	_dswitch

		cmp	int10_busy,0	; video bios free ?
		jz	_ds_ready	; yes

		inc	ds_pending	; set the pending flag
		jmp	short _ds_done	; and return

_ds_ready:	mov	ax,1202h	; active video off
		mov	bl,35h		; display switch
		mov	dx,_act_vgabuf	; active data area
		int	10h		; video bios call

		mov	ax,1203h	; inactive video on
		mov	bl,35h		; display switch
		xchg	dx,_alt_vgabuf	; inactive data area
		int	10h		; video bios call

		mov	_act_vgabuf,dx	; active data area
_ds_done:	ret			; and return
_dswitch	endp

_act_vgabuf	dw	_vgabuf1	; active vga's buffer
_alt_vgabuf	dw	_vgabuf2	; inactive vga's buffer

_vgabuf1	db	80h dup (?)	; display switch buffer
_vgabuf2	db	80h dup (?)	; display switch buffer
page
;-----------------------------------------------------------------------
;
;	isr_10()
;
;	Function:
;	   Monitor int 10 traffic.
;
;	Input:
;	   Per video bios spec.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;	   Sets and clears a busy flag on the active video bios so
;	that we do not tell the video system to go to sleep while
;	it is running.
;
;-----------------------------------------------------------------------
ds_pending	db	0	; != 0 want to do a display switch
int10_busy	db	0	; 0 = idle

_newisr_10   	proc	far
		public	_newisr_10

		inc	cs:int10_busy	; raise entrance count
		pushf			; flags plus a far call
		call	cs:isr10	;    == an interrupt

		dec	cs:int10_busy	; done with last int 10 call ?
		jnz	isr_10done	; nope

		cmp	cs:ds_pending,0	; display switch pending ?
		je	isr_10done	; nope
;
; here because we wanted to do a display switch while the video
; bios was running, and its not running now
;
		dec	cs:running	; set entrance lock

		push	ax		; save caller's registers
		push	bx
		push	dx
		push	es
		push	ds

		mov	ax,cs		; our code segment
		mov	ds,ax		;   is our data segment
		assume	ds:_text	; and tell the assembler
		mov	es,ax		;   and our extra segment
		assume	es:_text	; and tell the assembler

		dec	ds_pending	; we're doing the switch
		call	_dswitch	; do the switch

		pop	ds		; restore caller's registers
		pop	es
		pop	dx
		pop	bx
		pop	ax
		inc	cs:running	; clear entrance lock
isr_10done:	iret			; and back to caller
_newisr_10 	endp
page
;-----------------------------------------------------------------------
;
;	init()
;
;	Function:
;	   Init vectors and tsr.
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;
;-----------------------------------------------------------------------
_init		proc	near
		public	_init
;
; print title and copyright message
;
		lea	dx,init_msg	; copyright message
		mov	ah,09h		; DOS print string
		int	21h		; DOS call

;
; check for panel support
;
chk_panel:	mov	ah,12h		; alternate select
		mov al,0h
		mov	bl,80h		; inquire vga type
		int	10h		; video bios call

		test	ah,0c0h		; LCD or Plasma panel support ?
							; to also test for EL panel change to 0d0h
		jz	chk_dswitch	; nope
		or	env_flags,1	; C000 panel support
;
; initialize chip-specific data in C000
;
		call	_init_chip
;
; check for display switch support
;
chk_dswitch:	mov	ax,1200h	; initial adapter video off
		mov	bl,35h		; display switch
		mov	dx,_alt_vgabuf	; active vga's buffer
		int	10h		; video bios call

		cmp	al,12h		; display switch supported ?
		jne	no_dswitch	; nope
		or	env_flags,80h	; display switch support

		mov	ax,1201h	; initial planar video on
		mov	bl,35h		; display switch
		mov	dx,_act_vgabuf	; inactive vga's buffer
		int	10h		; video bios call

		test	env_flags,1	; C000 panel support
		jnz	sw_back		; yes, skip initialize E000

		mov	ah,12h		; alternate select
		mov al,0h
		mov	bl,80h		; inquire vga type
		int	10h		; video bios call
		test	ah,0c0h		; panel support ?
		jz	sw_back		; nope
		or	env_flags,2	; E000 panel support
;
; initialize chip-specific data in C000
;
		call	_init_chip

sw_back:	call	_dswitch	; toggle active vga's back

no_dswitch:	mov	al,env_flags	; environment flags
		test	al,80h		; display switch ?
		jz	null_dsk	; nope

		; display switch is supported here
		test	env_flags,3	; C000 or E000 panel support?
		jnz	chk_load	; yes

		; here we take care of display-switch-only function
		mov	chip_fc,only_count ; set up count
		mov	ax,offset only_dsk ; set up function table
		mov	chip_funcptr,ax
		jmp	short chk_load

null_dsk:
		mov	revb_dsk,0	; disable display switch hot key
		mov	revc_dsk,0	; disable display switch hot key
		mov	revcp_dsk,0	; disable display switch hot key
		mov	raven_dsk,0	; disable display switch hot key
		mov	term_dsk,0	; disable display switch hot key
		mov	macaw_dsk,0	; disable display switch hot key

chk_load:	mov	al,env_flags	; environment flags
		or	al,al		; anything to do ?
		jnz	load_tsr	; yes

		mov	ah,09h		; DOS print string
		lea	dx,fail_msg	; failure message
		int	21h
		jmp	short abort	; exit
;
; make this instance resident
;
load_tsr: 	mov	ah,35h		; get interrupt vector
		mov	al,15h		; interrupt 15h
		int	21h		; call DOS

		mov	ax,es		; 
		mov	isr15_seg,ax	; int 15 segment
		mov	isr15_off,bx	; int 15 offset

		cmp	es:[bx-2],ID_WORD ; previously installed?
		jne	chk_supp_sw	; nope

		mov	dx,offset prev_msg
		mov	ah,09h		; display string
		int	21h		; call DOS

abort:		mov	al,env_flags	; environment flags
		call	prt_keys	; print supported keys

		mov	ax,4c01h	; exit with errorlevel 1
		int	21h		; and terminate

chk_supp_sw:	test	cs:env_flags,80h; supporting display switch ?
		jz	load_done	; nope

		mov	ah,35h		; get interrupt vector
		mov	al,10h		; interrupt 10h
		int	21h		; call DOS

		mov	ax,es		; 
		mov	isr10_seg,ax	; int 10 segment
		mov	isr10_off,bx	; int 10 offset

		push	cs
		pop	ds
		mov	ah,25h		; set interrupt vector
		mov	al,10h		; interrupt 10h
		lea	dx,_newisr_10	; offset
		int	21h		; call DOS

load_done:	assume	ds:_text	; and tell the assembler

		push	cs
		pop	ds
		mov	ah,25h		; set interrupt vector
		mov	al,15h		; interrupt 15h
		lea	dx,_newisr_15	; offset
		int	21h		; call DOS

		xor	ax,ax		; no environment segment
		xchg	ax,cs:[2ch]	; segment of envirnment
		mov	es,ax		;    into es
		mov	ah,49h		; free allocated memory
		int	21h		; free our environment

		mov	al,env_flags	; environment flags
		call	prt_keys	; print the keys

		lea	dx,_dswitch	; no display switch support
		test	env_flags,80h	; supporting display switch ?
		jz	_init_done	; nope
		lea	dx,_init	; support display switch
_init_done:	int	27h		; terminate resident
_init		endp
;-----------------------------------------------------------------------
;
;	init_chip()
;
;	Function:
;	   Init chip-specific field
;
;	Input:
;	   Nothing.
;
;	Returns:
;	   Nothing.
;
;	Remarks:
;	   ONLY this routine and related data structure will be changed 
;	    to support future chipsets.
;
;-----------------------------------------------------------------------
_init_chip	proc	near
		public	_init_chip
;
; inquire VGA type
;
		mov	ah,12h		; alternate select
		mov al,0h
		mov	bl,80h		; inquire vga type
		int	10h		; video bios call
;
; check chipset, Stingray or Raven, Raven+Peacock, Terminator, Macaw?
;
 		; added to support GD6440 at 06-24-93
		cmp	al,040h		; Macaw?
		jz	is_macaw        ; yup
 		; added to support GD62x5 at 01-13-93
		cmp	al,020h		; T1?
		jz	is_term		; yup
		cmp	al,021h		; T2?
		jz	is_term		; yup
		cmp	al,022h		; T3?
		jz	is_term		; yup
		cmp	al,023h		; Orion? 08-03-93
		jz	is_term		; yup, and equal to Terminator

 		; added to support GD6416 at 01-13-93
		cmp	al,9		; 6416?
		jz	range_gdxx  	; yup

 		; added to support GD6412 at 01-13-93
		cmp	al,8		; 6412?
		jz	range_gdxx  	; yup

 		; added to support GD6420 at 01-09-92
		cmp	al,7		; Raven II?
		jz	range_gdxx  	; yup

		cmp	al,5		; Raven?
		jz      range_gdxx  	; yup

		jmp	chk_revision	; nope, is Stingray


range_gdxx:
		jmp	is_gdxx         ; nope, is Stingray

; we got GD6440
is_macaw:
; GD6440 OEM SPECIFIC CAPABILITIES.
; Some Configurations with Color Panels may not desire
; options such as Bold or Reverse Video.
; Some panels types such as C512ss do not support reverse
; video.  Use this area to remove specific capabilities
; from this program to support your configuration.
; REMOVE by commenting out "OR", and uncommenting "MOV"
		or	cap_stat,SIMUSC_SUPP ; enable simulscan support
;		mov	MACAW_SIMUL,0

		or	cap_stat,VERT_ALIGN_SUPP ; enable vertical alignment
;		mov	MACAW_CENT,0

		or	cap_stat,EXPAND_SUPP ; expand mode support
;		mov	MACAW_EXP,0

		or	cap_stat,ATTR_EMUL_SUPP ; Contrast Enhancement support
;		mov	MACAW_ATTR,0

		or	cap_stat,BOLD_SUPP ; enable bold font support
;		mov	MACAW_BOLD,0

		or	cap_stat,REV_SUPP ; enable reverse video support
;		mov	MACAW_REV,0

; OEM, Please do not edit the following entries
		or	chip_type,GD6440 ; GD6440 installed
		mov	chip_fc,macaw_count ; set up count
		mov	ax,offset macaw_funcptr ; set up function table
		mov	chip_funcptr,ax
		mov	ax,offset macaw_msg ; set up signon message
		mov	chip_msg,ax
		jmp	ic_exit

; we got GD62x5
is_term:
; GD62X5 (includes GD6235) OEM SPECIFIC CAPABILITIES.
; Some Configurations with Color Panels may not desire
; options such as Bold or Reverse Video.
; Some panels types such as C512ss do not support reverse
; video.  Use this area to remove specific capabilities
; from this program to support your configuration.
; REMOVE by commenting out "OR", and uncommenting "MOV"
		or	cap_stat,SIMUSC_SUPP ; enable simulscan support
;		mov	TERM_SIMUL,0

		or	cap_stat,VERT_ALIGN_SUPP ; enable vertical alignment
;		mov	TERM_CENT,0

		or	cap_stat,EXPAND_SUPP ; expand mode support
;		mov	TERM_EXP,0

		or	cap_stat,ATTR_EMUL_SUPP ; enable Black and White enhancement
;		mov	TERM_ATTR,0

		or	cap_stat,BOLD_SUPP ; enable bold font support
;		mov	TERM_BOLD,0

		or	cap_stat,REV_SUPP ; enable reverse video support
;		mov	TERM_REV,0

		or	cap_stat,RGB_SUPP ; enable text and graphics grey shading support
;		mov TERM_TXT,0
;		mov TERM_GRA,0

; OEM, Please do not edit the following entries
		or	chip_type,GD62XX ; GD62X5 installed
		mov	chip_fc,term_count ; set up count
		mov	ax,offset term_funcptr ; set up function table
		mov	chip_funcptr,ax
		mov	ax,offset term_msg ; set up signon message
		mov	chip_msg,ax
		jmp	ic_exit

; we got Raven here
is_gdxx:
; GD64XX OEM SPECIFIC CAPABILITIES.
; Some Configurations with Color Panels may not desire
; options such as Bold or Reverse Video.
; Use this area to remove specific capabilities
; from this program to support your configuration.
; REMOVE by commenting out "OR", and uncommenting "MOV"
		or	cap_stat,SIMUSC_SUPP ; enable simulscan support
;		mov	RAV_SIMUL,0

		or	cap_stat,VERT_ALIGN_SUPP ; enable vertical alignment
;		mov	RAV_CENT,0

		or	cap_stat,EXPAND_SUPP ; expand mode support
;		mov RAV_EXP,0

		or	cap_stat,ATTR_EMUL_SUPP ; Contrast Enhancement support
;		mov RAV_ATTR,0

		or	cap_stat,BOLD_SUPP ; enable bold font support
;		mov RAV_BOLD,0

		or	cap_stat,REV_SUPP ; enable reverse video support
;		mov RAV_REV,0

		or	cap_stat,RGB_SUPP ; enable RGB weighting support
;		mov RAV_RGB,0

; OEM, Please do not edit the following entries
		or	chip_type,GD64XX ; GD6410 compatible installed
		mov	chip_fc,raven_count ; set up count
		mov	ax,offset raven_funcptr ; set up function table
		mov	chip_funcptr,ax
		test	ah,02h		; GD6340 (Peacock) attached?
;		jnz	peavan		; yes
		jz	peavan		; no - use peavan for debugging
		mov	ax,offset raven_msg ; set up signon message
		mov	chip_msg,ax
		jmp	ic_exit
peavan:
; GD6340 + GD64XX OEM SPECIFIC CAPABILITIES.
; This section only valid when configuration is using GD6340
;
; Some Configurations with Color Panels may not desire
; options such as Bold or Reverse Video.
; Some panels types such as C512ss do not support reverse
; video.  Use this area to remove specific capabilities
; from this program to support your configuration.
; REMOVE by changing "OR" to "XOR", and uncommenting the "mov"
		or	cap_stat,SIMUSC_SUPP ; enable simulscan support
;		mov	RAV_SIMUL,0

		or	cap_stat,VERT_ALIGN_SUPP ; enable vertical alignment
;		mov	RAV_CENT,0

		or	cap_stat,EXPAND_SUPP ; expand mode support
;		mov RAV_EXP,0

		or	cap_stat,ATTR_EMUL_SUPP ; Contrast Enhancement support
;		mov RAV_ATTR,0

		or	cap_stat,BOLD_SUPP ; enable bold font support
;		mov RAV_BOLD,0

; Reverse video is disabled by default in BIOS.
		xor	cap_stat,REV_SUPP ; disable reverse video support
		mov RAV_REV,0

; RGB Wighting function not supported in 6340 implementation
		xor	cap_stat,RGB_SUPP ; disable RGB weighting support
		mov RAV_RGB,0

		mov	ax,offset raven_msg ; set up signon message
		mov	chip_msg,ax
		jmp	ic_exit

;
; check Stingray chip revision
;		
chk_revision:
		cmp	bl,02h		; revc?
		jz	off_revchk	; yes
; RevB
		or chip_type, REVB610620
		or	cap_stat,VERT_ALIGN_SUPP ; enable vertical alignment
		or	cap_stat,EXPAND_SUPP ; software expand mode support
		or	cap_stat,BOLD_SUPP ; enable bold font support
		or	cap_stat,REV_SUPP ; enable reverse video support
		mov	chip_fc,revb_count ; set up count
		mov	ax,offset revb_funcptr	; set up function table
		mov	chip_funcptr,ax
		mov	ax,offset revb_msg	; set up signon message
		mov	chip_msg,ax
		jmp	short ic_exit
off_revchk:
; RevC
		or chip_type, REVC610620
		or	cs:st_rev,REV_C
		test	ah,02h		; Peacock attached?
		jnz	revc_pk		; yes
		or	cap_stat,VERT_ALIGN_SUPP ; enable vertical alignment
		or	cap_stat,EXPAND_SUPP ; software expand mode support
		or	cap_stat,BOLD_SUPP ; enable bold font support
		or	cap_stat,REV_SUPP ; enable reverse video support
		mov	chip_fc,revc_count ; set up count
		mov	ax,offset revc_funcptr	; set up function table
		mov	chip_funcptr,ax
		mov	ax,offset revc_msg	; set up signon message
		mov	chip_msg,ax
		jmp	short ic_exit
revc_pk:
		or	cap_stat,SIMUSC_SUPP ; enable simulscan support
		or	cap_stat,VERT_ALIGN_SUPP ; enable vertical alignment
		or	cap_stat,EXPAND_SUPP ; software expand mode support
		or	cap_stat,BOLD_SUPP ; enable bold font support
		or	cap_stat,REV_SUPP ; enable reverse video support
		mov	chip_fc,revcp_count ; set up count
		mov	ax,offset revcp_funcptr	; set up function table
		mov	chip_funcptr,ax
		mov	ax,offset revcp_msg	; set up signon message
		mov	chip_msg,ax

ic_exit:	ret

_init_chip	endp
;-----------------------------------------------------------------------
;
;	prt_keys()
;
;	Function:
;	   Print a description of the supported hot keys.
;
;	Input:
;	   AL -> copy of env_flags
;
;	Returns:
;	   Nothing.
;
;-----------------------------------------------------------------------
prt_keys	proc	near
		public	prt_keys

		test	al,03h		; panel options ?
		jnz	have_panel		; yes
		jmp	prt_ds		; nope
have_panel:
		push	ax		; preserve env_flags

		test cap_stat, ATTR_EMUL_SUPP	; Test for Attribute Emulation.
		jz chk_bold		; nope
		test chip_type, REVB610620
		jnz sray_auto
		test chip_type, REVC610620
		jnz sray_auto
		test chip_type, GD62XX
		jnz term_bw
		mov	ah,09h		; print string
		lea	dx, cont_enh_msg	; contrast enhance msg, GD6440
		int	21h		; print msg
		jmp	short chk_bold

term_bw:
		mov	ah,09h		; print string
		lea	dx, b_and_w_enh_msg	; Black and White enhancement msg
		int	21h		; print msg
		jmp short chk_bold

sray_auto:
		mov	ah,09h		; print string
		lea	dx, automap_msg	; automap msg
		int	21h		; print msg

chk_bold:
		test cap_stat, BOLD_SUPP	; test for bold font support
		jz chk_cent		; nope
		mov	ah,09h		; print string
		lea	dx, bold_msg	; bold font msg
		int	21h		; print message

chk_cent:
		test cap_stat, VERT_ALIGN_SUPP	; test for centering support
		jz chk_disp		; nope
		mov	ah,09h		; print string
		lea	dx, cent_msg	; centering msg
		int	21h		; print message

chk_disp:
		test cap_stat, SIMUSC_SUPP	; test for SimulScan support
		jz lcd_crt_only	; nope
		mov	ah,09h		; print string
		lea	dx, simul_disp_msg	; SimulSCAN msg
		int	21h		; print message
		jmp	short chk_exp
lcd_crt_only:		mov	ah,09h		; print string
		lea	dx, sray_disp_msg	; LCD CRT msg
		int	21h		; print message


chk_exp:
		test cap_stat, EXPAND_SUPP	; test for expand support support
		jz chk_frame		; nope
		mov	ah,09h		; print string
		lea	dx, exp_msg	; expand msg
		int	21h		; print message

chk_frame:
		test chip_type, REVB610620
		jnz supt_frame
		test chip_type, REVC610620
		jz shading
supt_frame:
		test cap_stat, SIMUSC_SUPP ; is this peavan?
		jnz chk_rev
		mov	ah,09h		; print string
		lea	dx,frame_msg	; frame msg
		int	21h		; print message
		jmp	short chk_rev

shading:
		test cap_stat, RGB_SUPP	; test for RGB weighting support
		jz other_msg		; nope
		test chip_type, GD62XX
		jnz term_shading
		mov	ah,09h		; print string
		lea	dx, rgb_msg	; rgb msg
		int	21h		; print message
		jmp short other_msg

term_shading:
		mov	ah,09h		; print string
		lea	dx, gra_msg	; graphics shading msg
		int	21h		; print message
		mov	ah,09h		; print string
		lea	dx, txt_msg	; text shading msg
		int	21h		; print message

other_msg:	mov	ah,09h	; select print string
		mov dx,chip_msg ; chip specific message (other than Stingray)
		int 21h		; print message

chk_rev:
		test cap_stat, REV_SUPP	; test for Reverse screen support
		jz chk_screen		; nope
		mov	ah,09h		; print string
		lea	dx,rev_msg	; reverse msg
		int	21h		; print message

chk_screen:
		test cap_stat, REV_SUPP	; test for Reverse screen support
		jz chk_sray		; nope

		test chip_type, GD6440  ; GD6440?
		jnz chk_sray            ; skip screen power msg for GD6440
		mov	ah,09h		; print string
		lea	dx,screen_msg	; screen power off msg
		int	21h		; print message

chk_sray:
		test chip_type, REVB610620
		jnz sray_msg
		test chip_type, REVC610620
		jz last_message
sray_msg:
		mov	ah,09h		; print string
		lea	dx,chip_msg	; sray chip message
		int	21h		; print message

last_message:
		pop	ax		; restore env_flags

prt_ds:		test	al,80h		; display switch ?
		jz	prt_done	; nope

		mov	ah,09h		; print string
		lea	dx,ds_keys	; display switch key
		int	21h		; print display switch key

prt_done:	mov	ah,09h		; print string
		lea	dx,line_feed	; line feed string
		int	21h		; print extra line feed

		ret
prt_keys	endp

CR		equ	0dh
LF		equ	0ah

init_msg	db	CR,LF
		db	'VGA Option Switcher.  '
		db	'Version '
		db	VersionNum,CR,LF
		db	'Copyright (c) Cirrus Logic Inc., 1989-1993.  '
		db	'All rights reserved.'
		db	CR,LF,LF,'$'

; AutoMap message (used by Stingray rev B and C)
automap_msg	db	'ctrl-shift-A to toggle Automap on/off.',CR,LF,'$'

; Contrast Enhancement message
cont_enh_msg	db	'ctrl-shift-A to toggle Contrast enhancement.',CR,LF,'$'

; Black and White Enhancement message
b_and_w_enh_msg	db	'ctrl-shift-A to toggle black and white enhancement.',CR,LF,'$'

; Bold font message
bold_msg		db	'ctrl-shift-B to toggle Bold on/off.',CR,LF,'$'

; Centering message
cent_msg		db	'ctrl-shift-C to toggle Centering choices.',CR,LF,'$'

; Display switch for Stingray
sray_disp_msg	db	'ctrl-shift-D to toggle Display to crt/panel.',CR,LF,'$'

; Display Switch for SimulScan capable systems
simul_disp_msg	db	'ctrl-shift-D to toggle Display to panel/CRT/SimulSCAN.',CR,LF,'$'

; Expand Mode message
exp_msg		db	'ctrl-shift-E to toggle Expand mode on/off.',CR,LF,'$'

; Reverse Video message
rev_msg		db	'ctrl-shift-R to toggle Reverse video on/off.',CR,LF,'$'

; Frame color message used only for stingray
frame_msg	db	'ctrl-shift-F to toggle Frame color choices.',CR,LF,'$'

; Screen Power On/OFF message
screen_msg	db	'ctrl-shift-S to toggle Screen power on/off.',CR,LF,'$'

; RGB Weighting Message
rgb_msg		db	'ctrl-shift-G to toggle rGb weighting.',CR,LF,'$'
		
; Graphics Weighting Message
gra_msg		db	'ctrl-shift-G to toggle Graphics grey shading.',CR,LF,'$'

; Text Weighting Message
txt_msg		db	'ctrl-shift-T to toggle Text grey shading.',CR,LF,'$'
		

; Chip Specific Messages
; Stingray RevB
revb_msg	db	'ctrl-shift-W to toggle Width fixup choices.',CR,LF
		db	'$'

; Stingray RevC
revc_msg		db	'ctrl-shift-W to toggle Width fixup choices.',CR,LF
		db	'ctrl-shift-H to toggle Hardware text expand mode on/off.',CR,LF
		db	'ctrl-shift-U to toggle sUspend mode on/off.',CR,LF
		db	'$'

; Stingray RevC/Peacock
revcp_msg	db	'ctrl-shift-H to toggle Hardware text expand mode on/off.',CR,LF
;***		db	'ctrl-shift-U to toggle sUspend mode on/off.',CR,LF
;*** commented out 02-17-92
		db	'$'

; Raven
raven_msg	db	'ctrl-shift-L to toggle inhibit font Load.',CR,LF
		db	'ctrl-shift-O to toggle full height cursOr.',CR,LF
		db	'$'

; Terminator
term_msg	db	'ctrl-shift-L to toggle inhibit font Load.',CR,LF
		db  'ctrl-shift-P to toggle Panel power usage (Low/Normal).',CR,LF
		db	'$'
; Macaw
macaw_msg	db	'ctrl-shift-L to toggle inhibit font Load.',CR,LF
		db	'ctrl-shift-O to toggle full height cursOr.',CR,LF
		db      'ctrl-shift-P to toggle Panel power usage (Low/Normal).',CR,LF
		db	'$'

ds_keys		db	'ctrl-shift-V to toggle VGA display switch',CR,LF
		db	'$'

line_feed	db	LF,'$'

fail_msg	db	'This video system does not have any switchable '
		db	'options.',CR,LF,'$'

prev_msg	db	'VGA Option Switcher is already loaded.',CR,LF
		db	'New version will not be loaded.',CR,LF,CR,LF,'$'

_text		ends
		end	_start
