/*
 * $Id: compat.h,v 1.1 1997/01/31 10:32:20 calle Exp calle $
 * 
 * Headerfile for Compartibility between different kernel versions
 * 
 * (c) Copyright 1996 by Carsten Paeth (calle@calle.in-berlin.de)
 * 
 * $Log: compat.h,v $
 * Revision 1.1  1997/01/31 10:32:20  calle
 * Initial revision
 *
 * 
 */
#ifndef __COMPAT_H__
#define __COMPAT_H__
#include <linux/version.h>

/*
 * since 2.1.6 new exception handling for access to user area is in 
 */
#if LINUX_VERSION_CODE >= 0x020106	/* 2.1.6 */
#include <asm/uaccess.h>
#else
#undef copy_from_user
#undef copy_to_user

static inline unsigned long copy_from_user(void *to, const void *from, unsigned long n)
{
	int i;
	if ((i = verify_area(VERIFY_READ, from, n)) != 0)
		return i;
	memcpy_fromfs(to, from, n);
	return 0;
}

static inline unsigned long copy_to_user(void *to, const void *from, unsigned long n)
{
	int i;
	if ((i = verify_area(VERIFY_WRITE, to, n)) != 0)
		return i;
	memcpy_tofs(to, from, n);
	return 0;
}
#endif

#if LINUX_VERSION_CODE >= 0x020112	/* 2.1.18 */
#define HAS_NEW_SYMTAB
#endif

/*
 * in 2.0.26 there was the patch for good returncodes for ISDN_STAT_ICALL,
 * but up to 2.1.17 it was still not included hopefully it is coming in
 * 2.1.20 
 */
#if    (LINUX_VERSION_CODE > 0x02001a && LINUX_VERSION_CODE < 0x020100) \
    ||  LINUX_VERSION_CODE > 0x020114
#define STAT_ICALL_HAS_GOOD_RETURNVALUE
#endif

#if LINUX_VERSION_CODE < 0x02010f	/* 2.1.15 */
#define SKBUFF_HAS_FREE_MEMBER
#endif

#endif				/* __COMPAT_H__ */
