;****************************************************
;  This program is used to calculate the cpu's speed
;
; $Author: Hnguyen $Han Nguyen
; $History: cpuspeed.asm $
; 
; *****************  Version 5  *****************
; User: Hnguyen      Date: 11/26/96   Time: 5:28a
; Updated in $/General Utilities/CPU Speed Check
;
; *****************  Version 2  *****************
; User: Hnguyen      Date: 11/07/96   Time: 4:52p
; Updated in $/General Utilities/CPU Speed Check
; $Log: /General Utilities/CPU Speed Check/cpuspeed.asm $
; 
; 5     11/26/96 5:28a Hnguyen
;
; 2     11/07/96 4:52p Hnguyen
; $Logfile: /General Utilities/CPU Speed Check/cpuspeed.asm $
;
;****************************************************
.MODEL large
.586
.STACK
.CODE

TIMER_CNT       EQU    30

cpuspeed        PROC
                .STARTUP

        pushfd                          ; save flags
        pop     eax                     ; pop into eax
        mov     ebx,eax                 ; save for later use
        xor     eax,00200000            ; try to toggle bit 21
        push    eax
        popfd                           ; pop eflags
        pushfd
        pop     eax
        cmp     eax,ebx                 ; check if bit 21 toggles
        jz      no_cpuid                ; if it is not, no CPUID
        jmp     cpuid_ok

no_cpuid:                               ; display message to notify that the
                                        ; CPUID is not supported
        mov     ah, 9h
        mov     dx, offset nocpuid_msg
        int     21h
        jmp     abort

cpuid_ok:                               ; display message that the CPUID is
                                        ; supported
        mov     ah, 9h
        mov     dx, offset cpuid_msg
        int     21h
        mov     eax, 0                  ; function 0
        db      0fh,0a2h                ; CPUID opcode
        cmp     ecx,444d4163h           ; check if the CPU is AMD's CPU
        je      amd_cpu
        mov     ah, 9h
        mov     dx, offset ptium_msg
        int     21h
        jmp     speed

amd_cpu:
        mov     eax, 1                  ; function1
        db      0fh,0a2h                ; CPUID opcode
        mov     ebx,eax
        and     ebx,00000FF0h

        cmp     ebx,00000500h           ; if it is a class 5 CPU
        je      K5_model0
        cmp     ebx,00000510h
        je      K5_model1
        cmp     ebx,00000520h
        je      K5_model2
        cmp     ebx,00000530h
        je      K5_model3
        cmp     ebx,00000560h           ; if it is a class 6 CPU
        je      K6
        jmp     speed


K5_model0:                            ; display the message that the CPU is a K5-model 0
        mov     ah, 9h
        mov     dx, offset model0_msg
        int     21h
        jmp     speed

K5_model1:
        mov     model,1
        mov     ah,09h
        mov     dx, offset model1_msg
        int     21h
        jmp     speed

K5_model2:
        mov     model,2
        mov     ah,9h
        mov     dx,offset model2_msg
        int     21h
        jmp     speed

K5_model3:
        mov     model,3
        mov     ah,9h
        mov     dx,offset model3_msg
        int     21h
        jmp     speed

message:                                ; display the message and terminate the
        mov     ah,9h                   ; program if the CPU is not a K5 or K6
        mov     dx,offset msg
        int     21h
        jmp     abort

K6:                                     ; display the message that the CPU is a K6
        mov     model,6
        mov     ah,9h
        mov     dx, offset K6_msg
        int     21h

speed:
;       wbinvd                          ; validate the cache
;       mov     eax,CR0                 ; disable the cache
;       or      eax,60000000h
;       mov     CR0,eax
;       wbinvd



        mov     ax,0h                   ; set extra segment to 0
        mov     es,ax
        mov     bx,46ch
        mov     eax,es:[bx]

delay:
        cmp     es:[bx],eax             ; synchronize the timer
        je      delay
        mov     ecx,es:[bx]             ; save the current time
        mov     time_Orig,ecx
        xor     ecx,ecx
        cli                             ; disable interrupts
        mov     es:[bx],ecx             ; set timer to 0
        sti                             ; enable interrupts
        rdtsc                           ; read time stamp counter
        mov     esi,edx                 ; save upper 32 bits to esi
        mov     edi,eax                 ; save lower 32 bits to edi

; This is a dummy loop and it can have any kind of instructions
exeloop:
        mov     bx,0
        mov     ax,8000h
        bsf     bx,ax                   ; scan the bit in the second operand
                                        ; starting with bit 0
        mov     bx,0
        mov     ax,0001h
        bsr     bx,ax                   ; scan the bit in the second operand
                                        ; from the most significant bit
        mov     bx, 80

cont:
        mov     ax,50
        mov     dx,10
        idiv    dl                      ; signed divide ax by 10
        dec     bx                      ; decrement bx by 1
        jnz     cont
        mov     ax,10
        mov     dx,100
        sub     dx,dx
;        loop    exeloop
        xor     ecx,ecx
        mov     bx, 46ch
        rdtsc                           ; read time stamp counter again
        mov     ecx,es:[bx]             ; save the number of timer ticks
        cmp     ecx, TIMER_CNT          ; do the loop until the number of timer
                                        ; ticks are equal to TIMER_CNT
        jne     exeloop
        mov     ticks_end,ecx
        add     ecx,time_Orig           ; restore the time
        mov     es:[bx],ecx

cont_prog:
        mov     endl,eax                ; save the upper 32 bit of the TSC
                                        ; after executing the loop in endl
        mov     end1,edx                ; save the lower 32 bits of the TSC
                                        ; after executing the loop in end1

        sub     endl,edi                ; calculate the total cycles
        sbb     end1,esi                ; upper 32 bits are stored in endl
                                        ; lower 32 bits are stored in end1

        mov     eax, endl               ; store the upper 32 bits of the total
        mov     totcyc,eax              ; cycle

        mov     eax,end1                ; store the lower 32 bits of the total
        mov     totcyc1,eax             ; cycle

        xor     ebx,ebx
        xor     eax,eax
        finit                           ; initialize fpu unit
        fild    dword ptr ticks_end     ; load the integer onto the top of stack
        fmul    dword ptr real          ; multiply the integer by real
        fist    dword ptr totime        ; store the result as an integer into
                                        ; totime

        mov     edx,totcyc1             ; freq = cycle / time (in sec)
        mov     eax,totcyc
        mov     ecx,totime
        div     ecx
        mov     res,eax
        cmp     model,2
        je      print_exact_result
        jmp     continue

print_exact_result:
        cmp     res,84
        jge     msg_87mhz
        jmp     continue

msg_87mhz:
        cmp     res,90
        jle     display_msg
        cmp     res,100
        jge     msg_105mhz
        jmp     continue

msg_105mhz:
        cmp     res,108
        jle     display_msg1
        cmp     res,120
        jle     result
        jmp     continue


display_msg1:
        mov     ah,09h
        mov     dx,offset mul_bus_105msg
        int     21h
        xor     eax,eax
        mov     eax,res
        call    far ptr Print_result
        jmp     abort

display_msg:
        mov     ah,09h
        mov     dx,offset mul_bus_87msg
        int     21h
        xor     eax,eax
        mov     eax,res
        call    far ptr Print_result
        jmp     abort


result:
        mov     ah,09h
        mov     dx,offset rate_message
        int     21h
        xor     eax,eax
        mov     eax,res
        call    far ptr Print_result
        jmp     abort

continue:
        cmp     eax,65                  ; if the freq is in the range
        jg      jump_75                 ; 65 < freq <= 75, then display 75 Mhz
jump_75:
        cmp     eax,80
        jle     Display_75


        cmp     eax,85                  ; if the freq is in the range
        jg      jump_90                 ; 85 < freq <= 95, then display 90 Mhz
jump_90:
        cmp     eax,95
        jle     Display_90


        cmp     eax,95                  ; if the freq is in the range
        jg      jump_100                ; 95 < freq <= 105, then display 100Mhz
jump_100:
        cmp     eax,105
        jle     Display_100

        cmp     eax,115                 ; if the freq is in the range
        jg      jump_120                ; 115 < freq <= 125, then display 120 Mhz
jump_120:
        cmp     eax,125
        jle     Display_120

        cmp     eax,128                 ; if the freq is in the range
        jg      jump_133                ; 128 < freq <= 138, then display 133 Mhz
jump_133:
        cmp     eax,138
        jle     Display_133

        cmp     eax,145                 ; if the freq is in the range
        jg      jump_150                ; 145 < freq <= 155, then display 150 Mhz
jump_150:
        cmp     eax,155
        jle     Display_150

        cmp     eax,161                 ; if the freq is in the range
        jg      jump_166                ; 161 < freq <= 171, then display 166 Mhz
jump_166:
        cmp     eax,171
        jle     Display_166

        cmp     eax,175                 ; if the freq is in the range
        jg      jump_180                ; 175 < freq <= 185, then display 180 Mhz
jump_180:
        cmp     eax,185
        jle     Display_180

        cmp     eax,195                 ; if the freq is in the range
        jg      jump_200                ; 195 < freq <= 200, then display 200 Mhz
jump_200:
        cmp     eax,205
        jle     Display_200

        cmp     eax,205                 ; if the freq is in the range
        jg      jump_210                ; 205 < freq <= 215, then display 210 Mhz
jump_210:
        cmp     eax,215
        jle     Display_210

        cmp     eax,228                 ; if the freq is in the range
        jg      jump_233                ; 228 < freq <= 238, then display 233 Mhz
jump_233:
        cmp     eax,238
        jle     Display_233
        jmp     abort


Display_75:                             ; display 75 Mhz message
        mov     ah,9h
        mov     dx,offset msg_75
        int     21h
        jmp     abort

Display_90:                             ; display 90 Mhz message
        cmp     model,6
        je      K6_90mhz
        mov     ah,9h
        mov     dx,offset msg_90
        int     21h
        jmp     abort

Display_100:                            ; display 100 Mhz message
        cmp     model,1
        je      display_rate
        cmp     model,6
        je      K6_100mhz
        mov     ah,9h
        mov     dx,offset msg_100
        int     21h
        jmp     abort

display_rate:
        mov     ah,09h
        mov     dx,offset rate1_msg
        int     21h
        jmp     abort


Display_120:                            ; display 120 Mhz message
        cmp     model,6
        je      K6_120mhz
        mov     ah,9h
        mov     dx,offset msg_120
        int     21h
        jmp     abort

Display_133:                            ; display 133 Mhz message
        cmp     model,6
        je      K6_133mhz
        mov     ah,9h
        mov     dx,offset msg_133
        int     21h
        jmp     abort

Display_150:                            ; display 150 Mhz message
        mov     ah,9h
        mov     dx,offset msg_150
        int     21h
        jmp     abort

Display_166:
        mov     ah,9h                   ; display 166 Mhz message
        mov     dx,offset msg_166
        int     21h
        jmp     abort

Display_180:                            ; display 180 Mhz message
        mov     ah,9h
        mov     dx,offset msg_180
        int     21h
        jmp     abort

Display_200:                            ; display 200 Mhz message
        mov     ah,9h
        mov     dx,offset msg_200
        int     21h
        jmp     abort

Display_210:                            ; display 210 Mhz message
        mov     ah,9h
        mov     dx,offset msg_210
        int     21h
        jmp     abort

Display_233:                            ; display 233 Mhz message
        mov     ah,9h
        mov     dx,offset msg_233
        int     21h
        jmp     abort

K6_90mhz:
        mov     ah,9h
        mov     dx,offset K6_90_msg
        int     21h
        jmp     abort

K6_100mhz:
        mov     ah,9h
        mov     dx,offset K6_100_msg
        int     21h
        jmp     abort

K6_120mhz:
        mov     ah,9h
        mov     dx,offset K6_120_msg
        int     21h
        jmp     abort

K6_133mhz:
        mov     ah,9h
        mov     dx,offset K6_133_msg
        int     21h

abort:
        mov     ax,4c00h                ; terminate the program
        int     21h

cpuspeed        ENDP

;----------------------------------------------------------------------------------------------
;convert the frequency into ASCii
;This procedure is used when you want to display some value in decimal
;This procedure has nothing to do in this program
;----------------------------------------------------------------------------------------------
Print_result    PROC    FAR

                push    eax                     ; save the value in eax
                push    ebx                     ; ebx
                push    edx                     ; edx
                push    edi                     ; edi

                xor     ebx,ebx
                xor     edx,edx
                mov     ebx,10
                mov     di,2
dloop:          div     ebx                     ; divide eax by 10
                add     dl,30h                  ; make remainder ASCII
                mov     click[di],dl
                xor     edx,edx
                dec     di
                jns     dloop

                mov     dx, offset click
                mov     ax, 0900h
                int     021h


                pop     edi                     ; pop edi,edx,ebx,eax off the
                pop     edx                     ; stack
                pop     ebx
                pop     eax

                ret

Print_result    ENDP
;-------------------------------------------------------------------


.DATA

K6_90_msg       db      0dh,0ah
                db        '90 Mhz CPU Clock',0dh,0ah,'$'

K6_100_msg      db      0dh,0ah
                db        '100 Mhz CPU Clock',0dh,0ah,'$'

K6_120_msg      db      0dh,0ah
                db        '120 Mhz CPU Clock',0dh,0ah,'$'

K6_133_msg      db      0dh,0ah
                db        '133 Mhz CPU Clock',0dh,0ah,'$'

model0_msg      db      0dh,0ah
                db        'AMD K5 (Model 0 )',0dh,0ah,'$'

model1_msg      db      0dh,0ah
                db        'AMD K5 (Model 1)',0dh,0ah,'$'

model2_msg      db      0dh,0ah
                db        'AMD K5 (Model 2)',0dh,0ah,'$'

model3_msg      db      0dh,0ah
                db        'AMD K5 (Model 3)',0dh,0ah,'$'

K6_msg          db      0dh,0ah
                db        'AMD-K6',0dh,0ah,'$'

msg_75          db      0dh,0ah
                db        '1.5x - 50mhz bus, 75 Mhz CPU Clock',0dh,0ah,'$'

msg_90          db      0dh,0ah
                db        'PR-120: 1.5x-60mhz bus, 90 Mhz CPU Clock',0dh,0ah,'$'

msg_100         db      0dh,0ah
                db        '2x - 50mhz bus,100 Mhz CPU Clock',0dh,0ah,'$'

msg_120         db      0dh,0ah
                db        'PR-150: 2x-60mhz bus, 120 Mhz CPU Clock',0dh,0ah,'$'

msg_133         db      0dh,0ah
                db        'PR-200: 2x-66mhz bus, 133 Mhz CPU Clock',0dh,0ah,'$'

msg_150         db      0dh,0ah
                db        '150 Mhz CPU Clock',0dh,0ah,'$'

msg_166         db      0dh,0ah
                db        '166 Mhz CPU Clock',0dh,0ah,'$'

msg_180         db      0dh,0ah
                db        '180 Mhz CPU Clock',0dh,0ah,'$'

msg_200         db      0dh,0ah
                db        '200 Mhz CPU Clock',0dh,0ah,'$'

msg_210         db      0dh,0ah
                db        '210 Mhz CPU Clock',0dh,0ah,'$'

msg_233         db      0dh,0ah
                db        '233 Mhz CPU Clock',0dh,0ah,'$'

rate1_msg       db      0dh,0ah
                db        'PR-133: 1.5x - 66mhz bus, 100 Mhz CPU Clock',0dh,0ah,'$'

nocpuid_msg     db      0dh,0ah
                db        'CPUID is not supported by this processor', 0dh,0ah,'$'

cpuid_msg       db      0dh,0ah
                db        'This processor support CPUID', 0dh, 0ah,'$'

ptium_msg       db      0dh,0ah
                db        'PENTIUM CPU',0dh,0ah,'$'

msg             db      0dh,0ah
                db        'This program is not used for class 4 or below',0dh,0ah,'$'

rate_message    db      0dh,0ah
                db        'PR-166: 1.75x - 66mhz bus',0dh,0ah,'$'

mul_bus_87msg   db      0dh,0ah
                db        '1.75x - 50mhz bus',0dh,0ah,'$'

mul_bus_105msg  db      0dh,0ah
                db        '1.75x - 60mhz bus',0dh,0ah,'$'

click           db      '   '
                db      "MHz CPU Clock",0ah,0dh,'$'
model           WORD    0
res             DWORD   0
totcyc          DWORD   0
totcyc1         DWORD   0
totime          DWORD   0
ticks_end       DWORD   0
real            real4   5.4924E4
end1            DWORD   0
endl            DWORD   0
time_Orig       DWORD   0
END
