;

; This program was hacked together for the K5-PR166
; This is for internal use only
;
; Chris Gray / Mike Wisor -- NOV-1996
;
	PAGE    59, 132
       .586P

CODE    SEGMENT BYTE PUBLIC use16 'CODE'
        ASSUME CS:CODE,DS:CODE,ES:CODE,SS:CODE

;This program was created by Mike Wisor and should be treated as AMD
;Confidential Information

;Revision 1.2 added WBINVD before disabling caches ~~mtw 2/15/95

	org     100h                            ;.com file
start:
	jmp     hwcr_main

;****** constants
debug           equ     0h                      ;if one then debug mode

cr              equ     0dh
lf              equ     0ah

;****** macros and routines for the program
;wrmsr           macro           
;		db      0fh,30h
;		endm

;rdmsr           macro
;		db      0fh,32h
;		endm

;wbinvd          macro                           ;~~mtw 2/15/95
;                db      0fh,09h                 ;~~mtw 2/15/95
;                endm                            ;~~mtw 2/15/95

cpu_id          macro   case
		mov     eax,case
		db      0fh,0a2h
		endm

tag_it          macro   addr                    ;set patch tag macro
		mov     ecx,81h
		mov     eax,addr
		wrmsr
		endm

enable_hwcr     macro
		mov     ecx,83h
		rdmsr
		or      eax,00002000h   ;set bit 13
		mov     edx,0c0de0000h
		wrmsr
		endm
	
convert PROC
	push    bx
	mov     bx,ax
	xchg    ah,al                   ;contains most significant
	mov     ah,0
	cmp     al,39h
	jbe     not_char
	sub     ax,57h
	rol     ax,4
	jmp     chk_nxt

not_char:
	and     ax,000fh                ;convert ascii to hex
	rol     ax,4

chk_nxt:
	mov     bh,0
	cmp     bl,39h
	jbe     not_char1
	sub     bx,57h
	jmp     sum_up

not_char1:
	and     bx,000fh

sum_up:
	add     ax,bx                   ;result of conversion
	pop     bx
	ret
convert ENDP

hex_to_ascii    PROC
;convert hex to ascii - input is eax and si for storage pointer 
	mov     ebx,eax
	mov     cl,10h
	ror     ebx,cl          ;place upper 16 bits into lower bx area

	push    bx
	mov     bl,bh
	and     bx,0f00fh
	mov     cl,4
	ror     bh,cl
	call    ascii_adjust
	mov     byte ptr [si],bh
	inc     si
	mov     byte ptr [si],bl
	inc     si
	pop     bx

	mov     bh,bl
	and     bx,0f00fh
	mov     cl,4
	ror     bh,cl
	call    ascii_adjust
	mov     byte ptr [si],bh
	inc     si
	mov     byte ptr [si],bl
	inc     si

	mov     ebx,eax
	push    bx
	mov     bl,bh
	and     bx,0f00fh
	mov     cl,4
	ror     bh,cl
	call    ascii_adjust
	mov     byte ptr [si],bh
	inc     si
	mov     byte ptr [si],bl
	inc     si
	pop     bx

	mov     bh,bl
	and     bx,0f00fh
	mov     cl,4
	ror     bh,cl
	call    ascii_adjust
	mov     byte ptr [si],bh
	inc     si
	mov     byte ptr [si],bl
	inc     si
	
	ret
hex_to_ascii    ENDP

ascii_adjust    PROC
;bx is input in ready to be adjusted format
	cmp     bh,9h
	ja      not_number
	add     bh,30h
	jmp     do_bl

not_number:
	add     bh,37h

do_bl:
	cmp     bl,9h
	ja      not_number1
	add     bl,30h
	jmp     xit_ascii_adjust

not_number1:
	add     bl,37h

xit_ascii_adjust:
	ret
ascii_adjust    ENDP

;****** data area
;mtw added messages
help_msg                db      'k5_tr12 [options]',cr,lf
			db      '     /? - help',cr,lf
			db      '     /r - Read hardware configuration register. (default)',cr,lf
			db      '     /w00000000 - Write specified value to the hardware configuration register.',cr,lf
			db	'     /pxxxxxxxx - Programmable Memory Range ( Write Allocate)',cr,lf
			db	'	      bits 31-16 Range : yyyy',cr,lf
			db	'	      bits 15-0 Range  : xxxx',cr,lf
			db	'     /txxxxxxxx - Programmable Memory Range ( Write Allocate)',cr,lf
			db	'	      bit  18   : Top of Memory Enable',cr,lf
			db	'	      bit  17   : Programmable Range Enable',cr,lf
			db	'	      bit  16   : Fixed Range Enable ',cr,lf
			db	'	      bits 15-0 : Top of Memory Range ',cr,lf

			db      cr,lf
			db      '     K5_TR12 ' ,cr,lf
			db      '     To select the desired function set the bit to a 1.',cr,lf
			db      '       bits not listed are not used (set to zero)',cr,lf
			db	'       bit 31     - Disable write to anything pipelining',cr,lf
			db	'       bit 30     - Disable I to I pipelining ',cr,lf
			db	'       bit 23     - Enable FAST FDIV ',cr,lf
			db	'       bit 18     - Disable Pipeline ',cr,lf
			db      '       bit 07     - disable data cache',cr,lf
			db      '       bit 06     - disable instruction cache',cr,lf
			db      '       bit 05     - disable branch predication',cr,lf
			db      '       bit 04     - enable write allocate',cr,lf
			db      '       bit 00     - disable stop_clock at enter_freeze',cr,lf
			db      '$'

cmd_line_error          db      CR,LF,CR,LF,'Check the command line parameters - ERROR detected!',CR,LF,CR,LF,'$'
hwcr_write83_msg        db      cr,lf,' NOTHINGh has been written into the HWCR.',cr,lf
hwcr_write85_msg        db      cr,lf,' NOTHINGh has been written into MSR 85h.',cr,lf
hwcr_write86_msg        db      cr,lf,' NOTHINGh has been written into MSR 86h.',cr,lf,'$'
hwcr_read83_msg         db      cr,lf,' NOTHINGh has been read from the HWCR.',cr,lf
hwcr_read85_msg         db      cr,lf,' NOTHINGh has been read from MSR 85h.',cr,lf
hwcr_read86_msg         db      cr,lf,' NOTHINGh has been read from MSR 86h.',cr,lf,'$'
cpu_msg                 db      cr,lf,'An AMD-K5 CPU supporting CPUID is in place.',cr,lf,'$'
not_amd			db	cr,lf,'An AMD-K5 CPU is not in place. Aborting!',cr,lf,'$'
sign_on_msg             db      cr,lf,'K5 TR12 Feature Bit Program - Version .00002',cr,lf
			db            'Maintained by Chris Gray.',cr,lf,'$'
cpu_id_string           db      cr,lf,'000000000000',cr,lf,'$'

bytes_read              db      0       ;bytes read from command line
stepID			db	0	;dfault stepping model to !4
invalid_step		db	cr,lf,'Invalid Stepping ID for this operation. Aborting!',cr,lf,'$'

;******* main program

hwcr_main:
	mov     ax,cs
	mov     ds,ax
	mov     ah,9
	mov     dx,offset sign_on_msg
	int     21h

cpu_id_ok:
	cpu_id   0                       ;case 0
	mov     si,offset cpu_id_string
	push	ecx
	mov     eax,ecx
	mov     [si+10],al
	mov     [si+11],ah
	mov     cl,10h
	ror     eax,cl
	mov     [si+12],al
	mov     [si+13],ah

	mov     [si+6],dl
	mov     [si+7],dh
	mov     cl,10h
	ror     edx,cl
	mov     [si+8],dl
	mov     [si+9],dh

	mov     [si+2],bl
	mov     [si+3],bh
	mov     cl,10h
	ror     ebx,cl
	mov     [si+4],bl
	mov     [si+5],bh


	mov     ah,9h
	mov     dx,offset cpu_id_string
	int     21h
	pop     ecx
	cmp     ecx,444D4163h
	je      amd_cpu
	mov	dx, offset not_amd
	mov	ah, 09h
	int	21h
	jmp	exit

amd_cpu:
	mov     ah,9
	mov     dx,offset cpu_msg
	int     21h

; Now find out stepping model ;
	cpu_id	1			;case 1
	and	eax, 0Fh		;get stepping ID
	mov	stepID,al
	
	mov     ah,62h                  ;get PSP segment
	int     21h
	mov     es,bx                   ;bx contains the segment
	cld                             ;clear direction
	mov     al,'/'                  ;scan line delimiter
	mov     cl,byte ptr es:[80h]    ;length of scan line
	mov     byte ptr bytes_read,cl
	mov     di,81h                  ;scan line start
	cmp     byte ptr es:[80h],0     ;nothing entered
	je      get_help                ;if nothing show get help

cont_scan:
	mov     cx,0
	mov     cl,byte ptr bytes_read
	mov     al,'/'                  ;scan line delimiter
	repne   scasb                   ;look for '/'
	pushf
	cmp     cx,0
	je      done_with_line
	popf
	mov     byte ptr bytes_read,cl
	je      chk_param
	jmp     exit

done_with_line:
	popf
	jmp     exit

chk_param:
;first check for help and patch addresses
	cmp     byte ptr es:[di],'?'    ;HELP!!!!!!!!!!!
	je      get_help
	cmp     byte ptr es:[di],'r'    
	je      read_hwcr
	cmp     byte ptr es:[di],'w'    
	je      write_hwcr
	cmp	byte ptr es:[di],'p'
	je	get_program
	cmp	byte ptr es:[di],'t'
	je	get_topmem
	


errinline:
	mov     ah,9
	mov     dx,offset cmd_line_error
	int     21h

get_help:
	mov     ah,9
	mov     dx,offset help_msg
	int     21h
	jmp     exit

get_program:
	cmp	stepID, 3h
	jae	Ok_program	
	mov	dx, offset invalid_step
	mov	ah, 09h
	int	21h
	jmp	exit

Ok_program:
	mov     ecx,86h
	rdmsr                           ;eax contains the hwcr data
	
	mov     ah,byte ptr es:[di+1]   ;read hwcr data
	mov     al,byte ptr es:[di+2]
	mov     bx,ax                   ;save
	mov     ah,byte ptr es:[di+3]   ;
	mov     al,byte ptr es:[di+4]   ;
	call    convert                 ;convert ax ascii to hex in al
	xchg    bx,ax                   ;save converted result
	call    convert
	shl     ax,8h                   ;adjust to ah
	mov     al,bl                   ;ax holds data

	mov     cl,10h
	rol     eax,cl                  ;place into upper 16 bits of eax

	mov     ah,byte ptr es:[di+5]   ;read hwcr data
	mov     al,byte ptr es:[di+6]
	mov     bx,ax                   ;save
	mov     ah,byte ptr es:[di+7]   ;
	mov     al,byte ptr es:[di+8]   ;
	call    convert                 ;convert ax ascii to hex in al
	xchg    bx,ax                   ;save converted result
	call    convert
	shl     ax,8h                   ;adjust to ah
	mov     al,bl                   ;eax holds data

; EDX is the same from the read above
	mov     ecx,86h
	wrmsr

        mov     ecx,86h                 ;~~mtw 12/11/96 read back data
        rdmsr

        mov     si,offset hwcr_write86_msg + 2
	call    hex_to_ascii

	mov     ah,9
        mov     dx,offset hwcr_write86_msg
	int     21h

	jmp	cont_scan


get_topmem:
	
	cmp	stepID, 3h
	jae	Ok_topmem
	mov	dx, offset invalid_step
	mov	ah, 09h
	int	21h
	jmp	exit

Ok_topmem:
	mov     ecx,85h
	rdmsr                                   ;eax contains the hwcr data
	push	eax
	
	mov     ah,byte ptr es:[di+1]   ;read hwcr data
	mov     al,byte ptr es:[di+2]
	mov     bx,ax                   ;save
	mov     ah,byte ptr es:[di+3]   ;
	mov     al,byte ptr es:[di+4]   ;
	call    convert                 ;convert ax ascii to hex in al
	xchg    bx,ax                   ;save converted result
	call    convert
	shl     ax,8h                   ;adjust to ah
	mov     al,bl                   ;ax holds data

	mov     cl,10h
	rol     eax,cl                  ;place into upper 16 bits of eax

	mov     ah,byte ptr es:[di+5]   ;read hwcr data
	mov     al,byte ptr es:[di+6]
	mov     bx,ax                   ;save
	mov     ah,byte ptr es:[di+7]   ;
	mov     al,byte ptr es:[di+8]   ;
	call    convert                 ;convert ax ascii to hex in al
	xchg    bx,ax                   ;save converted result
	call    convert
	shl     ax,8h                   ;adjust to ah
	mov     al,bl                   ;eax holds data

; have to mask off some bits in EAX
	pop	ebx			; restore prev eax in EBX
	and	ebx, 0FF80000h
	and	eax, 07FFFFh
	or	ebx, eax
	xchg	eax, ebx

; EDX is the same from the read above
	mov     ecx,85h
	wrmsr

        mov     ecx,85h                 ;~~mtw 12/11/96 read back data
        rdmsr

        mov     si,offset hwcr_write85_msg + 2
	call    hex_to_ascii

	mov     ah,9
        mov     dx,offset hwcr_write85_msg
	int     21h

	jmp	cont_scan

read_hwcr:

	mov     ecx,83h
	rdmsr                                     ;eax contains the hwcr data
        mov     si,offset hwcr_read83_msg + 2     ;starting point for storage
	call    hex_to_ascii

	cmp	stepID, 4h
	jb	bypass_others

        mov     ecx,85h                         ;read TOM register
        rdmsr
        mov     si,offset hwcr_read85_msg + 2
        call    hex_to_ascii

        mov     ecx,86h                         ;read PRR register
        rdmsr
        mov     si,offset hwcr_read86_msg + 2
        call    hex_to_ascii
	jmp	continue_read

bypass_others:
	mov     bx, offset hwcr_read85_msg
	mov	byte ptr [bx], '$'
continue_read:

        mov     ah,9h                           ;print read data for 83,85,86
        mov     dx,offset hwcr_read83_msg
	int     21h
	jmp     cont_scan

write_hwcr:

	mov     ah,byte ptr es:[di+1]   ;read hwcr data
	mov     al,byte ptr es:[di+2]
	mov     bx,ax                   ;save
	mov     ah,byte ptr es:[di+3]   ;
	mov     al,byte ptr es:[di+4]   ;
	call    convert                 ;convert ax ascii to hex in al
	xchg    bx,ax                   ;save converted result
	call    convert
	shl     ax,8h                   ;adjust to ah
	mov     al,bl                   ;ax holds data

	mov     cl,10h
	rol     eax,cl                  ;place into upper 16 bits of eax

	mov     ah,byte ptr es:[di+5]   ;read hwcr data
	mov     al,byte ptr es:[di+6]
	mov     bx,ax                   ;save
	mov     ah,byte ptr es:[di+7]   ;
	mov     al,byte ptr es:[di+8]   ;
	call    convert                 ;convert ax ascii to hex in al
	xchg    bx,ax                   ;save converted result
	call    convert
	shl     ax,8h                   ;adjust to ah
	mov     al,bl                   ;eax holds data

	wbinvd                          ;~~mtw 2/15/95
	mov     ecx,83h
	wrmsr

        mov     ecx,83h                 ;~~mtw 12/11/96 - read back data written
        rdmsr

        mov     si,offset hwcr_write83_msg + 2
	call    hex_to_ascii
	
	cmp	stepID, 4h
	jae	continue_write
	mov	bx, offset hwcr_write85_msg
	mov	byte ptr [bx], '$'

continue_write:
	mov     ah,9
        mov     dx,offset hwcr_write83_msg
	int     21h
	jmp     cont_scan

exit:        

	mov     ax,4c00h
	int     21h                     ;return to dos

code    ends
	end         start
