The following are the modifications make to the IBMSETUP.ASM program.
These modificaitions fix the problem encountered when changing from
non-FIFO mode to FIFO mode on the SMC FDC37C665.

page,132
;---------------------------Module-Header-------------------------------;
; Module Name: IBMSETUP.ASM -> SMCSETUP.ASM
;
; Copyright (c) Microsoft Corporation 1985-1990.  All Rights Reserved.
; Copyright (c) Standard Microsystems Corp. 1994.  All Rights Reserved.
;
; General Description:
;
; History:
;
;-----------------------------------------------------------------------;

title	IBMSetup - IBM PC, PC-XT, PC-AT, PS/2 Communications Interface

The folowing is the software changed.  The only change was made to the 
sc_fifo subroutine:


sc_fifo:
;====================   SMC Mod       =================================|
                                        ;dx=FCR register               |
	add	dl, ACE_MCR-ACE_FCR	;dx=--> Modem Control Register |
	in	al, dx                  ; read Modem Control Register  |
        iodelay                         ;                              |
        or      al, ACE_LOOP            ; put into loopback mode       |
	out	dx, al			;                              |
        iodelay                         ;                              |
        sub     dl, ACE_MCR-ACE_RBR     ; dx= Receive Buffer Register  |
        in      al, dx                  ; read buffer                  |
        iodelay                         ;                              |
        add     dl, ACE_FCR-ACE_RBR     ; dx= FCR                      |
;======================================================================|

	mov	al, ACE_TRIG14 OR ACE_EFIFO OR ACE_CRFIFO OR ACE_CTFIFO
	out	dx, al			; attempt to enable FIFO

;====================   SMC Mod       =================================|
	add	dl, ACE_MCR-ACE_FCR	;dx=--> Modem Control Register |
	in	al, dx                  ; read Modem Control Register  |
        iodelay                         ;                              |
        and     al, NOT ACE_LOOP        ; out of loopback mode         |
	out	dx, al			;                              |
        iodelay                         ;                              |
	sub	dl, ACE_MCR-ACE_FCR	;dx=FCR                        |
;======================================================================|

	test	EFlags[si], fFIFOchkd	;Q: FIFO detect been done?
	jnz	sc_fifodone		;   Y: enabled FIFO
	iodelay
	.errnz	ACE_IIDR-ACE_FCR
	in	al, dx
	or	EFlags[si], fFIFOchkd
	test	al, ACE_FIFO_E2 	;Q: FIFO enabled?
	jz	short @F
	test	al, ACE_FIFO_E1 	;Q: 16550A detected?
	jnz	sc_fifodone		;   Y: enabled FIFO
@@:
	iodelay
	or	EFlags[si], fNoFIFO

sc_nofifo:
	xor	al, al
	out	dx, al
sc_fifodone:

	sub	dl,ACE_FCR-ACE_RBR	; dx -> RBR
;
; Delay for things to settle
;
	push	dx
	cCall	GetSystemMsecCount
	pop	dx
	mov	cx, ax
delay_loop:
	in	al, dx			;Read it once
	push	dx
	cCall	GetSystemMsecCount
	pop	dx
	sub	ax, cx
	cmp	ax, DELAY_TIME		;Q: Timeout reached?
	jb	delay_loop		;   N:

	add	dl,ACE_MSR		;--> Modem Status reg
	in	al,dx			;Throw away 1st status read
	iodelay
	in	al,dx			;Save 2nd for MSRWait (Clear MSR int)
	mov	MSRShadow[si],al
