/* $Id: pricebase.h 20411 2010-08-08 10:59:30Z rubidium $ */

/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file pricebase.h Price Bases */

extern const PriceBaseSpec _price_base_specs[] = {
	{    100, PCAT_NONE,         GSF_END,          INVALID_PRICE         }, ///< PR_STATION_VALUE
	{    100, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_RAIL
	{     95, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_ROAD
	{     65, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_SIGNALS
	{    275, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_BRIDGE
	{    600, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_DEPOT_TRAIN
	{    500, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_DEPOT_ROAD
	{    700, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_DEPOT_SHIP
	{    450, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_TUNNEL
	{    200, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_STATION_RAIL
	{    180, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_STATION_RAIL_LENGTH
	{    600, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_STATION_AIRPORT
	{    200, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_STATION_BUS
	{    200, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_STATION_TRUCK
	{    350, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_STATION_DOCK
	{ 400000, PCAT_CONSTRUCTION, GSF_TRAINS,       INVALID_PRICE         }, ///< PR_BUILD_VEHICLE_TRAIN
	{   2000, PCAT_CONSTRUCTION, GSF_TRAINS,       INVALID_PRICE         }, ///< PR_BUILD_VEHICLE_WAGON
	{ 700000, PCAT_CONSTRUCTION, GSF_AIRCRAFT,     INVALID_PRICE         }, ///< PR_BUILD_VEHICLE_AIRCRAFT
	{  14000, PCAT_CONSTRUCTION, GSF_ROADVEHICLES, INVALID_PRICE         }, ///< PR_BUILD_VEHICLE_ROAD
	{  65000, PCAT_CONSTRUCTION, GSF_SHIPS,        INVALID_PRICE         }, ///< PR_BUILD_VEHICLE_SHIP
	{     20, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_TREES
	{    250, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_TERRAFORM
	{     20, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_GRASS
	{     40, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_ROUGH
	{    200, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_ROCKS
	{    500, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_FIELDS
	{     20, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_TREES
	{    -70, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_RAIL
	{     10, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_SIGNALS
	{     50, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_BRIDGE
	{     80, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_DEPOT_TRAIN
	{     80, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_DEPOT_ROAD
	{     90, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_DEPOT_SHIP
	{     30, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_TUNNEL
	{  10000, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_WATER
	{     50, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_STATION_RAIL
	{     30, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_STATION_AIRPORT
	{     50, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_STATION_BUS
	{     50, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_STATION_TRUCK
	{     55, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_STATION_DOCK
	{   1600, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_HOUSE
	{     40, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_CLEAR_ROAD
	{   5600, PCAT_RUNNING,      GSF_TRAINS,       INVALID_PRICE         }, ///< PR_RUNNING_TRAIN_STEAM
	{   5200, PCAT_RUNNING,      GSF_TRAINS,       INVALID_PRICE         }, ///< PR_RUNNING_TRAIN_DIESEL
	{   4800, PCAT_RUNNING,      GSF_TRAINS,       INVALID_PRICE         }, ///< PR_RUNNING_TRAIN_ELECTRIC
	{   9600, PCAT_RUNNING,      GSF_AIRCRAFT,     INVALID_PRICE         }, ///< PR_RUNNING_AIRCRAFT
	{   1600, PCAT_RUNNING,      GSF_ROADVEHICLES, INVALID_PRICE         }, ///< PR_RUNNING_ROADVEH
	{   5600, PCAT_RUNNING,      GSF_SHIPS,        INVALID_PRICE         }, ///< PR_RUNNING_SHIP
	{1000000, PCAT_CONSTRUCTION, GSF_END,          INVALID_PRICE         }, ///< PR_BUILD_INDUSTRY
	{   1600, PCAT_CONSTRUCTION, GSF_END,          PR_CLEAR_HOUSE        }, ///< PR_CLEAR_INDUSTRY
	{     40, PCAT_CONSTRUCTION, GSF_END,          PR_CLEAR_ROUGH        }, ///< PR_BUILD_OBJECT
	{     40, PCAT_CONSTRUCTION, GSF_END,          PR_CLEAR_ROUGH        }, ///< PR_CLEAR_OBJECT
	{    600, PCAT_CONSTRUCTION, GSF_END,          PR_BUILD_DEPOT_TRAIN  }, ///< PR_BUILD_WAYPOINT_RAIL
	{     80, PCAT_CONSTRUCTION, GSF_END,          PR_CLEAR_DEPOT_TRAIN  }, ///< PR_CLEAR_WAYPOINT_RAIL
	{    350, PCAT_CONSTRUCTION, GSF_END,          PR_BUILD_STATION_DOCK }, ///< PR_BUILD_WAYPOINT_BUOY
	{     50, PCAT_CONSTRUCTION, GSF_END,          PR_CLEAR_STATION_TRUCK}, ///< PR_CLEAR_WAYPOINT_BUOY
	{1000000, PCAT_CONSTRUCTION, GSF_END,          PR_BUILD_INDUSTRY     }, ///< PR_TOWN_ACTION
	{    250, PCAT_CONSTRUCTION, GSF_END,          PR_TERRAFORM          }, ///< PR_BUILD_FOUNDATION
	{8000000, PCAT_CONSTRUCTION, GSF_END,          PR_BUILD_INDUSTRY     }, ///< PR_BUILD_INDUSTRY_RAW
	{1000000, PCAT_CONSTRUCTION, GSF_END,          PR_BUILD_INDUSTRY     }, ///< PR_BUILD_TOWN
	{   5000, PCAT_CONSTRUCTION, GSF_END,          PR_CLEAR_WATER        }, ///< PR_BUILD_CANAL
	{   5000, PCAT_CONSTRUCTION, GSF_END,          PR_CLEAR_WATER        }, ///< PR_CLEAR_CANAL
	{  10000, PCAT_CONSTRUCTION, GSF_END,          PR_CLEAR_WATER        }, ///< PR_BUILD_AQUEDUCT
	{   2000, PCAT_CONSTRUCTION, GSF_END,          PR_CLEAR_BRIDGE       }, ///< PR_CLEAR_AQUEDUCT
	{   7500, PCAT_CONSTRUCTION, GSF_END,          PR_CLEAR_WATER        }, ///< PR_BUILD_LOCK
	{   2000, PCAT_CONSTRUCTION, GSF_END,          PR_CLEAR_WATER        }, ///< PR_CLEAR_LOCK
};
assert_compile(lengthof(_price_base_specs) == PR_END);
