#include "stdafx.h"
#include "ttd.h"
#include "window.h"
#include "gui.h"
#include "gfx.h"


static void NetworkWindowWndProc(Window *w, WindowEvent *e)
{
	switch(e->event) {
	case WE_PAINT: {
		DrawWindowWidgets(w);
		break;
	}
	}
}


static const Widget _network_window_widgets[] = {
{   WWT_CLOSEBOX,    10,     0,    10,     0,    13, STR_00C5, STR_018B_CLOSE_WINDOW},
{    WWT_CAPTION,    10,    11,   369,     0,    13, STR_CONFIG_PATCHES_CAPTION, STR_018C_WINDOW_TITLE_DRAG_THIS},
{      WWT_PANEL,    10,     0,   369,    14,    41, 0x0, 0},
{      WWT_PANEL,    10,     0,   369,    42,   250, 0x0, 0},

{   WWT_CLOSEBOX,     3,    10,    96,    16,    27, STR_CONFIG_PATCHES_GUI, 0},
{   WWT_CLOSEBOX,     3,    97,   183,    16,    27, STR_CONFIG_PATCHES_CONSTRUCTION, 0},
{   WWT_CLOSEBOX,     3,   184,   270,    16,    27, STR_CONFIG_PATCHES_VEHICLES, 0},
{   WWT_CLOSEBOX,     3,   271,   357,    16,    27, STR_CONFIG_PATCHES_STATIONS, 0},
{   WWT_CLOSEBOX,     3,    10,    96,    28,    39, STR_CONFIG_PATCHES_ECONOMY, 0},
{      WWT_LAST},
};

static const WindowDesc _network_window_desc = {
	WDP_CENTER, WDP_CENTER, 370, 251,
	WC_NETWORK_WINDOW,0,
	WDF_STD_TOOLTIPS | WDF_STD_BTN | WDF_DEF_WIDGET,
	_network_window_widgets,
	NetworkWindowWndProc,
};


void ShowNetworkWindow()
{
	DeleteWindowById(WC_NETWORK_WINDOW, 0);
	AllocateWindowDesc(&_network_window_desc);
}

