cseg	segment para public 'code'
org	100h

	; This program is used to display the total and available memory.

sample	proc far

	assume cs:cseg,ds:cseg,ss:nothing,es:nothing

	jmp short start 	; go to the start

public	sample, total, tmemory, avail, amemory, totmem, fremem, start, dosret
public	getmem, convert, conloop, display

total	db 'Total memory: '
tmemory db '000 KB    '
avail	db 'Memory available: '
amemory db '000 KB','$'
totmem	dw 0			; total memory size
fremem	dw 0			; free memory size

start:	call getmem		; get memory size

	mov ax,totmem		; total memory
	mov di,offset tmemory
	call convert		; convert to ascii

	mov ax,fremem		; free (available) memory
	mov di,offset amemory
	call convert		; convert to ascii

	call display		; display the answers

dosret: int 20h 		; return to dos

getmem	proc near		; get memory size
	mov cl,6		; shift count
	mov si,2		; point to top of memory in psp
	mov ax,[si]		; get top of memory

	shr ax,cl		; convert to KB
	mov totmem,ax		; and save total memory

	mov bx,cs		; get current segment
	shr bx,cl		; convert to KB
	sub ax,bx		; subtract from total memory to get
	mov fremem,ax		; free memory
	ret
getmem	endp

convert proc near		; convert number to ascii
	; ax = number, di = output buffer pointer
	push ax 		; save number
	mov al,' '
	mov cx,3
	rep stosb		; clear 3 bytes
	pop ax			; restore number

	mov cx,10		; divisor

conloop:xor dx,dx		; clear remainder
	div cx			; divide by 10
	add dl,30h		; convert to ascii
	dec di			; back up 1 byte
	mov [di],dl		; save ascii number

	cmp ax,0		; done?
	jnz conloop		; no

	ret
convert endp

display proc near		; display memory sizes
	mov ah,9		; display string
	mov dx,offset total	; start of message
	int 21h 		; let dos display it
	ret
display endp

sample	endp
cseg	ends
end	sample
