; pause.asm - OS/2 driver to pause the display

.386p

comment |

To generate this program, use the following commands:

ml /Zi /c /Zf /Zm pause.asm			; masm 6
link pause.obj, pause.sys, pause.map/li/m, \os2\doscalls, pause.def
ts pause/v/32
 
pause.def contains the following two lines:

library pause
protmode

end comment |

		; DevHlp equates

DevHlp_AttachDD 	equ 2ah

		; OS/2 equates

incl_base equ 1
incl_dosfilemgr equ 1

	include os2.inc		; keep after os/2 equates
.386p		; again!

Public  DevHlp_AttachDD, incl_base, incl_dosfilemgr, dstart, header, DevHlp
Public  DevTable, maxcmd, EndData, viohandle, psr2name, psr2addr, message
Public  messagelen, crlf, crlflen, conhandle, conbuffer, byteread, cstart
Public  strategy, strat1, strat2, devopen, error, init, init1, readcon

Packet 	struc	; es:bx points here on entry
PktLen          db      ?       ; length in bytes of packet (+0)
PktUnit         db      ?       ; subunit number of block device (+1)
PktCmd          db      ?       ; command code (+2)
PktStatus       dw      ?       ; status word (+3)
PktDOSLink      dd      ?       ; reserved (+5)
PktDevLink      dd      ?       ; device multiple-request link (+9)
PktCat          db      ?       ; category (+13)
PktFunc         db      ?       ; function (+14)
PktParm         dd      ?       ; parameter pointer (+15)
PktData         dd      ?       ; data pointer (+19)
Packet  ends

dgroup  group   _data
_data   segment dword public 'data'

dstart equ this byte
header  dd      -1		; +0		; must be at top of data seg!
        dw      8880h		; +4		; device attribute
        dw      strategy	; +6		; offset to strategy routine
        dw      0		; +8		; offset to idc routine
        db      'PAUSE$  '	; +10		; device name
        dw      4 dup (0)	; +18		; reserved

DevHlp	dd    	0		; address for DevHlp calls

even		; control table

DevTable dw     init            ; 0 -- Init
        dw      12 dup (error)  ; 1 - 12 - not used
        dw      devopen         ; 13 -- DevOpen
        dw      devopen	        ; 14 -- DevClose
        dw      error           ; 15
        dw      devopen         ; 16 -- DevIOCtl
        dw      3 dup (error)  	; 17 - 19 - not used
	dw 	devopen		; 20 -- DevDeinstall
        dw      8 dup (error)   ; 21 - 28 - not used
maxcmd	equ 28			; max command count

; ***************************************************************************
; all data items after this point are discarded after init!
EndData dw	0		; last thing in data segment

even		; data for VioWrtTTY 

viohandle equ 0
psr2name db     'PSR2$   '	
psr2addr dw 6 dup(0)		; address returned by attachdd
message db 'Press Enter to continue (pause.sys) ... '
messagelen equ $-message

crlf db 0dh,0ah
crlflen equ $-crlf

conhandle dw 1			

conbuffer dw 40 dup(0)
byteread  dw 0

_data   ends

_text   segment dword use16 public 'code'
assume cs:_text,ds:dgroup,es:nothing

extrn	DosRead:far
extrn	VioWrtTTY:far

cstart:

strategy proc far
	push ax
	push di
        mov al,es:[bx].PktCmd	; get function id
	cbw
	mov di,ax
        cmp di,maxcmd
        jbe strat1			; in range

        call error
        jmp short strat2

strat1: add di,di
	push edi
	and edi,0ffffh
        call word ptr [edi+DevTable]
	pop edi

strat2: mov es:[bx].PktStatus,ax        ; set request header status
	pop di
	pop ax
        ret
strategy endp

devopen proc near
        mov ax,0100h
        ret
devopen endp

error   proc near
        mov ax,8103h
        ret
error   endp

init    proc near		; last thing in code segment!
        mov ax,word ptr es:[bx].PktFunc
        mov word ptr DevHlp,ax
        mov ax,word ptr es:[bx].Pktfunc+2
        mov word ptr DevHlp+2,ax

        mov word ptr es:[bx].PktFunc,offset init
        mov word ptr es:[bx].PktFunc+2,offset enddata
	xor ax,ax
	mov es:[bx].PktCat,al	; clear category

	mov bx,offset psr2name
	mov di,offset psr2addr
	mov dl,DevHlp_AttachDD
	call DevHlp
	jc init1		; psr2 not found

	int 3			; stop in Periscope
	nop
	nop
	nop
	int 60h			; test interrupt setup by comblock
	nop
	nop
	nop

	@VioWrtTTY message,messagelen,viohandle	; display message
	call readcon		; read console 
	@VioWrtTTY crlf,crlflen,viohandle	; display crlf

init1:

comment |
	; the following code will cause a trap d!
	push bx
	push es
	xor bx,bx 
	mov es,bx		
	mov bx,es:[bx]		; crashes here!
	pop es
	pop bx
end comment |

        mov ax,0100h
        ret
init    endp

readcon	proc near		; read console 
	push conhandle
	push ds
	mov ax,offset conbuffer
	push ax
	push 80
	push ds
	mov ax,offset byteread
	push ax
	call dosread
	ret
readcon	endp

_text   ends
        end
