#   File:       makefile.sol
#   Target:     loadice
#   Created:    Oct. 21, 1997
#   Grammar Engine, Inc.

MAKEFILE = makefile
#if using parallel port use the next line
#CDEFINES  = -c -DUNIX -DFASTP -DBPP -DSOLARIS -DANSI
CDEFINES  = -c -DUNIX -DFASTP -DBPP -DSOLARIS -DANSI
CC = gcc
LD = ld

all:	loadice vlog flog

COBJS =		piglob.o  \
		loadice.o \
		pishell.o \
		pisetup.o \
		pisyn.o \
		pisynf.o \
		piedit.o \
		picore.o \
		pifile.o \
		pitrace.o \
		piconfig.o \
		pierror.o \
		pidriver.o \
		piunix.o \
		piutil.o \
		fiutil.o \
		pimap.o

piglob.o: \
		piglob.c \
		piconfig.h \
		pistruct.h \
		piscript.h \
		pierror.h \
		pihelp.h \
		pidata.h \
		pisyn.h
	$(CC) $(CDEFINES)  piglob.c

loadice.o: \
		loadice.c \
		piconfig.h \
		pistruct.h
	$(CC) $(CDEFINES)  loadice.c

pishell.o: \
		pishell.c \
		piconfig.h \
		piscript.h \
		pistruct.h \
		pierror.h \
		pihelp.h
	$(CC) $(CDEFINES)  pishell.c

pisetup.o: \
		pisetup.c \
		piconfig.h \
		piscript.h \
		pistruct.h \
		pierror.h \
		pihelp.h
	$(CC) $(CDEFINES)  pisetup.c

pisyn.o: \
		pisyn.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pisyn.h
	$(CC) $(CDEFINES)  pisyn.c

pisynf.o: \
		pisynf.c \
		piconfig.h \
		piscript.h \
		pistruct.h \
		pierror.h \
		pidriver.h \
		pidata.h \
		pihelp.h \
		pisyn.h
	$(CC) $(CDEFINES)  pisynf.c

piedit.o: \
		piedit.c \
		piconfig.h \
		pistruct.h \
		pierror.h
	$(CC) $(CDEFINES)  piedit.c

picore.o: \
		picore.c \
		piconfig.h \
		pistruct.h \
		piscript.h \
		pierror.h \
		pidata.h \
		pidriver.h \
		pisyn.h
	$(CC) $(CDEFINES)  picore.c

pifile.o: \
		pifile.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pifile.h \
		pidata.h
	$(CC) $(CDEFINES)  pifile.c

pitrace.o: \
		pitrace.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pidata.h
	$(CC) $(CDEFINES)  pitrace.c

piconfig.o: \
		piconfig.c \
		piconfig.h \
		pistruct.h
	$(CC) $(CDEFINES)  piconfig.c

pierror.o: \
		pierror.c \
		piconfig.h \
		pistruct.h \
		pierror.h
	$(CC) $(CDEFINES)  pierror.c

pidriver.o: \
		pidriver.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pidriver.h \
		pidev.h
	$(CC) $(CDEFINES)  pidriver.c

piunix.o: \
		piunix.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pidriver.h \
		pidata.h \
		pidev.h
	$(CC) $(CDEFINES)  piunix.c

piutil.o: \
		piutil.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pidriver.h \
		pidata.h
	$(CC) $(CDEFINES)  piutil.c


fiutil.o: \
		fiutil.c \
		piconfig.h \
		pistruct.h \
		pierror.h \
		pidriver.h \
		pidata.h
	$(CC) $(CDEFINES)  fiutil.c

pimap.o: \
		pimap.c \
		piconfig.h \
		pistruct.h
	$(CC) $(CDEFINES) pimap.c

clean:
		- rm *.o
		- rm loadice
		- rm flog
		- rm vlog

loadice: \
		$(COBJS)
	$(CC) -o loadice -lgcc -lsocket -lnsl $(COBJS)

vlog.o: \
		vlog.c
	$(CC) $(CDEFINES) vlog.c

vlog: \
		vlog.o
	$(CC) -o vlog vlog.o

flog.o: \
		flog.c
	$(CC) $(CDEFINES) flog.c

flog: \
		flog.o
	$(CC) -o flog flog.o
