/*	PiDev.h - Edit 1

	LoadICE Version 4
	Copyright (C) 1990-99 Grammar Engine, Inc.
	All rights reserved
	
	NOTICE:  This software source is a licensed copy of Grammar Engine's
	property.  It is supplied to you as part of support and maintenance
	of some Grammar Engine products that you may have purchased.  Use of
	this software is strictly limited to use with such products.  Any
	other use constitutes a violation of this license to you.
*/

/*	 - definitions for serial or parallel port operation
*/


#define	BUSY    (0x80)          /* busy bit on parallel port */
#define	PAPER   (0X20)          /* busy bit on second parallel port */
#define	ACK     (0x40)          /* ack bit on parallel port */
#define	STRON	(0x05)			/* strobe bit on for parallel port */
#define	STROFF	(0x04)			/* strobe bit off for parallel port */
#define	AUTOON  (0x06)          /* strobe bit on for second parallel port */
#define	AUTOOFF (0x04)          /* strobe bit off for second parallel port */
#define	B_ACK	(0x0C)			/* back channel ack signal*/
#define	PP_INITS	(0x00)			/* init signal for pp */
#define	PP_INITC	(0x04)			/* remove init signal */
#define	TXBUF	(pxlink.saddr)		/* transmitt buffer */
#define	RXBUF	(pxlink.saddr)		/* receive buffer */
#define	DLLSB	(pxlink.saddr)		/* BRG divisor low */
#define	DLMSB	(pxlink.saddr+1)	/* BRG divisor high */
#define	IEREG	(pxlink.saddr+1)	/* interrupt reg */
#define	IDREG	(pxlink.saddr+2)	/* interrupt ID reg */
#define	LCREG	(pxlink.saddr+3)	/* line control reg */
#define	LC1STP	3					/* 8 data bits 1 stop bit */
#define	LCBRK	0x40				/* do a break */
#define	LC2STP	7					/* 8 data bits 2 stop bits */
#define	MCREG	(pxlink.saddr+4)	/* modem control reg */
#define	LSREG	(pxlink.saddr+5)	/* line status reg */
#define	CDIV	(115200/pxlink.brate) /* divisor for BRG */
#define	MCRSTS	(0x9)				/* assert reset to unit */
#define	MCRSTC	(0x8)				/* remove reset to unit */
#define	TSRMT	0x40				/* shift reg is mt */
#define	BUFMT	0x20				/* TBMT bit in LSREG */
#define	RDA		0x01				/* RDA bit in LSREG */
#define	OVR		0x02				/* data overrun */
#define	FIFON	0x01				/* enable the FIOFO */
#define	FIFOC	0x46				/* clr FIFO and set trig at 4 */
