/* Descendant class for generating horizontal bar charts. */!!

inherit(VidChart, #VidHChart, #(/* No additional instance variables. */), 2, nil)!!

now(class(VidHChart))!!

now(VidHChart)!!

/* Adjusts the scale based on the data and area. 
  Makes the scale fit horizontally. */
Def adjustScale(self, max)
{ scale := point((x(area) - 2 * x(lead)) / max, 10);
}!!

/* Draws the labels in the given display context.
   x, y and str are temporary variables.  */
Def drawLabels(self, context | str, x, y)
{ /* left edge for each label */
  x := 1;
  do(size(labels),
  {using(i)
    /* vertical location */
    y := asInt(y(lead) + i * (y(scale) + space));
    /* convert labels to strings */
    str := asString(labels[i]);
    /* draw the labels */
    drawText(self, x, y, str, context);
  });
}!!

/* Draws the data elements in the given display 
  context. x, y and dRect are temporary variables. */
Def drawData(self, context | x, y, dRect)
{ /* left edge of bar for each item */
  x := x(lead);
  do(size(data),
  {using(i) /* vertical location */
    y := asInt(y(lead) + i * (y(scale) + 
      space)); /* create a rectangle */
    dRect := rect(x, y, asInt(x + data[i]*x(scale)),
    asInt(y + y(scale))); /* draw the rectangle */
    fill(dRect, stock(GRAY_BRUSH), context);
  });
}!!

/* Defines a lead space that allows room for
   the labels on the left edge of the chart. */
Def resetLead(self)
{ lead := point(90, 20);
}!!
