/* Window for displaying chart objects */!!

inherit(Window, #VidChWindow, #(chart   /* stores chart data */), 2, nil)!!

now(class(VidChWindow))!!

now(VidChWindow)!!

/* Invoke clipWindow from the ancestor class */ 
Def clipWindow(self) 
{ clipWindow(self:ancestor, 1) 
} 
!!

/* Invokes printWindow from the ancestor class */ 
Def printWindow(self) 
{ printWindow(self:ancestor, 1) 
} 
!!

/* Sets the chart class to be a vertical bar chart */ 
Def setVidVClass(self) 
{ setChartClass(self, VidVChart); 
} 
!!

/* Sets the chart class to be a horizontal bar chart */ 
Def setVidHClass(self) 
{ setChartClass(self, VidHChart); 
} 
!!

/* Sets the chart type to the specified class. */ 
Def setChartClass(self, chartClass) 
{ setClass(chart, chartClass); 
  reScale(chart); 
  invalidate(self); 
} 
!!

/* Processes the menu selections by automatically 
  sending the corresponding message, as defined by
  the dynamic menu. */
Def command(self, item, lParam | msg) 
{ if msg := action(menu, item)
  then ^perform(self, msg); 
  endif; 
} 
!!

/* Initializes a new VidChWindow.  Sets a horizontal 
   bar chart as the default chart type.  Builds the
   window's menu.  */ 
Def init(self | top1, item1, item2, item3) 
{ setChart(self, new(VidHChart)); 
  menu := create(new(Menu), self); 
  
  item1 := new(MenuItem, "&Copy to clipboard", 601, #clipWindow); 
  item2 := new(MenuItem, "&Print", 602, #printWindow); 
  top1  := newPopup(MenuItem, "&Export"); 
  addItem(top1, item1); 
  addItem(top1, item2); 
  addItem(menu, top1); 
   
  item1 := new(MenuItem, "&Horizontal", 700, #setVidHClass); 
  item2 := new(MenuItem, "&Vertical", 701, #setVidVClass); 
  top1  := newPopup(MenuItem, "Options"); 
  addItem(top1, item1); 
  addItem(top1, item2); 
  addItem(menu, top1); 
  
  drawMenu(self);    
} 
!!

/* Initializes and displays a new chart. */
Def newChart(self, labels, data) 
{ setLabels(chart, labels); 
  resetSpace(chart); 
  setData(chart, data); 
  reScale(chart); 
  /* display new chart */ 
  invalidate(self); 
} 
!!

/* Sets the chart instance variable */
Def setChart(self, aChart)
{ chart := aChart;
}!!

/* Responds to a message to size the window.
   Makes sure the chart is properly adjusted.
   Note: Checks to see the chart is not nil. */
Def reSize(self, wp, lp | cRect)
{ if chart
  then cRect := clientRect(self);
    setArea(chart, point(width(cRect), height(cRect)));
    reScale(chart);
  endif;
}!!

/* Redraws the chart in the given context. */
Def paint(self, context)
{ if chart
  then draw(chart, context);
  endif;
}!!
