/*  ACTOR workspace edit window. The Actor Workspace is an
 instance of this class.  Instances of this class allows execution of
 Actor code, can starts Browsers and Inspectors, and have full editing
 capability. */!!

inherit(WorkEdit, #WorkSpace,
#(browsers   /* Set of open browsers */
inspectors   /* Set of open inspectors */
editors      /* Set of open file windows */
), 2, nil) !!

now(WorkSpaceClass) !!

/* Create a workspace window, bypass ancestor's new method.. */
Def new(self, menuName, wName)
{ ^new(self:WindowClass, menuName, wName)
} !!


now(WorkSpace) !!

/* Create workspace as a popupwindow, bypassing WorkEdit's
  create method. */
Def  create(self, par, wName, rect, style | x, y)
{ x := 460 +  x(screenSize())/4;
  y := 130 + y(screenSize())/4;
  create(self:EditWindow, TheApp.display,
    wName, rect(250, 40, x, y),
    WS_POPUPWINDOW);
} !!


/* Close window and quit ACTOR. */
Def WM_DESTROY(self, wP, lP)
{       Call PostQuitMessage(hWnd); ^0
}  !!

/* Check the class source files before closing.  If
  they have changed, user will have a chance to save
  his or her any work.  */
Def WM_CLOSE(self, wP, lP)
{
  if doDirtyClasses(self)
  then Call DestroyWindow(hWnd); ^1
  endif;
  ^0
} !!


/* Run Dirty Classes dialog, and return ok-to-quit flag.
  DirtyClasses is the set of classes whose source files
  have been modified. */
Def doDirtyClasses(self | ans)
{
  if size(DirtyClasses) =  0
  then ^0
  endif;
  ans := new(DirtyCLD, DCL_BOX, self,
    DirtyClasses);
  select
    case not(ans)
    is repaint(self);
      ^nil
    endCase
    case ans = IDOK
    is WM_COMMAND(self, WORK_SNAP, 0);
    endCase
    case ans = DCL_DEL
    is do(DirtyClasses,
      {using(cl)    setName(Source,
        "work\" + getFileName(Actor[cl]));
        delete(Source)
      });
    endCase
  endSelect;
  ^0
} !!


/* Initialize the workspace instance variables. */
Def init(self)
{ browsers := new(Set, 4);
  inspectors := new(Set, 4);
  editors := new(Set, 4);
  DirtyClasses := new(Set, 4);
  init(self:EditWindow);
}!!

/* Handle workspace events (Load, Edit, Browse, etc.). */
Def    WM_COMMAND(self, wP, lP | temp)
{
  select
    case wP == WORK_EDIT
    is
      if FileWindow
      then temp := new(FileWindow);
        show(temp,1);
        add(editors, temp);
        WM_COMMAND(temp, FILE_OPEN, 0);
      else errorBox(
        "Actor Error",
        "FileWindow is not loaded");
      endif;
    endCase
    case wP == WORK_LOAD
    is repaint(self);
      if temp := new(FileDialog, self,
        "*.*")
      then showWaitCurs(self);
        load(temp);
        showOldCurs(self);
      endif;
      setFocus(self);
    endCase
    case wP == WORK_SNAP
    /* snapshot and move dirty class
      files */
    is snapshot(VImage);
      do(DirtyClasses,
      {using(clName)  bak_Save(Source,
        Actor[clName])
      } );
      DirtyClasses := new(Set,4);
    endCase
    case wP == WORK_BROWSE
    is temp := new(Browser,
      TheApp.display,
      "Browmenu",
      "Browser", nil);
      add(browsers, temp);
      start(temp, nil, nil);
    endCase
    case wP == WORK_INSP
    is inspectIt(self);
    endCase
    case wP == WORK_DOIT
    is doLine(self);
    endCase
    case wP >= TEMP_DO and wP <=
      TEMP_LOOP
    is formatTemplate(self,
      tempStr(self, wP));
    endCase
    case wP == WORK_ROOM
    is errorBox(
      "Bytes Free", asString(staticRoom(), 10));
    endCase
    case lP = 0  or high(lP) = 1
    /* menu or accelerator */
    is ^WM_COMMAND(self:EditWindow, wP,
      lP);
    endCase
  endSelect;
  ^0
} !!


/* End MS-Windows message.  Go through
  Actor shutdown so that users can save
  their work.  They can cancel ending the session. */
Def WM_QUERYENDSESSION(self, wP, lP)
{ ^WM_CLOSE(self, wP, lP);
} !!

