/* TextCollection objects are collections of strings.  Each element must
 be a String object.  Used as an instance variable of all Actor edit windows
 to hold the working text. */  !!

inherit(OrderedCollection, #TextCollection, nil, 2, 1) !!

now(TextCollectionClass) !!

now(TextCollection) !!

/* Move forward in the collection from the
 given point by incr characters.  Return a Point
 made up of the current character and pos (char@pos).  */
Def advance(self, sl, sc, incr | cnt, el, ec)
{	
	if limit(self[sl]) - sc > incr
	then ^point(sc + incr, sl)
	endif;

	cnt := incr - (limit(self[sl]) - sc);
	ec := 0;
	el := sl + 1;

	loop
	while el < lastElement
	begin
		if  cnt < limit(self[el])
		then  ^point(cnt, el)
		endif;
		cnt := cnt - limit(self[el]);
		el := el + 1;
	endLoop;
	^point(limit(self[lastElement - 1]), lastElement - 1)
}!!

/* Break lines after comments and return new TextCollection.
  Used to format methods in the Browser edit window. */
Def  commentBreaks(self | pos, str, aTC)
{aTC := new(TextCollection, size(self));
  do(self,
  {using(line)
    if pos := commentBreak(line)
    then add(aTC, subString(line, 0, pos));
      str := leftJustify(subString(line, pos, 10000));
      if limit(str) > 0
      then add(aTC, stringOf(' ', leadingBlanks(line)) +
        str);
      endif;
    else add(aTC, line)
    endif;
  } );
  ^aTC
} !!

/* Break lines according to length and return new TextCollection.
  Used to format source lines in the Browser edit window. */
Def  lengthBreaks(self, length | len, str, line, aTC, lb,
  lbStr)
{aTC := new(TextCollection, size(self));
  do(self,
  {using(line)    lb := leadingBlanks(line);
    lbStr := tabs(lb/2 + 1);
    select
      case limit(line) < length
      is add(aTC, line);
      endCase
      case leftJustify(line)[0] == '"'
      is add(aTC, line);
      endCase
    default   str := line;
      len := findBreak(str, length);
      add(aTC, subString(str, 0, len));
      loop str := leftJustify(delete(str, 0, len));
      while  limit(str) > 0
      begin len := findBreak(str, max(lb+10, length-lb));
        add(aTC, lbStr + subString(str, 0, len));
      endLoop;
    endSelect;
  } );
  ^aTC
} !!

/* Return a single string that is the concatenation of all
  the strings.  Put one space between each line, remove extra
  spaces.  Will change total text length. */
Def   makeString(self | aStr)
{ aStr :=
    "";
  do(self,
  {using(string)  aStr := aStr +
    " " + leftJustify(rightJustify(string))
  });
  ^leftJustify(aStr)
} !!



/* Insert aStr into the collection at the specified line and character pos. */
Def  insertString(self, aStr, line, pos)
{	^self[line] :=	replace(self[line], aStr, 0, size(aStr), pos, pos);
} !!

/* Insert a string of lines delimited by CR_LF into the collection
  at the specified line and character position.  */
Def  insertText(self, aStr, line, pos | yP, loc, idx, tab, str, endStr)
{ tab := asChar(9);
  loc := 0;
  loop
  while loc := indexOf(aStr, tab, loc)
  begin aStr[loc] := ' ';
  endLoop;

  if not(loc := find(aStr, CR_LF, 0))
  then  insertString(self, aStr, line, pos);
    ^point(pos + size(aStr), line);
  endif;

  endStr := subString(self[line], pos, 10000);  /* remainder */
  self[line] := subString(self[line], 0, pos) + subString(aStr, 0, loc);
  yP := line;
  loop  yP := yP + 1;
  while idx  := find(aStr, CR_LF, loc+2)
  begin insert(self, subString(aStr, loc+2, idx), yP);
    loc := idx;
  endLoop;
  str := subString(aStr, loc+2, 10000);
  insert(self, str + endStr, yP);
  ^point(size(str), yP);
} !!

/* Return a string from the collection suitable for the
  clipboard.  A carriage return-line feed is inserted
  between each line from the collection. */
Def subText(self, sL, sC, eL, eC | aStr)
{
  if sL = eL
  then ^subString(self[sL], sC, eC);
  else aStr := subString(self[sL], sC, 10000) + CR_LF;
    do(over(sL+1, eL),
    {using(line)  aStr := aStr + self[line] + CR_LF
    });
    ^aStr + subString(self[eL], 0, eC);
  endif;
} !!


/* Delete the character at the specified line and position. */
Def deleteChar(self, line, pos)
{	^self[line] := delete(self[line], pos, pos+1)
} !!

/* Delete text from the collection, removing all extra lines but sL
  (sL=startLine; sC=startChar; eL=endLine; eC=endChar).  */
Def deleteText(self, sL, sC, eL, eC | aStr)
{	self[sL] := subString(self[sL],0,sC) + subString(self[eL],eC,10000);
	if sL < eL
	then do(over(sL+1, eL+1),
		{using(line)  remove(self, sL+1)});
	endif ;
} !!


/* Return a single string that is the
  concatenation of all the strings.  Don't
  adjust formatting at all, preserve total text length. */
Def   asString(self | aStr)
{ aStr :=
  "";
  do(self,
  {using(string)  aStr := aStr + string;
  });
  ^aStr;
} !!
