/* Symbols are strings that are guaranteed to be unique. They
 can be compared to other symbols via equivalence, and are used
 as keys in dictionaries. */  !!

/* inherit(String, #Symbol,  nil, nil, nil); */!!

now(class(Symbol));!!

now(Symbol);!!

/* sysPrint the Symbol onto the specified stream. */
Def sysPrintOn(self, aStrm)
{       nextPutAll(aStrm,"#");
        nextPutAll(aStrm, self);
}!!

/* Return the resource string that
  corresponds to the receiver, if any.
  The receiver must be a key in Constants
  with an integer value that is used as
  the resource id. */
Def errorString(self | id)
{
  if (id := Constants[self])
  then ^loadString(id);
  endif;
  ^nil;
} !!

/* The compiler was unable to resolve
  the receiver as a variable.  Allow the
  user to make the name into a global,
  otherwise report the undefined name. */
Def undefError(self, bp, str | val)
{ val := new(ErrorBox, ThePort, self +
  " is undefined. Should it become a global variable?",
  "Undefined Name", 4);
  if val = 6
  then ^Actor[self] := nil;
  endif;
  reportUndef(CurrentParser, self, bp,
    str);
  abort(TheApp);
} !!


/* Return a SortedCollection of classes
  who implement the message named by the
  receiver. */
Def implementors(self)
{ ^asSortedCollection(extract(
  classes(Actor),
  { using(cl)
    if cl.methods
    then cl.methods[self]
    else nil
    endif;
  }));
} !!



/* Symbols hash based on their unique
  object pointers. */
Prim hash(self):Int !!

/* If the symbol is the name of a
  metaclass, return the association of
  its instance or nil. For example,
  ArrayClass returns the association of
  Array. */
Prim isMetaName(self):Boolean !!

