/* SortedSet allows the caller to control what happens if 
 an element is already present.  See add method. */ !!

inherit(SortedCollection, #SortedSet, nil, 2, 1) !!

now(SortedSetClass) !!

now(SortedSet) !!

/*  Add an item to a sorted collection. 
  First determine where it should go and 
  then put the item there. Evaluate a 
  three-argument block if the new element 
  is already present.  The block args 
  are: using(oldItem, newItem, index). */
Def add(self, item, block | index, elem,
  idxTuple idx)
{ idxTuple := findItemIndex(self, item);
  idx := idxTuple[1];
  if idxTuple[0]
  then elem := self:Object[idx];
    ^eval(block, elem, item, idx);
  endif;
  ^insert(self, item, idx);
} !! 
 

/* Create a new collection, preserving 
  the old compareBlock, copy all the 
  elements from the old collection to the 
  new, and swap object pointers so that 
  self refers to the newly created 
  collection.  */
Def grow(self | newColl)
{  newColl := new(class(self), 
  limit(self) + 8);
  newColl.compareBlock := compareBlock;
  do(self,
  { using(element) add(newColl, element,
    {using(x y z)
    })
  });
  swap(newColl,self);
} !! 
  
 
