/* The PopupWindow class produces popup-style windows.  Most of the
  windows in Actor are of the popup variety--in fact, they all are,
  except for some of the demonstration programs and the Actor Display.

  PopupWindows are basically identical to their tiled counterparts
  except they are always attached to a parent window and cannot be
  made iconic or zoomed.  If their parent window is made iconic,
  PopupWindows	disappear.

  When creating a PopupWindow, default sizing is provided,
  or you can specify location with a Rect.  See the new method for
  this class. */!!

inherit(Window, #PopupWindow, nil, 2, nil) !!

now(PopupWindowClass) !!

/* Create and return a new Popup window.  The par argument
  is the parent window, and menuName is the ASCII string specifying
  the name of a menu resource (nil for no menu).  wName is a string
  containing the caption for the window, and rect, if specified,
  determines where and how big the PopupWindow will be.  */
Def new(self, par, menuName, wName, rect | theWnd, sRect)
{
  if not(sRect := rect)
  then sRect := rect(270, 80, 470 +
    x(screenSize())/4, min(screenSize().y,
    245 + y(screenSize())/4));
  endif;
  theWnd := new(self:Behavior);
  loadMenu(theWnd, menuName);
  create(theWnd, par, wName, sRect,
    WS_POPUPWINDOW);
  Call SetWindowWord(handle(theWnd), 0,
    hash(theWnd));
  theWnd.paintStruct :=
    static(new(Struct, 32));
  init(theWnd);
  ^theWnd
} !!


now(PopupWindow) !!





